public class CFSExpDriver extends PLExpDriver{

  public CFSExpDriver(long chunk, long chunk_size, long interInput, int interInputCount, long output, int treeWidth, URANode n){
    super(chunk, chunk_size, interInput, interInputCount, output, treeWidth, n);
  }
 
  public void runWrite(int i){
    // do the local write
    super.runWrite(i);

    
    // send to the central node
    String[] s = new String[1];
    s[0] = new String("/*");
    SubscriptionSet set = SubscriptionSet.makeSubscriptionSet(s);
    RMIClient rmiClient = new RMIClient();
    int receiver = 0;
    
    if(i==0){// only setup subscription once for all.
      CounterVV endVV = new CounterVV(node.getCurrentVV());
      long check = endVV.getMaxTimeStamp();
      CounterVV startVV = new CounterVV(node.getCurrentVV());
      long localTS = -1;
      if(i>0){
        localTS = exeChunk+i-1;
      }
      startVV.setStampByServer(new NodeId(localId), localTS);
      
      System.out.println(receiver + " subscribe to " + localId);
      
      try{
        rmiClient.subscribe(set, startVV, /*endVV,*/
                            new NodeId(localId), new NodeId(receiver),
                            Config.getDNS(new NodeId((long)receiver)),
                            Config.getPortInval(new NodeId((long)receiver)),
                            SUBSCRIPTION_TIMEOUT_MS, MAX_FORCE_MS, MAX_DELAY_MS);
      } catch (Exception e){
        e.printStackTrace();
      }
    }
    
    try{
      ObjId objId = new ObjId("/" + localId + "/" + i);
      rmiClient.issueDemandRead(objId, 0, interInputSize, 0, new NodeId(localId), 
                                new NodeId(receiver), Config.getDNS(new NodeId((long)receiver)),
                                Config.getPortBody(new NodeId((long)receiver)));
      
    } catch (Exception e){
      e.printStackTrace();
      assert false;
    }
  }
  
  
  public void runRead(int i){
    try{
      String[] s = new String[1];
      s[0] = new String("/*");
      SubscriptionSet set = SubscriptionSet.makeSubscriptionSet(s);
      RMIClient rmiClient = new RMIClient();
      int supplier = getPeer();      
      
      if(i==0){
        CounterVV endVV = new CounterVV(node.getCurrentVV());
        endVV.setStampByServer(new NodeId(supplier), exeChunk+i);
        System.out.println(localId + " subscribe to " + supplier);
        /* rmiClient.subscribe(set, node.getCurrentVV(), endVV,
           new NodeId(0), new NodeId(localId), 
           Config.getDNS(new NodeId((long)localId)), 
           Config.getPortInval(new NodeId((long)localId)),
           SUBSCRIPTION_TIMEOUT_MS, MAX_FORCE_MS, MAX_DELAY_MS);*/
        rmiClient.subscribe(set, node.getCurrentVV(), /*endVV,*/
                            new NodeId(0), new NodeId(localId), 
                            Config.getDNS(new NodeId((long)localId)), 
                            Config.getPortInval(new NodeId((long)localId)),
                            SUBSCRIPTION_TIMEOUT_MS, MAX_FORCE_MS, MAX_DELAY_MS);
      }
      ObjId[] objId = new ObjId[1];
      objId[0] = new ObjId("/" + supplier + "/" + i);
      issueBody(objId[0], 0, interInputSize, 0, new NodeId(0), new NodeId(localId),
                Config.getDNS(new NodeId((long)localId)),
                Config.getPortBody(new NodeId((long)localId)),
                rmiClient);
      waitForFiles(objId, 0, interInputSize, supplier, 0, (int)exeChunk+i);
      
    } catch (Exception e){
      e.printStackTrace();
    }
  }

 public void produceResult(){
    super.produceResult();
    ObjId[] objId = new ObjId[1];
    objId[0] = new ObjId("/00/" + localId);
    RMIClient rmiClient = new RMIClient();
    try{
      issueBody(objId[0], 0, outputSize, 0,
                new NodeId(localId), new NodeId(0),
                Config.getDNS(new NodeId(0)),
                Config.getPortBody(new NodeId(0)), 
                rmiClient);
    } catch (Exception e){
      e.printStackTrace();
      assert false;
    }
  }

   public void synchResults(){
    int[] otherNodes = Config.getNodesExclusive(0);
//    for(int i=0; i<otherNodes.length; i++){
    for(int i=otherNodes.length-1; i>=0; i--){
      ObjId[] objId = new ObjId[1];
      objId[0] = new ObjId("/00/" + otherNodes[i]);
      waitForFiles(objId, 0, outputSize, otherNodes[i], otherNodes[i], (int)exeChunk+interFileCount);
    }
  }

/*  public void synchResults(){
    int[] otherNodes = Config.getNodesExclusive(0);
    ObjId[] objId = new ObjId[1];
    for(int i=0; i<otherNodes.length; i++){
      objId[0] = new ObjId("/00/" + otherNodes[i]);
      waitForFiles(objId, 0, outputSize, otherNodes[i], otherNodes[i], (int)exeChunk+interFileCount);
    }
  }
*/

/*   protected void waitForFiles(ObjId[] oids, int offset, long length, int writer, int supplier, int as){
    NodeId wid = new NodeId(writer);
    NodeId sid = new NodeId(supplier);
    RMIClient rmiClient = new RMIClient();
    LocalInterface li = node.getLocalInterface();
    long hint = as;
    try{
      System.out.println("Sync on: " + new AcceptStamp(hint, wid));
      li.sync(new AcceptStamp(hint, wid));
      System.out.println("done syncing");
    } catch (Exception nsee){
      assert false;
    }

    BodyMsg bm = null;
    for(int i=0; i<oids.length; i++){
      while(bm == null){
        try{
          System.out.println("reading: " + oids[i]);
          bm = li.readBlockInvalid(oids[i], offset, length, true);
          System.out.println("done reading: " + oids[i]);
        } catch (ObjNotFoundException onfe){
          //hint ++;
          try{
            System.out.println("Object not available yet locally." + oids[i]);
            System.out.println("Sync on: " + new AcceptStamp(hint, wid));
            li.sync(new AcceptStamp(hint, wid));
            System.out.println("done syncing"); 
          } catch (Exception ee){
            ee.printStackTrace();
          } 
        } catch (Exception ge){
          ge.printStackTrace();
          assert false;
        }
      }
      bm = null;
    }
  }
*/


  protected void centralServerFunction(int count){
/*    int prograss = 0;
    int[] otherNodes = Config.getNodesExclusive(0);
    ObjId[] objId = new ObjId[1];;
    while(prograss < count){
      for(int i=0; i<otherNodes.length; i++){
        objId[0] = new ObjId("/" + otherNodes[i] + "/" + prograss);
        waitForFiles(objId, 0, interInputSize, otherNodes[i], otherNodes[i], (int)exeChunk+prograss);
      }
      prograss ++;
    }
*/
  }

   /*********** main ***********/
  
  public static void main(String[] argv){
    URANode n = new URANode(argv[0], null, Controller.NULL_CONTROLLER, false);
    System.out.println((int)Config.getMyNodeId().getIDint());
    long chk = (new Long(argv[1])).longValue();
    long chksz = (new Long(argv[2])).longValue();
    long iip = (new Long(argv[3])).longValue();
    int ic = (new Integer(argv[4])).intValue();
    long op = (new Long(argv[5])).longValue();
    int tw = (new Integer(argv[6])).intValue();
    int sid = (int)Config.getMyNodeId().getIDint();
    BarrierClient bc = new BarrierClient("borage.cs.utexas.edu", 9494, sid);

//    assert ic < tw;
    
    CFSExpDriver cfsDriver = new CFSExpDriver(chk, chksz, iip, ic, op, tw, n);
    cfsDriver.runExp(bc);
  }
}
