import java.util.Random;
import java.util.Enumeration;
import java.util.Hashtable;
import java.io.IOException;
import java.io.EOFException;

public class PLExpDriver{

  protected static String initSet = "/0/*";
  public static long SUBSCRIPTION_TIMEOUT_MS = 3000000; // 3000 SECONDS
  public static long MAX_DELAY_MS = 0; // 3600 seconds
  public static long MAX_FORCE_MS = 0; 
  
  protected Hashtable knownPeers;

  protected URANode node;
  protected int localId;
  protected long exeChunk;
  private long chunkSize;
  private long inputSize;
  protected long interInputSize;
  protected long outputSize;
  private int fanout;
  protected int interFileCount;
  private Random r;

  public PLExpDriver(long chunk, long chunk_size, long interInput, int interInputCount, long output, int treeWidth, URANode n){
    exeChunk = chunk;
    chunkSize = chunk_size;
    inputSize = interInput;
    interInputSize = interInput;
    outputSize = output;
    localId = (int)Config.getMyNodeId().getIDint();
    fanout = treeWidth;
    interFileCount = interInputCount;
    node = n;
    r = new Random(localId);
    knownPeers = new Hashtable();
    knownPeers.put(new Integer(localId), new Integer(localId));
  }

  public void initWrites(){
    try{
      LocalInterface li = node.getLocalInterface();
      ImmutableBytes buffer = URANode.populateByteArray(chunkSize);
      boolean bound = getInitWriteType();
      
      for(int i=0; i<exeChunk; i++){
        String oid = "/0/" + i;
        ObjId objId = new ObjId(oid);
        li.write(objId, 0, chunkSize, buffer, bound);
      }
    } catch (Exception e){
      e.printStackTrace();
    }
  }

  public void produceResult(){
    try{
      LocalInterface li = node.getLocalInterface();
      ImmutableBytes buffer = URANode.populateByteArray(outputSize);
      boolean bound =  getResultWriteType();
      String oid = "/00/" + localId;
      ObjId objId = new ObjId(oid);
      li.write(objId, 0, outputSize, buffer, bound);
    } catch (Exception e){
      e.printStackTrace();
    }
  }

  public void synchResults(){
    // "/00/" is the directory containing results from other nodes
    RMIClient rmiClient = new RMIClient();
    try{
      String[] s = new String[1];
      s[0] = new String(getResultSet());
      SubscriptionSet set = SubscriptionSet.makeSubscriptionSet(s);
      int[] otherNodes = Config.getNodesExclusive(0);
      for(int i=0; i<otherNodes.length; i++){
        System.out.println(localId + " subscribe to " + otherNodes[i]);
        rmiClient.subscribe(set, node.getCurrentVV(), 
                            new NodeId(otherNodes[i]), new NodeId(localId), 
                            Config.getDNS(new NodeId((long)localId)),
                            Config.getPortInval(new NodeId((long)localId)),
                            SUBSCRIPTION_TIMEOUT_MS, MAX_FORCE_MS, MAX_DELAY_MS);
        ObjId[] objId = new ObjId[1];
        objId[0] = new ObjId("/00/" + otherNodes[i]);
        
        issueBody(objId[0], 0, outputSize, 0, 
                  new NodeId(otherNodes[i]), new NodeId(localId),
                  Config.getDNS(new NodeId((long)localId)),
                  Config.getPortBody(new NodeId((long)localId)), 
                  rmiClient);
        waitForFiles(objId, 0, outputSize, otherNodes[i], otherNodes[i], (int)exeChunk+interFileCount);
      }
    } catch (Exception e){
      e.printStackTrace();
    }
  }
    
  public void synchInitFiles(){
    RMIClient rmiClient = new RMIClient();
    try{
      int pid = getParentNode();
      String[] s = new String[1];
      s[0] = new String(initSet);
      SubscriptionSet set = SubscriptionSet.makeSubscriptionSet(s);
      // start subscription of invals (init files are sent as bound invals)
      CounterVV endVV = new CounterVV(AcceptVV.makeVVAllNegatives());
      endVV.setStampByServer(new NodeId(0), exeChunk-1);
      System.out.println(localId + " subscribe to " + pid);
      rmiClient.subscribe(set, AcceptVV.makeVVAllNegatives(), endVV, 
                          new NodeId(pid), new NodeId(localId),  
                          Config.getDNS(new NodeId((long)localId)),
                          Config.getPortInval(new NodeId((long)localId)),
                          SUBSCRIPTION_TIMEOUT_MS, MAX_FORCE_MS, MAX_DELAY_MS);
      
      // try to read the actual files locally
      ObjId[] objId = new ObjId[(int)exeChunk];
      
      for(int i=0; i<exeChunk; i++){
        objId[i] = new ObjId("/0/" + i);
        issueBody(objId[i], 0, chunkSize, 0, 
                  new NodeId(pid), new NodeId(localId),
                  Config.getDNS(new NodeId((long)localId)),
                  Config.getPortBody(new NodeId((long)localId)),
                  rmiClient);
      }
      waitForFiles(objId, 0, chunkSize, 0, pid, (int)exeChunk-1);
        
      // terminate the subscription after files received
      //      rmiClient.unSubscribe();
      
    } catch (Exception e){
      e.printStackTrace();
      assert false;
    }
  }
  
  public void runWrite(int i){
    try{
      LocalInterface li = node.getLocalInterface();
      ImmutableBytes buffer = URANode.populateByteArray(interInputSize);
      boolean bound = getInterWriteType();

//      int numFiles = getWriteCount();

//      for(int i=0; i<numFiles; i++){
        String oid = "/" + localId + "/" + i;
        ObjId objId = new ObjId(oid);
        li.write(objId, 0, interInputSize, buffer, bound);
//      }

    } catch (Exception e){
      e.printStackTrace();
    }
  }

  public void runRead(int i){
    try{
      String[] s = new String[1];
      s[0] = new String("/*");
      SubscriptionSet set = SubscriptionSet.makeSubscriptionSet(s);
      RMIClient rmiClient = new RMIClient();
      int supplier = getPeer();      
//      for(int i=0; i<suppliers.length; i++){
      CounterVV endVV = new CounterVV(node.getCurrentVV());
      endVV.setStampByServer(new NodeId(supplier), exeChunk+i);
      System.out.println(localId + " subscribe to " + supplier);
      rmiClient.subscribe(set, node.getCurrentVV(), endVV, 
                          new NodeId(supplier), new NodeId(localId), 
                          Config.getDNS(new NodeId((long)localId)), 
                          Config.getPortInval(new NodeId((long)localId)),
                          SUBSCRIPTION_TIMEOUT_MS, MAX_FORCE_MS, MAX_DELAY_MS);
      
      ObjId[] objId = new ObjId[1];
      objId[0] = new ObjId("/" + supplier + "/" + i);
      issueBody(objId[0], 0, interInputSize, 0, 
                new NodeId(supplier), new NodeId(localId),
                Config.getDNS(new NodeId((long)localId)),
                Config.getPortBody(new NodeId((long)localId)),
                rmiClient);
      waitForFiles(objId, 0, interInputSize, supplier, supplier, (int)exeChunk+i);
      
      // terminate the subscription after files received
//        rmiClient.unSubscribe();
//      }
    } catch (Exception e){
      e.printStackTrace();
    }
  }

  public int getWriteCount(){
    return interFileCount;
  }

  /********** protected methods to be overritten by sub classes*******************/

  protected void waitForFiles(ObjId[] oids, int offset, long length, int writer, int supplier, int as){
    NodeId wid = new NodeId(writer);
    NodeId sid = new NodeId(supplier);
    RMIClient rmiClient = new RMIClient();
    LocalInterface li = node.getLocalInterface();
    long hint = as;
    try{
//      hint = node.getCurrentVV().getStampByServer(wid);
//      if(hint < 0){ // We shall receive at least one inval before reading the body
//        System.out.println("waiting for inval " + 0 + " to arrive from " + sid);
      System.out.println("Sync on: " + new AcceptStamp(hint, wid));
      li.sync(new AcceptStamp(hint, wid));
      System.out.println("done syncing");
//      System.out.println(node.getCurrentVV());
//        hint = 0;
//      }
    } catch (Exception nsee){
      assert false;
    }

    BodyMsg bm = null;
    for(int i=0; i<oids.length; i++){
      while(bm == null){
        try{
          System.out.println("reading: " + oids[i]);
/*          rmiClient.issueDemandRead(oids[i], offset, length, 0, sid, new NodeId(localId),
                                    Config.getDNS(new NodeId((long)localId)),
                                    Config.getPortBody(new NodeId((long)localId))); */
          bm = li.readBlockInvalid(oids[i], offset, length, true);
	  System.out.println("Ha.. successfully read "+oids[i]) ;
        } catch (ObjNotFoundException onfe){
          //hint ++;
          try{
            System.out.println("Object not available yet locally." + oids[i]);
            System.out.println("Sync on: " + new AcceptStamp(hint, wid));
            li.sync(new AcceptStamp(hint, wid));
            System.out.println("done syncing");
          } catch (Exception ee){
            ee.printStackTrace();
          } 
        }catch (Exception e){
          e.printStackTrace();
          assert false;
        }
      }
/*      try{
        assert hint <= node.getCurrentVV().getStampByServer(wid);
        hint =  node.getCurrentVV().getStampByServer(wid);
      } catch (NoSuchEntryException nsee){
        assert false;
      }
*/
      bm = null;
    }
  }

  protected int getParentNode(){
    if(localId == 0){
      return -1;
    } else {
      double level = 0;
      int levelMaxValue = (int) Math.pow((double)fanout, level) - 1;
      while(levelMaxValue < localId){
        level ++;
        levelMaxValue = levelMaxValue + (int) Math.pow((double)fanout, level);
      }
      // local Level Index is 0 based index ( see "- 1" in the formular below
      int preLevelMaxValue = levelMaxValue - (int) Math.pow((double)fanout, level);
      int localLevelIndex = localId - preLevelMaxValue - 1;
      // parentLevelIndex is also 0 based
      int parentLevelIndex = localLevelIndex / fanout;
      int preLevelCount = (int) Math.pow((double)fanout, level-1);
      int parentId =  preLevelMaxValue - (preLevelCount - parentLevelIndex - 1);
      return parentId;
    }
  }

  protected int getPeer(){
    // simple rule: a node always read from next several consecutive ones on the ring
    // But ignore the central node "0"  (i.e. ring construction omits 0 node
    int[] ids = Config.getNodesExclusive(0);
    int totalOthers = ids.length;

    // assume that the intermediate file count is less than server replicas
    assert totalOthers > interFileCount;

//    int[] peers = new int[interFileCount];
//    for(int i=0; i<interFileCount; i++){
    int peer = -1;
    while(peer==-1 || peer==localId){
      peer = r.nextInt(totalOthers) + 1;
      // do not let the same peer to be returned more than once.
      if(knownPeers.containsKey(new Integer(peer))){
        peer = -1;
      } else {
        knownPeers.put(new Integer(peer), new Integer(peer));
      }
    }
//    }
    
    return peer;
  }

  protected String getResultSet(){
    return "/*";
  }

  protected void issueBody(ObjId id,
                           long offset,
                           long length,
                           long requestId, 
                           NodeId supplierNodeId,
                           NodeId readerNodeId,
                           String readerNodeDNS,
                           int readerPortBody, 
                           RMIClient rmiClient) 
                           throws RMINetworkException, RMIApplicationException,
                           ObjNotFoundException, IOException, ReadOfInvalidRangeException,
                           EOFException{
    boolean found = false;
    while(!found){
      try{
        System.out.println(id + " is to be requested from " + supplierNodeId);
        rmiClient.issueDemandRead(id, offset, length, requestId, supplierNodeId,
                                  readerNodeId, readerNodeDNS, readerPortBody);
        found = true;
      } catch (ObjNotFoundException onfe){
        try{
          Thread.sleep(1000);
        } catch (InterruptedException ie){
        }
        System.out.println(id + " not available yet, try again!");
      } catch (Exception e){
        e.printStackTrace();
      }
    }
  }
  
  protected void centralServerFunction(int count){
  }

  protected void runExp(BarrierClient bc){
    long interval = 0;
    long startT = 0;
    StatsRecord preSR = null;
    StatsRecord curSR = null;
    StatsRecord diffSR = null;
    
    preSR = Stats.createRecord();
      
    if(Config.getMyNodeId().getIDint() == 0){
      // central server initiate files
      initWrites();
      // notify the barrier server that the init. files are ready on central server
      System.out.println("1: Initial file population done at the central server!");
      bc.sendBarrierRequest(-1, -1);      
      curSR = Stats.createRecord();
      diffSR = curSR.getDiff(preSR);
      preSR = curSR;


      // wait for files to be propagated to other nodes      
      System.out.println("2: Start file propagation to other nodes!");
      bc.sendBarrierRequest(-1, -1);
      System.out.println("3: Wait for file propogation...");
      bc.sendBarrierRequest(-1, -1);
      curSR = Stats.createRecord();
      diffSR = curSR.getDiff(preSR);
      preSR = curSR;
      System.out.println("4: Total time used and bytes transfered are sent to barrier server.");
      bc.sendBarrierRequest(-1, diffSR.getTotal());
      
      // wait for peer-wise communication among other nodes
      System.out.println("5: Start computation at other nodes!");
      startT = System.currentTimeMillis();
      centralServerFunction(getWriteCount());
      interval = System.currentTimeMillis()-startT;
      System.out.println("6: Done peer-wise computation.");
      bc.sendBarrierRequest(-1, -1); 
      curSR = Stats.createRecord();
      diffSR = curSR.getDiff(preSR);
      preSR = curSR;
      System.out.println("7: Total time used and bytes transfered are sent to barrier server.");
      bc.sendBarrierRequest(interval, diffSR.getTotal()); 

      // reports time when receive result from all machines
      System.out.println("8: Start receiving results from other nodes!");
/*      try{
        Thread.sleep(5000);
        } catch (InterruptedException ie){} */
      //ConstrainedOutputStream.setBW(ConstrainedOutputStream.getBW()/50);
      startT = System.currentTimeMillis();
      synchResults();
      interval = System.currentTimeMillis() - startT;
      System.out.println("9: Done receiving all results");
      bc.sendBarrierRequest(-1, -1); 
      curSR = Stats.createRecord();
      diffSR = curSR.getDiff(preSR);
      preSR = curSR;
      System.out.println("10: Total time used and bytes transfered are sent to barrier server.");
      bc.sendBarrierRequest(interval, diffSR.getTotal());
      System.out.println("11: Exp. completed.... See barrier server for stats.");

//      plDriver.printAllStats();
      
    } else {
      // wait for others to start and init. files' population on central server
      System.out.println("1: Waiting for file population at the central server!");
      bc.sendBarrierRequest(-1, -1); 
      curSR = Stats.createRecord();
      diffSR = curSR.getDiff(preSR);
      preSR = curSR;

      // wait for the init files to arrive
      System.out.println("2: Start receiving init files...");
      bc.sendBarrierRequest(-1, -1);
      startT = System.currentTimeMillis();
      synchInitFiles();
      interval = System.currentTimeMillis()-startT;
      System.out.println("3: Done receiving init files ...");
      bc.sendBarrierRequest(-1, -1);
      curSR = Stats.createRecord();
      diffSR = curSR.getDiff(preSR);
      preSR = curSR;
      System.out.println("4: Total time used and bytes transfered are sent to barrier server.");
      bc.sendBarrierRequest(interval, diffSR.getTotal());
      
      System.out.println("5: Start computation and file exchanges at individual servers!");
      // Peerwise msg exchange
      startT = System.currentTimeMillis();
      // write to Q files
      int count = getWriteCount();
      for(int i=0; i<count; i++){
        runWrite(i);
        if(i==0){
          try{
            Thread.sleep(50000);
          } catch (InterruptedException ie){}
        }
        // read Q files 
        runRead(i);
      }
      interval = System.currentTimeMillis()-startT-50000;
      System.out.println("6: Done peer-wise computation.");
      bc.sendBarrierRequest(-1, -1);
      curSR = Stats.createRecord();
      diffSR = curSR.getDiff(preSR);
      preSR = curSR;
      System.out.println("7: Total time used and bytes transfered are sent to barrier server.");
      produceResult();
      bc.sendBarrierRequest(interval, diffSR.getTotal());

      // wait for central server to retrieve results
      System.out.println("8: Start sending results to the central server!");
      ConstrainedOutputStream.setBW(ConstrainedOutputStream.getBW()/2);
      startT = System.currentTimeMillis();
      bc.sendBarrierRequest(-1, -1);
      interval = System.currentTimeMillis()-startT;
      System.out.println("9: Done sending results to the central server!");
      curSR = Stats.createRecord();
      diffSR = curSR.getDiff(preSR);
      preSR = curSR;
      System.out.println("10: Total time used and bytes transfered are sent to barrier server.");
      bc.sendBarrierRequest(interval, diffSR.getTotal());
      System.out.println("11: Experiment done! See results at the barrier server!");
    }
    
    System.out.println(Stats.createRecord());
  }
   
  protected boolean getInitWriteType(){
    return false;
  }

  protected boolean getInterWriteType(){
    return false;
  }

  protected boolean getResultWriteType(){
    return false;
  }
 
  public void printAllStats(){
    Stats.reset();
    RMIClient rmiClient = new RMIClient();
    for (Enumeration e = Config.getKnownNodeIds(); e.hasMoreElements();){
      NodeId id = (NodeId)e.nextElement();
      Hashtable h = null;
      try{
        h = rmiClient.getStats(id);
      } catch (Exception exc){
        exc.printStackTrace();
        assert(false);
        System.exit(-1);
      }
      if((h == null) || (h.size() == 0)){
        Env.printDebug("Machine " + Config.getRMIUrl(id) +
                       " sent no data");
      } else {
        for(Enumeration entry = h.keys(); entry.hasMoreElements();){
          String s = (String)entry.nextElement();
          Long value = (Long)h.get(s);
          assert(value != null);
          Stats.put(s,value.longValue());
        }
      }
    }
    System.out.println(Stats.createRecord());
  }
  
  /*********** main ***********/

  public static void main(String[] argv){
    URANode n = new URANode(argv[0], null, Controller.NULL_CONTROLLER, false);
    System.out.println((int)Config.getMyNodeId().getIDint());
    long chk = (new Long(argv[1])).longValue();
    long chksz = (new Long(argv[2])).longValue();
    long iip = (new Long(argv[3])).longValue();
    int ic = (new Integer(argv[4])).intValue();
    long op = (new Long(argv[5])).longValue();
    int tw = (new Integer(argv[6])).intValue();
    String bServer = "borage.cs.utexas.edu";
    int bServerPort = 9494 ;
	if(argv.length > 7) {
    	bServer = argv[7] ;
    	bServerPort = (new Integer(argv[8])).intValue();
	}
    int sid = (int)Config.getMyNodeId().getIDint();
    //BarrierClient bc = new BarrierClient("borage.cs.utexas.edu", 9494, sid);
    BarrierClient bc = new BarrierClient(bServer, bServerPort, sid);

//    assert ic < tw;
    
    PLExpDriver plDriver = new PLExpDriver(chk, chksz, iip, ic, op, tw, n);
    plDriver.runExp(bc);
  }
}
