public class PLFSPlusExpDriver extends PLExpDriver{

  public PLFSPlusExpDriver(long chunk, long chunk_size, long interInput, int interInputCount, long output, int treeWidth, URANode n){
    super(chunk, chunk_size, interInput, interInputCount, output, treeWidth, n);
  }

  public void runWrite(int j){
    if(j!=0){
      return;
    }
    setupSubscriptions();
    for(int i=0; i<interFileCount; i++){
      super.runWrite(i);
    }
  }

  public void runRead(int j){
    if(j!=0){
      return;
    }
    RMIClient rmiClient = new RMIClient();
    for(int i=0; i<interFileCount; i++){
      int supplier = getPeer();
      ObjId[] objId = new ObjId[1];
      objId[0] = new ObjId("/" + supplier + "/" + i);
      try{
        issueBody(objId[0], 0, interInputSize, 0, 
                  new NodeId(supplier), new NodeId(localId),
                  Config.getDNS(new NodeId((long)localId)),
                  Config.getPortBody(new NodeId((long)localId)),
                  rmiClient);
        waitForFiles(objId, 0, interInputSize, supplier, supplier, (int)exeChunk+i);
      } catch (Exception e){
        e.printStackTrace();
      }
    }
  }

  public void synchResults(){
    int[] otherNodes = Config.getNodesExclusive(0);
    for(int i=0; i<otherNodes.length; i++){
      ObjId[] objId = new ObjId[1];
      objId[0] = new ObjId("/00/" + otherNodes[i]);
      waitForFiles(objId, 0, outputSize, otherNodes[i], otherNodes[i], (int)exeChunk+interFileCount);
    }
  }

  public void produceResult(){
    super.produceResult();
    ObjId[] objId = new ObjId[1];
    objId[0] = new ObjId("/00/" + localId);
    RMIClient rmiClient = new RMIClient();
    try{
      issueBody(objId[0], 0, outputSize, 0,
                new NodeId(localId), new NodeId(0),
                Config.getDNS(new NodeId(0)),
                Config.getPortBody(new NodeId(0)), 
                rmiClient);
    } catch (Exception e){
      e.printStackTrace();
      assert false;
    }
  }

  public void setupSubscriptions(){
    String[] s = new String[1];
    s[0] = new String("/*");
    SubscriptionSet set = SubscriptionSet.makeSubscriptionSet(s);
    RMIClient rmiClient = new RMIClient();

    try{
      int pid = getParentNode();
      if(pid >= 0){
        CounterVV startVV = new CounterVV(AcceptVV.makeVVAllNegatives());
        startVV.setStampByServer(new NodeId(0), exeChunk-1);
        System.out.println(localId + " subscribe to " + pid);
        rmiClient.subscribe(set, startVV,
                            new NodeId(pid), new NodeId(localId), 
                            Config.getDNS(new NodeId((long)localId)), 
                            Config.getPortInval(new NodeId((long)localId)),
                            SUBSCRIPTION_TIMEOUT_MS, MAX_FORCE_MS, MAX_DELAY_MS);
        System.out.println(pid + " subscribe to " + localId);
        rmiClient.subscribe(set, startVV,
                            new NodeId(localId), new NodeId(pid), 
                            Config.getDNS(new NodeId(pid)), 
                            Config.getPortInval(new NodeId(pid)),
                            SUBSCRIPTION_TIMEOUT_MS, MAX_FORCE_MS, MAX_DELAY_MS);
      }
    } catch(Exception e){
      e.printStackTrace();
    }
  }

  /*********** main ***********/

  public static void main(String[] argv){
    URANode n = new URANode(argv[0], null, Controller.NULL_CONTROLLER, false);
    System.out.println((int)Config.getMyNodeId().getIDint());
    long chk = (new Long(argv[1])).longValue();
    long chksz = (new Long(argv[2])).longValue();
    long iip = (new Long(argv[3])).longValue();
    int ic = (new Integer(argv[4])).intValue();
    long op = (new Long(argv[5])).longValue();
    int tw = (new Integer(argv[6])).intValue();
    int sid = (int)Config.getMyNodeId().getIDint();
    String bServer = argv[7] ;
    int bServerPort = (new Integer(argv[8])).intValue();
    //BarrierClient bc = new BarrierClient("borage.cs.utexas.edu", 9494, sid);
    BarrierClient bc = new BarrierClient(bServer, bServerPort, sid);
    //    BarrierClient bc = new BarrierClient("borage.cs.utexas.edu", 9494, sid);
    
//    assert ic < tw;
    
    PLFSPlusExpDriver plDriver = new PLFSPlusExpDriver(chk, chksz, iip, ic, op, tw, n);
    plDriver.runExp(bc);
  }
}
