//import java.util.Date ;

public class PLFSPlusSDIMSExpDriver extends PLExpDriver{

    private int fanout ;
    private long chunkSize ;
  public PLFSPlusSDIMSExpDriver(long chunk, long chunk_size, long interInput, int interInputCount, long output, int treeWidth, URANode n){
    super(chunk, chunk_size, interInput, interInputCount, output, treeWidth, n);
    fanout = treeWidth ;
    chunkSize = chunk_size ;
  }

  public void runWrite(int j){
    if(j!=0){
      return;
    }
    //setupSubscriptions();
    for(int i=0; i<interFileCount; i++){
      super.runWrite(i);
    }
  }

  public void runRead(int j){
    if(j!=0){
      return;
    }
    RMIClient rmiClient = new RMIClient();
    for(int i=0; i<interFileCount; i++){
      int supplier = getPeer();
      ObjId[] objId = new ObjId[1];
      objId[0] = new ObjId("/" + supplier + "/" + i);
      try{
	  /*issueBody(objId[0], 0, interInputSize, 0, 
                  new NodeId(supplier), new NodeId(localId),
                  Config.getDNS(new NodeId((long)localId)),
                  Config.getPortBody(new NodeId((long)localId)),
                  rmiClient); */
	LocalInterface li = node.getLocalInterface() ;
	li.informDemandReadMiss(objId[0], 0, interInputSize) ;
	
        waitForFiles(objId, 0, interInputSize, supplier, supplier, (int)exeChunk+i);
      } catch (Exception e){
        e.printStackTrace();
      }
    }
  }

  public void synchResults(){
    int[] otherNodes = Config.getNodesExclusive(0);
    for(int i=0; i<otherNodes.length; i++){
      ObjId[] objId = new ObjId[1];
      objId[0] = new ObjId("/00/" + otherNodes[i]);
      LocalInterface li = node.getLocalInterface() ;
      li.informDemandReadMiss(objId[0], 0, outputSize) ;
    }
    for(int i=0; i<otherNodes.length; i++){
      ObjId[] objId = new ObjId[1];
      objId[0] = new ObjId("/00/" + otherNodes[i]);
      waitForFiles(objId, 0, outputSize, otherNodes[i], otherNodes[i], (int)exeChunk+interFileCount);
    }
  }

  public void produceResult(){
    super.produceResult();
    /*    ObjId[] objId = new ObjId[1];
    objId[0] = new ObjId("/00/" + localId);
    RMIClient rmiClient = new RMIClient();
    try{
      issueBody(objId[0], 0, outputSize, 0,
                new NodeId(localId), new NodeId(0),
                Config.getDNS(new NodeId(0)),
                Config.getPortBody(new NodeId(0)), 
                rmiClient);
    } catch (Exception e){
      e.printStackTrace();
      assert false;
      }*/
  }

  public void setupSubscriptions(){
    String[] s = new String[1];
    s[0] = new String("/*");
    SubscriptionSet set = SubscriptionSet.makeSubscriptionSet(s);
    RMIClient rmiClient = new RMIClient();

    try{
      int pid = getParentNode();
      
      if(pid >= 0){
        CounterVV startVV = new CounterVV(AcceptVV.makeVVAllNegatives());
        startVV.setStampByServer(new NodeId(0), exeChunk-1);
        System.out.println(localId + " subscribe to " + pid);
        rmiClient.subscribe(set, startVV,
                            new NodeId(pid), new NodeId(localId), 
                            Config.getDNS(new NodeId((long)localId)), 
                            Config.getPortInval(new NodeId((long)localId)),
                            SUBSCRIPTION_TIMEOUT_MS, MAX_FORCE_MS, MAX_DELAY_MS);
        System.out.println(pid + " subscribe to " + localId);
        rmiClient.subscribe(set, startVV,
                            new NodeId(localId), new NodeId(pid), 
                            Config.getDNS(new NodeId(pid)), 
                            Config.getPortInval(new NodeId(pid)),
                            SUBSCRIPTION_TIMEOUT_MS, MAX_FORCE_MS, MAX_DELAY_MS);
      }
    } catch(Exception e){
      e.printStackTrace();
    }
  }

  public void initWrites(){
    try{
	/*	System.out.println("sleeping  before populating.. just press enter or some key to continue");
	byte b[] = new byte[1] ;
	System.in.read(b) ;
	*/
	System.out.println("sleeping for 2minutes so that multicast subscription trees are formed properly\n") ;
	Thread.sleep(12000) ;

      LocalInterface li = node.getLocalInterface();
      ImmutableBytes buffer = URANode.populateByteArray(chunkSize);
      boolean bound = getInitWriteType();
      
      for(int i=0; i<exeChunk; i++){
        String oid = "/0/" + i;
        ObjId objId = new ObjId(oid);
        li.write(objId, 0, chunkSize, buffer, bound);
      }
    } catch (Exception e){
      e.printStackTrace();
    }
  }

  public void synchInitFiles(){
    RMIClient rmiClient = new RMIClient();
    try{
	//System.out.println("sleeping for 20 secs") ;
	//Thread.sleep(20000) ;
      int pid = getParentNode();
      String[] s = new String[1];
      s[0] = new String(initSet);
      /*SubscriptionSet set = SubscriptionSet.makeSubscriptionSet(s);
      // start subscription of invals (init files are sent as bound invals)
      CounterVV endVV = new CounterVV(AcceptVV.makeVVAllNegatives());
      endVV.setStampByServer(new NodeId(0), exeChunk-1);
      System.out.println(localId + " subscribe to " + pid);
      rmiClient.subscribe(set, AcceptVV.makeVVAllNegatives(), endVV, 
                          new NodeId(pid), new NodeId(localId),  
                          Config.getDNS(new NodeId((long)localId)),
                          Config.getPortInval(new NodeId((long)localId)),
                          SUBSCRIPTION_TIMEOUT_MS, MAX_FORCE_MS, MAX_DELAY_MS);
      
      */
      // try to read the actual files locally
      ObjId[] objId = new ObjId[(int)exeChunk];
      
      for(int i=0; i<exeChunk; i++){
        objId[i] = new ObjId("/0/" + i);
	LocalInterface li = node.getLocalInterface() ;
	li.informDemandReadMiss(objId[i], 0, chunkSize) ;
	
	/* issueBody(objId[i], 0, chunkSize, 0, 
                  new NodeId(pid), new NodeId(localId),
                  Config.getDNS(new NodeId((long)localId)),
                  Config.getPortBody(new NodeId((long)localId)),
                  rmiClient);
	*/
      }
      long before = System.currentTimeMillis() ;
	System.out.println("Before waiting "+ before) ;
      waitForFiles(objId, 0, chunkSize, 0, pid, (int)exeChunk-1);
	System.out.println("waiting time (ms) "+(System.currentTimeMillis() - before)) ;
        
      // terminate the subscription after files received
      //      rmiClient.unSubscribe();

	//Thread.sleep(40000) ;
    } catch (Exception e){
      e.printStackTrace();
      assert false;
    }
  }
  
    
 protected void waitForFiles(ObjId[] oids, int offset, long length, int writer, int supplier, int as){
    NodeId wid = new NodeId(writer);
    NodeId sid = new NodeId(supplier);
    RMIClient rmiClient = new RMIClient();
    LocalInterface li = node.getLocalInterface();
    long hint = as;
    try{
//      hint = node.getCurrentVV().getStampByServer(wid);
//      if(hint < 0){ // We shall receive at least one inval before reading the body
//        System.out.println("waiting for inval " + 0 + " to arrive from " + sid);
      System.out.println("Sync on: " + new AcceptStamp(hint, wid));
      li.sync(new AcceptStamp(hint, wid));
      System.out.println("done syncing");
//      System.out.println(node.getCurrentVV());
//        hint = 0;
//      }
    } catch (Exception nsee){
      assert false;
    }

    BodyMsg bm = null;
    for(int i=0; i<oids.length; i++){
      while(bm == null){
        try{
          System.out.println("reading: " + oids[i]);
/*          rmiClient.issueDemandRead(oids[i], offset, length, 0, sid, new NodeId(localId),
                                    Config.getDNS(new NodeId((long)localId)),
                                    Config.getPortBody(new NodeId((long)localId))); */
          bm = li.readBlockInvalid(oids[i], offset, length, true);
          //bm = li.read(oids[i], offset, length, false, true);
	  System.out.println("Ha.. successfully read "+oids[i]) ;
        } catch (ObjNotFoundException onfe){
          //hint ++;
          try{
            System.out.println("Object not available yet locally." + oids[i]);
            System.out.println("Sync on: " + new AcceptStamp(hint, wid));
            li.sync(new AcceptStamp(hint, wid));
            System.out.println("done syncing");
          } catch (Exception ee){
            ee.printStackTrace();
          } 
	  //}catch (ReadOfInvalidRangeException roire) {
	  // li.informDemandReadMiss(oids[i], offset, length);
        }catch (Exception e){
          e.printStackTrace();
          assert false;
        }
      }
/*      try{
        assert hint <= node.getCurrentVV().getStampByServer(wid);
        hint =  node.getCurrentVV().getStampByServer(wid);
      } catch (NoSuchEntryException nsee){
        assert false;
      }
*/
      bm = null;
    }
  }


  protected int getParentNode(){
    if(localId == 0){
      return -1;
    } else {
      double level = 0;
      int levelMaxValue = (int) Math.pow((double)fanout, level) - 1;
      while(levelMaxValue < localId){
        level ++;
        levelMaxValue = levelMaxValue + (int) Math.pow((double)fanout, level);
      }
      // local Level Index is 0 based index ( see "- 1" in the formular below
      int preLevelMaxValue = levelMaxValue - (int) Math.pow((double)fanout, level);
      int localLevelIndex = localId - preLevelMaxValue - 1;
      // parentLevelIndex is also 0 based
      int parentLevelIndex = localLevelIndex / fanout;
      int preLevelCount = (int) Math.pow((double)fanout, level-1);
      int parentId =  preLevelMaxValue - (preLevelCount - parentLevelIndex - 1);
      System.out.println("Parent id is "+parentId) ;
      return parentId;
    }
  }

  /*********** main ***********/

  public static void main(String[] argv){
      //rice.pastry.Log.init(argv) ;
    // set idBase in SDIMS routing table to 1 so to avoid
    //  fat trees
      rice.pastry.routing.RoutingTable.idBaseBitLength = 1 ;
//	  System.setProperty("sun.rmi.transport.connectionTimeout", "1800000") ;
//	  System.setProperty("sun.rmi.transport.tcp.handshakeTimeout", "1800000") ;
	  //System.setProperty("sun.rmi.activation.execTimeout", "1800000") ;
	  //System.setProperty("sun.rmi.transport.proxy.connectTimeout", "1800000") ;
	  //System.setProperty("sun.rmi.transport.proxy.connectTimeout", "1800000") ;

      URANode n = new URANode(argv[0], null, Controller.SDIMS_CONTROLLER, false);
      //URANode n = new URANode(argv[0], null, Controller.NULL_CONTROLLER, false);
    System.out.println((int)Config.getMyNodeId().getIDint());
    long chk = (new Long(argv[1])).longValue();
    long chksz = (new Long(argv[2])).longValue();
    long iip = (new Long(argv[3])).longValue();
    int ic = (new Integer(argv[4])).intValue();
    long op = (new Long(argv[5])).longValue();
    int tw = (new Integer(argv[6])).intValue();
    int sid = (int)Config.getMyNodeId().getIDint();
    String bServer = argv[7] ;
    int bServerPort = (new Integer(argv[8])).intValue();
    //BarrierClient bc = new BarrierClient("borage.cs.utexas.edu", 9494, sid);
    BarrierClient bc = new BarrierClient(bServer, bServerPort, sid);
    //    BarrierClient bc = new BarrierClient("borage.cs.utexas.edu", 9494, sid);
    
//    assert ic < tw;
    
    PLFSPlusSDIMSExpDriver plDriver = new PLFSPlusSDIMSExpDriver(chk, chksz, iip, ic, op, tw, n);
    plDriver.runExp(bc);
  }
}
