#!/bin/tcsh

rm -rf *.final

echo ",Distribute, Pairwise, Read" >> avg.final
echo ",Write, Pairwise, Read" >> max.final

set FS=(plfs plfs-sdims bfs cfs nfs)
set FSNAME=(PLFS+ PLFS-SDIMS BAYOU COOP NFS)

foreach SEED (1 2 3 4 5)
# -v 0 prints average and -v 1 prints maximum value
    cat ${FS[$SEED]}.data | gawk -v total=50 -v type=0 -v cum=$1 -v fn=${FSNAME[$SEED]} -f tproc.awk >> avg.final
    cat ${FS[$SEED]}.data | gawk -v total=50 -v type=1 -v cum=$1 -v fn=${FSNAME[$SEED]} -f tproc.awk >> max.final
end

./barchart4 avg.final avg.eps --y-min=0 --y-max=250 --show-data-label-value=no  --first-data-line-as-legend=yes --y-major-unit=20 --x-axis-label-column=0 --x-axis-type=category --set-key=left --set-label-fonts=Helvetica,18 --y-axis-title="Time(s)"



./barchart4 max.final max.eps --y-min=0 --y-max=300 --show-data-label-value=no  --first-data-line-as-legend=yes --y-major-unit=20 --x-axis-label-column=0 --x-axis-type=category --set-key=left --set-label-fonts=Helvetica,18 --y-axis-title="Time(s)"

#gv avg.eps&
#gv max.eps&

#./barchart$1 avg.final avg.eps --y-min=0 --y-max=250 --show-data-label-value=yes  --x-axis-title="PLFS+               PLFS-SDIMS           Bayou                     Coop                     NFS           " --first-data-line-as-legend=yes --chart-title="Grid File System (avg.)"
#./barchart$1 avg.final avg.eps --y-max=250 --show-data-label-value=yes  --first-data-line-as-legend=yes --y-major-unit=20 --x-axis-label-column=0 --x-axis-type=category --set-key=left --set-label-fonts=Helvetica,18 --y-axis-title="Time(s)"
#gv avg.eps& 
#./barchart$1 max.final max.eps --y-min=0 --y-max=300 --show-data-label-value=yes  --x-axis-title="PLFS+              PLFS-SDIMS           Bayou                     Coop                     NFS           " --first-data-line-as-legend=yes --chart-title="Grid File System (max.)"
#gv max.eps&
#cat avg.final | gawk -f proc.awk > average.data
#cat max.final | gawk -f proc.awk > max.data

#gnuplot average.plot
#gnuplot max.plot


