 /** 
 *  Global Coordinator 
 *  Read scripts from standard input 
 *  Currently have 4 kinds of commands: subscribe, subscribeBody, 
 *                                      issueDemandRead, and sleep 
 **/ 
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.HashMap;
import java.util.Random;
import java.util.Vector;

public class SanityCheck extends CoordExptA
{
    public static long SUBSCRIPTION_DURATION_MS = 1000000;  // 1000 seconds
    public static long MAX_DELAY_MS = 1000; // 1 second

 /** 
 *  Constructor 
 **/ 
    public SanityCheck(String exptConfigFileName, String shellType_)
    {
	super(exptConfigFileName, shellType_);
    }

 /** 
 *  Demand Read all the files one by one 
 **/ 
    public void demandReadAllFiles(int supplierNodeId, int receiverNodeId, long numFiles, long fileSize){
	for(long i = 0; i < numFiles; i++){
	    String fileName = this.senderScriptGen.createFileName(i, numFiles);
	    this.issueDemandRead(supplierNodeId,
				 receiverNodeId,
				 fileName,
				 0,
				 fileSize,
				 i);
	}
    }

 /** 
 *  Perform experiment actions 
 **/ 
    public void runSanityCheck(long numFiles, long fileSize)
    {
	CoordCommPacket ccp = null;
	StatsRecord initStats = null;
	StatsRecord finalStats = null;
	StatsRecord diffStats = null;
	SubscriptionSet dis = null;
        
        long start, end;
        double avgMS;
        AcceptStamp asAfterWrite, asAfterRead;
	
	this.restartRMIRegistrySync();
	this.startNode(9);
	this.startNode(10);
	this.waitStartNode(9);
	this.waitStartNode(10);

	//send a sequential write of all the file once to the sender and wait 
        // for the sender to send back its final acceptstamp
        
        //1.  time to write 1000 small files
        start = System.currentTimeMillis();
	this.sendPopulateFullScript(9, 
                                    false, //bound
                                    numFiles, //numFiles
                                    fileSize);   // file size

        ccp = this.recv(9);
	assert(ccp.getSignalType() == CoordCommPacket.ACCEPT_STAMP);
	assert(ccp.getData() instanceof AcceptStamp);
        
        end = System.currentTimeMillis();
        avgMS = ((double)((double)end - (double)start))/((double)(numFiles));
        System.err.println("==========Write "+ fileSize + " byte File: " + avgMS + "ms");

        asAfterWrite = (AcceptStamp)ccp.getData();

        //2.  time to read 1000 small files
        start = System.currentTimeMillis();
	this.sendSequentialReadScript(9, 
                                      numFiles, //numFiles
                                      fileSize);   // file size
	ccp = this.recv(9);
	assert(ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	assert(ccp.getData() == null);
        //asAfterRead = (AcceptStamp)ccp.getData();
        //assert asAfterRead.equals(asAfterWrite);

        //note the time includes an overhead of get the AcceptStamp.
        end = System.currentTimeMillis();
        avgMS = ((double)((double)end - (double)start))/((double)(numFiles));
        System.err.println("==========Read "+ fileSize + "byte File: " + avgMS + "ms");

	dis = SubscriptionSet.makeSubscriptionSet(":/*");
	
	this.issueSubscribe(9,
			    10,
			    AcceptVV.makeVVAllNegatives(),

			    dis,
			    SUBSCRIPTION_DURATION_MS,
			    MAX_DELAY_MS);
	this.sendSync(10, asAfterWrite);
	ccp = this.recv(10);
	assert(ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	assert(ccp.getData() == null);
	System.err.println("Received a SYNC_DONE");
	// Sender and receiver have synchronized for the first initial
        // sequential writes.
        
        // 3. time to read precise invalid
        //    evaluate it by subscribing body and readBlockInvalid
       
	initStats = this.getAllStats();
        start = System.currentTimeMillis();
	Env.warn("replace demandread with issueSubscribeBody when" +
		 " issueSubscribeBody is implemented"); 
	/*
        this.issueSubscribeBody(9,
                                10,
                                AcceptVV.makeVVAllNegatives(),
                                dis,
                                SUBSCRIPTION_DURATION_MS);
	*/
	this.demandReadAllFiles(9, 
				10,
				numFiles,
				fileSize);
	
        this.sendSequentialReadScript(10, 
                                      numFiles, //numFiles
                                      fileSize);   // file size

	
	ccp = this.recv(10);
	
	assert(ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	assert(ccp.getData()== null);
        //asAfterRead = (AcceptStamp)ccp.getData();
        //assert asAfterRead.equals(asAfterWrite);
        end = System.currentTimeMillis();
	avgMS = ((double)((double)end - (double)start))/((double)(numFiles));
        System.err.println("==========Read "+ fileSize + "byte File precise Invalid: " + 
                           avgMS + "ms");
	
	
        this.startNode(11);
	
	this.waitStartNode(11);
        
	
        //4. time to read imprecise invalid
        this.issueSubscribe(9,
                            11,
                            AcceptVV.makeVVAllNegatives(),
                            
                            SubscriptionSet.makeSubscriptionSet("/a"),//dummy dir
                            SUBSCRIPTION_DURATION_MS,
			    MAX_DELAY_MS);

        this.sendSync(11, asAfterWrite);

        ccp = this.recv(11);

        assert(ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
        assert(ccp.getData() == null);
        System.err.println("Received second SYNC_DONE");
        
        //now on node 11 every file is imprecise
        // the following subscribe make it incrementally precise
        // question: will all the files in node 11 be precise after this?
        start = System.currentTimeMillis();
        this.issueSubscribe(9,
                            11,
                            AcceptVV.makeVVAllNegatives(),
                            
                            SubscriptionSet.makeSubscriptionSet("/5/*"),
                            SUBSCRIPTION_DURATION_MS,
			    MAX_DELAY_MS);

        this.issueSubscribe(9,
                            11,
                            AcceptVV.makeVVAllNegatives(),
                            
                            SubscriptionSet.makeSubscriptionSet("/4/*"),
                            SUBSCRIPTION_DURATION_MS,
			    MAX_DELAY_MS);

        this.issueSubscribe(9,
                            11,
                            AcceptVV.makeVVAllNegatives(),
                            
                            SubscriptionSet.makeSubscriptionSet("/3/*"),
                            SUBSCRIPTION_DURATION_MS,
			    MAX_DELAY_MS);

        this.issueSubscribe(9,
                            11,
                            AcceptVV.makeVVAllNegatives(),
                            
                            SubscriptionSet.makeSubscriptionSet("/2/*"),
                            SUBSCRIPTION_DURATION_MS,
			    MAX_DELAY_MS);

        this.issueSubscribe(9,
                            11,
                            AcceptVV.makeVVAllNegatives(),
                            
                            SubscriptionSet.makeSubscriptionSet("/1/*"),
                            SUBSCRIPTION_DURATION_MS,
			    MAX_DELAY_MS);

        this.issueSubscribe(9,
                            11,
                            AcceptVV.makeVVAllNegatives(),
                            
                            SubscriptionSet.makeSubscriptionSet("/0/*"),
                            SUBSCRIPTION_DURATION_MS,
			    MAX_DELAY_MS);

        this.issueSubscribe(9,
                            11,
                            AcceptVV.makeVVAllNegatives(),
                            
                            SubscriptionSet.makeSubscriptionSet("/9/*"),
                            SUBSCRIPTION_DURATION_MS,
			    MAX_DELAY_MS); 

        this.issueSubscribe(9,
                            11,
                            AcceptVV.makeVVAllNegatives(),
                            
                            SubscriptionSet.makeSubscriptionSet("/8/*"),
                            SUBSCRIPTION_DURATION_MS,
			    MAX_DELAY_MS);

        this.issueSubscribe(9,
                            11,
                            AcceptVV.makeVVAllNegatives(),
                            
                            SubscriptionSet.makeSubscriptionSet("/7/*"),
                            SUBSCRIPTION_DURATION_MS,
			    MAX_DELAY_MS);

       this.issueSubscribe(9,
                            11,
                            AcceptVV.makeVVAllNegatives(),
                            
                            SubscriptionSet.makeSubscriptionSet("/6/*"),
                            SUBSCRIPTION_DURATION_MS,
			    MAX_DELAY_MS);

       this.demandReadAllFiles(9, 
			       11,
			       numFiles,
			       fileSize);

       this.sendSequentialReadScript(11, 
                                     numFiles, //numFiles
                                     fileSize);   // file size


       /*
       this.issueSubscribeBody(9,
                               11,
                               AcceptVV.makeVVAllNegatives(),
                               dis,
                               SUBSCRIPTION_DURATION_MS);
       */

	ccp = this.recv(11);
	assert(ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
	assert(ccp.getData()== null);

        //asAfterRead = (AcceptStamp)ccp.getData();
        //assert asAfterRead.equals(asAfterWrite);
        end = System.currentTimeMillis();
	avgMS = ((double)((double)end - (double)start))/((double)(numFiles));
        System.err.println("==========Read "+ fileSize + "byte File Imprecise Invalid: " + 
                           avgMS + "ms");
       
	finalStats = this.getAllStats();
	diffStats = finalStats.getDiff(initStats);
	System.out.println("---------------------------------------");
	System.out.println("" + diffStats);
	System.out.println("Exit value for node 9 = " + this.killNode(9));
	System.out.println("Exit value for node 10 = " + this.killNode(10));
        System.out.println("Exit value for node 11 = " + this.killNode(11));
    }

 /** 
 *  Program starting point 
 **/ 
    public static void main(String[] argv)
    {
	SanityCheck coord = null;

	if (argv.length < 4){
	    System.out.println("Usage: <exptConfigfile> <shellType> <fileNum> <fileSize>");
	    System.exit(-1);
	}
	coord = new SanityCheck(argv[0], argv[1]);
	coord.runSanityCheck(new Long(argv[2]).longValue(), new Long(argv[3]).longValue());
    }
}

 /** 
 *  $Log: SanityCheck.java,v $ 
 *  Revision 1.3  2005/03/15 21:15:35  zjiandan 
 *  Automatic GC checked in. 
 *  
 *  Revision 1.2  2005/03/02 21:44:07  zjiandan 
 *  Modified to work with new code 
 *  
 *  Revision 1.1  2005/01/13 20:55:41  zjiandan 
 *  Reorganized sosp experiments files into sosp subdirectory under experiments. 
 *  
 *  Revision 1.1  2005/01/10 03:50:30  zjiandan 
 *  Source files for the first three Experiments. 
 *  
 **/ 
