import java.util.Random;
import java.util.HashSet;

import java.io.IOException;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.StringTokenizer;

public class ActiveNode implements TactExpt{
  
  private int nWrites;
  private double[] objWeights = new double[nFiles];

  private NodeId passiveNodeId;
  private String pnDNS;
  private int pnPortBody;
  
  private static long startTime;

  private static double writeUnavail_online = 0.0;
  private static int maxOE_online = 0;
  
  //
  // URANode Members (all private)
  //
  private Core core;
  private RMIServerImpl rmiServer;         
  private SocketServer socketServer;
  private LocalController controller;
  private LocalInterface localInterface;
  private RMIClient rmiClient;
  private static short exptType;
  public ActiveNode(String localConfigFile,
                    NodeId myId,
                    boolean cleanDb,
                    NodeId pn,
                    short exptType){//passiveNodeId
    try{
      Config.readConfig(localConfigFile);
      rmiClient = new RMIClient();
      this.passiveNodeId = pn;
      this.pnDNS = Config.getDNS(this.passiveNodeId);
      this.pnPortBody = Config.getPortBody(this.passiveNodeId);
      this.exptType = exptType;
      
      boolean filterOn = true;
      core = new Core(rmiClient, filterOn, cleanDb, myId);
      controller = new LocalController(core);
      rmiServer = new RMIServerImpl(core, controller);
      rmiServer.start();
      socketServer = new SocketServer(core, controller);
      localInterface = new LocalInterface(controller, core);
      assert(this.localInterface != null);
      core.recoverLocalState(rmiServer);
    }catch(Exception e){
      System.err.println("" + e);
      e.printStackTrace();
      assert(false);
    }
  }
  
  public void 
  populateEvents(){
    boolean bound = false;
    if((exptType == BAYOU)||(exptType ==TACT)){
      bound = true;
    }
    maxOE_online = 0;
    boolean dbg = true;
    boolean dbgVerbose = true;
    boolean dbgTime = false;
    boolean dbgOE = true;
    long offset = 0;
    long len = bytesPerFile;
    
    Random r = new Random(77217);
    int invalSeed = 2*(int) (1000*(bytesPerFile + metadataSize)/tracePeakBW);
    
    if (invalSeed == 0){
      invalSeed = 1;
    }
    
    long currentTime = 0;
    long intval;
    int readNum = 0;

    int eventTypes;
    long eventTimes = 0;
    int eventTargets;
    HashSet demandReadCandidates = new HashSet();
    ObjId lastWriteObj;
    ObjId syncOverObj = new ObjId("/" + nFiles);
    /*
    try{
      for(int i = 0; i < 4944; i++){
        rmiClient.requestSync(this.passiveNodeId,
                              core.getMyNodeId(),
                              new AcceptStamp(i, core.getMyNodeId()));
      }
    }catch(Exception e){
      e.printStackTrace();
      assert false;
    }
    */
    //
    //send an end mark -- write a file unbound which is not in the trace
    //                    and rank it as the last one before applying the trace
    //                    issue a write on it, then demandRead it
    //                    for the passiveNode at the end of trace. 
    //                    so that the passivenode can check when all the writes
    //                    data(inv or body) arrive by when successfully reading 
    //                    the this file.
    //
    ImmutableBytes buffer = URANode.populateByteArray(len);
    try{
      localInterface.write(syncOverObj, offset, len, buffer, false);
      if(dbg){
	  System.out.println("Write " + syncOverObj + " @ " + (System.currentTimeMillis()-startTime));
      }
      //write to log file for postprocess

    }catch(IOException e){
      assert false;
    }

    int failedWriteNum = 0;
    //
    //start trace
    //
    for (int i = 0; i < nEvents; i++){
      eventTypes = r.nextInt(2);//0--write 1-- read
      readNum += eventTypes;
      if(eventTypes==WRITE){//write
        eventTargets = r.nextInt(nFiles);
        //evenly distributed over all the objs
      }else{//read
          
        eventTargets = getFileNum(r.nextDouble());
      }
      ObjId obj = new ObjId("/" + eventTargets);
      intval = (long)(invalSeed - r.nextInt(invalSeed)/2);
      //peakInterval<interval <= 2 peakInterval
      eventTimes = System.currentTimeMillis() + intval;
      while(intval > 0){
        try{
          if(dbgTime){
            System.out.println("wait for next write arriving:" + intval);
          }
          Thread.sleep(intval);
        } catch (InterruptedException e){
          
          Env.printDebug("Interrupted while waiting to send data."
                         + "Will check for schedule again!");
        }
        intval = eventTimes - System.currentTimeMillis();
      }
      assert (intval<=0);
      if(eventTypes == WRITE){
        
        if(dbg){
          System.out.println("write " + eventTargets);
        }
        buffer = URANode.populateByteArray(len);
        try{
          long passiveNodeReceived = rmiClient.getCurrentVV(this.passiveNodeId).getMaxTimeStamp();
          int currOE = (int)(core.getCurrentVV().getMaxTimeStamp() 
            - passiveNodeReceived);
                    
          if(maxOE_online < currOE){
            maxOE_online = currOE;
            if(dbgOE){
              System.err.println("current maxOE_online: " +maxOE_online 
                                 + "@" + System.currentTimeMillis());
            }
          }
          if(currOE >= target){
            failedWriteNum++;
          }

          Env.logWrite("WRITE " + System.currentTimeMillis() + "\n");
          localInterface.write(obj, offset, len, buffer, bound);
          if(dbgOE){
            System.err.println("write: " + obj 
                               + "@" + (System.currentTimeMillis()-startTime));
          }
	  //write to log file for postprocess
          
        }catch(IOException e){
          assert false;
        }catch(Exception e){
          assert false;
        }
        lastWriteObj = obj;
        demandReadCandidates.add(obj);
        buffer = null;
      }else{
        assert eventTypes == READ;
        if(dbg){
          System.out.println("read " + eventTargets);
        }
        
        if((exptType == DEMAND)||(exptType == PREFETCH)){ 
          if(demandReadCandidates.contains(obj)){//need to demand read
            try{
              int get = rmiServer.issueDemandRead(obj, offset, len, 0,
                                                  this.passiveNodeId,
                                                  this.pnDNS,
                                                  this.pnPortBody);
              if(dbg){
                System.out.println("Demand read " + eventTargets
                                   + " to PassiveNode");
              }
              assert get == len;
            }catch(ObjNotFoundException onfe){
              //there's no write yet. -- ignore this read op
              assert false;//never reached
            }catch(Exception re){
              assert false;
            }
            boolean result = demandReadCandidates.remove(obj);
            assert result == true;
          }
        }
      }
    } 
    nWrites = nEvents - readNum;
    Env.logWrite("ENDTIME " + eventTimes + "\n");
    assert nWrites > 0;
    writeUnavail_online = (double)failedWriteNum/(double)nWrites;  
    if(dbg){
      System.out.println("number of Writes:" + nWrites 
                         +" number of Reads:" + readNum);
      System.out.println("totalTime:"+ eventTimes);
    }
    
    try{
      int get = rmiServer.issueDemandRead(syncOverObj, offset, len, 0,
                                          this.passiveNodeId,
                                          this.pnDNS,
                                          this.pnPortBody);
      if(dbg){
        System.out.println("Demand read " + syncOverObj + " to PassiveNode");
      }
      assert get == len;
        
    }catch(ObjNotFoundException onfe){
      //there's no write yet. -- ignore this read op
      assert false;//never reached
    }catch(Exception re){
      assert false;
    }
    System.err.println("------------- maxOE_online for " + 
                       exptType + ":" + 
                       maxOE_online);
    System.err.println("------------- write fail-no network failure: " + 
                       writeUnavail_online);
  }
  
  private void
  makeNormalizedZipf(){
    int ii;
      
    double sum = 0;
    double check = 0;
    for(ii = 0; ii < nFiles; ii++){
      objWeights[ii] = 1.0/Math.pow(ii + 1, alpha);
      sum += objWeights[ii];
    }
    for(ii = 0; ii < nFiles; ii++){
      objWeights[ii] = objWeights[ii] / sum;
      //System.out.println("objWeights[" + ii +"]:" + objWeights[ii]);
      check += objWeights[ii];
    }
      
    assert(check > .99999 && check < 1.00001);
    return;
  }

  private int getFileNum(double p){
    assert p <= 1.0;
    double sum = 0;
    int ret = 0;
    for(int i = 0; i < nFiles; i++){
      sum += objWeights[i];
      if(p <= sum){
        ret = i;
        break;
      }
    }
    return ret;
  }
    
  public static void main(String[] argv){
    boolean dbgProgress = true;
    if (argv.length <6){
      Env.printDebug("Usage: [configfile] [localNodeId] [PassiveNodeId] [ExptType] [BarrierServerName] [BarrierServerPort]");
      System.exit(-1);
    }
    boolean cleanDb; 
    if (argv.length == 6){
 /** 
      ActiveNode an = new ActiveNode(argv[0], 
                                     new NodeId((new Long(argv[1])).longValue()),
                                     cleanDb,
                                     new NodeId((new Long(argv[2])).longValue()),
                                     new Short(argv[3]).shortValue());
      if(dbgProgress){
        System.err.println("ActiveNode starts up");
      }
      BarrierClient bc = new BarrierClient(argv[4], (new Integer(argv[5])).intValue(), 
 * (new Integer(argv[1])).intValue()); 
 * wait for passive node to start 

 *  
 *  record currentTime to sync with passiveNode 
 *  
      startTime = System.currentTimeMillis();
      Env.logWrite("STARTTIME1 " + startTime + "\n");
      if(dbgProgress){
        System.err.println("ActiveNode starts to populate...");
      }
 * wait for passivenode to log startTime 
      an.populateEvents();
      if(dbgProgress){
        System.err.println("ActiveNode populate all data");
      }
 * wait for the receiver to receive all the data 
      if(dbgProgress){
        System.err.println("ActiveNode finishes");
      }
      System.exit(0);
    }
  }
}
