import java.io.IOException;
import java.rmi.RemoteException;

public class PassiveNode implements TactExpt{
 
  private static long SUB_DURATION = 10000000;
  private static long FORCE = 10000;
  private NodeId activeNodeId;
  private String anDNS;
  private int anPortBody;
  private short expType;
  private static long startTime = 0;
  //
  // URANode Members (all private)
  //
  private Core core;
  private RMIServerImpl rmiServer;         
  private SocketServer socketServer;
  private Controller controller;
  private LocalInterface localInterface;
  private RMIClient rmiClient;
  private short exptType;
  public PassiveNode(String localConfigFile,
                     NodeId myId,
                     boolean cleanDb,
                     NodeId an,
                     short exptType){//ActiveNodeId
    try{
      Config.readConfig(localConfigFile);
      rmiClient = new RMIClient();
      this.activeNodeId = an;
      this.anDNS = Config.getDNS(this.activeNodeId);
      this.anPortBody = Config.getPortBody(this.activeNodeId);
      
      boolean filterOn = true;
      core = new Core(rmiClient, filterOn, cleanDb, myId);
      controller = new LocalController(core);
      rmiServer = new RMIServerImpl(core, controller);
      rmiServer.start();
      socketServer = new SocketServer(core, controller);
      localInterface = new LocalInterface(controller, core);
      assert(this.localInterface != null);
      core.recoverLocalState(rmiServer);
    }catch(Exception e){
      System.err.println("" + e);
      e.printStackTrace();
      assert(false);
    }
  }
  
  public void 
  subscribeAll(long nWrites){
    boolean dbgProgress = true;
    try{
      rmiClient.subscribe(SubscriptionSet.makeSubscriptionSet("/*"),
                          CounterVV.makeVVAllNegatives(),
                          this.activeNodeId,
                          core.getMyNodeId(),
                          Config.getDNS(core.getMyNodeId()),
                          Config.getPortInval(core.getMyNodeId()),
                          SUB_DURATION,
                          FORCE,
                          0);
    }catch(Exception e){
      assert false;
    }
    while(true){
      try{
        System.err.println(new AcceptStamp(nWrites, this.activeNodeId));
        localInterface.sync(new AcceptStamp(nWrites, this.activeNodeId));
        break;
      }catch(InterruptedException ie){
        //ignore
      }
    }
    if(dbgProgress){
      System.err.println("currentVV:" + core.getCurrentVV());
    }
    //
    // read the last mark write issued by ActiveNode
    // to make sure that PassiveNode has received all data
    //
    while(true){
      try{
        if(dbgProgress){
          System.err.println("try to read obj /5");
        }
        localInterface.read(new ObjId("/"+ nFiles),
                            0,
                            1000,
                            true,
                            true);
        if(dbgProgress){
          System.err.println("succeed reading obj /5");
        }
        break;
      }catch(ObjNotFoundException onfe){
        //ignore
      }catch(ReadOfInvalidRangeException roire){
        if(dbgProgress){
          System.err.println("read invalidate range Exception, ignore it");
        }
        assert false;
      }catch(Exception e){
        assert false;
      }
    }
      
    System.err.println("PassiveNode finishes reading last file");
  }

  public void 
  subscribePeriod(long nWrites){
    boolean dbgProgress = true;
    boolean dbgTime = false;
    long syncT = bayouSyncPeriod;
    long allStartTime = System.currentTimeMillis();
    long nextSyncStartTime = allStartTime + syncT;
    long timeToWait = 0;
    AcceptStamp activeNodeEndStamp = new AcceptStamp(nWrites, 
                                                     this.activeNodeId);
    VV endVVOfThisSync = null;

    while(!core.getCurrentVV().includes(activeNodeEndStamp)){
      
      timeToWait = nextSyncStartTime - System.currentTimeMillis();
      // wait for next time to subscribe
      while(timeToWait > 0){
        try{
          if(dbgTime){
            System.out.println("wait for next sync start:" + timeToWait);
          }
          Thread.sleep(timeToWait);
        } catch (InterruptedException e){
          
          Env.printDebug("Interrupted while waiting for next sync."
                         + "Will check for schedule again!");
        }
        timeToWait = nextSyncStartTime - System.currentTimeMillis();
      }
      //
      //start to subscribe
      //
      try{
        //get the sender's currentVV so that this subscribe will close when
        //all the writes happened in this period are sent.
        endVVOfThisSync = rmiClient.getCurrentVV(this.activeNodeId);
        if(dbgProgress){
          System.err.println("Start a new subscribe from "
                             + core.getCurrentVV() 
                             + "to " + endVVOfThisSync);
        }
        rmiClient.subscribe(SubscriptionSet.makeSubscriptionSet("/*"),
                            core.getCurrentVV(),
                            endVVOfThisSync,
                            this.activeNodeId,
                            core.getMyNodeId(),
                            Config.getDNS(core.getMyNodeId()),
                            Config.getPortInval(core.getMyNodeId()),
                            SUB_DURATION,
                            FORCE,
                            0);
      }catch(Exception e){
        assert false;
      }
	
      //
      // wait for the sync to be finished
      //    
      while(true){
        try{
          core.syncCheck(endVVOfThisSync);
          if(dbgProgress){
            System.err.println("passivenode currentVV:" + core.getCurrentVV());
            assert core.getCurrentVV().includes(endVVOfThisSync);
          }
          break;
        }catch(InterruptedException ie){
          //ignore
        }
      }
      
      nextSyncStartTime = nextSyncStartTime + syncT;
      if (nextSyncStartTime < System.currentTimeMillis()){
        nextSyncStartTime = System.currentTimeMillis();
      }
    }
	
    if(dbgProgress){
      System.err.println("subscribe end up with currentVV:" 
                         + core.getCurrentVV());
    }
    assert core.getCurrentVV().includes(activeNodeEndStamp);
    //
    // read the last mark write issued by ActiveNode
    // to make sure that PassiveNode has received all data
    //
    while(true){
      try{
        if(dbgProgress){
          System.err.println("try to read obj /5");
        }
        localInterface.read(new ObjId("/"+ nFiles),
                            0,
                            1000,
                            true,
                            true);
        if(dbgProgress){
          System.err.println("succeed reading obj /5");
        }
        break;
      }catch(ObjNotFoundException onfe){
        //ignore
      }catch(ReadOfInvalidRangeException roire){
        if(dbgProgress){
          System.err.println("read invalidate range Exception, ignore it");
        }
        assert false;
      }catch(Exception e){
        assert false;
      }
    }
    
    System.err.println("PassiveNode finishes reading last file");
  }

  public static void main(String[] argv){
    boolean dbgProgress = true;
    if (argv.length < 7){
      Env.printDebug("Usage: [configfile] [localNodeId]" 
                     +"[PassiveNodeId] [ExptType] [BarrierServerName]"
                     +"[BarrierServerPort] [nWrites]");
      System.exit(-1);
    }
    boolean cleanDb; 
    if (argv.length == 7){
	short exptType = new Short(argv[3]).shortValue();
	long nWrites = (new Long(argv[6])).longValue();
      cleanDb = true; //-- recover from disk
      PassiveNode pn = new PassiveNode(argv[0], 
                                       new NodeId((new Long(argv[1])).longValue()),
                                      
                                       cleanDb,
                                       new NodeId((new Long(argv[2])).longValue()),
                                       exptType);
      if(dbgProgress){
        System.err.println("PassiveNode starts up");
      }
      BarrierClient bc = new BarrierClient(argv[4], 
                                           (new Integer(argv[5])).intValue(), 
                                           1);//(new Integer(argv[1])).intValue());
      bc.sendBarrierRequest(-1, -1); //wait for active node to start
      startTime = System.currentTimeMillis();
      Env.logValid("STARTTIME2 " + startTime + "\n");
      Env.logWrite("STARTTIME2 " + startTime + "\n");
      bc.sendBarrierRequest(-1, -1); //wait for activenode to log startTime
      if(dbgProgress){
        System.err.println("PassiveNode starts to subscribe...");
      }
      if(exptType == BAYOU){
	  pn.subscribePeriod(nWrites);
      }else{
	  pn.subscribeAll(nWrites);
      }
      if(dbgProgress){
        System.err.println("PassiveNode gets all data");
      }
      bc.sendBarrierRequest(-1, -1); //tell the sender that all data received
      if(dbgProgress){
        System.err.println("PassiveNode finishs");
      }
      System.exit(0);
      
    }
  }
}

  
  
