import java.io.IOException;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.StringTokenizer;

public class TactExptPostProcess implements TactExpt{
  private static int maxOE = 0;
  private static double[] objWeights = new double[nFiles];
  private static double readUnavail = 0.0;
  private static double writeUnavail = 0.0;
  private static double writeUnavail_NF = 0.0;
  
 /** 
 *  precondition: the log file's time should be processed to be relative 
 *  time and the endTime of the trace should be added to the first line 
 *  which can be gotten from the last line of the activenode writelog.  
 *  
 *  file should be: 
 *    <ENDTIME time> 
 *    <STARTTIME2 0> 
 *    <BODY|INV objId time> 
 **/ 
  public static void postProcessReadAvail(String fileName){
    boolean dbg = true;
 
    double validWeight = 1.0;
    double availScoreCumulative = 0.0;
    long previousTime = 0;
    long endTime = 0;
    if(dbg){
      System.err.println("ActiveNode postprocessing valid log...");
    }
    try{
      BufferedReader in = new BufferedReader(new FileReader(fileName));
      assert in!=null;
      String line = in.readLine();
      StringTokenizer st = new StringTokenizer(line);
      String type = st.nextToken();
      assert type.equals("ENDTIME");
      endTime = new Long(st.nextToken()).longValue();

      line = in.readLine();
      st = new StringTokenizer(line);
      type = st.nextToken();
      assert type.equals("STARTTIME2");
      previousTime = new Long(st.nextToken()).longValue();

      assert previousTime == 0;
      line = in.readLine();
      while(line!=null){
        
        st = new StringTokenizer(line);
        type = st.nextToken();
        
        if(type.equals("BODY")){
          int oid = new Integer(st.nextToken().substring(1)).intValue();
          if(oid == nFiles){//ignore the dummy obj
            line = in.readLine();
            continue;
          }
          long time = new Long(st.nextToken()).longValue();
          if(time > endTime){
            break;
          }
          availScoreCumulative += 
            validWeight * (time - previousTime);
          validWeight += objWeights[oid];
          assert validWeight <= 1.00001;
          assert validWeight >= 0;
          previousTime = time;
        }else if (type.equals("INV")){
          int oid = new Integer(st.nextToken().substring(1)).intValue();
          long time = new Long(st.nextToken()).longValue();
          if(oid == nFiles){//ignore dummy obj
            line = in.readLine();
            continue;
          }
          if(time > endTime){
            break;
          }
          availScoreCumulative += 
            validWeight * (time - previousTime);
          validWeight -= objWeights[oid];
          assert validWeight <= 1.00001;
          assert validWeight >= 0;
          previousTime = time;
        }else{
          assert false;
        }
        line = in.readLine();
      }      
    }catch (Exception e){ 
      e.printStackTrace();
      assert(false);
    }
    
    //calculate the last period
    if(previousTime < endTime){
      availScoreCumulative += 
        validWeight * (endTime - previousTime);
    }
    assert endTime > 0;
    readUnavail = 1 - availScoreCumulative/endTime;
    return;
  }
  
 /** 
 *  This method takes an input file of <WRITE/ACK Time> 
 *  It means that the created files need to be merged in one file before 
 *  call this method. and all the time should be relative time. 
 **/ 
  public static void postProcessWriteAvail(String fileName){
    boolean dbg = true;
    boolean dbgFail = false;
    int totalAck = 0;
    int totalWrite = 0;
    long[] ackTimes = new long[nEvents];
    double unavailWithNF = 0.0;
    int minFailedAck;
    int writeFailNum = 0;
    maxOE = 0;
    if(dbg){
      System.err.println("ActiveNode postprocessing write log...");
    }
    try{
      
      BufferedReader in = new BufferedReader(new FileReader(fileName));
      assert in!=null;
      String line = in.readLine();
      
      boolean firstAck = true;
      while(line!=null){
        StringTokenizer st = new StringTokenizer(line);
        String type = st.nextToken();
        
        if(type.equals("WRITE")){  
          long time = new Long(st.nextToken()).longValue();
          int currOE = totalWrite - totalAck;
          if(currOE > maxOE){
            maxOE = currOE;
          }
          assert currOE >= 0;
 /** 
            writeFailNum++;
 * this write Pfail = 100% 
            if(dbgFail){
              System.err.println("write["+ (totalWrite-1)+"] Pfail: 1.0");
            }
            
          }else{
            minFailedAck = target - currOE;
            assert minFailedAck > 0;
            double minFailDuration;
            if(totalAck >= minFailedAck){
              minFailDuration = time - ackTimes[totalAck - minFailedAck]; 
              unavailWithNF += lookupP(2*(minFailDuration/1000.0));
              
 * else this write will never fail  
          }
          totalWrite++;
          
        }else if (type.equals("ACK")){
 * ignore first ack which is for dummy obj 
            firstAck = false;
            line = in.readLine();
            continue;
          }
          long time = new Long(st.nextToken()).longValue();
          ackTimes[totalAck] = time;
          totalAck++;
          
        }else{
          assert false;
        }
        line = in.readLine();
      }
      in.close();
    }catch (Exception e){ 
      e.printStackTrace();
      assert(false);
    }
    
 * assert totalWrite == nWrites; 
    writeUnavail = (double)writeFailNum/(double)totalWrite;
    writeUnavail_NF = unavailWithNF/totalWrite;
    assert writeUnavail_NF <= 1.000001;
    assert writeUnavail_NF > 0;
    return;
  }

   private static double lookupP(double minDuration){
    if(minDuration < 30.0) {
      return 1-0.0018;
    }else if(minDuration > 1411723){
      return 1-0.998;
 * look up the table 
      try{
        BufferedReader in = new BufferedReader(new FileReader("nw-failure-duration-table.txt"));
        assert in!=null;
        String line = in.readLine();
        while(line!=null){
 * System.err.println(line); 
          StringTokenizer st = new StringTokenizer(line);
          long duration = (new Long(st.nextToken())).longValue();
          if (duration >= minDuration){
            in.close();
            return (1-(new Double(st.nextToken())).doubleValue());
          }
          line = in.readLine();
        }
        
      }catch (Exception e){ 
        e.printStackTrace();
        assert(false);
      }
      assert false;
 * impossible 
    }
  }
  
  private static double calTotalUnavail(double wFailP, 
                                        double wFailP_NF,
                                        double rFailP_NF){
    double ret = writeP*((1-nwFailP)*wFailP + nwFailP*wFailP_NF) 
      + readP*nwFailP*rFailP_NF;
    assert ret > 0;
    assert ret < 1.00001;
    return ret;
  }
  
  private void
  makeNormalizedZipf(){
    int ii;
      
    double sum = 0;
    double check = 0;
    for(ii = 0; ii < nFiles; ii++){
      objWeights[ii] = 1.0/Math.pow(ii + 1, alpha);
      sum += objWeights[ii];
    }
    for(ii = 0; ii < nFiles; ii++){
      objWeights[ii] = objWeights[ii] / sum;
 * System.out.println("objWeights[" + ii +"]:" + objWeights[ii]); 
      check += objWeights[ii];
    }
      
    assert(check > .99999 && check < 1.00001);
    return;
  }

  public static void main(String[] argv){
    if(argv.length<2){
      System.out.println("Usage: <validlog> <writelog>");
      System.exit(-1);
    }

    postProcessReadAvail(argv[0]);
    postProcessWriteAvail(argv[1]);
    
    System.out.print(" maxOE: " + maxOE);
    System.out.print(" readUnAvail: " + readUnavail);
    System.out.print(" writeUnavail: " + writeUnavail);
    System.out.print(" writeUnavail_NF: " + writeUnavail_NF);
    System.out.println(" totalUnavail: " + calTotalUnavail(writeUnavail,
                                                          writeUnavail_NF,
                                                          readUnavail));
  }
}
