
import java.util.Random;
import java.util.HashSet;

import java.io.IOException;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.StringTokenizer;

public class TraceServer implements TactExpt{
  
  private int nWrites;
  private double[] objWeights = new double[nFiles];

  private NodeId passiveNodeId;
  private String pnDNS;
  private int pnPortBody;
  
 // private static long startTime;

  private static double writeUnavail_online = 0.0;
  private static int maxOE_online = 0;
  
  //
  // URANode Members (all private)
  //
  private Core core;
  private RMIServerImpl rmiServer;         
  private SocketServer socketServer;
  private LocalController controller;
  private LocalInterface localInterface;
  private RMIClient rmiClient;
  private static short exptType;
  public TraceServer(String localConfigFile,
                    NodeId myId,
                    boolean cleanDb,
                    NodeId pn,
                    short exptType){//passiveNodeId
    try{
      Config.readConfig(localConfigFile);
      rmiClient = new RMIClient();
      this.passiveNodeId = pn;
      this.pnDNS = Config.getDNS(this.passiveNodeId);
      this.pnPortBody = Config.getPortBody(this.passiveNodeId);
      this.exptType = exptType;
      
      boolean filterOn = true;
      core = new Core(rmiClient, filterOn, cleanDb, myId);
      controller = new LocalController(core);
      rmiServer = new RMIServerImpl(core, controller);
      rmiServer.start();
      socketServer = new SocketServer(core, controller);
      localInterface = new LocalInterface(controller, core);
      assert(this.localInterface != null);
      core.recoverLocalState(rmiServer);
    }catch(Exception e){
      System.err.println("" + e);
      e.printStackTrace();
      assert(false);
    }
  }
  
  public void writeFakeFile(boolean bound)
    throws Exception{
    boolean dbgVerbose = false;
    long offset = 0;
    long len = bytesPerFile;
    ObjId syncOverObj = new ObjId("/none");
    ImmutableBytes buffer = URANode.populateByteArray(len);
    try{
      localInterface.write(syncOverObj, offset, len, -100, buffer, bound);
      if(dbgVerbose){
	  System.out.println("Write " + syncOverObj + " @ " + (System.currentTimeMillis()));
      }
      //write to log file for postprocess

    }catch(IOException e){
      assert false;
    }
  }

  public void demandReadFakeFile(){
    assert exptType == BAYOU; //only Bayou won't subscribe body
    long offset = 0;
    long len = bytesPerFile;
    ObjId syncOverObj = new ObjId("/none");
    int get = 0;
    boolean dbg = false;
    try{
      get = rmiServer.issueDemandRead(syncOverObj, offset, len, 0,
                                          this.passiveNodeId,
                                          this.pnDNS,
                                          this.pnPortBody);
      if(dbg){
        System.out.println("Demand read " + syncOverObj + " to PassiveNode");
      }
      assert get == len;
      
    }catch(ObjNotFoundException onfe){
      //there's no write yet. -- ignore this read op
      assert false;//never reached
    }catch(Exception re){
      assert false;
    }
  }
  
  public void 
  populateEvents(BufferedReader br)
    throws Exception{
    ImmutableBytes buffer;
    boolean bound = false;

    if(exptType == BAYOU){
      bound = true;
    }
    maxOE_online = 0;
    boolean dbg = true;
    boolean dbgVerbose = false;
    boolean dbgTime = false;
    boolean dbgOE = false;
    boolean prograssPrint = true;
    long offset = 0;
    long len = bytesPerFile;
   
    long currentTime = 0;
    long intval;
    int readNum = 0;

    int eventTypes;
    long eventTimes = 0;
    int eventTargets;
    HashSet demandReadCandidates = new HashSet();
    ObjId lastWriteObj;
    
    /*
    try{
      for(int i = 0; i < 4944; i++){
        rmiClient.requestSync(this.passiveNodeId,
                              core.getMyNodeId(),
                              new AcceptStamp(i, core.getMyNodeId()));
      }
    }catch(Exception e){
      e.printStackTrace();
      assert false;
    }
    */
    //
    //send an end mark -- write a file unbound which is not in the trace
    //                    and rank it as the last one before applying the trace
    //                    issue a write on it, then demandRead it
    //                    for the passiveNode at the end of trace. 
    //                    so that the passivenode can check when all the writes
    //                    data(inv or body) arrive by when successfully reading 
    //                    the this file.
    //
    
    

    int failedWriteNum = 0;
    long startTime = System.currentTimeMillis();

    nWrites = 0;
    //
    //start trace
    //
    TraceEntry te = HarvardTracePreprocesser.getEntry(br);
    long startTraceTime = getTimeMillis(te.getTimeSec(), te.getTimeUSec());
    long diff = 0;
    while(te!=null){
      
      ObjId obj = te.getObjId(); 
      eventTypes = te.getOperation();
      readNum += eventTypes;
      len = te.getLength();
      
      intval = getTimeMillis(te.getTimeSec(), te.getTimeUSec()) - startTraceTime;
      //peakInterval<interval <= 2 peakInterval
      eventTimes = startTime + intval + diff;
      diff = eventTimes - System.currentTimeMillis(); 
      while(diff > 0){
        try{
          if(dbgTime){
            System.out.println("wait for next write arriving:" + diff);
          }
          Thread.sleep(diff);
        } catch (InterruptedException e){
          
          Env.printDebug("Interrupted while waiting to send data."
                         + "Will check for schedule again!");
        }
        diff = eventTimes - System.currentTimeMillis();
      }
      assert (diff<=0);
      if(eventTypes == WRITE){
	 nWrites ++;
	 if(prograssPrint && 
	    (nWrites%100)==0){
	     System.err.println(nWrites);
	 }
        if(dbgVerbose){
          System.out.println("write " + obj);
        }
        buffer = URANode.populateByteArray(len);
        
        try{
          /*
          long passiveNodeReceived = rmiClient.getCurrentVV(this.passiveNodeId).getMaxTimeStamp();
          int currOE = (int)(core.getCurrentVV().getMaxTimeStamp() 
            - passiveNodeReceived);
                    
          if(maxOE_online < currOE){
            maxOE_online = currOE;
            if(dbgOE){
              System.err.println("current maxOE_online: " +maxOE_online 
                                 + "@" + System.currentTimeMillis());
            }
          }
          if(currOE >= target){
            failedWriteNum++;
          }

          */
          localInterface.write(obj, offset, len, te.getPriority(), 
                               buffer, bound);
          if(dbgOE){
            System.err.println("write: " + obj 
                               + "@" + (System.currentTimeMillis()-startTime));
          }
	  //write to log file for postprocess
          
        }catch(IOException e){
          assert false;
        }catch(Exception e){
          assert false;
        }
        
        lastWriteObj = obj;
        demandReadCandidates.add(obj);
        buffer = null;
      }else{
        /*
        assert eventTypes == READ;
        if(dbg){
          System.out.println("read " + eventTargets);
        }
        
        if((exptType == DEMAND)||(exptType == PREFETCH)){ 
          if(demandReadCandidates.contains(obj)){//need to demand read
            try{
              int get = rmiServer.issueDemandRead(obj, offset, len, 0,
                                                  this.passiveNodeId,
                                                  this.pnDNS,
                                                  this.pnPortBody);
              if(dbg){
                System.out.println("Demand read " + eventTargets
                                   + " to PassiveNode");
              }
              assert get == len;
            }catch(ObjNotFoundException onfe){
              //there's no write yet. -- ignore this read op
              assert false;//never reached
            }catch(Exception re){
              assert false;
            }
            boolean result = demandReadCandidates.remove(obj);
            assert result == true;
          }
        }
        */
      }
      te = HarvardTracePreprocesser.getEntry(br);
    } 
    
    assert nWrites > 0;
    writeUnavail_online = (double)failedWriteNum/(double)nWrites;  
    if(dbg){
      System.out.println("number of Writes:" + nWrites 
                         +" number of Reads:" + readNum);
      System.out.println("totalTime:"+ 
                         (System.currentTimeMillis() - startTime));
    }
  /*
    if(dbgOE){
      System.err.println("------------- maxOE_online for " + exptType + ":" + maxOE_online);
      System.err.println("------------- write fail-no network failure: " + writeUnavail_online);
    }
  */
  }
  
  private void
  makeNormalizedZipf(){
    int ii;
      
    double sum = 0;
    double check = 0;
    for(ii = 0; ii < nFiles; ii++){
      objWeights[ii] = 1.0/Math.pow(ii + 1, alpha);
      sum += objWeights[ii];
    }
    for(ii = 0; ii < nFiles; ii++){
      objWeights[ii] = objWeights[ii] / sum;
      //System.out.println("objWeights[" + ii +"]:" + objWeights[ii]);
      check += objWeights[ii];
    }
      
    assert(check > .99999 && check < 1.00001);
    return;
  }

  private int getFileNum(double p){
    assert p <= 1.0;
    double sum = 0;
    int ret = 0;
    for(int i = 0; i < nFiles; i++){
      sum += objWeights[i];
      if(p <= sum){
        ret = i;
        break;
      }
    }
    return ret;
  }

  public long getTimeMillis(long sec, long usec){
    return sec*1000 + usec/1000;
  }
  public static void main(String[] argv)
    throws Exception{
    StatsRecord initStats = null;
    StatsRecord finalStats = null;
    StatsRecord diffStats = null;
    boolean dbgProgress = true;
    if (argv.length <6){
      Env.printDebug("Usage: [configfile] [localNodeId]"
                     +"[PassiveNodeId] [ExptType] [BarrierServerName]"
                     +" [BarrierServerPort] [rawTraceFile] [uid]");
      System.exit(-1);
    }
    boolean cleanDb; 
    if (argv.length > 6){
 /** 
      TraceServer an = new TraceServer(argv[0], 
                                     new NodeId((new Long(argv[1])).longValue()),
                                     cleanDb,
                                     new NodeId((new Long(argv[2])).longValue()),
                                     new Short(argv[3]).shortValue());
      if(dbgProgress){
        System.err.println("TraceServer starts up");
      }
      BarrierClient bc = new BarrierClient(argv[4], 
                                           (new Integer(argv[5])).intValue(), 
 * (new Integer(argv[1])).intValue()); 
      an.writeFakeFile(false);
 * wait for passive node to start 

 *  
 *  record currentTime to sync with passiveNode 
 *  
      HarvardTracePreprocesser htp = null;
      BufferedReader br = null;
      
 * already parsed 
        
        String parsedFileName = argv[6];
        br = new BufferedReader(new FileReader(parsedFileName));
 * need parse raw file with the specified uid as 
 * interested user 
        String rawFileName = argv[6];
        String uid = argv[7];
        htp = new HarvardTracePreprocesser(rawFileName, 
                                           uid);
        br = htp.parse2();
 * need parse raw file, get op for 1 node 
        String rawFileName = argv[6];
        String uid = argv[7];
        String nodeIdHexStr = argv[8];
        htp = new HarvardTracePreprocesser(rawFileName, 
                                           uid,
                                           nodeIdHexStr);
        br = htp.parse2();
      }
       
      if(dbgProgress){
        System.err.println("TraceServer starts to populate...");
      }
      
 * wait for passivenode to subscribe 
 * subscribe everything; 
      initStats = Stats.createRecord();
      an.populateEvents(br);
      if(dbgProgress){
        System.err.println("TraceServer populate all data");
      }
      boolean bound = false;
      if(exptType == BAYOU){
        bound = true;
      }
      an.writeFakeFile(bound);
 * wait for the receiver to receive all the data 
      finalStats = Stats.createRecord();
      diffStats = finalStats.getDiff(initStats);
      System.out.println(diffStats);
      if(dbgProgress){
        System.err.println("TraceServer finishes");
      }
      System.exit(0);
    }
  }
}
