import java.io.*;

public class TopologyIndependence extends CoordExptA{

  public static final int HOME = 12;  
  public static final int PDA = 10;
  public static final int LAPTOP = 11;
  public static final int SERVER = 9;

  /*public static final int PHONE_READ_SYNC = 99;
  public static final int PDA_READ_SYNC = 999;
  public static final int LAPTOP_READ_SYNC = 9999;
  public static final int SERVER_READ_SYNC = 99999;
  */

  public static long SUBSCRIPTION_TIMEOUT_MS = 3000000; // 3000 SECONDS
  public static long MAX_DELAY_MS = 3000; // 3000 seconds
  
  public static long mg = 1;
  
  TopologyIndependence(String exptConfigFileName, String shellType){
    super(exptConfigFileName, shellType);
  }

  public SubscriptionSet getInterestSet(int nodeId){
    SubscriptionSet dis = null;
    
    switch(nodeId){
    case HOME:
      dis = SubscriptionSet.makeSubscriptionSet("/*");
      break;
    case PDA:
      dis = SubscriptionSet.makeSubscriptionSet("/0/0");
      break;
    case LAPTOP:
      dis = SubscriptionSet.makeSubscriptionSet("/*");
      break;
    case SERVER:
      dis = SubscriptionSet.makeSubscriptionSet("/*");
      break;
    default:
      System.err.println("Unimplemented");
      System.exit(-1);
      break;
    }
    return(dis);
  }
  
  private double getDirPct(int nodeId){
    double dirPct = 0.0;

    switch (nodeId){
    case PDA: 
      dirPct = 0.0001;
      break;
    case LAPTOP:
    case HOME:
      dirPct = 0.01;
      break;
    case SERVER:
      dirPct = 1.0;
      break;
    default:
      System.err.println("Unrecoganized type!!!");
      System.exit(-1);
    }
    
    return dirPct;
  }

  private VV getHighestTimeStamps(int nodeId){
    OutputStream os = getProcessOutputStream(nodeId);
    PrintStream ps = new PrintStream(os);
    ps.println("v");
    try{
      os.flush();
    }catch (IOException e){
      System.err.println("Failed to send all object mods over stdout" + e);
      e.printStackTrace();
    }
    CoordCommPacket ccp = recv(nodeId);
    assert(ccp.getSignalType() == CoordCommPacket.CURRENT_VV);
    assert(ccp.getData() instanceof VV);
    VV cvv = (VV)ccp.getData();
    return cvv;
  }
  
  private long sendInitWritesScript(int nodeId, boolean bound){
    double dirPct = getDirPct(nodeId);
    double filePct = 1.0;  // we consider all files under the directory if included for this expirement 
    long numWrites = mg * Math.round(numFiles * dirPct * filePct);
    System.err.println("Magnified-by: " + mg);
    //System.err.println("number of writes:" + numWrites);
//    sendRandomWritesScript(nodeId, bound, numWrites, exptConfig.getFileSize());//, numFiles, dirPct*filePct, bound);
    sendPopulateFullScript(nodeId, bound, numWrites, exptConfig.getFileSize());
    return numWrites;
  }

  public void PRACTI_P2L(){

    CoordCommPacket done_ccp = null;
    CoordCommPacket pda_ccp = null;
    SubscriptionSet pda_dis = null;
    SubscriptionSet laptop_dis = null;
    StatsRecord initStats = null;
    StatsRecord finalStats = null;
    StatsRecord diffStats = null;
    CounterVV laptop_cvv = null;
    CounterVV pda_cvv = null;

    this.restartRMIRegistrySync();
    startNode(PDA);
    startNode(LAPTOP);
    waitStartNode(PDA);
    waitStartNode(LAPTOP);

    // initial data population
    long totalWrites = sendInitWritesScript(PDA, true);
    pda_ccp = recv(PDA);
    assert(pda_ccp.getSignalType() == CoordCommPacket.ACCEPT_STAMP);
    assert(pda_ccp.getData() instanceof AcceptStamp);

    // get experimental specific interest sets
    pda_dis = getInterestSet(SERVER);
    laptop_dis = getInterestSet(SERVER);

    initStats = getAllStats();
    long startT = System.currentTimeMillis();

    // laptop subscribe to pda
    issueSubscribe(PDA, LAPTOP, AcceptVV.makeVVAllNegatives(),
                   laptop_dis, SUBSCRIPTION_TIMEOUT_MS, MAX_DELAY_MS);
    sendSync(LAPTOP, (AcceptStamp)pda_ccp.getData());

    // wait for the sync. process to complete on laptop
    done_ccp = recv(LAPTOP);
    assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
    assert(done_ccp.getData() == null);
    System.out.println("Received a SYNC_DONE from node " + LAPTOP);

    long endT = System.currentTimeMillis();
    finalStats = getAllStats();
    diffStats = finalStats.getDiff(initStats);
    System.out.println(diffStats);
    System.out.println("Total_time " + (endT-startT) + " (ms)");
    laptop_cvv = (CounterVV)getHighestTimeStamps(LAPTOP);
    pda_cvv = (CounterVV)getHighestTimeStamps(PDA);
    assert(pda_cvv.equals(laptop_cvv));
    
    long data_size = diffStats.getTotal()*8;
    System.out.println("Achieved bandwidth (kb/s): " + (data_size/(endT-startT)));
    System.out.println("---------------------------------------");
    System.out.println("Exit value for node " + LAPTOP + " = " + killNode(LAPTOP));
    System.out.println("Exit value for node " + PDA + " = " + killNode(PDA));
  }

  public void CODA_P2L(){

    CoordCommPacket done_ccp = null;
    CoordCommPacket pda_ccp = null;
    SubscriptionSet pda_dis = null;
    SubscriptionSet laptop_dis = null;
    SubscriptionSet server_dis = null;
    StatsRecord initStats = null;
    StatsRecord finalStats = null;
    StatsRecord diffStats = null;
    CounterVV laptop_cvv = null;
    CounterVV pda_cvv = null;
    CounterVV server_cvv = null;

    this.restartRMIRegistrySync();
    startNode(PDA);
    startNode(LAPTOP);
    startNode(SERVER);
    waitStartNode(PDA);
    waitStartNode(LAPTOP);
    waitStartNode(SERVER);

    // initial data population
    long totalWrites = sendInitWritesScript(PDA, true);
    pda_ccp = recv(PDA);
    assert(pda_ccp.getSignalType() == CoordCommPacket.ACCEPT_STAMP);
    assert(pda_ccp.getData() instanceof AcceptStamp);

    // get experimental specific interest sets
    pda_dis = getInterestSet(SERVER);
    laptop_dis = getInterestSet(SERVER);
    server_dis = getInterestSet(SERVER);

    initStats = getAllStats();
    long startT = System.currentTimeMillis();

    // server subscribe to pda
    issueSubscribe(PDA, SERVER, AcceptVV.makeVVAllNegatives(), 
                   server_dis, SUBSCRIPTION_TIMEOUT_MS, MAX_DELAY_MS);
    sendSync(SERVER, (AcceptStamp)pda_ccp.getData());

    // wait for the sync. process to complete on server
    done_ccp = recv(SERVER);
    assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
    assert(done_ccp.getData() == null);
    System.out.println("Received a SYNC_DONE from node " + SERVER);

    // laptop subscribe to server
    issueSubscribe(SERVER, LAPTOP, AcceptVV.makeVVAllNegatives(), 
                   laptop_dis, SUBSCRIPTION_TIMEOUT_MS, MAX_DELAY_MS);
    sendSync(LAPTOP, (AcceptStamp)pda_ccp.getData());

    // wait for the sync. process to complete on laptop
    done_ccp = recv(LAPTOP);
    assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
    assert(done_ccp.getData() == null);
    System.out.println("Received a SYNC_DONE from node " + LAPTOP);

    long endT = System.currentTimeMillis();
    finalStats = getAllStats();
    diffStats = finalStats.getDiff(initStats);
    System.out.println(diffStats);
    System.out.println("Total_time " + (endT-startT) + " (ms)");
    laptop_cvv = (CounterVV)getHighestTimeStamps(LAPTOP);
    pda_cvv = (CounterVV)getHighestTimeStamps(PDA);
    assert(pda_cvv.equals(laptop_cvv));
    
    long data_size = diffStats.getTotal()*8;
    System.out.println("Achieved bandwidth (kb/s): " + (data_size/(endT-startT)));
    System.out.println("---------------------------------------");
    System.out.println("Exit value for node " + LAPTOP + " = " + killNode(LAPTOP));
    System.out.println("Exit value for node " + PDA + " = " + killNode(PDA));
    System.out.println("Exit value for node " + PDA + " = " + killNode(SERVER));
  }

  public void PRACTI_P2H(){
    CoordCommPacket done_ccp = null;
    CoordCommPacket pda_ccp = null;
    SubscriptionSet pda_dis = null;
    SubscriptionSet laptop_dis = null;
    SubscriptionSet home_dis = null;
    StatsRecord initStats = null;
    StatsRecord finalStats = null;
    StatsRecord diffStats = null;
    CounterVV laptop_cvv = null;
    CounterVV pda_cvv = null;
    CounterVV home_cvv = null;

    this.restartRMIRegistrySync();
    startNode(PDA);
    startNode(LAPTOP);
    startNode(HOME);
    waitStartNode(PDA);
    waitStartNode(LAPTOP);
    waitStartNode(HOME);

    // initial data population
    long totalWrites = sendInitWritesScript(PDA, true);
    pda_ccp = recv(PDA);
    assert(pda_ccp.getSignalType() == CoordCommPacket.ACCEPT_STAMP);
    assert(pda_ccp.getData() instanceof AcceptStamp);

    // get experimental specific interest sets
    pda_dis = getInterestSet(SERVER);
    laptop_dis = getInterestSet(SERVER);
    home_dis = getInterestSet(SERVER);

    initStats = getAllStats();
    long startT = System.currentTimeMillis();

    // laptop subscribe to pda
    issueSubscribe(PDA, LAPTOP, AcceptVV.makeVVAllNegatives(),  
                   laptop_dis, SUBSCRIPTION_TIMEOUT_MS, MAX_DELAY_MS);
    sendSync(LAPTOP, (AcceptStamp)pda_ccp.getData());

    // wait for the sync. process to complete on laptop
    done_ccp = recv(LAPTOP);
    assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
    assert(done_ccp.getData() == null);
    System.out.println("Received a SYNC_DONE from node " + LAPTOP);

    // home subscribe to laptop
    issueSubscribe(LAPTOP, HOME, AcceptVV.makeVVAllNegatives(),  
                   home_dis, SUBSCRIPTION_TIMEOUT_MS, MAX_DELAY_MS);
    sendSync(HOME, (AcceptStamp)pda_ccp.getData());

    // wait for the sync. process to complete on laptop
    done_ccp = recv(HOME);
    assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
    assert(done_ccp.getData() == null);
    System.out.println("Received a SYNC_DONE from node " + HOME);

    long endT = System.currentTimeMillis();
    finalStats = getAllStats();
    diffStats = finalStats.getDiff(initStats);
    System.out.println(diffStats);
    System.out.println("Total_time " + (endT-startT) + " (ms)");
    laptop_cvv = (CounterVV)getHighestTimeStamps(LAPTOP);
    pda_cvv = (CounterVV)getHighestTimeStamps(PDA);
    assert(pda_cvv.equals(laptop_cvv));
    
    long data_size = diffStats.getTotal()*8;
    System.out.println("Achieved bandwidth (kb/s): " + (data_size/(endT-startT)));
    System.out.println("---------------------------------------");
    System.out.println("Exit value for node " + LAPTOP + " = " + killNode(LAPTOP));
    System.out.println("Exit value for node " + PDA + " = " + killNode(PDA));
    System.out.println("Exit value for node " + HOME + " = " + killNode(HOME));
  }

  public void PRACTI_P2H_THRU_O(){
    CoordCommPacket done_ccp = null;
    CoordCommPacket pda_ccp = null;
    SubscriptionSet pda_dis = null;
    SubscriptionSet laptop_dis = null;
    SubscriptionSet home_dis = null;
    SubscriptionSet server_dis = null;
    StatsRecord initStats = null;
    StatsRecord finalStats = null;
    StatsRecord diffStats = null;
    CounterVV laptop_cvv = null;
    CounterVV pda_cvv = null;
    CounterVV home_cvv = null;
    CounterVV server_cvv = null;

    this.restartRMIRegistrySync();
    startNode(PDA);
    startNode(LAPTOP);
    startNode(HOME);
    startNode(SERVER);
    waitStartNode(PDA);
    waitStartNode(LAPTOP);
    waitStartNode(HOME);
    waitStartNode(SERVER);
    // initial data population
    long totalWrites = sendInitWritesScript(PDA, true);
    pda_ccp = recv(PDA);
    assert(pda_ccp.getSignalType() == CoordCommPacket.ACCEPT_STAMP);
    assert(pda_ccp.getData() instanceof AcceptStamp);

    // get experimental specific interest sets
    pda_dis = getInterestSet(SERVER);
    laptop_dis = getInterestSet(SERVER);
    home_dis = getInterestSet(SERVER);
    server_dis = getInterestSet(SERVER);

    initStats = getAllStats();
    long startT = System.currentTimeMillis();

    // laptop subscribe to pda
    issueSubscribe(PDA, LAPTOP, AcceptVV.makeVVAllNegatives(),  
                   laptop_dis, SUBSCRIPTION_TIMEOUT_MS, MAX_DELAY_MS);
    sendSync(LAPTOP, (AcceptStamp)pda_ccp.getData());

    // wait for the sync. process to complete on laptop
    done_ccp = recv(LAPTOP);
    assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
    assert(done_ccp.getData() == null);
    System.out.println("Received a SYNC_DONE from node " + LAPTOP);

    // server subscribe to laptop
    issueSubscribe(LAPTOP, SERVER, AcceptVV.makeVVAllNegatives(),  
                   server_dis, SUBSCRIPTION_TIMEOUT_MS, MAX_DELAY_MS);
    sendSync(SERVER, (AcceptStamp)pda_ccp.getData());

    // wait for the sync. process to complete on server
    done_ccp = recv(SERVER);
    assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
    assert(done_ccp.getData() == null);
    System.out.println("Received a SYNC_DONE from node " + SERVER);

    // home subscribe to server
    issueSubscribe(SERVER, HOME, AcceptVV.makeVVAllNegatives(),  
                   home_dis, SUBSCRIPTION_TIMEOUT_MS, MAX_DELAY_MS);
    sendSync(HOME, (AcceptStamp)pda_ccp.getData());

    // wait for the sync. process to complete on laptop
    done_ccp = recv(HOME);
    assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
    assert(done_ccp.getData() == null);
    System.out.println("Received a SYNC_DONE from node " + HOME);

    long endT = System.currentTimeMillis();
    finalStats = getAllStats();
    diffStats = finalStats.getDiff(initStats);
    System.out.println(diffStats);
    System.out.println("Total_time " + (endT-startT) + " (ms)");
    laptop_cvv = (CounterVV)getHighestTimeStamps(LAPTOP);
    pda_cvv = (CounterVV)getHighestTimeStamps(PDA);
    assert(pda_cvv.equals(laptop_cvv));
    
    long data_size = diffStats.getTotal()*8;
    System.out.println("Achieved bandwidth (kb/s): " + (data_size/(endT-startT)));
    System.out.println("---------------------------------------");
    System.out.println("Exit value for node " + LAPTOP + " = " + killNode(LAPTOP));
    System.out.println("Exit value for node " + PDA + " = " + killNode(PDA));
    System.out.println("Exit value for node " + HOME + " = " + killNode(HOME));
    System.out.println("Exit value for node " + SERVER + " = " + killNode(SERVER));
  }

  public void PRACTI_L2H(){
    CoordCommPacket done_ccp = null;
    CoordCommPacket laptop_ccp = null;
    SubscriptionSet laptop_dis = null;
    SubscriptionSet home_dis = null;
    StatsRecord initStats = null;
    StatsRecord finalStats = null;
    StatsRecord diffStats = null;
    CounterVV laptop_cvv = null;
    CounterVV home_cvv = null;

    this.restartRMIRegistrySync();
    startNode(LAPTOP);
    startNode(HOME);
    waitStartNode(LAPTOP);
    waitStartNode(HOME);

    // initial data population
    long totalWrites = sendInitWritesScript(LAPTOP, true);
    laptop_ccp = recv(LAPTOP);
    assert(laptop_ccp.getSignalType() == CoordCommPacket.ACCEPT_STAMP);
    assert(laptop_ccp.getData() instanceof AcceptStamp);

    // get experimental specific interest sets
    laptop_dis = getInterestSet(SERVER);
    home_dis = getInterestSet(SERVER);

    initStats = getAllStats();
    long startT = System.currentTimeMillis();

    // home subscribe to laptop
    issueSubscribe(LAPTOP, HOME, AcceptVV.makeVVAllNegatives(),  
                   home_dis, SUBSCRIPTION_TIMEOUT_MS, MAX_DELAY_MS);
    sendSync(HOME, (AcceptStamp)laptop_ccp.getData());

    // wait for the sync. process to complete on laptop
    done_ccp = recv(HOME);
    assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
    assert(done_ccp.getData() == null);
    System.out.println("Received a SYNC_DONE from node " + HOME);

    long endT = System.currentTimeMillis();
    finalStats = getAllStats();
    diffStats = finalStats.getDiff(initStats);
    System.out.println(diffStats);
    System.out.println("Total_time " + (endT-startT) + " (ms)");
    laptop_cvv = (CounterVV)getHighestTimeStamps(LAPTOP);
    home_cvv = (CounterVV)getHighestTimeStamps(HOME);
    assert(home_cvv.equals(laptop_cvv));
    
    long data_size = diffStats.getTotal()*8;
    System.out.println("Achieved bandwidth (kb/s): " + (data_size/(endT-startT)));
    System.out.println("---------------------------------------");
    System.out.println("Exit value for node " + LAPTOP + " = " + killNode(LAPTOP));
    System.out.println("Exit value for node " + PDA + " = " + killNode(HOME));
  }

  public void PRACTI_L2H_THRU_O(){

    CoordCommPacket done_ccp = null;
    CoordCommPacket laptop_ccp = null;
    SubscriptionSet laptop_dis = null;
    SubscriptionSet home_dis = null;
    SubscriptionSet server_dis = null;
    StatsRecord initStats = null;
    StatsRecord finalStats = null;
    StatsRecord diffStats = null;
    CounterVV laptop_cvv = null;
    CounterVV home_cvv = null;
    CounterVV server_cvv = null;

    this.restartRMIRegistrySync();
    startNode(LAPTOP);
    startNode(HOME);
    startNode(SERVER);
    waitStartNode(LAPTOP);
    waitStartNode(HOME);
    waitStartNode(SERVER);

    // initial data population
    long totalWrites = sendInitWritesScript(LAPTOP, true);
    laptop_ccp = recv(LAPTOP);
    assert(laptop_ccp.getSignalType() == CoordCommPacket.ACCEPT_STAMP);
    assert(laptop_ccp.getData() instanceof AcceptStamp);

    // get experimental specific interest sets
    laptop_dis = getInterestSet(SERVER);
    home_dis = getInterestSet(SERVER);
    server_dis = getInterestSet(SERVER);

    initStats = getAllStats();
    long startT = System.currentTimeMillis();

    // server subscribe to laptop 
    issueSubscribe(LAPTOP, SERVER, AcceptVV.makeVVAllNegatives(),  
                   server_dis, SUBSCRIPTION_TIMEOUT_MS, MAX_DELAY_MS);
    sendSync(SERVER, (AcceptStamp)laptop_ccp.getData());

    // wait for the sync. process to complete on server
    done_ccp = recv(SERVER);
    assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
    assert(done_ccp.getData() == null);
    System.out.println("Received a SYNC_DONE from node " + SERVER);

    // home subscribe to server
    issueSubscribe(SERVER, HOME, AcceptVV.makeVVAllNegatives(),  
                   home_dis, SUBSCRIPTION_TIMEOUT_MS, MAX_DELAY_MS);
    sendSync(HOME, (AcceptStamp)laptop_ccp.getData());

    // wait for the sync. process to complete on home
    done_ccp = recv(HOME);
    assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
    assert(done_ccp.getData() == null);
    System.out.println("Received a SYNC_DONE from node " + HOME);

    long endT = System.currentTimeMillis();
    finalStats = getAllStats();
    diffStats = finalStats.getDiff(initStats);
    System.out.println(diffStats);
    System.out.println("Total_time " + (endT-startT) + " (ms)");
    laptop_cvv = (CounterVV)getHighestTimeStamps(LAPTOP);
    home_cvv = (CounterVV)getHighestTimeStamps(HOME);
    assert(home_cvv.equals(laptop_cvv));
    
    long data_size = diffStats.getTotal()*8;
    System.out.println("Achieved bandwidth (kb/s): " + (data_size/(endT-startT)));
    System.out.println("---------------------------------------");
    System.out.println("Exit value for node " + LAPTOP + " = " + killNode(LAPTOP));
    System.out.println("Exit value for node " + PDA + " = " + killNode(HOME));
    System.out.println("Exit value for node " + SERVER + " = " + killNode(SERVER));
  }

  public void PRACTI_O2A_OH(){

    CoordCommPacket done_ccp = null;
    CoordCommPacket server_ccp = null;
    SubscriptionSet home_dis = null;
    SubscriptionSet server_dis = null;
    StatsRecord initStats = null;
    StatsRecord finalStats = null;
    StatsRecord diffStats = null;
    CounterVV home_cvv = null;
    CounterVV server_cvv = null;

    this.restartRMIRegistrySync();
    startNode(HOME);
    startNode(SERVER);
    waitStartNode(HOME);
    waitStartNode(SERVER);
    
     // initial data population
    // Need to change the total file number in the config file for this run
    long totalWrites = sendInitWritesScript(SERVER, true);
    server_ccp = recv(SERVER);
    assert(server_ccp.getSignalType() == CoordCommPacket.ACCEPT_STAMP);
    assert(server_ccp.getData() instanceof AcceptStamp);

    // get experimental specific interest sets
    home_dis = getInterestSet(HOME);
    server_dis = getInterestSet(SERVER);

    initStats = getAllStats();
    long startT = System.currentTimeMillis();

    // home subscribe to server
    issueSubscribe(SERVER, HOME, AcceptVV.makeVVAllNegatives(),  
                   home_dis, SUBSCRIPTION_TIMEOUT_MS, MAX_DELAY_MS);
    sendSync(HOME, (AcceptStamp)server_ccp.getData());

    // wait for the sync. process to complete on home
    done_ccp = recv(HOME);
    assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
    assert(done_ccp.getData() == null);
    System.out.println("Received a SYNC_DONE from node " + HOME);

    long endT = System.currentTimeMillis();
    finalStats = getAllStats();
    diffStats = finalStats.getDiff(initStats);
    System.out.println(diffStats);
    System.out.println("Total_time " + (endT-startT) + " (ms)");
    server_cvv = (CounterVV)getHighestTimeStamps(SERVER);
    home_cvv = (CounterVV)getHighestTimeStamps(HOME);
    assert(home_cvv.equals(server_cvv));
    
    long data_size = diffStats.getTotal()*8;
    System.out.println("Achieved bandwidth (kb/s): " + (data_size/(endT-startT)));
    System.out.println("---------------------------------------");
    System.out.println("Exit value for node " + HOME + " = " + killNode(HOME));
    System.out.println("Exit value for node " + SERVER + " = " + killNode(SERVER));
  }

  public void PRACTI_O2A_OL(){

    CoordCommPacket done_ccp = null;
    CoordCommPacket server_ccp = null;
    SubscriptionSet laptop_dis = null;
    SubscriptionSet server_dis = null;
    StatsRecord initStats = null;
    StatsRecord finalStats = null;
    StatsRecord diffStats = null;
    CounterVV laptop_cvv = null;
    CounterVV server_cvv = null;

    this.restartRMIRegistrySync();
    startNode(LAPTOP);
    startNode(SERVER);
    waitStartNode(LAPTOP);
    waitStartNode(SERVER);
    
     // initial data population
    // Need to change the total file number in the config file for this run
    long totalWrites = sendInitWritesScript(SERVER, true);
    server_ccp = recv(SERVER);
    assert(server_ccp.getSignalType() == CoordCommPacket.ACCEPT_STAMP);
    assert(server_ccp.getData() instanceof AcceptStamp);

    // get experimental specific interest sets
    laptop_dis = getInterestSet(LAPTOP);
    server_dis = getInterestSet(SERVER);

    initStats = getAllStats();
    long startT = System.currentTimeMillis();

    // laptop subscribe to server
    issueSubscribe(SERVER, LAPTOP, AcceptVV.makeVVAllNegatives(),  
                   laptop_dis, SUBSCRIPTION_TIMEOUT_MS, MAX_DELAY_MS);
    sendSync(LAPTOP, (AcceptStamp)server_ccp.getData());

    // wait for the sync. process to complete on LAPTOP
    done_ccp = recv(LAPTOP);
    assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
    assert(done_ccp.getData() == null);
    System.out.println("Received a SYNC_DONE from node " + LAPTOP);

    long endT = System.currentTimeMillis();
    finalStats = getAllStats();
    diffStats = finalStats.getDiff(initStats);
    System.out.println(diffStats);
    System.out.println("Total_time " + (endT-startT) + " (ms)");
    server_cvv = (CounterVV)getHighestTimeStamps(SERVER);
    laptop_cvv = (CounterVV)getHighestTimeStamps(LAPTOP);
    assert(laptop_cvv.equals(server_cvv));
    
    long data_size = diffStats.getTotal()*8;
    System.out.println("Achieved bandwidth (kb/s): " + (data_size/(endT-startT)));
    System.out.println("---------------------------------------");
    System.out.println("Exit value for node " + LAPTOP + " = " + killNode(LAPTOP));
    System.out.println("Exit value for node " + SERVER + " = " + killNode(SERVER));
  }

  public void PRACTI_O2A_OHLP(){

    CoordCommPacket done_ccp = null;
    CoordCommPacket server_ccp = null;
    SubscriptionSet laptop_dis = null;
    SubscriptionSet pda_dis = null;
    SubscriptionSet server_dis = null;
    SubscriptionSet home_dis = null;
    StatsRecord initStats = null;
    StatsRecord finalStats = null;
    StatsRecord diffStats = null;
    CounterVV laptop_cvv = null;
    CounterVV pda_cvv = null;
    CounterVV server_cvv = null;
    CounterVV home_cvv = null;

    this.restartRMIRegistrySync();
    startNode(LAPTOP);
    startNode(PDA);
    startNode(SERVER);
    startNode(HOME);
    waitStartNode(LAPTOP);
    waitStartNode(PDA);
    waitStartNode(SERVER);
    waitStartNode(HOME);
    
     // initial data population
    // Need to change the total file number in the config file for this run
    long totalWrites = sendInitWritesScript(SERVER, true);
    server_ccp = recv(SERVER);
    assert(server_ccp.getSignalType() == CoordCommPacket.ACCEPT_STAMP);
    assert(server_ccp.getData() instanceof AcceptStamp);

    // get experimental specific interest sets
    laptop_dis = getInterestSet(LAPTOP);
    pda_dis = getInterestSet(PDA);
    server_dis = getInterestSet(SERVER);
    home_dis = getInterestSet(HOME);
    
    initStats = getAllStats();
    long startT = System.currentTimeMillis();

    // home subscribe to server
    issueSubscribe(SERVER, HOME, AcceptVV.makeVVAllNegatives(),  
                   home_dis, SUBSCRIPTION_TIMEOUT_MS, MAX_DELAY_MS);
    sendSync(HOME, (AcceptStamp)server_ccp.getData());

    // wait for the sync. process to complete on home
    done_ccp = recv(HOME);
    assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
    assert(done_ccp.getData() == null);
    System.out.println("Received a SYNC_DONE from node " + HOME);

    // laptop subscribe to home
    issueSubscribe(HOME, LAPTOP, AcceptVV.makeVVAllNegatives(),  
                   laptop_dis, SUBSCRIPTION_TIMEOUT_MS, MAX_DELAY_MS);
    sendSync(LAPTOP, (AcceptStamp)server_ccp.getData());

    // wait for the sync. process to complete on LAPTOP
    done_ccp = recv(LAPTOP);
    assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
    assert(done_ccp.getData() == null);
    System.out.println("Received a SYNC_DONE from node " + LAPTOP);

    // pda subscribe to laptop
    issueSubscribe(LAPTOP, PDA, AcceptVV.makeVVAllNegatives(),  
                   pda_dis, SUBSCRIPTION_TIMEOUT_MS, MAX_DELAY_MS);
    sendSync(PDA, new AcceptStamp(9, new NodeId(SERVER)));

    // wait for the sync. process to complete on LAPTOP
    done_ccp = recv(PDA);
    assert(done_ccp.getSignalType() == CoordCommPacket.SYNC_DONE);
    assert(done_ccp.getData() == null);
    System.out.println("Received a SYNC_DONE from node " + PDA);

    long endT = System.currentTimeMillis();
    finalStats = getAllStats();
    diffStats = finalStats.getDiff(initStats);
    System.out.println(diffStats);
    System.out.println("Total_time " + (endT-startT) + " (ms)");
    server_cvv = (CounterVV)getHighestTimeStamps(SERVER);
    laptop_cvv = (CounterVV)getHighestTimeStamps(LAPTOP);
    assert(laptop_cvv.equals(server_cvv));
    
    long data_size = diffStats.getTotal()*8;
    System.out.println("Achieved bandwidth (kb/s): " + (data_size/(endT-startT)));
    System.out.println("---------------------------------------");
    System.out.println("Exit value for node " + LAPTOP + " = " + killNode(LAPTOP));
    System.out.println("Exit value for node " + PDA + " = " + killNode(PDA));
    System.out.println("Exit value for node " + SERVER + " = " + killNode(SERVER));
    System.out.println("Exit value for node " + HOME + " = " + killNode(HOME));
  }

  public static void main(String argv[]){
    TopologyIndependence ti = null;
    ti = new  TopologyIndependence("experiments/sosp/expt.config", argv[1]);

    if (argv.length < 2){
      System.err.println("Usage: <exptConfigfile> <shellType>");
      System.exit(-1);
    }
    
    int type = (new Integer(argv[0])).intValue();

    if(argv.length >= 3){
      mg = (new Long(argv[2])).longValue();
      assert(mg >= 1);
    }

    switch(type){
    case 0:
      ti.PRACTI_P2L();
      break;
      
    case 1:
    case 2:
      ti.PRACTI_P2H_THRU_O();
      break;

    case 3:
      ti.PRACTI_P2H();
      break;

    case 4:
    case 5:
      ti.PRACTI_L2H_THRU_O();
      break;

    case 6:
      ti.PRACTI_L2H();
      break;

    case 7:
      ti.PRACTI_O2A_OL();
      break;

    case 9:
      ti.PRACTI_O2A_OHLP();
      break;

    case 8:
      ti.PRACTI_O2A_OH();
      break;
    }
  }
  
}
