 /** 
 *  Start two timers when the inval stream is initiated. 
 *  Stop one when we see NUM_FILES invalidates, and stop the 
 *  other when we see NUM_FILES object bodies. 
 **/ 
import java.util.BitSet;

public class RemoteExptController implements Controller{

 /** 
 *  Data members 
 **/ 
  private int numFiles;
  private BitSet invSet;
  private BitSet objSet;
  private long startTimeMS;
  private long invEndTimeMS;
  private long objEndTimeMS;

 /** 
 *  Constructor 
 **/ 
  public
  RemoteExptController(int newNumFiles){
    this.numFiles = newNumFiles;
    this.invSet = new BitSet(this.numFiles);
    this.objSet = new BitSet(this.numFiles);
    this.startTimeMS = -1;
    this.invEndTimeMS = -1;
    this.objEndTimeMS = -1;
  }

 /** 
 *  Start the timer 
 **/ 
  public synchronized void
  informInvalStreamInitiated(NodeId senderNodeId, 
                             SubscriptionSet is,
                             VV vvStart, 
                             boolean placeholderWriterSet){
    Env.printDebug("informInvalStreamInitiated");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informCommitStreamInitiated(NodeId senderNodeId){
    Env.printDebug("informCommitStreamInitiated");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informBodyStreamInitiated(NodeId senderNodeId){
    Env.printDebug("informBodyStreamInitiated");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informUnbindStreamInitiated(NodeId senderNodeId){
    Env.printDebug("informUnbindStreamInitiated");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informSyncRplyStreamInitiated(NodeId senderNodeId){
    Env.printDebug("informSyncRplyStreamInitiated");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informOutgoingInvalStreamInitiated(NodeId targetNodeId, 
                                     SubscriptionSet is, 
                                     VV startVV,
                                     boolean placeholderWriterSet){
    Env.printDebug("informOutgoingInvalStreamInitiated");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informOutgoingBodyStreamInitiated(NodeId targetNodeId,
                                    SubscriptionSet is, 
                                    VV startVV,
                                    boolean placeholderWriterSet){
    Env.printDebug("informOutgoingBodyStreamInitiated");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informInvalStreamTerminated(NodeId senderNodeId,
                              SubscriptionSet is,
                              VV vvStart, 
                              boolean placeholderWriterSet){
    Env.printDebug("informInvalStreamTerminated");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informCommitStreamTerminated(NodeId senderNodeId){
    Env.printDebug("informCommitStreamTerminated");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informBodyStreamTerminated(NodeId senderNodeId){
    Env.printDebug("informBodyStreamTerminated");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informUnbindStreamTerminated(NodeId senderNodeId){
    Env.printDebug("informUnbindStreamTerminated");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informSyncRplyStreamTerminated(NodeId senderNodeId){
    Env.printDebug("informSyncRplyStreamTerminated");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informOutgoingInvalStreamTerminated(NodeId targetNodeId, 
                                      SubscriptionSet is, 
                                      VV startVV,
                                      boolean placeholderWriterSet){
    Env.printDebug("informOutgoingInvalStreamTerminated");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informOutgoingBodyStreamTerminated(NodeId targetNodeId, 
                                     SubscriptionSet is, 
                                     VV startVV,
                                     boolean placeholderWriterSet){
    Env.printDebug("informOutgoingBodyStreamTerminated");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  recvSyncReply(AcceptStamp acceptStamp, NodeId sender){
    Env.printDebug("recvSyncReply");
  }

 /** 
 *  Record the fact that we received this object 
 **/ 
  public synchronized void
  informReceivePushBody(BodyMsg msg){
    int objNum = 0;

    Env.printDebug("informReceivePushBody");
    objNum = RemoteExptController.getObjNum(msg.getObjId());
    assert(objNum < this.numFiles);
    this.objSet.set(objNum);
    if(this.objSet.cardinality() == this.numFiles){
      // We have seen all writes
      if(this.objEndTimeMS < 0){
        this.objEndTimeMS = System.currentTimeMillis();
        this.notifyAll();
      }
    }
  }

 /** 
 *  Indicate that we received this invalidate 
 **/ 
  public synchronized void
  informReceiveInval(GeneralInv inv){
    int objNum = 0;
    PreciseInv pi = null;

    Env.printDebug("informReceiveInval");
    assert(inv instanceof PreciseInv);
    pi = (PreciseInv)inv;
    objNum = RemoteExptController.getObjNum(pi.getObjId());
    if(objNum == 0){
      startTimeMS = System.currentTimeMillis();
      this.notifyAll();
    }
    assert(objNum < this.numFiles);
    assert(!this.invSet.get(objNum));
    this.invSet.set(objNum);
    if(this.invSet.cardinality() == this.numFiles){
      // We have seen all invalidates
      this.invEndTimeMS = System.currentTimeMillis();
      this.notifyAll();
    }

    if(pi.isBound()){
      this.objSet.set(objNum);
      if(this.objSet.cardinality() == this.numFiles){
        // We have seen all objects
        if(this.objEndTimeMS < 0){
          this.objEndTimeMS = System.currentTimeMillis();
          this.notifyAll();
        }
      }
    }
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informLocalWrite(ObjId objId,
                   long offset,
                   long length,
                   AcceptStamp as){
    Env.printDebug("informLocalWrite");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informLocalDelete(ObjId objId){
    Env.printDebug("informLocalDelete");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informDemandReadMiss(ObjId objId, long offset, long length){
    Env.printDebug("informDemandReadMiss");
  }

 /** 
 *  Record the fact that this object arrived 
 **/ 
  public synchronized void
  informReceiveDemandReply(BodyMsg msg){
    int objNum = 0;

    Env.printDebug("informReceiveDemandReply");
    objNum = RemoteExptController.getObjNum(msg.getObjId());
    assert(objNum < this.numFiles);
    this.objSet.set(objNum);
    if(this.objSet.cardinality() == this.numFiles){
      // We have seen all writes
      if(this.objEndTimeMS < 0){
        this.objEndTimeMS = System.currentTimeMillis();
        this.notifyAll();
      }
    }
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informDemandReadHit(ObjId objId, long offset, long length){
    Env.printDebug("informDemandReadHit");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informDemandImprecise(ObjId objId,
                        PreciseSet enclosingIS,
                        VV lpVV){
    Env.printDebug("informDemandImprecise");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informBecameImprecise(PreciseSet is){
    Env.printDebug("informBecameImprecise");
  }

 /** 
 *  Fake method 
 **/ 
  public void
  informBecamePrecise(PreciseSet is){
    Env.printDebug("informBecamePrecise");
  }

 /** 
 **/ 
  //    inform methods for send-checkpoint protocol
 /** 
 **/ 
  
 /** 
 *  called in SubscribeInvalWorker when !(this.omitVV < startVV) i.e 
 *  gap exist between the sender's omitVV and the requested stream's  
 *  startVV. It implies that the ongoing subscribe inval stream is  
 *  failed. 
 *  
 *  What expected in the controller is to make the decision whether 
 *  to subscribe inval from other nodes for the receiver or invoke 
 *  a subscribeCheckpoint request to the same node optionally followed  
 *  by a subscribeInval request with a higher startVV 
 **/ 
  public void
  informGapExistForSubscribeInv(NodeId invReceiver,
                                SubscriptionSet is,
                                VV startVV,
                                VV omitVV){
    Env.printDebug("informGapExistForSubscribeInv");
  }

 /** 
 *  inform Outgoing Checkpoint Stream initiated called in CPSendWorker 
 **/ 
  public void
  informOutgoingCheckpointStreamInitiated(NodeId targetNodeId, 
                                          String cpPath, 
                                          String[] exclChildNames,
                                          VV startVV,
                                          boolean placeholderWriterSet){
    Env.printDebug("informOutgoingCheckpointStreamInitiated");
  }
 /** 
 *  inform Outgoing Checkpoint Stream initiated called in CPSendWorker 
 **/ 
  public void
  informOutgoingCheckpointStreamTerminated(NodeId receiverNodeId,
                                           String cpPath,
                                           String[] exclChildNames,
                                           VV startVV, 
                                           boolean placeholderWriterSet){
    Env.printDebug("informOutgoingCheckpointStreamTerminated");
  }
 /** 
 *  inform a Checkpoint Stream initiated called in CPRecvWorker 
 **/ 
  public void
  informCheckpointStreamInitiated(NodeId senderNodeId, 
                                  String cpPath,
                                  String[] exclChildNames,
                                  VV vvStart,
                                  boolean placeholderWriterSet){
    Env.printDebug("informCheckpointStreamInitiated");
  }

 /** 
 *  inform a Checkpoint Stream terminated called in CPRecvWorker 
 **/ 
  public void
  informCheckpointStreamTerminated(NodeId senderNodeId, 
                                   String cpPath,
                                   String[] exclChildNames,
                                   VV vvStart, 
                                   boolean placeholderWriterSet){
    Env.printDebug("informCheckpointStreamTerminated");
  }

 /** 
 *  inform a Checkpoint Stream apply status called in CPRecvWorker 
 **/ 
  public void
  informCheckpointStreamReceiveStatus(NodeId senderNodeId, 
                                      String cpPath,
                                      String[] exclChildNames,
                                      VV vvStart, 
                                      boolean applyStatus,
                                      boolean placeholderWriterSet){
    Env.printDebug("informCheckpointStreamTerminated"); 
  }

 /** 
 *  Return startTimeMS 
 **/ 
  public synchronized long
  getStartTimeMS(){
    try{
      while(this.startTimeMS < 0){
        this.wait();
      }
    }catch(InterruptedException e){
      e.printStackTrace();
      System.err.println("" + e);
    }
    return(this.startTimeMS);
  }

 /** 
 *  Return invEndTimeMS 
 **/ 
  public synchronized long
  getInvEndTimeMS(){
    try{
      while(this.invEndTimeMS < 0){
        this.wait();
      }
    }catch(InterruptedException e){
      e.printStackTrace();
      System.err.println("" + e);
    }
    return(this.invEndTimeMS);
  }

 /** 
 *  Return objEndTimeMS 
 **/ 
  public synchronized long
  getObjEndTimeMS(){
    try{
      while(this.objEndTimeMS < 0){
        this.wait();
      }
    }catch(InterruptedException e){
      e.printStackTrace();
      System.err.println("" + e);
    }
    return(this.objEndTimeMS);
  }

 /** 
 *  Convert the object ID to a number 
 **/ 
  private static int
  getObjNum(ObjId objId){
    int objNum = 0;
    String objIdPath = null;
    String objIdNumStr = null;

    objIdPath = objId.getPath();
    assert(objIdPath.startsWith("/"));
    objIdNumStr = objIdPath.substring(1); // Skip the '/'
    try{
      objNum = Integer.parseInt(objIdNumStr);
    }catch(NumberFormatException e){
      e.printStackTrace();
      assert(false);
    }
    return(objNum);
  }
}
