 /** 
 *  Write some files and time how long it takes to write them 
 **/ 
import java.io.IOException;

public class WriteLocalExpt{

 /** 
 *  Private data 
 **/ 
  private static final int NUM_FILES = 1000;
  private static final int FILE_SIZE_BYTES = 1000;

 /** 
 *  Generate NUM_FILES writes of FILE_SIZE_BYTES byte files and 
 *  time the operation 
 **/ 
  private static void
  timeWrites(URANode uraNode) throws IOException{
    // Send over the writes
    // See how long this takes
    long startTimeMS = 0;
    long endTimeMS = 0;
    LocalInterface li = null;
    ImmutableBytes ib = null;
    byte[] b = null;
    double printPct = 0.0;

    li = uraNode.getLocalInterface();
    b = new byte[FILE_SIZE_BYTES];
    ib = ImmutableBytes.dangerousCreateImmutableBytes(b);
    b = null; // Delete byte array reference

    startTimeMS = System.currentTimeMillis();
    for(int i = 0; i < NUM_FILES; i++){
      li.write(new ObjId("/" + i),
               0,
               FILE_SIZE_BYTES,
               Core.DEFAULT_PRIORITY,
               ib,
               true);
      if(((double)i / NUM_FILES) >= printPct){
        System.out.println("Finished: " + ((i * 100) / NUM_FILES) + "%");
        printPct += 0.1;
      }
    }
    endTimeMS = System.currentTimeMillis();
    System.out.println("Start time (ms) = " + startTimeMS);
    System.out.println("End time (ms) = " + endTimeMS);
    System.out.println("Diff (ms) = " + (endTimeMS - startTimeMS));
  }

 /** 
 *  Program staring point 
 **/ 
  public static void
  main(String[] argv){
    int nodeIdInt = 0;
    NodeId nodeId = null;
    URANode uraNode = null;
    LocalInterface localInterface = null;

    if(argv.length != 2){
      System.err.println("Usage: java WriteLocalExpt " +
                         "<configFileName> <my node id>");
    }else{
      // Start URA Node
      nodeIdInt = Integer.parseInt(argv[1]);
      nodeId = new NodeId(nodeIdInt);
      uraNode = new URANode(argv[0],
                            nodeId,
                            Controller.NULL_CONTROLLER,
                            true);

      // Issue NUM_FILES writes of FILE_SIZE_BYTES bytes each
      try{
        WriteLocalExpt.timeWrites(uraNode);
      }catch(IOException e){
        System.err.println("" + e);
      }
    }
  }
}
