#######################################################################
#
# Universal Replication toolkit
# (Copyright information?)
#
#######################################################################
JFLAGS = -g 
JAVAC = javac $(JFLAGS)
JAVA = java 
CLASSDIR = classes

ifeq "$(OSTYPE)" "linux"
  os = "linux"
  shellParam = tcsh
endif
ifeq "$(OSTYPE)" "linux-gnu"
  os = "linux"
  shellParam = bash
endif

ifndef os
  CLASSPATH = classes/\;.\;experiments/expt1/classes\;experiments/sosp/classes\;experiments/expt2/classes\;experiments/expt3/classes\;sdims.jar\;./je-1.5.1/lib/je.jar
  CONFIG_FILE = ./ufs.config
  JAVA_POLICY_FILE = ./java.security.SecurityPermission
else
  CLASSPATH = $(PWD)/classes:$(PWD):./experiments/expt1/classes:./experiments/sosp/classes:./experiments/expt2/classes:./experiments/expt3/classes:sdims.jar:./je-1.5.1/lib/je.jar
  CONFIG_FILE = $(PWD)/ufs.config
  JAVA_POLICY_FILE = $(PWD)/java.security.SecurityPermission
endif

#
# Alphabetical list of all java files goes here
# (Note that javac *.java doesn't reliably work, so we're stuck with this.)
#
THESRCS = $(DIR)AcceptStamp.java\
$(DIR)AcceptVV.java\
$(DIR)Assert.java\
$(DIR)BodyMsg.java\
$(DIR)BodyReceiver.java\
$(DIR)BodyRecvWorker.java\
$(DIR)BoundStatus.java\
$(DIR)BoundInval.java\
$(DIR)CSNContainer.java\
$(DIR)CSNMap.java\
$(DIR)CantRecoverCheckpointException.java\
$(DIR)CausalOrderException.java\
$(DIR)Config.java\
$(DIR)ConfigEntry.java\
$(DIR)ConstrainedOutputStream.java\
$(DIR)Controller.java\
$(DIR)Coordinator.java\
$(DIR)Core.java\
$(DIR)CounterVV.java\
$(DIR)DISTreeNode.java\
$(DIR)DataStore.java\
$(DIR)DelayOutputStream.java\
$(DIR)DeleteInv.java\
$(DIR)DemandReadWorker.java\
$(DIR)DirectoryInterestSet.java\
$(DIR)DirectoryUpdate.java\
$(DIR)DirectoryUpdateWorker.java\
$(DIR)Env.java\
$(DIR)GeneralInv.java\
$(DIR)HBFrame.java\
$(DIR)HBObj.java\
$(DIR)HeartbeatInputStream.java\
$(DIR)HeartbeatOutputStream.java\
$(DIR)HeartbeatServerSocket.java\
$(DIR)HeartbeatSocket.java\
$(DIR)IsImpreciseException.java\
$(DIR)ISIterator.java\
$(DIR)ISStatus.java\
$(DIR)ImmutableBytes.java\
$(DIR)ImpreciseInv.java\
$(DIR)InterestSet.java\
$(DIR)InterestSetRecord.java\
$(DIR)InvalIterator.java\
$(DIR)InvalListItem.java\
$(DIR)InvalReceiver.java\
$(DIR)InvalRecvWorker.java\
$(DIR)InvalSpanningList.java\
$(DIR)InvalTarget.java\
$(DIR)LocalController.java\
$(DIR)LocalInterface.java\
$(DIR)NetAddr.java\
$(DIR)NoSuchEntryException.java\
$(DIR)NodeId.java\
$(DIR)ObjId.java\
$(DIR)ObjInvalTarget.java\
$(DIR)ObjNotFoundException.java\
$(DIR)OmittedVVException.java\
$(DIR)PendingDemandList.java\
$(DIR)PendingDemandRequest.java\
$(DIR)PersistentUpdateLog.java\
$(DIR)PreciseInv.java\
$(DIR)RandomReadDirectory.java\
$(DIR)ReadDirectory.java\
$(DIR)ReadOfInvalidRangeException.java\
$(DIR)RMIApplicationException.java\
$(DIR)RMIClient.java\
$(DIR)RMINetworkException.java\
$(DIR)RMIServer.java\
$(DIR)RMIServerImpl.java\
$(DIR)RMITimeoutSocketFactory.java\
$(DIR)RandomAccessState.java\
$(DIR)ReconnectConnection.java\
$(DIR)SDIMSController.java\
$(DIR)SDIMSInterface.java\
$(DIR)SDIMSReadDirectory.java\
$(DIR)SingleWriterImpreciseInv.java\
$(DIR)SingleWriterInval.java\
$(DIR)SingleWriterLog.java\
$(DIR)SingleWriterLogCommitted.java\
$(DIR)SingleWriterLogUncommitted.java\
$(DIR)SocketServer.java\
$(DIR)SpanningChangeHandler.java\
$(DIR)SpanningDirectory.java\
$(DIR)SpanningTreeWorker.java\
$(DIR)SpanningTreeWatchdog.java\
$(DIR)Stats.java\
$(DIR)StatsRecord.java\
$(DIR)StreamPool.java\
$(DIR)SubscribeBodyWorker.java\
$(DIR)SubscribeInvalRequest.java\
$(DIR)SubscribeInvalWorker.java\
$(DIR)SyncPool.java\
$(DIR)SyncRequest.java\
$(DIR)SyncRequestQ.java\
$(DIR)SyncRequestThread.java\
$(DIR)SyncRplyReceiver.java\
$(DIR)SyncRplyRecvWorker.java\
$(DIR)TaggedOutputStream.java\
$(DIR)TestMemConsumption.java\
$(DIR)TentativeState.java\
$(DIR)TimeoutHandler.java\
$(DIR)TimeoutQueue.java\
$(DIR)TimeoutQueueWorker.java\
$(DIR)TrivialSpanningTreeDirectory.java\
$(DIR)URANode.java\
$(DIR)UnableToConnectException.java\
$(DIR)UnbindMsg.java\
$(DIR)UpdateLog.java\
$(DIR)UpdatePriorityComparator.java\
$(DIR)UpdatePriorityQueue.java\
$(DIR)UpdateRangeList.java\
$(DIR)VV.java\
$(DIR)VVIterator.java\
$(DIR)VVMap.java\
$(DIR)WorkQueue.java




SRCDIR=.
DIR:=$(SRCDIR)/
SRCS := $(THESRCS) 
DIR:=$(CLASSDIR)/
THECLASSFILES := $(THESRCS:.java=.class)
CLASSFILES = $(THECLASSFILES)

.phony:			clean all

all:
			echo $(OSTYPE) 
			mkdir -p $(CLASSDIR)
			$(JAVAC) -source 1.4 -d $(CLASSDIR) -classpath $(CLASSPATH) *.java 
			rmic -d $(CLASSDIR) -classpath $(CLASSPATH) RMIServerImpl
#			cd experiments/script-generators; make
			cd experiments/sosp; make
			cd experiments/expt1; make

#
# Use
#    > make -k force 
# to force compilation of each file for cases when javac * skips
# some...
#
force:			classfiles

classfiles:		$(CLASSFILES)


clean:
			rm -rf $(CLASSDIR)/*
			rm -rf experiments/expt1/$(CLASSDIR)
			rm -rf experiments/sosp/$(CLASSDIR)
			rm -rf experiments/expt2/$(CLASSDIR)
			rm -rf experiments/expt3/$(CLASSDIR)
#			rm -rf experiments/script-generators/$(CLASSDIR)

classes/%.class: %.java
	mkdir -p $(CLASSDIR); $(JAVAC) -source 1.4 -d $(CLASSDIR) -classpath $(CLASSPATH) $<



%.class: %.java
	mkdir -p $(CLASSDIR); $(JAVAC) -source 1.4 -d $(CLASSDIR) -classpath $(CLASSPATH) $<

config:
			mkdir -p $(CLASSDIR)
			$(JAVAC) -source 1.4 -d $(CLASSDIR) -classpath $(CLASSPATH) Config.java

run-config:
			$(JAVA) -ea -classpath $(CLASSPATH) Config $(CONFIG_FILE) 9 10 11

rmi:
			mkdir -p $(CLASSDIR)
			$(JAVAC) -source 1.4 -d $(CLASSDIR) -classpath $(CLASSPATH) RMIClient.java
			rmic -d $(CLASSDIR) -classpath $(CLASSPATH) RMIServerImpl

run-s:
			rmiregistry &
			$(JAVA) -ea -Djava.security.policy=$(JAVA_POLICY_FILE) RMIServerImpl $(CONFIG_FILE) 11

run-c:
			$(JAVA) -ea -Djava.security.policy=$(JAVA_POLICY_FILE) RMIClient $(CONFIG_FILE) 9 10 11

ura:
			mkdir -p $(CLASSDIR)
			$(JAVAC) -source 1.4 -d $(CLASSDIR) -classpath $(CLASSPATH) URANode.java

li:
			mkdir -p $(CLASSDIR)
			$(JAVAC) -source 1.4 -d $(CLASSDIR) -classpath $(CLASSPATH) LocalInterface.java

core:	
			mkdir -p $(CLASSDIR)
			$(JAVAC) -source 1.4 -d $(CLASSDIR) -classpath $(CLASSPATH) Core.java

upq:
			mkdir -p $(CLASSDIR)
			$(JAVAC) -source 1.4 -d $(CLASSDIR) -classpath $(CLASSPATH) UpdatePriorityQueue.java

run-upq:
			mkdir -p $(CLASSDIR)
			cat upq-test | $(JAVA) -ea -classpath $(CLASSPATH) UpdatePriorityQueue

hb:
			mkdir -p  $(CLASSDIR)
			$(JAVAC) -source 1.4 -d $(CLASSDIR) -classpath $(CLASSPATH) HeartbeatServerSocket.java 

run-hb-s:
			$(JAVA) -ea -classpath $(CLASSPATH) HeartbeatServerSocket server 

run-hb-c:	
			$(JAVA) -ea -classpath $(CLASSPATH) HeartbeatServerSocket client borage.cs.utexas.edu

cos:
			mkdir -p  $(CLASSDIR)
			$(JAVAC) -source 1.4 -d $(CLASSDIR) -classpath $(CLASSPATH) ConstrainedOutputStream.java

run-cos-c:
			 $(JAVA) -ea -classpath $(CLASSPATH) ConstrainedOutputStream client lily.cs.utexas.edu 10000

run-cos-s:
			 $(JAVA) -ea -classpath $(CLASSPATH) ConstrainedOutputStream server 10000

dos:
			mkdir -p  $(CLASSDIR)
			$(JAVAC) -source 1.4 -d $(CLASSDIR) -classpath $(CLASSPATH) DelayOutputStream.java

run-dos-c:
			 $(JAVA) -ea -classpath $(CLASSPATH) DelayOutputStream client delacroix.cs.utexas.edu

run-dos-s:
			 $(JAVA) -ea -classpath $(CLASSPATH) DelayOutputStream server

runSocketServer:
			$(JAVA) -esa -ea -classpath $(CLASSPATH) \
			  InvalReceiver $(CONFIG_FILE) 1

runSubscribeInvalWorker:
			$(JAVA) -esa -ea -classpath $(CLASSPATH) \
			  SubscribeInvalWorker $(CONFIG_FILE) 1

runSDIMSControllerTest:
	./runSDIMSControllerTest

%.unit: classes/%.class
			$(JAVA) -ea -classpath $(CLASSPATH) $*; 

unit:			
			$(JAVA) -ea -classpath $(CLASSPATH) WorkQueue; \
			$(JAVA) -ea -classpath $(CLASSPATH) AcceptStamp; \
			$(JAVA) -ea -classpath $(CLASSPATH) AcceptVV; \
			$(JAVA) -ea -classpath $(CLASSPATH) BoundStatus;\
			$(JAVA) -ea -classpath $(CLASSPATH) DirectoryInterestSet; \
			$(JAVA) -ea -classpath $(CLASSPATH) DISTreeNode; \
			$(JAVA) -ea -classpath $(CLASSPATH) SubscribeInvalRequest;\
			$(JAVA) -ea -classpath $(CLASSPATH) ImmutableBytes;\
			$(JAVA) -ea -classpath $(CLASSPATH) InvalSpanningList; \
			$(JAVA) -ea -classpath $(CLASSPATH) NodeId; \
			$(JAVA) -ea -classpath $(CLASSPATH) PendingDemandRequest;\
			$(JAVA) -ea -classpath $(CLASSPATH) PendingDemandList;\
			$(JAVA) -ea -classpath $(CLASSPATH) SpanningTreeWorker;\
			$(JAVA) -ea -classpath $(CLASSPATH) DemandReadWorker;\
			$(JAVA) -ea -classpath $(CLASSPATH) RandomReadDirectory;\
			$(JAVA) -ea -classpath $(CLASSPATH) InvalListItem;\
			./runSDIMSControllerTest;\
                        $(JAVA) -ea -classpath $(CLASSPATH) SingleWriterLogCommitted;\
                        $(JAVA) -ea -classpath $(CLASSPATH) SingleWriterLogUncommitted;\
			$(JAVA) -ea -classpath $(CLASSPATH) TrivialSpanningDirectory;\
                        $(JAVA) -ea -classpath $(CLASSPATH) UpdateLog;\
			$(JAVA) -ea -classpath $(CLASSPATH) TimeoutQueue; \
			$(JAVA) -ea -classpath $(CLASSPATH) TimeoutQueueWorker; \
			$(JAVA) -ea -classpath $(CLASSPATH) DataStore; \
			$(JAVA) -ea -classpath $(CLASSPATH) RandomAccessState

run-test0:
			(xterm -sl 2000 -hold -title 'Node 9: zinnia' -geometry 70x17+0+0 -e ssh -x zinnia -t "cd $(PWD);./runURA.sh 9 experiments/expt1/populate.dat 2>&1 | tee experiments/expt1/node9.output") &
			(xterm -sl 2000 -hold -title 'Node 10: lily' -geometry 70x17+0+300 -e ssh -x lily -t "cd $(PWD);./runURA.sh 10 2>&1 | tee experiments/expt1/node10.output") &
			sleep 2
			(xterm -sl 2000 -hold -title 'Node 11: el-greco' -geometry 70x17+0+620 -e ssh -x el-greco -t "cd $(PWD);./runCoordinator.sh 11 < experiments/expt1/coordscr.scr 2>&1 | tee experiments/expt1/node11.output") &

run-test0-local:
			./killRMIRegistry.sh
			rmiregistry &
			(xterm -sl 2000 -hold -title 'Node 9' -geometry 70x17+0+0 -e "./runURA-local.sh 9 experiments/expt1/populate.dat 2>&1 | tee experiments/expt1/node9.output") &
			(xterm -sl 2000 -hold -title 'Node 10' -geometry 70x17+0+300 -e "./runURA-local.sh 10 2>&1 | tee experiments/expt1/node10.output") &
			sleep 4
			(xterm -sl 2000 -hold -title 'Node 11' -geometry 70x17+0+620 -e "./runCoordinator-local.sh 11 < experiments/expt1/coordscr.scr 2>&1 | tee experiments/expt1/node11.output") &

run-test1-local:
			./killRMIRegistry.sh
			rmiregistry &

			# 1000 files, each 10KB, unbound writes, 10 writes
			$(JAVA) -esa -ea -classpath $(CLASSPATH) SenderScriptGen 1000 / 10000 0 10 > experiments/expt1/A.writes.scr
			#$(JAVA) -esa -ea -classpath $(CLASSPATH) SenderScriptGen 10000 / 10000 0 10000 > experiments/expt1/A.writes.scr
			# 1000 files, each 10KB, 10 reads, IS = (10,100)
			$(JAVA) -esa -ea -classpath $(CLASSPATH) CoordScriptGen 1000 / 10000 10 10 100 > experiments/expt1/A.coords.scr
			#$(JAVA) -esa -ea -classpath $(CLASSPATH) CoordScriptGen 10000 / 10000 1000 30 100 > experiments/expt1/A.coords.scr
			(xterm -sl 2000 -hold -title 'Node 9' -geometry 70x17+0+0 -e "./runURA-local.sh 9 experiments/expt1/A.writes.scr 2>&1 | tee experiments/expt1/node9.output") &
			(xterm -sl 2000 -hold -title 'Node 10' -geometry 70x17+0+300 -e "./runURA-local.sh 10 2>&1 | tee experiments/expt1/node10.output") &
			(xterm -sl 2000 -hold -title 'Node 11' -geometry 70x17+0+620 -e "./runCoordinator-local.sh 11 < experiments/expt1/A.coords.scr 2>&1 | tee experiments/expt1/node11.output") &

expt-Amol:
			./killall.sh
			rm -rf experiments/expt1/ufs-local.config9.store
			rm -rf experiments/expt1/ufs-local.config9.log
			rm -rf experiments/expt1/ufs-local.config10.store
			rm -rf experiments/expt1/ufs-local.config10.log
			rm -rf experiments/expt1/ufs-local.config11.store
			rm -rf experiments/expt1/ufs-local.config11.log
			rm -rf experiments/expt1/ufs-local.config12.store
			rm -rf experiments/expt1/ufs-local.config12.log
			mkdir -p experiments/expt1/results
			java -esa -ea -Djava.rmi.server.codebase="file://$(PWD)/classes/file://$(PWD)/experiments/expt1/classes/" -Djava.security.policy=$(PWD)/java.security.SecurityPermission -Xmx1000m CoordExptD experiments/expt1/expt.config $(shellParam) 2>&1 | tee experiments/expt1/results/result6.txt

SanityCheck:
			./killall.sh
			rm -rf experiments/sosp/*.store
			rm -rf experiments/sosp/*.log
#			rm -rf experiments/sosp/results
			mkdir -p experiments/sosp/results
			java -esa -ea -Djava.rmi.server.codebase="file://$(PWD)/classes/file://$(PWD)/experiments/sosp/classes/" -Djava.security.policy=$(PWD)/java.security.SecurityPermission -Xmx1000m SanityCheck experiments/sosp/expt.config $(shellParam) 100 100000 2>&1 | tee experiments/sosp/results/SC1.txt
			grep "======" experiments/sosp/results/SC1.txt |cat >> experiments/sosp/Performance.txt

			./killall.sh
			rm -rf experiments/sosp/*.store
			rm -rf experiments/sosp/*.log
			mkdir -p experiments/sosp/results
			java -esa -ea -Djava.rmi.server.codebase="file://$(PWD)/classes/file://$(PWD)/experiments/sosp/classes/" -Djava.security.policy=$(PWD)/java.security.SecurityPermission -Xmx1000m SanityCheck experiments/sosp/expt.config $(shellParam) 1000 1 2>&1 | tee experiments/sosp/results/SC2.txt
			grep "======" experiments/sosp/results/SC2.txt |cat >> experiments/sosp/Performance.txt


PR:
			./killall.sh
			rm -rf experiments/sosp/ufs-local.config*.store
			rm -rf experiments/sosp/ufs-local.config*.log
			mkdir -p experiments/sosp/results
			java -esa -ea -Djava.rmi.server.codebase="file://$(PWD)/classes/file://$(PWD)/experiments/sosp/classes/" -Djava.security.policy=$(PWD)/java.security.SecurityPermission -Xmx1000m PartialReplication experiments/sosp/expt.config $(shellParam) 0.2 2>&1 | tee experiments/sosp/results/PR02.txt

BDY:
			./killall.sh
			rm -rf experiments/sosp/ufs-local.config*.store
			rm -rf experiments/sosp/ufs-local.config*.log
			mkdir -p experiments/sosp/results
			java -esa -ea -Djava.rmi.server.codebase="file://$(PWD)/classes/file://$(PWD)/experiments/sosp/classes/" -Djava.security.policy=$(PWD)/java.security.SecurityPermission -Xmx1000m ByteDieYoung experiments/sosp/expt.config $(shellParam) 5 2>&1 | tee experiments/sosp/results/BDY5.txt
			./killall.sh
			rm -rf experiments/sosp/ufs-local.config*.store
			rm -rf experiments/sosp/ufs-local.config*.log
			mkdir -p experiments/sosp/results
			java -esa -ea -Djava.rmi.server.codebase="file://$(PWD)/classes/file://$(PWD)/experiments/sosp/classes/" -Djava.security.policy=$(PWD)/java.security.SecurityPermission -Xmx1000m ByteDieYoung experiments/sosp/expt.config $(shellParam) 10 2>&1 | tee experiments/sosp/results/BDY10.txt
			./killall.sh
			rm -rf experiments/sosp/ufs-local.config*.store
			rm -rf experiments/sosp/ufs-local.config*.log
			mkdir -p experiments/sosp/results
			java -esa -ea -Djava.rmi.server.codebase="file://$(PWD)/classes/file://$(PWD)/experiments/sosp/classes/" -Djava.security.policy=$(PWD)/java.security.SecurityPermission -Xmx1000m ByteDieYoung experiments/sosp/expt.config $(shellParam) 20 2>&1 | tee experiments/sosp/results/BDY20.txt
			./killall.sh
			rm -rf experiments/sosp/ufs-local.config*.store
			rm -rf experiments/sosp/ufs-local.config*.log
			mkdir -p experiments/sosp/results
			java -esa -ea -Djava.rmi.server.codebase="file://$(PWD)/classes/file://$(PWD)/experiments/sosp/classes/" -Djava.security.policy=$(PWD)/java.security.SecurityPermission -Xmx1000m ByteDieYoung experiments/sosp/expt.config $(shellParam) 50 2>&1 | tee experiments/sosp/results/BDY50.txt

			./killall.sh
			rm -rf experiments/sosp/ufs-local.config*.store
			rm -rf experiments/sosp/ufs-local.config*.log
			mkdir -p experiments/sosp/results
			java -esa -ea -Djava.rmi.server.codebase="file://$(PWD)/classes/file://$(PWD)/experiments/sosp/classes/" -Djava.security.policy=$(PWD)/java.security.SecurityPermission -Xmx1000m ByteDieYoung experiments/sosp/expt.config $(shellParam) 70 2>&1 | tee experiments/sosp/results/BDY70.txt


			./killall.sh
			rm -rf experiments/sosp/ufs-local.config*.store
			rm -rf experiments/sosp/ufs-local.config*.log
			mkdir -p experiments/sosp/results
			java -esa -ea -Djava.rmi.server.codebase="file://$(PWD)/classes/file://$(PWD)/experiments/sosp/classes/" -Djava.security.policy=$(PWD)/java.security.SecurityPermission -Xmx1000m ByteDieYoung experiments/sosp/expt.config $(shellParam) 100 2>&1 | tee experiments/sosp/results/BDY100.txt
BW:
			./killall.sh
			rm -rf experiments/sosp/ufs-local.config*.store
			rm -rf experiments/sosp/ufs-local.config*.log
			mkdir -p experiments/sosp/results
			java -esa -ea -Djava.rmi.server.codebase="file://$(PWD)/classes/file://$(PWD)/experiments/sosp/classes/" -Djava.security.policy=$(PWD)/java.security.SecurityPermission -Xmx1000m Bandwidth experiments/sosp/expt-bw.config $(shellParam) 1 100000 2>&1 | tee experiments/sosp/results/result2.txt

CC:
			./killall.sh
			rm -rf experiments/sosp/ufs-local.config*.store
			rm -rf experiments/sosp/ufs-local.config*.log
			mkdir -p experiments/sosp/results
			java -esa -ea -Djava.rmi.server.codebase="file://$(PWD)/classes/file://$(PWD)/experiments/sosp/classes/" -Djava.security.policy=$(PWD)/java.security.SecurityPermission -Xmx1000m ConsistencyCost experiments/sosp/expt.config $(shellParam) 5 10 2>&1 | tee experiments/sosp/results/CC.txt

TI-P2L:
			cp experiments/sosp/TI-config/1000000F.config  experiments/sosp/expt.config

			./killall.sh
			rm -rf experiments/sosp/ufs-local.config*.store
			rm -rf experiments/sosp/ufs-local.config*.log
			rm -rf experiments/sosp/TI-results/PRACT-P2L-50K.txt
			mkdir -p experiments/sosp/TI-results/
			cp  experiments/sosp/TI-config/PRACT-P2L-50K.config  experiments/sosp/ufs-local.config
			java -esa -ea -Djava.rmi.server.codebase="file://$(PWD)/classes/ file://$(PWD)/experiments/expt1/classes/" -Djava.security.policy=$(PWD)/java.security.SecurityPermission -Xmx1000m TopologyIndependence 0 $(shellParam) 1 2>&1 | tee experiments/sosp/TI-results/PRACT-P2L-50K.txt

			./killall.sh
			rm -rf experiments/sosp/ufs-local.config*.store
			rm -rf experiments/sosp/ufs-local.config*.log
			rm -rf experiments/sosp/TI-results/PRACT-P2L.txt
			mkdir -p experiments/sosp/TI-results/
			cp  experiments/sosp/TI-config/PRACT-P2L.config  experiments/sosp/ufs-local.config
			java -esa -ea -Djava.rmi.server.codebase="file://$(PWD)/classes/ file://$(PWD)/experiments/expt1/classes/" -Djava.security.policy=$(PWD)/java.security.SecurityPermission -Xmx1000m TopologyIndependence 0 $(shellParam) 1 2>&1 | tee experiments/sosp/TI-results/PRACT-P2L.txt

			./killall.sh
			rm -rf experiments/sosp/ufs-local.config*.store
			rm -rf experiments/sosp/ufs-local.config*.log
			rm -rf experiments/sosp/TI-results/PRACT-P2L-10M.txt
			mkdir -p experiments/sosp/TI-results/
			cp  experiments/sosp/TI-config/PRACT-P2L-10M.config  experiments/sosp/ufs-local.config
			java -esa -ea -Djava.rmi.server.codebase="file://$(PWD)/classes/ file://$(PWD)/experiments/expt1/classes/" -Djava.security.policy=$(PWD)/java.security.SecurityPermission -Xmx1000m TopologyIndependence 0 $(shellParam) 1 2>&1 | tee experiments/sosp/TI-results/PRACT-P2L-10M.txt

TI-P2H:
			cp experiments/sosp/TI-config/1000000F.config  experiments/sosp/expt.config
#			cp experiments/sosp/TI-config/10000F.config  experiments/sosp/expt.config	

			./killall.sh
			rm -rf experiments/sosp/ufs-local.config*.store
			rm -rf experiments/sosp/ufs-local.config*.log
			rm -rf experiments/sosp/TI-results/PRACT-P2H-O50K.txt
			mkdir -p experiments/sosp/TI-results/
			cp  experiments/sosp/TI-config/PRACT-P2H-O50K.config  experiments/sosp/ufs-local.config
			java -esa -ea -Djava.rmi.server.codebase="file://$(PWD)/classes/ file://$(PWD)/experiments/expt1/classes/" -Djava.security.policy=$(PWD)/java.security.SecurityPermission -Xmx1000m TopologyIndependence 1 $(shellParam) 2>&1 | tee experiments/sosp/TI-results/PRACT-P2H-O50K.txt

			./killall.sh
			rm -rf experiments/sosp/ufs-local.config*.store
			rm -rf experiments/sosp/ufs-local.config*.log
			rm -rf experiments/sosp/TI-results/PRACT-P2H-O10M.txt
			mkdir -p experiments/sosp/TI-results/
			cp  experiments/sosp/TI-config/PRACT-P2H-O10M.config  experiments/sosp/ufs-local.config
			java -esa -ea -Djava.rmi.server.codebase="file://$(PWD)/classes/ file://$(PWD)/experiments/expt1/classes/" -Djava.security.policy=$(PWD)/java.security.SecurityPermission -Xmx1000m TopologyIndependence 2 $(shellParam) 2>&1 | tee experiments/sosp/TI-results/PRACT-P2H-O10M.txt

			./killall.sh
			rm -rf experiments/sosp/ufs-local.config*.store
			rm -rf experiments/sosp/ufs-local.config*.log
			rm -rf experiments/sosp/TI-results/PRACT-P2H.txt
			mkdir -p experiments/sosp/TI-results/
			cp  experiments/sosp/TI-config/PRACT-P2H.config  experiments/sosp/ufs-local.config
			java -esa -ea -Djava.rmi.server.codebase="file://$(PWD)/classes/ file://$(PWD)/experiments/expt1/classes/" -Djava.security.policy=$(PWD)/java.security.SecurityPermission -Xmx1000m TopologyIndependence 3 $(shellParam) 2>&1 | tee experiments/sosp/TI-results/PRACT-P2H.txt

TI-L2H:
			cp experiments/sosp/TI-config/10000F.config  experiments/sosp/expt.config	

			./killall.sh
			rm -rf experiments/sosp/ufs-local.config*.store
			rm -rf experiments/sosp/ufs-local.config*.log
			rm -rf experiments/sosp/TI-results/PRACT-L2H-O50K.txt
			mkdir -p experiments/sosp/TI-results/
			cp  experiments/sosp/TI-config/PRACT-L2H-O50K.config  experiments/sosp/ufs-local.config
			java -esa -ea -Djava.rmi.server.codebase="file://$(PWD)/classes/ file://$(PWD)/experiments/expt1/classes/" -Djava.security.policy=$(PWD)/java.security.SecurityPermission -Xmx1000m TopologyIndependence 4 $(shellParam) 2>&1 | tee experiments/sosp/TI-results/PRACT-L2H-O50K.txt

			./killall.sh
			rm -rf experiments/sosp/ufs-local.config*.store
			rm -rf experiments/sosp/ufs-local.config*.log
			rm -rf experiments/sosp/TI-results/PRACT-L2H-O10M.txt
			mkdir -p experiments/sosp/TI-results/
			cp  experiments/sosp/TI-config/PRACT-L2H-O10M.config  experiments/sosp/ufs-local.config
			java -esa -ea -Djava.rmi.server.codebase="file://$(PWD)/classes/ file://$(PWD)/experiments/expt1/classes/" -Djava.security.policy=$(PWD)/java.security.SecurityPermission -Xmx1000m TopologyIndependence 5 $(shellParam) 2>&1 | tee experiments/sosp/TI-results/PRACT-L2H-O10M.txt

			./killall.sh
			rm -rf experiments/sosp/ufs-local.config*.store
			rm -rf experiments/sosp/ufs-local.config*.log
			rm -rf experiments/sosp/TI-results/PRACT-L2H.txt
			mkdir -p experiments/sosp/TI-results/
			cp  experiments/sosp/TI-config/PRACT-L2H.config  experiments/sosp/ufs-local.config
			java -esa -ea -Djava.rmi.server.codebase="file://$(PWD)/classes/ file://$(PWD)/experiments/expt1/classes/" -Djava.security.policy=$(PWD)/java.security.SecurityPermission -Xmx1000m TopologyIndependence 6 $(shellParam) 2>&1 | tee experiments/sosp/TI-results/PRACT-L2H.txt

TI-O2A:
			cp experiments/sosp/TI-config/100F.config  experiments/sosp/expt.config	

			./killall.sh
			rm -rf experiments/sosp/ufs-local.config*.store
			rm -rf experiments/sosp/ufs-local.config*.log
			rm -rf experiments/sosp/TI-results/PRACT-O2A-O50K.txt
			mkdir -p experiments/sosp/TI-results/
			cp  experiments/sosp/TI-config/PRACT-O2A-O50K.config  experiments/sosp/ufs-local.config
			java -esa -ea -Djava.rmi.server.codebase="file://$(PWD)/classes/ file://$(PWD)/experiments/expt1/classes/" -Djava.security.policy=$(PWD)/java.security.SecurityPermission -Xmx1000m TopologyIndependence 7 $(shellParam) 2>&1 | tee experiments/sosp/TI-results/PRACT-O2A-O50K.txt

			./killall.sh
			rm -rf experiments/sosp/ufs-local.config*.store
			rm -rf experiments/sosp/ufs-local.config*.log
			rm -rf experiments/sosp/TI-results/PRACT-O2A-O10M.txt
			mkdir -p experiments/sosp/TI-results/
			cp  experiments/sosp/TI-config/PRACT-O2A-O10M.config  experiments/sosp/ufs-local.config
			java -esa -ea -Djava.rmi.server.codebase="file://$(PWD)/classes/ file://$(PWD)/experiments/expt1/classes/" -Djava.security.policy=$(PWD)/java.security.SecurityPermission -Xmx1000m TopologyIndependence 8 $(shellParam) 2>&1 | tee experiments/sosp/TI-results/PRACT-O2A-O10M.txt

			./killall.sh
			rm -rf experiments/sosp/ufs-local.config*.store
			rm -rf experiments/sosp/ufs-local.config*.log
			rm -rf experiments/sosp/TI-results/PRACT-O2A.txt
			mkdir -p experiments/sosp/TI-results/
			cp  experiments/sosp/TI-config/PRACT-O2A.config  experiments/sosp/ufs-local.config
			java -esa -ea -Djava.rmi.server.codebase="file://$(PWD)/classes/ file://$(PWD)/experiments/expt1/classes/" -Djava.security.policy=$(PWD)/java.security.SecurityPermission -Xmx1000m TopologyIndependence 9 $(shellParam) 2>&1 | tee experiments/sosp/TI-results/PRACT-O2A.txt

TI-CS:
			./killall.sh
			rm -rf experiments/sosp/ufs-local.config*.store
			rm -rf experiments/sosp/ufs-local.config*.log
			rm -rf experiments/sosp/TI-results/CODA-P-10M.txt
			mkdir -p experiments/sosp/TI-results/
			cp  experiments/sosp/TI-config/CODA-P-10M.config  experiments/sosp/ufs-local.config	

expt1:
			./killall.sh
			rm -rf experiments/expt1/ufs-local.config9.store
			rm -rf experiments/expt1/ufs-local.config10.store
			rm -rf experiments/expt1/ufs-local.config11.store
			rm -rf experiments/expt1/ufs-local.config12.store
			mkdir -p experiments/expt1/results
			java -esa -ea -Djava.rmi.server.codebase="file://$(PWD)/classes/ file://$(PWD)/experiments/expt1/classes/" -Djava.security.policy=$(PWD)/java.security.SecurityPermission CoordExptA experiments/expt1/expt.config $(shellParam) 2>&1 | tee experiments/expt1/results/result1.txt

			./killall.sh
			rm -rf experiments/expt1/ufs-local.config9.store
			rm -rf experiments/expt1/ufs-local.config10.store
			rm -rf experiments/expt1/ufs-local.config11.store
			rm -rf experiments/expt1/ufs-local.config12.store
#			rm -rf experiments/expt1/results
			mkdir -p experiments/expt1/results
			java -esa -ea -Djava.rmi.server.codebase="file://$(PWD)/classes/ file://$(PWD)/experiments/expt1/classes/" -Djava.security.policy=$(PWD)/java.security.SecurityPermission CoordExptB experiments/expt1/expt.config $(shellParam) 2>&1 | tee experiments/expt1/results/result2.txt

			./killall.sh
			rm -rf experiments/expt1/ufs-local.config9.store
			rm -rf experiments/expt1/ufs-local.config10.store
			rm -rf experiments/expt1/ufs-local.config11.store
			rm -rf experiments/expt1/ufs-local.config12.store
#			rm -rf experiments/expt1/results
			mkdir -p experiments/expt1/results
			java -esa -ea -Djava.rmi.server.codebase="file://$(PWD)/classes/ file://$(PWD)/experiments/expt1/classes/" -Djava.security.policy=$(PWD)/java.security.SecurityPermission CoordExptC experiments/expt1/expt.config $(shellParam) 2>&1 | tee experiments/expt1/results/result3.txt

			./killall.sh
			rm -rf experiments/expt1/ufs-local.config9.store
			rm -rf experiments/expt1/ufs-local.config10.store
			rm -rf experiments/expt1/ufs-local.config11.store
			rm -rf experiments/expt1/ufs-local.config12.store
#			rm -rf experiments/expt1/results
			mkdir -p experiments/expt1/results
			java -esa -ea -Djava.rmi.server.codebase="file://$(PWD)/classes/ file://$(PWD)/experiments/expt1/classes/" -Djava.security.policy=$(PWD)/java.security.SecurityPermission CoordExptD experiments/expt1/expt.config $(shellParam) 2>&1 | tee experiments/expt1/results/result4.txt

			./killall.sh
			rm -rf experiments/expt1/ufs-local.config9.store
			rm -rf experiments/expt1/ufs-local.config10.store
			rm -rf experiments/expt1/ufs-local.config11.store
			rm -rf experiments/expt1/ufs-local.config12.store
#			rm -rf experiments/expt1/results
			mkdir -p experiments/expt1/results
			java -esa -ea -Djava.rmi.server.codebase="file://$(PWD)/classes/ file://$(PWD)/experiments/expt1/classes/" -Djava.security.policy=$(PWD)/java.security.SecurityPermission CoordExptE experiments/expt1/expt.config $(shellParam) 2>&1 | tee experiments/expt1/results/result5.txt

			./killall.sh
			rm -rf experiments/expt1/ufs-local.config9.store
			rm -rf experiments/expt1/ufs-local.config10.store
			rm -rf experiments/expt1/ufs-local.config11.store
			rm -rf experiments/expt1/ufs-local.config12.store
#			rm -rf experiments/expt1/results
			mkdir -p experiments/expt1/results
			java -esa -ea -Djava.rmi.server.codebase="file://$(PWD)/classes/ file://$(PWD)/experiments/expt1/classes/" -Djava.security.policy=$(PWD)/java.security.SecurityPermission CoordExptF experiments/expt1/expt.config $(shellParam) 2>&1 | tee experiments/expt1/results/result6.txt

tiss:
			java -esa -ea TaggedInputStream server

tisc:
			java -esa -ea TaggedInputStream client localhost
toss:
			java -esa -ea TaggedOutputStream server

tosc:
			java -esa -ea TaggedOutputStream client localhost
# conf 1, #2
# conf 2, #5
# conf 3, #4 Assertion error
# conf 3, #6
# conf 4, #6


expt:
			./killall.sh
			rm -rf ufs-local.config9.store
			rm -rf ufs-local.config10.store
			java -esa -ea -Djava.rmi.server.codebase="file://$(PWD)/classes/ file://$(PWD)/experiments/expt1/classes/ file://$(PWD)/experiments/expt2/classes/" -Djava.security.policy=$(PWD)/java.security.SecurityPermission CoordExpt2 experiments/expt2/expt.config $(shellParam) 2>&1 | tee s

exp3:
			rm -rf ufs-local.config9.store
			rm -rf ufs-local.config10.store
			rm -rf ufs-local.config11.store
			rm -rf ufs-local.config12.store	
			java -Xmx512 -esa -ea -Djava.rmi.server.codebase="file://$(PWD)/classes/ file://$(PWD)/experiments/expt1/classes/ file://$(PWD)/experiments/expt3/classes/" -Djava.security.policy=$(PWD)/java.security.SecurityPermission TIExpt experiments/expt3/expt.config $(shellParam) 2>&1 | tee s

exp3b:
			rm -rf ufs-local.config9.store
			rm -rf ufs-local.config10.store
			rm -rf ufs-local.config11.store
			rm -rf ufs-local.config12.store	
			java -Xmx512 -esa -ea -Djava.rmi.server.codebase="file://$(PWD)/classes/ file://$(PWD)/experiments/expt1/classes/ file://$(PWD)/experiments/expt3/classes/" -Djava.security.policy=$(PWD)/java.security.SecurityPermission TIExptB experiments/expt3/expt.config $(shellParam) 2>&1 | tee s

core-unit:
	killall.sh
	rmiregistry &
	java -esa -ea -Djava.rmi.server.codebase="file://$(PWD)/classes/ file://$(PWD)/experiments/expt1/classes/ file://$(PWD)/experiments/expt2/classes/" -Djava.security.policy=$(PWD)/java.security.SecurityPermission Core 2>&1 | tee s

#######################################################################
# $Log: graph_L2H.sh,v $
# Revision 1.1  2005/03/07 21:00:08  lgao
# Planet lab exp check-in
#
# Revision 1.104  2005/01/18 22:49:42  zjiandan
# Rewrited Class Serialization for network deliveringto reduce the overall bandwidth.
#
# Revision 1.103  2005/01/13 22:41:15  zjiandan
# fixed Makefile problem and add precise invalidate statistic collection facility.
#
# Revision 1.102  2005/01/13 20:55:40  zjiandan
# Reorganized sosp experiments files into sosp subdirectory under experiments.
#
# Revision 1.101  2005/01/10 03:47:47  zjiandan
# Fixed some bugs. Successfully run SanityCheck and Partial Replication experiments.
#
# Revision 1.100  2004/11/02 22:24:33  zjiandan
# add utility methods for core recovery self test.
#
# Revision 1.99  2004/11/01 18:48:48  nayate
# Changed the path used to access Berkeley DB.
#
# Revision 1.98  2004/10/22 20:46:55  dahlin
# Replaced TentativeState with RandomAccessState in DataStore; got rid of 'chain' in BodyMsg; all self-tests pass EXCEPT (1) get compile-time error in rmic and (2) ./runSDIMSControllerTest fails [related to (1)?]
#
# Revision 1.97  2004/10/22 18:13:39  zjiandan
# cleaned csn from UpdateLog, modified DeleteInv.
# TBD:
#    1. clean csn from all subclasses of GeneralInv
#    2. fix *Inv::cloneIntersectInvaltargetChopStartEnd
#
# Revision 1.96  2004/08/27 20:39:40  dahlin
# Fixed to compile under Cygwin
#
# Revision 1.95  2004/08/18 22:44:44  dahlin
# Made BoundInval subclass of PreciseInval; RandomAccessState passes 2 self tests
#
# Revision 1.94  2004/07/29 22:05:11  dahlin
# Set up unit test for TwoFileObjectStore.java
#
# Revision 1.93  2004/07/28 20:18:26  dahlin
# encapsulated byte[] bodies in ImmutableBytes for safety
#
# Revision 1.92  2004/07/26 20:03:39  dahlin
# Fixed typos from windows checkin so it will compile under Linux
#
# Revision 1.91  2004/07/07 21:14:51  nayate
# Added the ability to automate some experiments
#
# Revision 1.90  2004/05/27 00:20:40  zjiandan
# *** empty log message ***
#
# Revision 1.89  2004/05/26 20:14:39  nayate
# Added some experiments
#
# Revision 1.88  2004/05/26 17:15:10  lgao
# *** empty log message ***
#
# Revision 1.87  2004/05/26 16:19:28  nayate
# *** empty log message ***
#
# Revision 1.86  2004/05/26 08:00:55  lgao
# *** empty log message ***
#
# Revision 1.85  2004/05/25 23:04:57  lgao
# *** empty log message ***
#
# Revision 1.84  2004/05/25 08:16:41  lgao
# *** empty log message ***
#
# Revision 1.83  2004/05/25 06:26:37  nayate
# Minor changes
#
# Revision 1.82  2004/05/23 20:08:27  zjiandan
# *** empty log message ***
#
# Revision 1.81  2004/05/23 09:14:49  lgao
# *** empty log message ***
#
# Revision 1.80  2004/05/22 10:53:57  nayate
# Added some missing directories to CLASSPATH
#
# Revision 1.79  2004/05/22 04:15:07  nayate
# Added the "-rf" option to rm
#
# Revision 1.78  2004/05/22 03:05:13  nayate
# Fixed blocked read bug
#
# Revision 1.77  2004/05/21 23:25:05  nayate
# Minor change
#
# Revision 1.76  2004/05/21 22:22:23  zjiandan
# Add rm filesystem build in previous experiment in expt2.
#
# Revision 1.75  2004/05/21 20:32:18  zjiandan
# Add target for experiment 2.
#
# Revision 1.74  2004/05/21 11:57:42  arun
# minor
#
# Revision 1.73  2004/05/21 11:48:56  nayate
# Minor change
#
# Revision 1.72  2004/05/21 11:47:47  nayate
# Minor change
#
# Revision 1.71  2004/05/21 11:43:59  nayate
# Added expt1
#
# Revision 1.70  2004/05/21 08:08:47  lgao
# *** empty log message ***
#
# Revision 1.69  2004/05/21 00:46:39  lgao
# Added the ability to work for bash as well as tcsh
#
# Revision 1.68  2004/05/20 21:56:40  nayate
# Minor change
#
# Revision 1.67  2004/05/20 20:39:29  ypraveen
# Added sdims.jar to classpath for undefined OS case too. Missed last time
#
# Revision 1.66  2004/05/20 19:32:10  nayate
# Removed hard-coded path names
#
# Revision 1.65  2004/05/20 18:53:59  nayate
# Added experiments/expt1/classes to the class path
#
# Revision 1.64  2004/05/20 17:13:11  ypraveen
# Added sdims.jar to CLASSPATH
#
# Revision 1.63  2004/05/20 01:54:06  nayate
# Added the expt1 directory to the compilation path
#
# Revision 1.62  2004/05/20 00:47:34  dahlin
# Fixed several bugs to make inval log exchange work (biggest one: ISIterator handling case when an single-writer log exists but has no records in it; also added some debugging tools
#
# Revision 1.61  2004/05/19 20:43:11  lgao
# Add StatsRecord class to maintain stats
#
# Revision 1.60  2004/05/19 04:34:55  dahlin
# SDIMSController test compiles and runs but deadlocks
#
# Revision 1.59  2004/05/19 03:09:01  dahlin
# Fixed default constructor for URANode
#
# Revision 1.58  2004/05/19 01:46:30  arun
# added getLPVV functionality
#
# Revision 1.57  2004/05/19 00:18:01  dahlin
# Fixed makefile to work for windows/cygwin
#
# Revision 1.56  2004/05/18 20:28:07  nayate
# Allowed make to compile the script generators as well
#
# Revision 1.55  2004/05/18 08:53:37  nayate
# Added a new test "run-test1-local"
#
# Revision 1.54  2004/05/18 06:25:27  lgao
# Initial implementation of the ConstrainedOutputStream.
# Note: the bandwidth parameter, BW, in ufs.config limits the network output rate of the file system if ConstrainedOutputStream is used for sending data.
#
# Revision 1.53  2004/05/14 21:42:54  nayate
# (1) Changed Makefile to redirect stdout and stderr to files nodeXXX.output,
#     where XXX is the node id.
# (2) Added the "-hold" option to xterm windows so that they don't exit when
#     the application does.
#
# Revision 1.52  2004/05/14 20:37:11  nayate
# Added the ability to run tests locally
#
# Revision 1.51  2004/05/14 02:47:35  nayate
# Allowed the Makefile to run tests on others' machines
#
# Revision 1.50  2004/05/14 00:12:43  zjiandan
# Changes for second experiments.
#
# Revision 1.49  2004/05/13 21:58:14  dahlin
# simple unbind implemented
#
# Revision 1.48  2004/05/13 18:49:17  dahlin
# Clean SDIMSController by moving SpanningTree directory out as separate class (rather than using raw SDIMSInterface)
#
# Revision 1.47  2004/05/13 11:58:52  nayate
# (1) Added the ability to log output
# (2) Added a delay between before allowing the coordinator to start
#
# Revision 1.46  2004/05/13 01:17:15  nayate
# Added the simple ability to run tests using make
#
# Revision 1.45  2004/05/12 19:08:41  zjiandan
# Add UpdateLog self test.
#
# Revision 1.44  2004/05/12 17:12:36  lgao
# Modify the getNext() to block when no data to return
#
# Revision 1.43  2004/05/11 23:20:04  lgao
# *** empty log message ***
#
# Revision 1.42  2004/05/11 21:46:38  lgao
# Implementation of TaggedOutputStream which counts bytes sent over the wire.
#
# Revision 1.41  2004/05/11 17:38:41  nayate
# Added a unit test entry for DISTreeNode.java
#
# Revision 1.40  2004/05/11 03:49:45  zjiandan
# Made some changes to get the first version to work.
#
# Revision 1.39  2004/05/11 00:46:56  dahlin
# Added read-miss-directory updates to SDIMSController
#
# Revision 1.38  2004/05/10 23:55:42  dahlin
# Moved SDIMS read requests into ReadDirectory class for modularity and extensibility
#
# Revision 1.37  2004/05/10 22:45:47  dahlin
# All unit: target tests succeed
#
# Revision 1.36  2004/05/10 21:17:38  lgao
# Initial implementation
#
# Revision 1.35  2004/05/10 21:10:26  dahlin
# Make % targets work after make clean
#
# Revision 1.34  2004/05/10 21:00:22  lgao
# Just to make things compile.
#
# Revision 1.33  2004/05/10 20:50:17  nayate
# Added the ability to check for "linux" as well as "linux-gnu" as os types
#
# Revision 1.32  2004/05/10 20:48:19  dahlin
# Clarified RMI exceptions; full version of (stub) DemandReadWorker
#
# Revision 1.31  2004/05/10 18:56:31  dahlin
# Created PendingDemandList and PendingDemandRequest (needed by SDIMSController)
#
# Revision 1.30  2004/05/09 22:21:11  dahlin
# Unit test and stub implementation for spanningTreeWorker
#
# Revision 1.29  2004/05/09 20:43:32  dahlin
# Use make -k force to force compilation of all stale .java files
#
# Revision 1.28  2004/05/09 20:09:14  dahlin
# Updated unit tests for WorkQueue, TimeoutQueue, TimeoutQueueWorker, DirectoryInterestSet, SubscribeInvalRequest, InvalSpanningList, AcceptStamp, NodeId, and AcceptVV
#
# Revision 1.27  2004/05/09 19:27:03  dahlin
# Updated AcceptVV self tests
#
# Revision 1.26  2004/05/09 19:17:31  dahlin
# Updated NodeId self tests
#
# Revision 1.25  2004/05/09 19:11:10  dahlin
# Updated AcceptStamp self tests
#
# Revision 1.24  2004/05/09 18:51:39  dahlin
# Re-added unit: target that wa accidentally deleted in revision 1.21
#
# Revision 1.23  2004/05/09 18:49:23  nayate
# Removed more redundant entries
#
# Revision 1.22  2004/05/09 03:28:57  lgao
# Add configuration entries for InterestSets and Bandwidth for computing HBStream frame size.
#
# Revision 1.21  2004/05/09 03:04:04  zjiandan
# Remove some redundant updatelog dependency lines.
#
# Revision 1.20  2004/05/09 02:24:16  dahlin
# Complete coding and unit testing of InvalSpanningList and SubscribeInvalRequest
#
# Revision 1.19  2004/05/08 22:18:57  dahlin
# Partially complete version of SDIMSController (it should compile w/o error, though)
#
# Revision 1.18  2004/05/08 19:15:14  nayate
# Removed redundant entries
#
# Revision 1.17  2004/05/07 18:06:46  nayate
# Allowed make to work on Linux
#
#######################################################################
