package code.lasr.db;

import java.io.File;
import java.util.Map;

import code.lasr.db.DbHandle;

import com.sleepycat.je.Transaction;

import code.lasr.db.berkdb.*;

/**
 * For now, a stupid and unified place where transactions are created.
 * This will make it easy for us to change databases without modifying
 * a ton of files.  If we want something more sophisticated in the future,
 * it can be done here too.
 *
 * For now, all calls are done to Berkeley DB.
 **/
public class Database
{
  private final String dbPath;
  private boolean openFlag = false;
  private final BerkDatabase intDb;

  public DbTransaction newTransaction()
  {
    return intDb.newTransaction();
  }

  /************************************************************************
   * New preferred method of opening a DbHandle.
   ***********************************************************************/
  public final static DbHandle getHandle(String t, boolean duplicate) 
  {
    return new DbHandle(t, Object.class, Object.class, duplicate);
  }

  public final static DbHandle getHandle(String t)
  {
    return getHandle(t, false);
  }

  public static DbHandle getHandle(String t, Class<?> keyType, Class<?> valType)
  {
      return getHandle(t, keyType, valType, false);
  }
  
  public static DbHandle getHandle(String t, Class<?> keyType, Class<?> valType, boolean dup)
  {
      return new DbHandle(t, keyType, valType, dup);
  }

  public  void clearAll() throws DbException
  {
    close();
    intDb.clearAll();
  }

  public  Database(String path)
  throws DbException
  {
    dbPath = path;
    intDb = new BerkDatabase(dbPath);
    openFlag = true;
  }

  public Database(String path, long cache, boolean sync)
  throws DbException
  {
    dbPath = path;
    intDb = new BerkDatabase(dbPath, cache, sync);
    openFlag = true;
  }

  public  void close() 
  {
    if (openFlag) {
      intDb.close();
      openFlag = false;
    }
  }

  public void openDatabase(DbHandle dbHandle){
    intDb.openDatabase(dbHandle);
  }
  
  public void closeDatabase(DbHandle dbHandle){
    intDb.closeDatabase(dbHandle);
  }
}


