package code.lasr.db;

import com.sleepycat.bind.EntryBinding;

/**
 * Implements a database handle.  Used to access databases.
 **/
public final class DbHandle<K,V> implements Comparable, java.io.Serializable
{
  private final boolean allowDup;
  protected final String dbName;
  protected final Class<K> keyType;
  protected final Class<V> valType;

  /**
   * Constructor.  Allows duplicate option to be set.
   **/
  DbHandle(String s, Class<K> kt, Class<V> vt, boolean dup) 
  {
    dbName = s;
    keyType = kt;
    valType = vt;
    this.allowDup = dup;
  }

  public Class<K> getKeyType() { return keyType; }
  public Class<V> getValType() { return valType; }

  /**
   * Grab the name of the database handle.
   **/
  public final String getDbName() { return dbName; }

  /**
   * Return a hash of the handle.
   **/
  public int hashCode() { return dbName.hashCode(); }

  /**
   * Converts the handle to a string.
   **/
  public final String toString() { return dbName; }

  /**
   * To implement Comparable.
   **/
  public final int compareTo(Object handle) 
  {
    return dbName.compareTo(handle.toString());
  }

  public final boolean equals(Object obj)
  {
    return dbName.equals(obj.toString());
  }

  public boolean allowDuplicates(){
    return allowDup;
  }
}
