package code.lasr.db;

public interface DbIterator<K,V>
{
	public Object next() throws DbException;
    public boolean hasNext() throws DbException;
    public void reset() throws DbException;
    
    public void delete() throws DbException;
    public Object getKey() throws DbException;
    public Object getValue() throws DbException;
    public void close() throws DbException;
    public boolean seek(Object key) throws DbException;
    public boolean seek(Object key, Object value) throws DbException;
}
