package code.lasr.db;

/**
 * TODO perhaps extend support for database to object keys vs. strings
 **/
public interface DbTransaction<K,V>
{
    /**
     * Methods to write, read, search, and remove elements from the database.
     **/
    public void write(DbHandle db, K k, V v) 
	throws DbException;
    public V read(DbHandle db, K k) 
	throws DbException;
    public K[] listAllKeys(DbHandle db) throws DbException;
    public V[] retrieveAllValues(DbHandle db) throws DbException;
    public void removeAll(DbHandle dbHandle, K k) 
	throws DbException;
    public void remove(DbHandle db, K k) 
	throws DbException;
    public void remove(DbHandle db, K k, V v) 
	throws DbException;
    public void removeDatabase(DbHandle db) throws DbException;
    public void removeAll(DbHandle db) throws DbException;

    /**
     * Get an iterator to the first (key, value) in the database.
     **/
    public DbIterator getIterator(DbHandle db)
	throws DbException;

    /**
     * Methods to pop an element off the top of the database.
     **/
    public Object pop(DbHandle db) throws DbException;


    /** 
     * Abort a transaction.  Note that once this is called, the transaction 
     * is UNUSABLE regardless of the outcome.
     **/
    public void abort();

    /**
     * Commits a transaction.  This call doesn't necessarily force the write
     * to persistent storage.  To do this, use sync() instead of commit().  
     * Note that once this is called, the transaction is UNUSABLE 
     * regardless of the outcome.
     **/
    public void commit() throws TxnFailedException;

    /**
     * Commits a transaction to persistent storage.  This is slower than
     * commit() but is safer.  Note that once this is called, the transaction
     * is UNUSUABLE regardless of the outcome.
     **/
    public void sync() throws TxnFailedException;
}
