package code.lasr.db;

/**
 * Exception representing a key/data pair not being found.
 **/
public class NotFoundException extends DbException
{
    public NotFoundException(Object s, Object v, DbHandle db) 
    {
	super("Key " + s + " and value " + v + " in DB " + db.getDbName());
    }
    public NotFoundException(Object s, DbHandle db) 
    { 
	super("Key " + s + " in DB " + db.getDbName());
    }
    public NotFoundException(Exception e) { super(e); }
}
