package code.lasr.util;

import java.io.*;

public class Debug
{    
    // global flag to turn on and off println
    // this should generally be left on, as this will disable
    // ALL printing (including from Debug.exit())
    private static boolean enablePrint = true;

    // global flag to turn on and off colorized output
    private static boolean enableColorPrint = true;

    // global flag to turn on timestamping/thread stamping
    private static boolean enableTimeThreadStamp = true;

    // the active set of debug print statements
    private static java.util.HashSet activeScreenSet = new java.util.HashSet();
    private static java.util.HashSet activeFileSet = new java.util.HashSet();

    // the file output stream if enabled
    private static PrintStream fileOut;

    // ANSI escape codes for colorized text output
    private static java.util.Hashtable colorTable = new java.util.Hashtable();
    private static final String COLOR_NORMAL   = ((char) 27) + "[0m";
    //    private static final String COLOR_BLACK    = ((char) 27) + "[30;47m";
    private static final String COLOR_BLACK    = ((char) 27) + "[31;40m";
    private static final String COLOR_RED      = ((char) 27) + "[31;40m";
    private static final String COLOR_GREEN    = ((char) 27) + "[32;40m";
    private static final String COLOR_YELLOW   = ((char) 27) + "[33;40m";
    private static final String COLOR_BLUE     = ((char) 27) + "[34;40m";
    private static final String COLOR_MAGENTA  = ((char) 27) + "[35;40m";
    private static final String COLOR_CYAN     = ((char) 27) + "[36;40m";
    private static final String COLOR_WHITE    = ((char) 27) + "[37;40m";
    private static final String COLOR_BRED     = ((char) 27) + "[1;31;40m";
    private static final String COLOR_BGREEN   = ((char) 27) + "[1;32;40m";
    private static final String COLOR_BYELLOW  = ((char) 27) + "[1;33;40m";
    private static final String COLOR_BBLUE    = ((char) 27) + "[1;34;40m";
    private static final String COLOR_BMAGENTA = ((char) 27) + "[1;35;40m";
    private static final String COLOR_BCYAN    = ((char) 27) + "[1;36;40m";
    private static final String COLOR_BWHITE   = ((char) 27) + "[1;37;40m";

    // sleep before exiting if error
    private static final int EXIT_ERROR_SLEEP = 120000;

    // base timestamp for debugging
    private static final long baseTimestamp = Util.getTime(); // 0

    /** 
     * Static initializer.  This is where you can change what is in 
     * the active sets (control what is printed to screen) and the 
     * color tables (what color things print as).
     **/
    static {
        setupDefaultColors();

	// the active set for files
        activeFileSet.add("*");

	// this should generally be left on always
	colorTable.put("error", COLOR_BRED);
	activeScreenSet.add("error");
	colorTable.put("debug-critical", COLOR_BRED);
	activeScreenSet.add("debug-critical");

	// this should generally be left on during development
	colorTable.put("debug", COLOR_BRED);
	activeScreenSet.add("debug");
        activeScreenSet.add("status");

	// used for benchmarking
	// colorTable.put("benchmark", COLOR_BCYAN);
        //	activeScreenSet.add("benchmark");

	//activeScreenSet.add("benchmark");

	// the tag used by tests
	colorTable.put("lasr.tests", COLOR_BWHITE);
	//activeScreenSet.add("lasr.tests");
	colorTable.put("tests", COLOR_BWHITE);
	//	activeScreenSet.add("lasr.tests");
	//	activeScreenSet.add("tests");

        // default packages
	colorTable.put("lasr.sm", COLOR_RED);
	colorTable.put("PIB.ca", COLOR_YELLOW);

	// colorTable.put("lasr.net2", COLOR_BLUE);

	//	activeScreenSet.add("lasr.net2");
	//	activeScreenSet.add("lasr.sm");

	// Paxos
	colorTable.put("lasr.rsm.paxos", COLOR_CYAN);
	colorTable.put("paxos-leader", COLOR_BGREEN);
	colorTable.put("paxos-rsm", COLOR_YELLOW);
	colorTable.put("paxos-elect", COLOR_RED);
	colorTable.put("paxos-decide", COLOR_BRED);

	colorTable.put("rsm", COLOR_YELLOW);
	colorTable.put("test", COLOR_MAGENTA);
	colorTable.put("member", COLOR_BBLUE);
	colorTable.put("lasr.pbft", COLOR_GREEN);
	colorTable.put("pbft", COLOR_GREEN);
	colorTable.put("pbft-result", COLOR_BGREEN);
	colorTable.put("pbft-client", COLOR_BBLUE);
        colorTable.put("pbft-normal", COLOR_CYAN);
        colorTable.put("pbft-messages", COLOR_WHITE);
        colorTable.put("pbft-error", COLOR_MAGENTA);
        colorTable.put("pbft-checkpoint", COLOR_YELLOW);
        colorTable.put("pbft-viewchange", COLOR_BLUE);
	colorTable.put("pbft-network", COLOR_BLUE);
	colorTable.put("pbft-byzantine", COLOR_BMAGENTA);



	colorTable.put("lasr.rsm.ic", COLOR_BGREEN);

	colorTable.put("*", COLOR_WHITE);
	


	// what should be printed out

	// ic rsm
	activeScreenSet.add("lasr.rsm.ic");

	/*	activeScreenSet.add("lasr.rsm.paxos");
	activeScreenSet.add("paxos-leader");
	activeScreenSet.add("paxos-rsm");
	activeScreenSet.add("paxos-elect");
	activeScreenSet.add("paxos-decide");
	*/
	/*
	activeScreenSet.add("lasr.sm");
	activeScreenSet.add("PIB.ca");
	activeScreenSet.add("lasr.net2");

	activeScreenSet.add("lasr.paxos");
	activeScreenSet.add("leader");
	activeScreenSet.add("leader election");
	activeScreenSet.add("rsm");
	activeScreenSet.add("test");
	activeScreenSet.add("result");
	activeScreenSet.add("member");
	*/
	//	activeScreenSet.add("*");
	/*

	activeScreenSet.add("lasr.pbft");
	activeScreenSet.add("pbft-result");
	activeScreenSet.add("pbft-client");
	activeScreenSet.add("pbft-normal");
	activeScreenSet.add("pbft-messages");
        activeScreenSet.add("pbft-error");
        activeScreenSet.add("pbft-checkpoint");
        activeScreenSet.add("pbft-viewchange");
        //activeScreenSet.add("pbft-network");
        activeScreenSet.add("pbft-byzantine");
	*/
    }


    private static final void setupDefaultColors()
    {
        ////////////////////////////////////////////////////////////////////////
        // Default colors
        ////////////////////////////////////////////////////////////////////////
        colorTable.put("normal", COLOR_NORMAL);
        activeScreenSet.add("normal");
        activeFileSet.add("normal");

        colorTable.put("black", COLOR_BLACK);
        activeScreenSet.add("black");
        activeFileSet.add("black");

        colorTable.put("red", COLOR_RED);
        activeScreenSet.add("red");
        activeFileSet.add("red");

        colorTable.put("green", COLOR_GREEN);
        activeScreenSet.add("green");
        activeFileSet.add("green");

        colorTable.put("yellow", COLOR_YELLOW);
        activeScreenSet.add("yellow");
        activeFileSet.add("yellow");

        colorTable.put("blue", COLOR_BLUE);
        activeScreenSet.add("blue");
        activeFileSet.add("blue");

        colorTable.put("magenta", COLOR_MAGENTA);
        activeScreenSet.add("magenta");
        activeFileSet.add("magenta");

        colorTable.put("cyan", COLOR_CYAN);
        activeScreenSet.add("cyan");
        activeFileSet.add("cyan");

        colorTable.put("white", COLOR_WHITE);
        activeScreenSet.add("white");
        activeFileSet.add("white");

        colorTable.put("bred", COLOR_BRED);
        activeScreenSet.add("bred");
        activeFileSet.add("bred");

        colorTable.put("bgreen", COLOR_BGREEN);
        activeScreenSet.add("bgreen");
        activeFileSet.add("bgreen");

        colorTable.put("byellow", COLOR_BYELLOW);
        activeScreenSet.add("byellow");
        activeFileSet.add("byellow");

        colorTable.put("bblue", COLOR_BBLUE);
        activeScreenSet.add("bblue");
        activeFileSet.add("bblue");

        colorTable.put("bmagenta", COLOR_BMAGENTA);
        activeScreenSet.add("bmagenta");
        activeFileSet.add("bmagenta");

        colorTable.put("bcyan", COLOR_BCYAN);
        activeScreenSet.add("bcyan");
        activeFileSet.add("bcyan");

        colorTable.put("bwhite", COLOR_BWHITE);
        activeScreenSet.add("bwhite");
        activeFileSet.add("bwhite");
    }    


    public static void enableFileOutput(String filename)
	throws java.io.FileNotFoundException, Exception
    {
	// create directories as needed
	Util.mkdir((new File(filename)).getParent());
	fileOut = new PrintStream(new FileOutputStream(filename, true));
    }


    private static void setColor(String prefix)
    {
	if (enableColorPrint) {
	    if (prefix != null && colorTable.containsKey(prefix))
		System.err.print(colorTable.get(prefix));
	    else System.err.print(colorTable.get("*"));
	}
    }

    private static void resetColor()
    {
	if (enableColorPrint) System.err.print(COLOR_NORMAL);
    }


    private static String getCallingClass()
    {
	if (getStackTrace() == null) {
	    System.err.println("WTF!!!!");
	    System.exit(-1);
	}

	java.util.StringTokenizer st = 
            new java.util.StringTokenizer(getStackTrace(), "\n");
	st.nextToken();
	String classname = null;
	do {
	    classname = st.nextToken();
	    classname = classname.substring(classname.indexOf("at ")+3,
					    classname.lastIndexOf("("));
	    classname = classname.substring(0, classname.lastIndexOf("."));
	}
	while (classname.equals("lasr.util.Debug") && st.hasMoreTokens());
	if (classname != null && !classname.equals("lasr.util.Debug")) {
	    classname = classname.substring(0, classname.lastIndexOf("."));
	    return classname;
	}
	else return null;
    }

    /**
     * Exiting with an error exception.
     **/
    public synchronized static void exit(Exception e)
    {
	Debug.println("error", Thread.currentThread().getName() + 
		      ": Program exit, uncaught exception");
	activeScreenSet.add("*");
	Debug.println("error", e);
        Debug.println("error", "Sleeping " + 
                      (EXIT_ERROR_SLEEP/1000) + " second(s) " +
                      "before exiting.");
        fileOut.flush();
        fileOut.close();
        Util.sleep(EXIT_ERROR_SLEEP);
	System.exit(-1);
    }

    /**
     * Exiting with a status code.
     **/
    public synchronized static void exit(int status)
    {
	Debug.println("error", Thread.currentThread().getName() + 
		      ": Program exit, status code = " + status);
        if (status != 0) {
            activeScreenSet.add("*");
            Debug.printStackTrace("error");
            Debug.println("error", "Sleeping " + 
                          (EXIT_ERROR_SLEEP/1000) + " second(s) " +
                          "before exiting.");
            fileOut.flush();
            fileOut.close();
            Util.sleep(EXIT_ERROR_SLEEP);
        }
        System.exit(status);
    }

    /**
     * Exiting with a string message and status code.
     **/
    public synchronized static void exit(String msg, int status)
    {
	Debug.println("error", Thread.currentThread().getName() + 
		      ": Program exit, reason: " + msg);
        if (status != 0) {
            activeScreenSet.add("*");
            printStackTrace();
            Debug.println("error", "Sleeping " + 
                          (EXIT_ERROR_SLEEP/1000) + " second(s) " +
                          "before exiting.");
            fileOut.flush();
            fileOut.close();
            Util.sleep(EXIT_ERROR_SLEEP);
        }
	System.exit(status);
    }

    /**
     * Exiting with a string message, assuming error.
     **/
    public synchronized static void exit(String msg) { exit(msg, -1); }


    /**
     * Prints a stack trace.
     **/
    public synchronized static void printStackTrace()
    {
        printStackTrace(getCallingClass());
    }
    public synchronized static void printStackTrace(String mode)
    {
	if (!enablePrint) return;
        Debug.println(mode, getStackTrace());
    }


    /**
     * Returns a stack trace.
     **/
    public synchronized static String getStackTrace()
    {
	return getStackTrace(new StackTrace());
    }

    public synchronized static String getStackTrace(Exception e)
    {
	Writer sw = new StringWriter();
	PrintWriter pw = new PrintWriter(sw);
	e.printStackTrace(pw);
	return sw.toString();
    }


    /**
     * Prints a line with the thread's name.
     **/
    public synchronized static void println(String mode, String s)
    {
	// create string to print
	String strToPrint;
	if (enableTimeThreadStamp) 
	    strToPrint = "[" + Thread.currentThread().getName() + "," +
		(Util.getTime() - baseTimestamp) + "] " + s;
	else strToPrint = s;

	// check whether we should print text out to stderr
        if (enablePrint && (activeScreenSet.contains(mode) || 
			    activeScreenSet.contains("*")))
	{
	    setColor(mode);
	    System.err.print(strToPrint);
	    resetColor();
	    System.err.println("");
        }

	// Check whether we should write text to file.
	// Note that at the moment, we write EVERYTHING to
	// file, even if its mode is disabled.
	// Color is disabled because color is annoying in files.
	if (fileOut != null && (activeFileSet.contains(mode) ||
				activeFileSet.contains("*"))) 
	{
	    fileOut.println(strToPrint);
	}
    }

    public synchronized static void println(String s) 
    { println(getCallingClass(), s); }

    /**
     * For exceptions, just print the stack trace.
     **/
    public synchronized static void println(String mode, Exception e)
    {
	println(mode, getStackTrace(e));
    }
    public synchronized static void println(Exception e)
    {
        println(getCallingClass(), e);
    }

    /**
     * Prints an object with the thread's name.
     **/
    public synchronized static void println(String mode, Object o)
    {
	if (!enablePrint) return;
	println(mode, o.toString());
    }
    public synchronized static void println(Object o)
    {
        println(getCallingClass(), o);
    }

    /**
     * Prints an empty line.
     **/
    public synchronized static void println()
    {
	println("");
    }

    /**
     * Assert.
     **/
    public synchronized static void check(boolean cond, String s)
    {
	if (!cond) exit(s);
    }
}

/* used by exit() and printStackTrace() */
class Exiting extends Exception { }
class StackTrace extends Exception { }
