package code.lasr.util;

import java.util.Arrays;
import java.math.BigInteger;

public class Hash implements java.io.Serializable, Comparable
{
    protected byte[] m_hash;

    /**
     * This should not be used directly; call Util.getHash() instead.
     **/
    Hash(byte[] s) { m_hash = s; }

    /**
     * Good ol' copy constructor.
     **/
    public Hash(Hash h) 
    {
	m_hash = new byte[h.m_hash.length];
	System.arraycopy(h.m_hash, 0, m_hash, 0, h.m_hash.length);
    }

    public boolean equals(Object o){
	boolean res = false;
	if (o instanceof Hash)
	    res= Arrays.equals(m_hash,((Hash)o).m_hash);
	return res;
    }

    public int hashCode(){
	return toString().hashCode();
    }

    public String toString() {
	return new BigInteger(m_hash).toString(16);
    }

    public int compareTo(Object o) {
	return hashCode()-o.hashCode();
    }
}
