package code.lasr.util;

import java.util.*;

public class TwoWayMap
{
    private HashMap normalMap = new HashMap();
    private HashMap inverseMap = new HashMap();

    public void put(Object key, Object val)
    {
        normalMap.put(key, val);
        inverseMap.put(val, key);
    }

    public Object get(Object key) { return getKey(key); }
    public Object getKey(Object key)
    {
        return normalMap.get(key);
    }
    
    public Object getValue(Object val)
    {
        return inverseMap.get(val);
    }

    public Object remove(Object key) { return removeKey(key); }
    public Object removeKey(Object key)
    {
        Object val = normalMap.remove(key);
        return inverseMap.remove(val);
    }

    public Object removeValue(Object val)
    {
        Object key = inverseMap.remove(val);
        return normalMap.remove(key);
    }

    public Set keySet()
    {
        return normalMap.keySet();
    }
}