#!/bin/bash

if [ "$OS" = "Windows_NT" ]; then
  SERVER_BIN=code.ntnfs
else
  SERVER_BIN=code.unixnfs
  JAVA_PATH=/usr/bin
 # Note: using jrocket path
 #JAVA_PATH=/home/nalini/jrockit-R27.4.0-jdk1.6.0_02/jre/bin
fi


# Use PRACTI
kill `ps aux | grep -v grep | grep rmiregistry | awk '{print $2;}'`
sleep 2
pushd classes
rmiregistry &
popd

##
## by default, the nfs.java will start the portmap.
## if set "-p" after unixnfs, it will not run the portmap thread.
## 
## Note: in mac,
## if rpcinfo -p :
##   rpcinfo: can't contact portmapper: RPC: remote system error - Connection refused
##
## this means that we need explicitly start the native mac portmap before start the server.
## to do that, just enter the following command:
## sudo launchctl start com.apple.portmap
##

#${JAVA_PATH}/java -Xmx128m -agentlib:hprof -Xdebug -Xrunjdwp:transport=dt_socket,address=8000,server=y,suspend=n -classpath classes:je-1.7.1/lib/je.jar -esa -ea unixnfs -p practi test/pfs.config 1 true true 2>&1 | tee out

#CPU profiling
#${JAVA_PATH}/java -agentlib:hprof=heap=all,cpu=samples,thread=y,depth=9 -Xdebug -Xrunjdwp:transport=dt_socket,address=8000,server=y,suspend=n -classpath classes:je-1.7.1/lib/je.jar -esa -ea unixnfs -p practi test/pfs.config 1 true true 2>&1 | tee out

if [ "$OS" = "Windows_NT" ]; then
  java -classpath .\;classes\;je-1.7.1/lib/je.jar ${SERVER_BIN} -p practi test/pfs.config 1 true true 
else
  ${JAVA_PATH}/java -Xms256M -Xmx256M -classpath .:classes:je-3.2.23/lib/je-3.2.23.jar ${SERVER_BIN} -p practi test/pfs.config 1 true true
fi


#
# MDD: For Windows-XP, the following works
# (1) Install SFU (services for unix)
# install the NFS client and user mapping service.
# (I told it to use a new dummy password and group file in c:/SFS/passwd
# and c:/SFS/group. And I added mappings from my account (dahlin)
# in XP to nobody 1000 in c:/SFS/passwd)
# 
# (2) tell SFU to use NFS V2
#    Note: NFS Version 2: If you are using NFS version 2 then you will
#    have to disable version 3 support in SFU otherwise it will not
#    mount. To do this open regedit and navigate to
#    "HKEY_LOCAL_MACHINE\Software\Microsoft\Client for
#    NFS\CurrentVersion\Default". Add a new item of the "REG_DWORD" data
#    type named "DisableV3" with the value 1.
#
# (3) Run server
# rmiregistry &
# java -classpath ./classes\;je-1.7.1/lib/je.jar ntnfs -p practi test/pfs.config 1 true true
#
# (4) mount drive
# /cygdrive/c/SFU/common/mount.exe 127.0.0.1:/practidir Q:
#


#${JAVA_PATH}/java -server -Dcom.sun.management.jmxremote -Dcom.sun.management.jmxremote.authenticate=false -Dcom.sun.management.jmxremote.ssl=false -agentlib:hprof=heap=all,cpu=samples,thread=y -Xdebug -Xrunjdwp:transport=dt_socket,address=8000,server=y,suspend=n -classpath classes:je-1.7.1/lib/je.jar -esa -ea unixnfs -p practi test/pfs.config 0 true true 2>&1 | tee out

# Use ramdisk (for debugging)
#${JAVA_PATH}/java -classpath classes:../classes:../NFSlib2/classes -esa -ea unixnfs -p ramdisk test/pfs.config 0 2>&1 | tee out

