package code.security;
import java.io.*;
import java.security.*;

import code.simulator.Obj2Bytes;

/**
 * Reside in an InvalListItem and used to calculate a summary hash
**/
public class ChainingHash {
  private byte [] digest;

  public ChainingHash(ChainingHash previousHash, Obj2Bytes spi){
    ByteArrayOutputStream buffer = new ByteArrayOutputStream(40);

    assert(spi != null);

    try {
      MessageDigest md = MessageDigest.getInstance("SHA");
      if(previousHash != null)
        buffer.write(previousHash.getHashVal());
      buffer.write(md.digest(spi.obj2Bytes()));
      this.digest = md.digest(buffer.toByteArray());
    } catch (Exception e){
      System.out.println(e.toString());
      e.printStackTrace();
      System.exit(1);
    }
  }

  public byte[] getHashVal(){
    return this.digest;
  }

  public boolean equals(Object o){
    if(o instanceof DataHash && MessageDigest.isEqual(this.digest, ((DataHash)o).getHashVal()))
      return true;
    return false;
  }
}