package code.security;

import java.io.EOFException;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeSet;
import java.util.Vector;

import code.HierInvalTarget;
import code.InvalTarget;
import code.AcceptStamp;
import code.AcceptVV;
import code.BodyMsg;
import code.CatchupStreamStartMsg;
import code.ConnectionState;
import code.CounterVV;
import code.GeneralInv;
import code.ImpreciseInv;
import code.LatencyWatcher;
import code.NoSuchEntryException;
import code.NodeId;
import code.ObjId;
import code.ObjInvalTarget;
import code.ObjNotFoundException;
import code.PreciseInv;
import code.ReadOfHoleException;
import code.ReadOfInvalidRangeException;
import code.SubscriptionSet;
import code.VV;
import code.VVIterator;
import code.security.ahs.*;
import code.security.holesync.filter.*;
import code.security.liveness.*;

class CheckpointFilter {

  SecurityFilter securityFilter;

  CheckpointFilter(SecurityFilter securityFilter)
  {
    this.securityFilter = securityFilter;
  }

  boolean apply(SecureCheckpoint chkPt, NodeId sender, LinkedList<GeneralInv> giList){
    long start =0 , end =0;

    assert(SangminConfig.securityLevel > SangminConfig.NONE);
    //System.out.println("applySecureCheckpoint:" + securityFilter.getCurrentVV() + " \n " + chkPt);
    // first check the correctness of secure checkpoint
    // then update the lpVV based on the received information
    if(this.securityFilter.measureTime){
      start = System.currentTimeMillis();
    }
    if(!getMaxDVV(chkPt, sender)){
      return false;
    }else if(verifyAndApplyCheckpoint(chkPt, giList, sender)){
      AcceptVV startVV  = chkPt.getStartVV(); 
      //
      // No lock shoud be held before calling updateState 
      // Refer to OutgoingConnectionMailbox.newUpdate()
      if(this.securityFilter.measureTime){
        end = System.currentTimeMillis();
        LatencyWatcher.put("SecurityFilter.SecureCheckpointVerification", 
            (end - start));
        start = end;
      }

      // now we deal with the 2nd case: chkPt is splittable across curVV when chkPt.getEndVV() > curVV
      DependencyVV dvv = securityFilter.getSplitCVVBetweenStartAndEnd(chkPt.getStartVV(), chkPt.getEndVV(), securityFilter.getCurrentVV());
      if(SecurityFilter.dbg)System.out.println("case 2: ensuring verifiability of " + dvv + " startVV " + chkPt.getStartVV() + " endVV " + chkPt.getEndVV() + " cvv" + securityFilter.getCurrentVV());

      if(!securityFilter.getLivenessFilter().ensureCompatibility(dvv, securityFilter.getAhsMap(), sender)){
        assert false;
        return false;
      }

      if(this.securityFilter.measureTime){
        end = System.currentTimeMillis();
        LatencyWatcher.put("SecurityFilter.SecureCheckpointUpdateState", 
            (end - start));
      }
      return true;   
    }else{
      System.out.println("invalid checkpoint received: " + chkPt);
    }
    return false;
  }

  private boolean verifyAndApplyCheckpoint(SecureCheckpoint chkPt, LinkedList<GeneralInv> giList,  NodeId sender){
    boolean ret = true;
    AcceptVV initialVV = securityFilter.getCurrentVV();
    if(verifyCheckpoint(chkPt, giList, sender, initialVV)){
      ret = true;    
    }else{
      ret = false;
      System.out.println("invalid checkpoint received: " + chkPt);
    }
    return ret;
  }

  boolean verifyCheckpoint(SecureCheckpoint chkPt, LinkedList<GeneralInv> giList,  NodeId sender, AcceptVV initialVV){
    long start=0,end=0,start2=0,end2=0;
    if(this.securityFilter.measureTime){
      start = System.currentTimeMillis();
    }
    if(this.securityFilter.measureTime){
      end = System.currentTimeMillis();

      LatencyWatcher.put("SecurityFilter.SecureCheckpointsecurityFilter.getAhsMap()Clone", 
          (end - start));

    }
    SplitManager.advance = true;

    AcceptVV currentVV = securityFilter.getCurrentVV();
    CounterVV cvv = new CounterVV(currentVV);

    //indicates the VV of the last precise update received by the corresponding writer
    //  HashMap<NodeId, AcceptVV> lastPreciseVVMap = new HashMap<NodeId, AcceptVV>();

    //stores the unverified IHs received for a given node
    HashMap<NodeId, Vector<IH>> newIHMap = new HashMap<NodeId, Vector<IH>>();

    // a temp variable for holding the DVV map
    DVVMap tempDVVMap;

    // stores the set of all IHs unverified IHs received since last precise invalidate by any node
    // useful for creating dummy imprecise invalidates for local state modification
    HashMap<NodeId, Vector<IH>> allIHs = new HashMap<NodeId, Vector<IH>>();

    ImpreciseInv ii = null;

    // initialize lastPreciseVVMap to the startVV of the checkpoint
    //  AcceptVV lastPreciseVV = cvv.cloneAcceptVV();
    //  for(VVIterator vvIterator = chkPt.getStartVV().getIterator(); vvIterator.hasMoreElements();){
    //  NodeId nId = vvIterator.getNext();
    //  lastPreciseVVMap.put(nId, lastPreciseVV);
    //  }

    //TODO: ensure that the updates are ordered in the ordered update list in the order of their endTS

    // process all the updates in the checkpoint
    for(Object o: chkPt.orderedUpdateList){
      if(o instanceof SecurePreciseInv){
        // process secure precise invalidate

        // apply a dummy imprecise inval to advance the cvv
        if(!allIHs.isEmpty()){
          // create the insecure imprecise invalidate
//          ii = this.securityFilter.impreciseInvFilter.getInsecureImpreciseInv(allIHs);
//          giList.add(ii);

          // advance the cvv to include the endVV of the insecure imprecise invalidate
          //cvv.advanceTimestamps(ii.getEndVV());
        }
        SecurePreciseInv spi = (SecurePreciseInv)o;

        if(!securityFilter.verifySignature(spi)){
          assert false;
          return false;
        }
        //    System.out.println("spi :" + spi);
        //    System.out.println("ii :" + ii);
        // also check if the hashes for the imprecise hashes received since last precise invalidate match or not
        // basically excluding components for DVV[spi], check all other components for the sh and the corresponding value
        // the following checks only take place if some updates received since last precise inval
        if(newIHMap.containsKey(spi.getCreator())){
          tempDVVMap = securityFilter.getMaxDVVMap(newIHMap.get(spi.getCreator()), spi.getCreator());
          tempDVVMap = tempDVVMap.mask(spi.getDVV()); // removes all DVV entries which are also present in the spi

          DependencyVV dvv = tempDVVMap.getDVV();
          // only send components that are older than currentVV
          for(VVIterator vvi = dvv.getIterator(); vvi.hasMoreElements();){
            NodeId nId = vvi.getNext();
            try{
              if(!currentVV.containsNodeId(nId) || currentVV.getStampByServer(nId) < dvv.getStampByServer(nId)){
                dvv.dropNode(nId);
              }
            }catch(NoSuchEntryException e){
              // TODO Auto-generated catch block
              e.printStackTrace();
              assert false;
            }
          }
          if(!securityFilter.getLivenessFilter().ensureVerifiability(dvv, securityFilter.getAhsMap(), sender))
          {
            assert false;
            return false;
          }
          //  System.out.println("tempDVVMap :" + tempDVVMap.getCounterDVV());

          //the remaining entries must be verified
          if(!tempDVVMap.isPresentInVV(cvv) || !tempDVVMap.verifyDVVMap(securityFilter.getAhsMap(), securityFilter.secureRMIClient, sender, securityFilter)){
            //System.out.println("### dvvMap component verification failed for checkpoint " + chkPt);
            //System.out.println("DVVMapMap :" + chkPt.getMaxDVVMap());
            assert false;
            return false;
          }
        }

        if(!securityFilter.getLivenessFilter().ensureVerifiability(spi.getDVV(), securityFilter.getAhsMap(), sender))
        {
          assert false;
          return false;
        }
        else 
          if(!securityFilter.preciseInvFilter.verifyPreciseInv(spi, new AcceptVV(cvv), sender)){
          assert false;
          return false;
        }else{
          if(this.securityFilter.measureTime){
            start2 = System.currentTimeMillis();
          }
          securityFilter.apply(spi, null);
          if(this.securityFilter.measureTime){
            end2 = System.currentTimeMillis();
            LatencyWatcher.put("SecurityFilter.applyInCheckpoint", 
                (end2 - start2));
          }

          // finally reset the state
          if(SangminConfig.attachBodyToCheckpoint){
            giList.add(((SecureBoundInval)spi).getBoundInval());
          } else {
            giList.add(spi);
          }
          allIHs.clear();
          newIHMap.remove(spi.getCreator());
          cvv.advanceTimestamps(spi.getAcceptStamp());
          //          lastPreciseVV = cvv.cloneAcceptVV(); // actually the entries used for calculating the DVVMap should exclude the lastPreciseVV
        }
      }else{
        //process NodeAHSTuple

        assert(o instanceof NodeAHSTuple);
        //simply apply the securityFilter.hashMap and return false if it fails

        NodeAHSTuple ihMap = (NodeAHSTuple)o;
        NodeId nodeId = ihMap.getNodeId();
        ii = this.securityFilter.impreciseInvFilter.getInsecureImpreciseInv(nodeId, ihMap.getAHS().getIHs());
        giList.add(ii);
        cvv.advanceTimestamps(ii.getEndVV());

        //System.out.println("ihMap : " + ihMap);

        // Apply ih tuples for this writer
        try{
          if(this.securityFilter.measureTime){
            start2 = System.currentTimeMillis();
          }
          securityFilter.getAhsMap().applyAHS(nodeId, ihMap.getAHS(), chkPt);
          if(this.securityFilter.measureTime){
            end2 = System.currentTimeMillis();
            LatencyWatcher.put("SecurityFilter.applyInCheckpoint", 
                (end2 - start2));
          }
        }catch(UnmatchingTreeNodeException e){
          e.printStackTrace();
          assert(false);
          //TODO: call controller
        }
        // put the ih tuples in the allIHs securityFilter.hashMap for creating imprecise invalidate
        Vector<IH> ihVector = ihMap.getAHS().getIHs();
        if(allIHs.containsKey(nodeId)){
          Vector<IH> v = allIHs.get(nodeId);
          v.addAll(ihVector);
        }else{
          allIHs.put(nodeId, (Vector<IH>)ihVector.clone());
        }

        // also put the tuples in each field in newIHMap. newIHMap is used for validating ih tuples on receiving precise invalidates
        if(newIHMap.containsKey(nodeId)){
          Vector<IH> v = newIHMap.get(nodeId);
          v.addAll(ihVector);
        }else{
          newIHMap.put(nodeId, (Vector<IH>)ihVector.clone());
        }

      }
    }

    if(!allIHs.isEmpty()){

      // princem: added the following
      for(NodeId nodeId: allIHs.keySet()){
        ii = this.securityFilter.impreciseInvFilter.getInsecureImpreciseInv(nodeId, allIHs.get(nodeId));
        giList.add(ii);
        cvv.advanceTimestamps(ii.getEndVV());
      }
      // create the insecure imprecise invalidate for the last set of uncovered IHs
//      ii = securityFilter.impreciseInvFilter.getInsecureImpreciseInv(allIHs);
//      giList.add(ii);
//      cvv.advanceTimestamps(ii.getEndVV());
    }
    // now check the last ih tuples

    Vector<IH> tempVec = null;
    for(NodeId nId: newIHMap.keySet()){
      tempVec = newIHMap.get(nId);
      if(!tempVec.isEmpty()){
        tempDVVMap = securityFilter.getMaxDVVMap(tempVec, nId);

        DependencyVV dvv = tempDVVMap.getDVV();
        // only send components that are older than currentVV
        for(VVIterator vvi = dvv.getIterator(); vvi.hasMoreElements();){
          NodeId n = vvi.getNext();
          try{
            if(!currentVV.containsNodeId(n) || currentVV.getStampByServer(n) < dvv.getStampByServer(n)){
              dvv.dropNode(n);
            }
          }catch(NoSuchEntryException e){
            // TODO Auto-generated catch block
            e.printStackTrace();
            assert false;
          }
        }
        if(!securityFilter.getLivenessFilter().ensureVerifiability(dvv, securityFilter.getAhsMap(), sender))
        {
          assert false;
          return false;
        }

        //the remaining entries must be verified
        if(!tempDVVMap.isPresentInVV(cvv) || !tempDVVMap.verifyDVVMap(securityFilter.getAhsMap(),securityFilter.secureRMIClient, sender, securityFilter)){
          System.out.println("### dvvMap component verification failed for " + nId );
          assert false;
          return false;
        }
      }
    }

    if(cvv.includes(chkPt.getEndVV())){
      return true;
    }else{
      System.out.println("checkpoint verification failed as cvv inclusion test failed" + cvv + " " + chkPt.getEndVV());
      assert false;
      return false;
    }

  }

////update LPVV state based on the received checkpoint. Assume that the checkpoint is correct.
////startVV denotes the inclusion startVV for the checkpoint based on our local logs

////No lock shoud be held before calling updateState 
////Refer to OutgoingConnectionMailbox.newUpdate()
//private void updateState(AcceptVV startVV, LinkedList<GeneralInv> giList, SecureCheckpoint chkPt, ConnectionState sic){
////create a CatchupStreamStartMsg and call apply GI for each update after converting these updates into a valid update
//AcceptVV cssmStartVV = securityFilter.getAhsMap().getPrceedingVV(chkPt.getStartVV());

//CatchupStreamStartMsg cssm = new CatchupStreamStartMsg(chkPt.ss, cssmStartVV);
////sic.applyCatchupStreamStartMsg(cssm);

//assert sic instanceof SecureIncomingInvalConnection;
//((SecureIncomingInvalConnection)sic).applyCheckpointCatchupStreamStartMsg(cssm, chkPt.getEndVV());
////apply the msgs from the checkpoint now
//for(GeneralInv gi: giList){
////System.out.println("applyCatchupGi called for " + gi);
//sic.applyInsecureGI(gi);
////((SecureIncomingInvalConnection)sic).applyInsecureGI(gi);
//}
//sic.applyCatchupStreamEndMsg(cssm);
//}

  /**
   * New checkpoint update func to update state based on a secure checkpoint
   * @param startVV
   * @param giList
   * @param chkPt
   * @param sic
   */
  void updateState(AcceptVV startVV, LinkedList<GeneralInv> giList, SecureCheckpoint chkPt, SecureConnectionState sic){
    sic.applySecureCheckpointUpdates(startVV, giList, chkPt);
  }

  /**
   * create an iterator from startVV to endVV (inclusive)
   * @param startVV
   * @param endVV
   * @return
   */
  Iterator<NodeTreeNodeTuple> allUpdatesIterator(AcceptVV startVV, AcceptVV endVV){
    SecureReverseTreeNodeIterator rii = new SecureReverseTreeNodeIterator(endVV, securityFilter.getAhsMap());

    LinkedList<NodeTreeNodeTuple> allUpdateList = new LinkedList<NodeTreeNodeTuple>();
    // the counter starts from endVV and goes till startVV
    CounterVV receivedMinVV = new CounterVV(endVV);
    // because we want to use the !includes check
    AcceptVV lastStartVV = AcceptVV.decrementAll(startVV);

    NodeTreeNodeTuple curInvFromLog = null;
    if(SecurityFilter.dbg){
      System.out.println("startVV : " + startVV + " endVV " + endVV);
    }

    // keep iterating until all entries covered or if the log is empty
    while(rii.hasPrev() && 
        !lastStartVV.includes(receivedMinVV)){
      curInvFromLog = rii.prev();
      receivedMinVV.setStampByServer(curInvFromLog.getNodeId(), curInvFromLog.getTreeNode().getStartTS());
      AcceptStamp as = new AcceptStamp(curInvFromLog.getTreeNode().getEndTS(),curInvFromLog.getNodeId());
      //princem: I also think the following checek should be removed to ensure a causally consistent checkpoint
      if(!lastStartVV.includes(as) && endVV.containsNodeId(as.getNodeId())){
        allUpdateList.addFirst(curInvFromLog);
      }else{
        if(SecurityFilter.dbg){
          System.out.println("rejecting : " + as);
          }
      }
    }

    ListIterator<NodeTreeNodeTuple> l = allUpdateList.listIterator();
    NodeTreeNodeTuple ntnt = null;
    if(l.hasNext()){
      ntnt = l.next();
    }
    while(l.hasNext()){
      NodeTreeNodeTuple ntnt2 = l.next();
      assert(ntnt.compareTo(ntnt2) < 0);
      ntnt = ntnt2;
    }


    //LinkedList<NodeTreeNodeTuple> allUpdateList2 = (LinkedList<NodeTreeNodeTuple>)allUpdateList.clone();
    //Collections.sort((List)allUpdateList2);
    //assert(allUpdateList.equals(allUpdateList2)):"original :" + allUpdateList + "\nsorted :" + allUpdateList2;

    //  Iterator<NodeTreeNodeTuple> testIter = allUpdateList.iterator();
    //  Iterator<NodeTreeNodeTuple> optiIter = this.makeSecureTreeNodeIterator(AcceptVV.decrementAll(startVV));
    //  while(testIter.hasNext()){
    //  assert optiIter.hasNext();
    //  NodeTreeNodeTuple testntnt = testIter.next();
    //  NodeTreeNodeTuple optintnt = optiIter.next();
    //  assert testntnt.equals(optintnt):"testIter:"+testntnt+" optiIter:" + optintnt;
    //  if(!testntnt.equals(optintnt)){
    //  System.out.println("testIter:"+testntnt+" optiIter:" + optintnt);
    //  }
    //  }

    //  assert !optiIter.hasNext():"This assertion may fail if concurrent threads are updating and reading from " +
    //  "the AHSMap (i.e. in realisitic settings). However, this must pass in single threaded system. " +
    //  "Comment it in multithreaded systems";
    if(SecurityFilter.dbg){
    System.out.println("allUpdatesiterator: " + allUpdateList);
    }
    return allUpdateList.iterator();
  }



  //TODO: princem: Can optimize by not using the SecureInMemLogIterator
  /** 
   *  getSecureCheckpoint() 
   *  startVV: inclusion startVV 
   *  endVV: inclusion endVV 
   **/ 
  SecureCheckpoint getSecureCheckpoint(AcceptVV startVV, 
      boolean withBody,
      AcceptVV endVV, 
/*      boolean includeAll,*/
      LivenessFilter lf, 
      Filter f){

    long startTime=0,endTime=0, startTime2=0, endTime2=0;

    if(this.securityFilter.measureTime){
      startTime = System.currentTimeMillis();
    }

//  assert endVV.includes(startVV):" startVV " + startVV + " endVV" + endVV;
    //System.out.println("startVV : " + startVV);  
    //System.out.println("endVV: " + endVV);  
    //assert !startVV.includes(endVV); // what is the right assertion here?
    //System.out.println("SubscriptionSet: " + ss);  
    SecureCheckpoint chkPt = new SecureCheckpoint(startVV, endVV, SubscriptionSet.makeEmptySet(), securityFilter.core.getMyNodeId());
    LinkedList<PreciseInv> lastUpdateList = getLastUpdateList(startVV, endVV/*, includeAll*/, lf, f);

//    if(securityFilter.core.getMyNodeId().equals(new NodeId(4))){
//      System.out.println("LastUpdateList: " + lastUpdateList);
//    }

    if(this.securityFilter.measureTime){
      endTime = System.currentTimeMillis();
      LatencyWatcher.put("SecurityFilter.getLastUpdateList", 
          (endTime - startTime));
    }

    if(SecurityFilter.dbg){
      System.out.println("lastUpdateList.toString()");   
      System.out.println(lastUpdateList.toString());   
    }
    /**
     * the decrement all is to provide the secureInMemLog with the exclusion VV
     */
    //SecureInMemLogIterator sii = this.makeSecureInMemLogIterator(AcceptVV.decrementAll(startVV));
    if(this.securityFilter.measureTime){
      startTime2 = System.currentTimeMillis();
    }
    Iterator<NodeTreeNodeTuple> sii = allUpdatesIterator(startVV, endVV);
    if(this.securityFilter.measureTime){
      endTime2 = System.currentTimeMillis();
      LatencyWatcher.put("SecurityFilter.allUpdatesIterator", 
          (endTime2 - startTime2));
    }
    /*
	     System.out.println("AllUpdatesIterator");   
	     while(sii.hasNext()){
	       System.out.println(sii.next().toString());
	     }
	     sii = this.allUpdatesIterator(startVV, endVV);
     */
    NodeTreeNodeTuple curNodeFromLog = null;

    PreciseInv curStopSignInv = null;
    AcceptStamp curStopSignInvAS = null;
    if(lastUpdateList.size() > 0){
      curStopSignInv = lastUpdateList.removeFirst();
      curStopSignInvAS = curStopSignInv.getAcceptStamp();
    }
    else{
      curStopSignInv = null;
    }
    CounterVV accuIIStartVV = new CounterVV(); // the startVV of the next accumulated II
    CounterVV accuIIEndVV = new CounterVV(); // the endVV of the next accumulated II
    CounterVV curVV = new CounterVV(); // the VV summarizing all the updates we have seen so far 
    CounterVV realStartVV = new CounterVV(); // the VV summarizing all the updates we have seen so far 

    while(sii.hasNext() && !(curVV.includes(endVV))){

      curNodeFromLog = sii.next();
      if(SecurityFilter.dbg){
        System.out.println("### CurrentStopSignInv : " + curStopSignInv);
        System.out.println("### CurrentNodeFromLog : " + curNodeFromLog);
      }
//      if(securityFilter.core.getMyNodeId().equals(new NodeId(4))){
//      System.out.println("### CurrentStopSignInv : " + curStopSignInv);
//      System.out.println("### CurrentNodeFromLog : " + curNodeFromLog);
//      }

      AcceptStamp as = new AcceptStamp(curNodeFromLog.getTreeNode().getEndTS(), curNodeFromLog.getNodeId());
      if(!realStartVV.containsNodeId(curNodeFromLog.getNodeId())){
        realStartVV.setStamp(new AcceptStamp(curNodeFromLog.getTreeNode().getStartTS(), curNodeFromLog.getNodeId()));
      }
      // the following is just trying to extract the accept stamp for the creator
      //curVV.advanceTimestamps(curNodeFromLog.getEndVV());
      curVV.advanceTimestamps(as);

      if(curStopSignInv != null &&
          curVV.includes(curStopSignInvAS)){
        // main algorithm
        //if(curStopSignInv instanceof DummyPreciseInv){
        // set the IH start and end ts fields appropriately
        //   accuIIStartVV.addMinVV(curNodeFromLog.getStartVV());
        //   accuIIEndVV.addMaxVV(curNodeFromLog.getEndVV());
        //add the AHS for the portion from accuIIStartVV[curNodeFromLog.getCreator]-accuIIEndVV[curNodeFromLog.getCreator]
        // reseet accuIIStartVV[creator], accuIIEndVV[creator]
        //}else{
        // precise inv
        //add the AHS for portion from accuIIStartVV[curNodeFromLog.getCreator]-accuIIEndVV[curNodeFromLog.getCreator]
        //reset accuIIStartVV[creator], accuIIEndVV[creator]
        // add the pi to the checkpoint
        //}

//        if(securityFilter.core.getMyNodeId().equals(new NodeId(4))){
//          System.out.println("found split point: " + curStopSignInv);
//        }

        // set the IH start and end ts fields appropriately
        if(curStopSignInv instanceof DummyPreciseInv){
          //	accuIIStartVV.addMinVV(curNodeFromLog.getStartVV());
          //	accuIIEndVV.addMaxVV(curNodeFromLog.getEndVV());
          accuIIStartVV.addMinAS(new AcceptStamp(curNodeFromLog.getTreeNode().getStartTS(), curNodeFromLog.getNodeId()));
          accuIIEndVV.addMaxAS(new AcceptStamp(curNodeFromLog.getTreeNode().getEndTS(), curNodeFromLog.getNodeId()));
        }

        NodeId nodeId = curStopSignInv.getNodeId();

        //send the IH tuples
        if(accuIIEndVV.getSize() != 0 && accuIIEndVV.containsNodeId(nodeId)){
          assert accuIIEndVV.includes(accuIIStartVV);


          try{
//            if(securityFilter.core.getMyNodeId().equals(new NodeId(4))){
//              System.out.println("taking care of split point: " + curStopSignInv + " " + accuIIEndVV + " " + accuIIStartVV);
//            }
            if(SecurityFilter.dbg){
              System.out.println("taking care of split point: " + curStopSignInv + " " + accuIIEndVV + " " + accuIIStartVV);
            }
            
            long start = accuIIStartVV.getStampByServer(nodeId);
            long end =  accuIIEndVV.getStampByServer(nodeId);
            assert curStopSignInv.getEnd() == curNodeFromLog.getTreeNode().getEndTS():curStopSignInv + " doesn't agree with " + curNodeFromLog;
            AHS ahs = securityFilter.getAhsMap().createAHS(nodeId, start, end);
            NodeAHSTuple accumulatedII = new NodeAHSTuple(nodeId, ahs);
            List<AHSEntry> ahsList = ahs.getSortedListOfEntries();
            assert ahsList.size() > 0:"ahslist of size 0 obtaied " + start + " " + end + " " + nodeId;
            assert ahsList.get(0).getStartTS() == start && ahsList.get(ahsList.size() - 1).getEndTS() == end:ahsList + 
            " doesn't agree with " + start + " "+ end+ " "+ nodeId;
            chkPt.addUpdate(accumulatedII);

            accuIIStartVV.dropNode(nodeId);
            accuIIEndVV.dropNode(nodeId);
          }catch(NoSuchEntryException e){
            assert false;
          }

        }else{
//          if(securityFilter.core.getMyNodeId().equals(new NodeId(4))){
//            System.out.println("strange condition: found split point: " + curStopSignInv + " " + accuIIEndVV + " " + accuIIStartVV);
//          }
          // can only happen when no other updates received between two consecutive precise invalidates
          assert curStopSignInv instanceof SecurePreciseInv: curStopSignInv;

        }
        //add the split point if its not a dummy update (in other words if it is a precise update)
        if(curStopSignInv != null && !(curStopSignInv instanceof DummyPreciseInv)){
          if(SangminConfig.attachBodyToCheckpoint){
            BodyMsg bodyMsg = null;
            try{
              bodyMsg =
                securityFilter.core.read(curStopSignInv.getObjId(),
                  curStopSignInv.getOffset(),
                  curStopSignInv.getLength(),
                  false, false, false, 3000);
            }catch(EOFException e){
              e.printStackTrace();
              assert(false);
            }catch(ObjNotFoundException e){
              e.printStackTrace();
              assert(false);
            }catch(IOException e){
              e.printStackTrace();
              assert(false);
            }catch(ReadOfInvalidRangeException e){
              e.printStackTrace();
              assert(false);
            }catch(ReadOfHoleException e){
              e.printStackTrace();
              assert(false);
            }

            curStopSignInv =
              new SecureBoundInval((SecurePreciseInv) curStopSignInv,
                  bodyMsg.getBody());
          }          
          
          chkPt.addUpdate(curStopSignInv);
        }

        if(lastUpdateList.size() > 0){
          curStopSignInv = lastUpdateList.removeFirst();
          curStopSignInvAS = curStopSignInv.getAcceptStamp();
        }
        else{
          curStopSignInv = null;
        }
      }else{
        //	accuIIStartVV.addMinVV(curNodeFromLog.getStartVV());
        //	accuIIEndVV.addMaxVV(curNodeFromLog.getEndVV());
        accuIIStartVV.addMinAS(new AcceptStamp(curNodeFromLog.getTreeNode().getStartTS(), curNodeFromLog.getNodeId()));
        accuIIEndVV.addMaxAS(new AcceptStamp(curNodeFromLog.getTreeNode().getEndTS(), curNodeFromLog.getNodeId()));
      }

    }

    if(accuIIEndVV.getSize() != 0){
      Vector<NodeAHSTuple> accumulatedII = securityFilter.getAhsMap().generateAHS(accuIIStartVV, accuIIEndVV);
      for(NodeAHSTuple t: accumulatedII){
        chkPt.addUpdate(t);
      }
    }

    AcceptVV acceptCurVV = new AcceptVV(curVV);

    if(!chkPt.getStartVV().includes(startVV)){
      System.out.println("Excess data: required " + startVV + " present " + chkPt.getStartVV());
    }
    if(SecurityFilter.dbg){
      System.out.println("startVV : "  +startVV.dropNegatives() + " endVV " + endVV.dropNegatives() + "realStartVV " + realStartVV + " acceptCurVV " + acceptCurVV.dropNegatives()  + 
        " chkPt: startVV " + chkPt.getStartVV().dropNegatives() + " endVV " +chkPt.getEndVV().dropNegatives());
      System.out.println("checkpoint: " + chkPt);
    }
    assert acceptCurVV.equalsIgnoreNegatives(chkPt.getEndVV()): "AcceptCurVV: " + acceptCurVV + " endVV " + chkPt.getEndVV() + " chkPt " + chkPt;
    assert acceptCurVV.includes(endVV): "acceptCurVV: "  +acceptCurVV + " endVV " + endVV + " chkPt " + chkPt;
    assert realStartVV.equals(chkPt.getStartVV()): " realStartVV " + realStartVV + " startVV " + chkPt.getStartVV();
    //AcceptVV relevantVV = AcceptVV.decrementAll(acceptCurVV.getRealDiff(startVV)).dropNegatives();

    // chkPt.setEndVV(acceptCurVV.project(relevantVV));
    //chkPt.setStartVV(startVV.project(relevantVV));

    //princem: need to fix these
    //chkPt.setEndVV(acceptCurVV);
    //chkPt.setStartVV(new AcceptVV(realStartVV));

    assert (!chkPt.getStartVV().includes(chkPt.getEndVV()) || chkPt.getStartVV().equalsIgnoreNegatives(chkPt.getEndVV())): "startVV"+chkPt.getStartVV()+" "+chkPt.getEndVV() ;
    assert chkPt.getEndVV().includes(chkPt.getStartVV());
    assert securityFilter.getCurrentVV().includes(chkPt.getEndVV()):"can't create checkpoint beyond my cvv" + securityFilter.getCurrentVV() + " " + chkPt.getEndVV();

    if(this.securityFilter.measureTime){
      endTime = System.currentTimeMillis();
      LatencyWatcher.put("SecurityFilter.SecureCheckpointCreation", 
          (endTime - startTime));
    }

    return chkPt;
  }

  
  
  /**
   * Merge precise invalidtes present in ret and the split stamps under the constraint that nothing older than exclusionVV should 
   * be included
   * @param ret
   * @param splitStamps
   * @param exclusionVV
   * @return
   */
  LinkedList<PreciseInv> merge(LinkedList<PreciseInv> ret, TreeSet<PreciseInv> splitStamps, AcceptVV exclusionVV){
    Iterator<PreciseInv> splitIter = splitStamps.iterator();
    Iterator<PreciseInv> preciseIter = ret.iterator();
    LinkedList<PreciseInv> returnSplitPoints = new LinkedList<PreciseInv>();
    PreciseInv curSplit = null;
    PreciseInv curPreciseInv = null;

    // initialize curSplit
    if(splitIter.hasNext()){
      curSplit = splitIter.next();
    }

    //advance until curSplit > exclusionVV: basically throwing away stuff that we don't need
    while(curSplit != null && exclusionVV.includes(curSplit.getAcceptStamp())){
      if(splitIter.hasNext()){
        curSplit = splitIter.next();
      }else{
        curSplit = null;
      }
    }

    if(preciseIter.hasNext()){
      curPreciseInv = preciseIter.next();
      assert !(exclusionVV.includes(curPreciseInv.getAcceptStamp()));
    }

    while(curSplit != null && curPreciseInv != null){
      int comp = curSplit.compareTo(curPreciseInv);
      if(comp < 0){
        returnSplitPoints.add(curSplit);
        if(splitIter.hasNext()){
          curSplit = splitIter.next();
        }else{
          curSplit = null;
        }
      }else{
        returnSplitPoints.add(curPreciseInv);
        if(preciseIter.hasNext()){
          curPreciseInv = preciseIter.next();
        }else{
          curPreciseInv = null;
        }
        if(comp == 0){ // don't need to add splitpoints for ts covered by precise invalidates
          if(splitIter.hasNext()){
            curSplit = splitIter.next();
          }else{
            curSplit = null;
          }
        }
      }
    }

    while(splitIter.hasNext()){
      returnSplitPoints.add(curSplit);
      curSplit = splitIter.next();
    }

    if(curSplit != null){
      returnSplitPoints.add(curSplit);
    }

    while(preciseIter.hasNext()){
      returnSplitPoints.add(curPreciseInv);
      curPreciseInv = preciseIter.next();
    }

    if(curPreciseInv != null){
      returnSplitPoints.add(curPreciseInv);
    }
    LinkedList test = new LinkedList(returnSplitPoints);
    Collections.sort(test);
    assert test.equals(returnSplitPoints):"Sorted List: " + test + " merged one " + returnSplitPoints;
    return returnSplitPoints;
  }

  /**
   * Can this secureCheckpoint's dvv dependency be satisfied based on current state and potentially by 
   * fetching information from other nodes based on liveness policy?
   * @param secureCheckpoint
   * @param sender
   * @return
   */
  boolean getMaxDVV(SecureCheckpoint secureCheckpoint, NodeId sender){

    AcceptVV cvv = securityFilter.getCurrentVV();
    AcceptVV vv = cvv.cloneMaxVV(secureCheckpoint.getEndVV());
    VV startVV = secureCheckpoint.getStartVV();
    VVIterator vvi = secureCheckpoint.getEndVV().getIterator();
    /*
    HashMap<NodeId, DependencyVV> dvvMapMap = secureCheckpoint.getMaxDVVMap();
    //System.out.println("dvvMap: " + dvvMapMap);
    // For each writer in sii
    while(vvi.hasMoreElements()){
      Object token = vvi.getNext();
      NodeId nodeId = startVV.getServerByIteratorToken(token);
      DependencyVV maxDVV = dvvMapMap.get(nodeId);
      //verify each dvvMap component
      if(!vv.includes(maxDVV)){
        assert false;
        return false;
      }

      //check if the DVV is split for both 1) values included in imprecise inval and 
      // lcoal values. If not for local values, call rmiController
      // if not for included values. return false;
      AcceptVV borderStartVV = cvv;
      vvi = borderStartVV.getIterator();
      try{
        while(vvi.hasMoreElements()){
          nodeId = vvi.getNext();
          if(maxDVV.containsNodeId(nodeId)){
            if(borderStartVV.getStampByIteratorToken(nodeId) < maxDVV.getStampByServer(nodeId)){
              // princem: added the following check as I think this condition should not occur
              //assert false: "maxDVV " + maxDVV + " cvv " + cvv  + " nodeId " + nodeId + " \n " + secureCheckpoint;
              maxDVV.dropNode(nodeId);
            }
          }
        }
      }catch(NoSuchEntryException e){
        // TODO Auto-generated catch block
        e.printStackTrace();
        assert false;
      }

      // check if the maxDVV is split?
      // find tree node containing 


      System.out.println("ensuring verifiability of " + maxDVV);
      if(!securityFilter.getLivenessFilter()(maxDVV, sender)){
        assert false;
        return false;
      }

    }
     */
    // check if accepting this checkpoint implies that i am accepting concurrent overlapping updates 
    // that i can't verify to be from the same history: if yes, then try to break the existing updates/ or the 
    // checkpoint to ensure compatibility

    //approach: 4 possibilities for any nodeId component:
    // 1> startVV >= CVV: Do nothing
    // 2> startVV < CVV and endVV > CVV: ensure that the checkpoint is split across endVV or get a split secure ii
    // 3> endVV = CVV: do nothing
    // 4> CVV > endVV: ensure that current state is split across endVV
    // We deal with 4th case here and deal with the 2nd case after applying the checkpoint
    // so we need to find out all the VV entries where CVV > endVV

    DependencyVV dvv = securityFilter.getSplitEndVVBetweenStartAndCVV(secureCheckpoint.getStartVV(), 
        secureCheckpoint.getEndVV(), securityFilter.getCurrentVV());
    if(SecurityFilter.dbg)System.out.println("case 4: ensuring verifiability of " + dvv + " startVV " + 
        secureCheckpoint.getStartVV() + " endVV " + secureCheckpoint.getEndVV() + " cvv" + securityFilter.getCurrentVV());


    if(!securityFilter.getLivenessFilter().ensureCompatibility(dvv, securityFilter.getAhsMap(), sender)){
      assert false;
      return false;
    }


    //System.out.println("returning true");
    return true;
  }

  /**
   * returns a list of last updates and all the split points in that range
   * the split points are the set of points which must NOT be included in an imprecise invalidate 
   * as validation of some precise or imprecise invalidate depends on those points being split
   * For a range of uniwrites ihs, split points can be calculated by getting a maxDVV/writer's component over that range. 
   * @param startVV inclusion
   * @param ss
   * @param endVV inclusion
   * @return
   */
  LinkedList<PreciseInv> getLastUpdateList(AcceptVV startVV,  
      SubscriptionSet ss, AcceptVV endVV){
    
    return getLastUpdateList(startVV, endVV/*, false*/, new BlockingLivenessFilter(), new SubscriptionSetFilter(ss));
  }

  
  //TODO:princem: this function can be highly optimized by embedding the maxDVV computation within the traversal by maintaining running maxDVVs
  /**
   * returns a list of last updates and all the split points in that range
   * the split points are the set of points which must NOT be included in an imprecise invalidate 
   * as validation of some precise or imprecise invalidate depends on those points being split
   * For a range of uniwrites ihs, split points can be calculated by getting a maxDVV/writer's component over that range.
   * Ensure that only the split points belonging to the nodes present in endVV are included 
   * @param startVV inclusion
   * @param ss
   * @param endVV inclusion
   * @return
   */
  LinkedList<PreciseInv> getLastUpdateList(AcceptVV startVV,  
      AcceptVV endVV/*, boolean includeAll*/, LivenessFilter lf, Filter f){

    try{
    assert securityFilter.getAhsMap().isConsistent();
    endVV = endVV.dropNegatives();
    startVV = startVV.dropNegatives();
    SecureReverseTreeNodeIterator rii = new SecureReverseTreeNodeIterator(endVV, securityFilter.getAhsMap());


    // the counter starts from endVV and goes till startVV
    CounterVV receivedMinVV = new CounterVV(endVV);
    // because we want to use the !includes check
    AcceptVV lastStartVV = AcceptVV.decrementAll(startVV).dropNegatives();
    // this hash map stores the last updates for each objects
    HashMap<ObjId, TreeNode> lastPreciseUpdates = new HashMap<ObjId, TreeNode>();

    // stores the precise invalidates to be returned
    LinkedList<PreciseInv> ret = new LinkedList<PreciseInv>();

    //sorted set to maintain the points of splits
    TreeSet<PreciseInv> splitStamps = new TreeSet<PreciseInv>();

    //princem: wondering if this should be initialized to empty?
    CounterVV nextIHPeriodEnvVV = new CounterVV(endVV); // the endVV of the next ih period for each writer
    CounterVV nextIHPeriodStartVV = new CounterVV(endVV); // the startVV of the next ih period for each writer
    AcceptVV maxDVV = null; 

    NodeTreeNodeTuple curInvFromLog = null;
    NodeId nId;
    ObjInvalTarget it = null;


    // keep iterating until all entries covered or if the log is empty
    while(rii.hasPrev() && 
        !lastStartVV.includes(receivedMinVV)){
      curInvFromLog = rii.prev();
      
      if(SecurityFilter.dbg){
        
        System.out.println("### receivedMinVV Before"+receivedMinVV);
        System.out.println("### curInvFromLog : "+ curInvFromLog);
      }
      receivedMinVV.setStampByServer(curInvFromLog.getNodeId(), curInvFromLog.getTreeNode().getStartTS());
      nId = curInvFromLog.getNodeId();


      // if the treenode we are considering is precise
      // and is useful for ss and  
      // we don;t already have an invalidate for this object
      if((curInvFromLog.getTreeNode().getInv() instanceof SecurePreciseInv) && 
        (!lf.isPresent((SecurePreciseInv)curInvFromLog.getTreeNode().getInv()) 
            //uncomment the following 3 lines to get the previous condition
//            ||
//            /*includeAll ||*/ 
//            (it = (ObjInvalTarget)curInvFromLog.getTreeNode().getInvalTarget()).intersects(ss) //&&
        )
    //!lastPreciseUpdates.containsKey(it.getObjId())) || 
    ){
//          ((it = (ObjInvalTarget)curInvFromLog.getTreeNode().getInvalTarget()).intersects(ss) &&
//              lf.shouldSummarize(curInvFromLog.getTreeNode().getInv().getEndVV()) &&
//          !lastPreciseUpdates.containsKey(it.getObjId())) || includeAll){

        it = (ObjInvalTarget)curInvFromLog.getTreeNode().getInvalTarget();
        
        assert curInvFromLog.getTreeNode().getLevel() == 0;
        // we found a precise inval for "it"
        // add it to the data structure indicating that it has been covered
        // also add it to the list of stuff to be sent/split
        lastPreciseUpdates.put(it.getObjId(), curInvFromLog.getTreeNode());
        PreciseInv inv = (PreciseInv)(curInvFromLog.getTreeNode().getInv());

        // princem: I think the following check should be removed if we want a causal stream
        if( !lastStartVV.includes(inv.getAcceptStamp()) ){
          if(SecurityFilter.dbg){
            System.out.println("~~~ Adding inv :"  + (SecurePreciseInv)inv);
          }
          ret.addFirst((PreciseInv)(curInvFromLog.getTreeNode().getInv()));
          
        //Basically, we are using newIHPeriodEndVV and nextIHPeriodStartVV as a HashMap with bit more versatile functionality
          // but the key value that it stores is that ih tuples range to aggregate for each node
          if(nextIHPeriodStartVV.containsNodeId(nId)){

            try{
              maxDVV = securityFilter.getMaxDVV(nId, nextIHPeriodStartVV.getStampByServer(nId), 
                  nextIHPeriodEnvVV.getStampByServer(nId));
              maxDVV = maxDVV.makeVVexcludeNode(nId);
            }catch(NoSuchEntryException e){
              // this should never happen
              assert false;
            }

            if(SecurityFilter.dbg){
            System.out.println("last IHPeriod Start : " + nextIHPeriodStartVV);
            System.out.println("last IHPeriod End : " + nextIHPeriodEnvVV);
            System.out.println("maxDVV : " + maxDVV);
            }

            // add the maxDVV to the split stamps to ensure verification
            Collection<AcceptStamp> allStamps = maxDVV.getAllStamps();
            for(AcceptStamp s: allStamps){
              if(!lastStartVV.includes(s) && endVV.containsNodeId(s.getNodeId())){
                //System.out.println("adding splitpoint : " + s);
                splitStamps.add(new DummyPreciseInv(s));
              }
            }

          }
          
          nextIHPeriodEnvVV.dropNode(nId);
          nextIHPeriodStartVV.dropNode(nId);

        }else{
//          System.out.println("*** lastStartVV:"+lastStartVV);
//          System.out.println("*** receivedMinVV After"+receivedMinVV);
//          System.out.println("*** Current inv from Log"+ curInvFromLog);
//          System.out.println("*** Current inv"+ inv);
//
//          System.out.println("*** ReverseTreeNodeIterator :");// + new SecureReverseTreeNodeIterator(endVV, securityFilter.getAhsMap()));
//          SecureReverseTreeNodeIterator ri = new SecureReverseTreeNodeIterator(endVV, securityFilter.getAhsMap());
//          while(ri.hasPrev()){
//            System.out.println("*** " + ri.prev());
//          }
//          assert false;
	
	    }
      }
      else{
//	  if(curInvFromLog.getTreeNode().getInv() instanceof SecurePreciseInv){
//	      PreciseInv inv = (PreciseInv)(curInvFromLog.getTreeNode().getInv());
//	      assert !(inv instanceof LivenessCertificate): inv + " combined certificate" + lf + " ss" + ss + " present in ss" + ((ObjInvalTarget)curInvFromLog.getTreeNode().getInvalTarget()).intersects(ss) ; 
//	      
//	  }else{
//	      InvalTarget nit = curInvFromLog.getTreeNode().getInvalTarget();
//	      HierInvalTarget hit = null;
//	      if(nit instanceof HierInvalTarget){
//		  hit = (HierInvalTarget)nit;
//	      }else{
//		  hit = HierInvalTarget.makeHierInvalTarget(((ObjInvalTarget)nit).getObjId().getPath());
//	      }
//	      //assert that it doesn't intersect receiver's ss
//	      if(!ss.getIntersection(hit).isEmpty()){
//		  System.out.println( "ss " + ss + " invalTarget " + hit + " curInvFromLog"  +curInvFromLog);
//	      }
//
//	  }
       
      } 
      AcceptStamp ass = new AcceptStamp(curInvFromLog.getTreeNode().getStartTS(), nId);
      AcceptStamp ase = new AcceptStamp(curInvFromLog.getTreeNode().getEndTS(), nId);
      nextIHPeriodEnvVV.addMaxAS(ase);
      // need to accumulate
      nextIHPeriodStartVV.addMinAS(ass);

    }

    //System.out.println("last IHPeriod Start : " + nextIHPeriodStartVV);
    //System.out.println("last IHPeriod End : " + nextIHPeriodEnvVV);

    // add the splits for the range[nextIHPeriodStartVV, nextIHPeriodEndVV]
//    if(securityFilter.core.getMyNodeId().equals(new NodeId(4))){
//      System.out.println("lastStartVV: " + lastStartVV  + " \n nextIHPeriodEndVV " + nextIHPeriodEnvVV + " nextIHPeriodStartVV " + nextIHPeriodStartVV );
//    }
    VVIterator vvi = endVV.getIterator();
    NodeId nodeId;
    while(vvi.hasMoreElements()){
      nodeId = vvi.getNext();
      if(nextIHPeriodEnvVV.containsNodeId(nodeId)){

        try{
          maxDVV = securityFilter.getMaxDVV(nodeId, nextIHPeriodStartVV.getStampByServer(nodeId), 
              nextIHPeriodEnvVV.getStampByServer(nodeId));
          maxDVV = maxDVV.makeVVexcludeNode(nodeId);
        }catch(NoSuchEntryException e){
          // this should never happen
          assert false;
        }
        // add the maxDVV to the split stamps to ensure verification
        Collection<AcceptStamp> allStamps = maxDVV.getAllStamps();
        for(AcceptStamp s: allStamps){
          if(!lastStartVV.includes(s) && endVV.containsNodeId(s.getNodeId())){
            if(SecurityFilter.dbg)System.out.println("adding splitpoint : " + s);
            splitStamps.add(new DummyPreciseInv(s));
          }
        }

        nextIHPeriodStartVV.dropNode(nodeId);
        nextIHPeriodEnvVV.dropNode(nodeId);
      }
    }

    assert nextIHPeriodStartVV.equalsIgnoreNegatives(AcceptVV.makeVVAllNegatives()): "nextIHPeriodStartVV" + nextIHPeriodStartVV + " nextIHPeriodEndVV " + nextIHPeriodEnvVV;
    assert nextIHPeriodEnvVV.equalsIgnoreNegatives(AcceptVV.makeVVAllNegatives()): "nextIHPeriodStartVV" + nextIHPeriodStartVV + " nextIHPeriodEndVV " + nextIHPeriodEnvVV;

    //finally we have all the split points and precise invals in splitStamps and ret
    // now we have to merge them ensuring that no value included in exclusionVV gets included
    // only splitStamps can have values smaller than exclusionVV
    AcceptVV exclusionVV = AcceptVV.decrementAll(startVV);

    /*
	     Iterator<PreciseInv> i = ret.iterator();
	     while( i.hasNext() ){
	       PreciseInv pi = i.next();
	       assert(pi instanceof SecurePreciseInv):pi;
	       SecurePreciseInv spi = (SecurePreciseInv)pi;

	       DependencyVV dvv = spi.getDVV();

	       Enumeration<NodeId> e = dvv.getEnumeratedNodes();
	       while(e.hasMoreElements()){
	         NodeId nodeId2 = e.nextElement();
	         AcceptStamp as = null;
	         try{
	           as = new AcceptStamp(dvv.getStampByServer(nodeId2), nodeId2);
	         }catch(NoSuchEntryException E){
	           assert(false):dvv + "\n**" + nodeId2;
	         }
	         if( !lastStartVV.includes(as) && endVV.includes(as)){
	           assert(splitStamps.contains(as)):"as : " + as +"\nsplitStamps:" + splitStamps;
	         }
	       }

	     }*/

    assert securityFilter.getAhsMap().isConsistent();
//    if(securityFilter.core.getMyNodeId().equals(new NodeId(4))){
//      System.out.println("ret: " + ret + " \n splitStamps " + splitStamps );
//    }
    return merge(ret, splitStamps, exclusionVV);
    }
    catch(Exception e){
      e.printStackTrace();
      assert false: e;
      return null;
    }
  }

}
