package code.security;

import java.util.*;

import code.*;
import code.security.ahs.NodeAHSTuple;
import code.security.holesync.Range;


public class CostPredicate{

  final AcceptVV lpvv;
  final AcceptVV curVV; 
  final Hashtable<NodeId, List<Range>> holes;
  
  public CostPredicate(AcceptVV lpvv, AcceptVV curVV, Hashtable<NodeId, List<Range>> holes){
    this.lpvv = lpvv;
    this.curVV = curVV;
    this.holes = holes;
  }
  
  public boolean includes(AcceptStamp as){
    if(!(curVV.includes(as))){
      return true;
    }else if(lpvv.includes(as)){
      return false;
    }else if(holes.containsKey(as.getNodeId())){
      for(Range r: holes.get(as.getNodeId())){
        if(r.contains(as.getLocalClock())){
          return true;
        }
      }
    }
    return false;

  }

  public boolean includes(AcceptStamp startTS, AcceptStamp endTS){
    if(!(curVV.includes(startTS))){
      return true;
    }else if(lpvv.includes(endTS)){
      return false;
    }else if(holes.containsKey(startTS.getNodeId())){
      for(Range range: holes.get(startTS.getNodeId())){
        Range r = new Range(startTS.getLocalClock(), endTS.getLocalClock());
        if(range.contains(r) && !r.contains(range)){
          return true;
        }
      }
    }
    return false;
  }
  
  public int size(){
    AcceptVV realDiff = AcceptVV.decrementAll(curVV.getRealDiff(lpvv)).dropNegatives();
    return curVV.getSize()*16+ realDiff.size()+holes.size()*(24);
  }
}
