package code.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;

import code.Config;

import de.flexiprovider.core.FlexiCoreProvider;


public class Crypto{

  final static boolean useFlexiCore = false;
  public static final int KeyLen = 1024;
  
  static{
    if(useFlexiCore){
      Security.addProvider(new FlexiCoreProvider());
      //Security.addProvider(new de.flexiprovider.core.FlexiCoreProvider());
    }
    System.out.println("All providers are added");
    
    sigList = Collections.synchronizedList(new LinkedList<Signature>()); 

  }
  
  public static Signature getSignature(){
    if(SangminConfig.useRSA){
      try{
        if(useFlexiCore){
          return Signature.getInstance(SangminConfig.RSAscheme,SangminConfig.RSAProvider);
        } else {
          return Signature.getInstance(SangminConfig.RSAscheme);
        }
      }catch(NoSuchAlgorithmException e1){
        e1.printStackTrace();
        System.exit(-1);
      }catch(NoSuchProviderException e1){
        e1.printStackTrace();
        System.exit(-1);
      }
    } else {
      try{
        return Signature.getInstance("DSA");
      }catch(NoSuchAlgorithmException e1){
        e1.printStackTrace();
        System.exit(-1);
      } 
    }
    return null;
//    Signature sig = null;
//    try{
//      sig = sigList.remove(0);
//    } catch(IndexOutOfBoundsException e){
//      if(SangminConfig.useRSA){
//        try{
//          if(useFlexiCore){
//            return Signature.getInstance(SangminConfig.RSAscheme,SangminConfig.RSAProvider);
//          } else {
//            return Signature.getInstance(SangminConfig.RSAscheme);
//          }
//        }catch(NoSuchAlgorithmException e1){
//          e1.printStackTrace();
//          System.exit(-1);
//        }catch(NoSuchProviderException e1){
//          e1.printStackTrace();
//          System.exit(-1);
//        }
//      } else {
//        try{
//          return Signature.getInstance("DSA");
//        }catch(NoSuchAlgorithmException e1){
//          e1.printStackTrace();
//          System.exit(-1);
//        } 
//      }
//    }
//    
//    return sig;
  }
  
  public static void returnSignature(Signature sig){
    
//    sigList.add(0, sig);
  }

  private static List<Signature> sigList;

  @SuppressWarnings("unchecked")
  public static void readKeys() throws IOException, ClassNotFoundException {
    if(SangminConfig.useRSA){
      File publicKeyFile;
      File privateKeyFile;
      System.out.println("Reading RSA keys");
      publicKeyFile = new File("RSAPublicKeys");
      privateKeyFile = new File("RSAPrivateKeys");
      // backward compatibility for the time we only used DSA
      if(!publicKeyFile.exists()){
        publicKeyFile = new File("publicKeys");
      }
      if(!privateKeyFile.exists()){
        privateKeyFile = new File("privateKeys");
      }

      FileInputStream istream = new FileInputStream(publicKeyFile);
      ObjectInputStream p = new ObjectInputStream(istream);
      Config.publicKeys = (Hashtable<Long, PublicKey>) p.readObject();
      p.close();
      istream.close();
      istream = new FileInputStream(privateKeyFile);
      p = new ObjectInputStream(istream);
      Config.privateKeys = (Hashtable<Long, PrivateKey>) p.readObject();
      p.close();
      istream.close();
//      System.out.println("Reading RSA keys");
//
//      Config.publicKeys = new Hashtable<Long,PublicKey>();
//      FileInputStream istream = new FileInputStream("RSAPublicKeys");
//      ObjectInputStream p = new ObjectInputStream(istream);
//      int size = p.readInt();
//      for(int i=0; i < size; i++){
//        Long id = p.readLong();
//        PublicKey pubKey = getPubKeyFromString((String)p.readObject());
//        Config.publicKeys.put(id, pubKey);
//      }
//      p.close();
//      istream.close();
//
//      Config.privateKeys = new Hashtable<Long,PrivateKey>();
//      istream = new FileInputStream("RSAPrivateKeys");
//      p = new ObjectInputStream(istream);
//      size = p.readInt();
//      for(int i=0; i < size; i++){
//        Long id = p.readLong();
//        PrivateKey privKey = getPrivKeyFromString((String)p.readObject());
//        Config.privateKeys.put(id, privKey);
//      }
//      p.close();
//      istream.close();
    }else{
      File publicKeyFile;
      File privateKeyFile;
      System.out.println("Reading DSA keys");
      publicKeyFile = new File("DSAPublicKeys");
      privateKeyFile = new File("DSAPrivateKeys");
      // backward compatibility for the time we only used DSA
      if(!publicKeyFile.exists()){
        publicKeyFile = new File("publicKeys");
      }
      if(!privateKeyFile.exists()){
        privateKeyFile = new File("privateKeys");
      }

      FileInputStream istream = new FileInputStream(publicKeyFile);
      ObjectInputStream p = new ObjectInputStream(istream);
      Config.publicKeys = (Hashtable<Long, PublicKey>) p.readObject();
      p.close();
      istream.close();
      istream = new FileInputStream(privateKeyFile);
      p = new ObjectInputStream(istream);
      Config.privateKeys = (Hashtable<Long, PrivateKey>) p.readObject();
      p.close();
      istream.close();
    }
  }

  // write Keys from Config.publicKeys and Config.privateKeys
  public static void writeKeys() throws IOException{

    if(SangminConfig.useRSA){
      FileOutputStream ostream = new FileOutputStream("RSAPublicKeys");
      ObjectOutputStream p = new ObjectOutputStream(ostream);
      p.writeObject(Config.publicKeys);
      p.close();
      ostream.close();
      ostream = new FileOutputStream("RSAPrivateKeys");
      p = new ObjectOutputStream(ostream);
      p.writeObject(Config.privateKeys);
      p.close();
      ostream.close();
//      int size= Config.publicKeys.size();
//      FileOutputStream ostream = new FileOutputStream("RSAPublicKeys");
//      ObjectOutputStream p = new ObjectOutputStream(ostream);
//      p.writeInt(size);
//      for(Long id : Config.publicKeys.keySet()){
//        p.writeLong(id);
//        p.writeObject(keyToString((RSAPublicKey)Config.publicKeys.get(id)));
//      }
//      p.close();
//      ostream.close();
//      
//      size = Config.privateKeys.size();
//      ostream = new FileOutputStream("RSAPrivateKeys");
//      p = new ObjectOutputStream(ostream);
//      p.writeInt(size);
//      for(Long id : Config.privateKeys.keySet()){
//        p.writeLong(id);
//        p.writeObject(keyToString((RSAPrivateKey)Config.privateKeys.get(id)));
//      }
//      p.close();
//      ostream.close();
      
    }else{
      // DSA
      FileOutputStream ostream = new FileOutputStream("DSAPublicKeys");
      ObjectOutputStream p = new ObjectOutputStream(ostream);
      p.writeObject(Config.publicKeys);
      p.close();
      ostream.close();
      ostream = new FileOutputStream("DSAPrivateKeys");
      p = new ObjectOutputStream(ostream);
      p.writeObject(Config.privateKeys);
      p.close();
      ostream.close();
    }
  }

  public static void generateKeys(int numKeys){
    Config.privateKeys = new Hashtable<Long, PrivateKey>();
    Config.publicKeys = new Hashtable<Long, PublicKey>();
    try{

      // key pair generator init
      KeyPairGenerator kpg = null;
      if(SangminConfig.useRSA){
        if(useFlexiCore){
          System.out.println("Creating key for RSA FlexiCore");
          kpg = KeyPairGenerator.getInstance("RSA", "FlexiCore");
        } else {
          System.out.println("Creating key for RSA");
          kpg = KeyPairGenerator.getInstance("RSA");
        }
        kpg.initialize(KeyLen);
      }else{
        System.out.println("Creating key for DSA");
        kpg = KeyPairGenerator.getInstance("DSA");
        kpg.initialize(KeyLen);
      }
      //SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
      

      // generate a public and private key pairs
      for(long i=0; i < numKeys; i++){
        KeyPair pair = kpg.generateKeyPair();
        PrivateKey priv = pair.getPrivate();
        PublicKey pub = pair.getPublic();

        Config.privateKeys.put(new Long(i), priv);
        Config.publicKeys.put(new Long(i), pub);
      }

    } catch (Exception e){
      System.err.println(e.toString());
      e.printStackTrace();
      System.exit(-1);
    }
  }

  private static String keyToString(RSAPublicKey rk) {
    String retString = null;
    String pubKeyModString = rk.getModulus().toString(16).toUpperCase();
    String pubKeyExpString = rk.getPublicExponent().toString(16).toUpperCase();
    retString = pubKeyModString + ":" + pubKeyExpString;
    return retString;
  }

  private static String keyToString(RSAPrivateKey rk) {
    String retString = null;
    String privKeyModString = rk.getModulus().toString(16).toUpperCase();
    String privKeyExpString = rk.getPrivateExponent().toString(16).toUpperCase();
    retString = privKeyModString + ":" + privKeyExpString;
    return retString;
  }

  /**
   * @param keyString A {@link String} object containing the hex representation of the base and exponent separated by a ":".
   * @return A {@link RSAPublicKey} object that can be used to verify signatures.
   */
  private static RSAPublicKey getPubKeyFromString(String keyString) {
    RSAPublicKey key = null;
    try {
      String[] splits = keyString.split(":");
      BigInteger mod = new BigInteger(splits[0], 16);
      BigInteger exp = new BigInteger(splits[1], 16);
      RSAPublicKeySpec pubKeySpec = new RSAPublicKeySpec(mod, exp);
      KeyFactory kf;
      if(useFlexiCore){
        kf = KeyFactory.getInstance("RSA", "FlexiCore");
      } else {
        kf = KeyFactory.getInstance("RSA");
      }
      key = (RSAPublicKey)kf.generatePublic(pubKeySpec);
    } catch (Exception e) {
      e.printStackTrace(System.err);
      System.exit(1);
    }
    return key;
  }

  /**
   * @param keyString A {@link String} object containing the hex representation of the base and exponent separated by a ":".
   * @return A {@link RSAPrivateKey} object that can be used to verify signatures.
   */
  private static RSAPrivateKey getPrivKeyFromString(String keyString) {
    RSAPrivateKey key = null;
    try {
      String[] splits = keyString.split(":");
      BigInteger mod = new BigInteger(splits[0], 16);
      BigInteger exp = new BigInteger(splits[1], 16);
      RSAPrivateKeySpec privKeySpec = new RSAPrivateKeySpec(mod, exp);
      KeyFactory kf;
      if(useFlexiCore){
        kf = KeyFactory.getInstance("RSA", "FlexiCore");
      } else {
        kf = KeyFactory.getInstance("RSA");
      }
//      KeyFactory kf = KeyFactory.getInstance("RSA", "FlexiCore");
      key = (RSAPrivateKey)kf.generatePrivate(privKeySpec);
    } catch (Exception e) {
      e.printStackTrace(System.err);
      System.exit(1);
    }
    return key;
  }

  private static void testKeys(int nKeyPairs) throws InvalidKeyException, SignatureException{
    String teststr = "this is a test string for digital signature!";
    Signature sig = null;
    for(int i=0; i < nKeyPairs; i++){
      byte [] signature;
      PublicKey pubKey = Config.publicKeys.get(new Long(i));
      PrivateKey privKey = Config.privateKeys.get(new Long(i));

      //        sig = Signature.getInstance(SangminConfig.RSAscheme,SangminConfig.RSAProvider);
      sig = getSignature();
      sig.initSign(privKey);
      sig.update(teststr.getBytes());
      signature = sig.sign();

      sig.initVerify(pubKey);
      sig.update(teststr.getBytes());
      if(!sig.verify(signature)){
        throw new InvalidKeyException("verification failed");
      }
      returnSignature(sig);
    }
    System.out.println("Test passed.");
  }

  public static void main(String[] argv){
    
    
    SangminConfig.useRSA = true;
//    useFlexiCore = false;
    int numKeys;
    try{
      numKeys = Integer.parseInt(argv[0]);
    }catch(Throwable e){
      numKeys=30;
    }
    
    generateKeys(numKeys);
    
    try{
      testKeys(numKeys);
      writeKeys();
      testKeys(numKeys);
      readKeys();
      testKeys(numKeys);
    } catch (IOException e) {
      System.err.println(e);
      e.printStackTrace();
      System.exit(-1);
    } catch (ClassNotFoundException e) {
      e.printStackTrace();
    } catch (InvalidKeyException e) {
      e.printStackTrace();
    } catch (SignatureException e) {
      e.printStackTrace();
    }
  }
}
