package code.security;
import code.Config;
import code.NodeId;
import code.ResultStats;

import java.io.*;
import java.security.*;
import java.util.Random;
import java.io.Serializable;


public class DataHash implements Serializable{
  private byte [] digest;

  public static byte[] getMD(byte[] data){
    try{
      MessageDigest md = MessageDigest.getInstance("SHA");
      return md.digest(data);
    }catch(Exception e){
      System.out.println(e.toString());
      e.printStackTrace();
      System.exit(1);
    }
    return null;
  }
  
  public DataHash(){
    digest = null;
  }
  
  public DataHash(byte[] data, boolean doHash){
    if(doHash){
      this.digest = getMD(data);

    }else{
      this.digest = data;
    }
  }


  public byte[] getHashVal(){
    return this.digest;
  }

  public void putHashVal(byte[] _digest){
	  this.digest = _digest;
    //assert(false);    
  }

  public boolean equals(Object o){
    if(o instanceof DataHash && MessageDigest.isEqual(this.digest, ((DataHash)o).getHashVal()))
      return true;
    return false;
  }
  
  public String toString(){
    return digest.toString();
  }
  
  public static void main(String[] argv){

    Config.readKeys();
    PrivateKey privKey = (PrivateKey)Config.privateKeys.get(new Long(1));
    PublicKey pubKey = (PublicKey)Config.publicKeys.get(new Long(1));

    byte[] buffer = new byte[]{0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19};
    byte[] digest;
    long start=0,end=0;
    ResultStats stats = new ResultStats();



    for(int i=0; i<1000; i++){
      byte[] b = new byte[150];

      Random r = new Random(System.currentTimeMillis());
      r.nextBytes(b);    

      try{
        start = System.currentTimeMillis();
        MessageDigest md = MessageDigest.getInstance("SHA");
        digest = md.digest(b);
        end = System.currentTimeMillis();
      }catch(Exception e){
        System.out.println(e.toString());
        System.out.println(e.getStackTrace());
        System.exit(-1);
      }

      stats.enter((double)end-start);
    }

    System.out.println("###### Data Hashing time");
    System.out.println(stats.getSummary(1));
    System.out.println(stats.getAverage90());
    
  }
}





