package code.security;

import java.security.PrivateKey;

import code.AcceptVV;
import code.Config;
import code.ImmutableBytes;
import code.LatencyWatcher;
import code.NoSuchEntryException;
import code.NodeId;
import code.PreciseInv;
import code.SummaryHash;
import code.VV;
import code.VVIterator;
import code.security.ahs.DVVMap;
import code.security.ahs.DependencyVV;
import code.security.ahs.TreeNode;
import code.security.ahs.AHSMap;

class PreciseInvFilter {

  SecurityFilter securityFilter;
  PreciseInvFilter(SecurityFilter securityFilter)
  {
    this.securityFilter = securityFilter;
  }

  boolean getMaxDVV(SecurePreciseInv si, NodeId sender){

    AcceptVV cvv = securityFilter.core.getCurrentVV();
    AcceptVV vv = cvv.cloneMaxVV(si.getEndVV());
    VV startVV = si.getStartVV();
    VVIterator vvi = startVV.getIterator();

    NodeId nodeId = si.getCreator();
    DependencyVV maxDVV = si.getDVV().clone();
    //verify each dvvMap component
    if(!vv.includes(maxDVV)){
      assert false;
      return false;
    }

    //check if the DVV is split for both 1) values included in imprecise inval and 
    // lcoal values. If not for local values, call rmiController
    // if not for included values. return false;
    AcceptVV borderStartVV = cvv;
    vvi = borderStartVV.getIterator();
    try{
      while(vvi.hasMoreElements()){
        nodeId = vvi.getNext();
        if(maxDVV.containsNodeId(nodeId)){
          if(borderStartVV.getStampByIteratorToken(nodeId) < maxDVV.getStampByServer(nodeId)){
            maxDVV.dropNode(nodeId);
          }
        }
      }
    }catch(NoSuchEntryException e){
      // TODO Auto-generated catch block
      e.printStackTrace();
      assert false;
    }

    // check if the maxDVV is split?
    // find tree node containing 

    if(!securityFilter.getLivenessFilter().ensureVerifiability(maxDVV, securityFilter.getAhsMap(), sender)){
      assert false;
      return false;
    }


    return true;
  }



  PreciseInv createPreciseInval(PreciseInv inv, ImmutableBytes buffer){
    PreciseInv ret = null;
    if(SangminConfig.securityLevel == SangminConfig.COMPLETE){
      securityFilter.setInteracted.add(inv.getNodeId());
      DependencyVV dvv = securityFilter.generateDVV();
      SummaryHash sh = securityFilter.getSummaryHash(dvv);
      DataHash dh = new DataHash(buffer.getCopyBytes(), true);

      VVIterator vvi = dvv.getIterator();
      long ts = inv.getAcceptStamp().getLocalClock();
      if(SecurityFilter.sanityCheck){
      while(vvi.hasMoreElements()){
        NodeId n = vvi.getNext();
        assert dvv.getStampByIteratorToken(n) <= ts: dvv + " ts " + ts;
      }}

      assert(Config.privateKeys.containsKey(new Long(securityFilter.core.getMyNodeId().getIDint())));
      ret = new SecurePreciseInv(
          inv, dvv,sh,dh,
          (PrivateKey)(Config.privateKeys.get(new Long(securityFilter.core.getMyNodeId().getIDint()))));
      securityFilter.setInteracted.clear();
      this.securityFilter.apply(ret, null);

      //securityFilter.getKnowledge().apply(ret);
    }else if(SangminConfig.securityLevel == SangminConfig.SIGNATURE){      
      DataHash dh = new DataHash(buffer.getCopyBytes(), true);

      ret = new SecurePreciseInv(
          inv,null,null,dh,
          (PrivateKey)(Config.privateKeys.get(new Long(securityFilter.core.getMyNodeId().getIDint()))));

    }else{
      ret = inv;
    }

    return ret;

  }


//PreciseInv createSecurePreciseInvalFromNonSecure(PreciseInv inv, ImmutableBytes buffer){
//PreciseInv ret = null;
//securityFilter.core.specialLock();

//if(SangminConfig.securityLevel == SangminConfig.COMPLETE){
//securityFilter.setInteracted.add(inv.getNodeId());
//DependencyVV dvv = securityFilter.generateDVV();
//SummaryHash sh = securityFilter.getSummaryHash(dvv);
//DataHash dh = new DataHash(buffer.getCopyBytes(), true);

//assert(Config.privateKeys.containsKey(new Long(securityFilter.core.getMyNodeId().getIDint())));
//ret = new SecurePreciseInv(
//inv, dvv,sh,dh,
//(PrivateKey)(Config.privateKeys.get(new Long(securityFilter.core.getMyNodeId().getIDint()))));
//securityFilter.setInteracted.clear();
//this.securityFilter.apply(ret, null);
//}else if(SangminConfig.securityLevel == SangminConfig.SIGNATURE){

//DataHash dh = new DataHash(buffer.getCopyBytes(), true);

//ret = new SecurePreciseInv(
//inv,null,null,dh,
//(PrivateKey)(Config.privateKeys.get(new Long(securityFilter.core.getMyNodeId().getIDint()))));

//}else{
//ret = inv;
//}

//securityFilter.core.specialUnlock();

//return ret;
//}

  public boolean verifyPreciseInv(SecurePreciseInv spi, AcceptVV cvv, NodeId sender){
    // a temp variable for holding the DVV map
    DVVMap tempDVVMap;

    if(SecurityFilter.dbg)System.out.println("verifyPreciseInv : " + spi);
    if(spi.isHasHash() && !securityFilter.verifySignature(spi)){
      assert false;
      return false;
    }
    //    System.out.println("spi :" + spi);
    //    System.out.println("ii :" + ii);
    // also check if the hashes for the imprecise hashes received since last precise invalidate match or not
    // basically excluding components for DVV[spi], check all other components for the sh and the corresponding value
    // the following checks only take place if some updates received since last precise inval


    DependencyVV dvv = null;
    try{
      if(spi.getDVV().containsNodeId(spi.getNodeId())){
        if(!securityFilter.getLivenessFilter().ensureVerifiability(spi.getDVV(), securityFilter.getAhsMap(), sender))
        {
          assert false;
          return false;
        }
        
        tempDVVMap = securityFilter.getNewMaxDVVMap(spi.getNodeId(), spi.getDVV().getStampByServer(spi.getNodeId()));
        tempDVVMap = tempDVVMap.mask(spi.getDVV()); // removes all DVV entries which are also present in the spi
        dvv = tempDVVMap.getDVV();
        if(!securityFilter.getLivenessFilter().ensureVerifiability(dvv, securityFilter.getAhsMap(), sender))
        {
          assert false;
          return false;
        }
      }else{
        dvv = new DependencyVV();
        tempDVVMap = new DVVMap();
      }
      
      if(SecurityFilter.dbg)System.out.println("tempDVVMap: " + tempDVVMap + " DVV " + dvv);

      //princem: also include the tempDVVMap components in the ensure verifiability
      
        //the remaining entries must be verified
        if(!tempDVVMap.isPresentInVV(cvv) || 
            !tempDVVMap.verifyDVVMap(securityFilter.getAhsMap(), securityFilter.secureRMIClient, sender, securityFilter)){
	    // System.out.println("### dvvMap component verification failed for checkpoint " + chkPt);
          //System.out.println("DVVMapMap :" + chkPt.getMaxDVVMap());
          assert false;
          return false;
        }
        else if(!verifyPreciseInv(spi, cvv)){
          assert false;
          return false;
        }
        //  System.out.println("tempDVVMap :" + tempDVVMap.getCounterDVV());

    }catch(NoSuchEntryException e1){
      // TODO Auto-generated catch block
      e1.printStackTrace();
    }

    return true;
  }

  /***
   * returns whether the secure precise inv spi is valid with respect to the receiver state if cvv is the current vv
   * ensures compatibility, inclusion 
   * function is idempotent except for the experimental instrumentation
   * @param spi
   * @param cvv
   * @return
   */
  private boolean verifyPreciseInv(SecurePreciseInv spi, VV cvv){

    //System.out.println("~~~~~~~~~~~~~~~~~~1");
    if(securityFilter.dbg){
      System.out.println("VERIFYING spi " +spi);
    }
    // Check DVV
    long start =0, end=0;
    if(this.securityFilter.measureTime){
      start = System.currentTimeMillis();	
    }
    if(!cvv.includes(spi.getDVV())){
      //TODO : call controller
      if(securityFilter.dbg){
        System.out.println("dvv not included -- SecurePreciseInv");
        System.out.println("Current VV: " + cvv);
        System.out.println("DVV: " + spi.getDVV());
        assert(false):spi;
      }

      return false;
    }

    long firstStart;
    if(SecurityFilter.measureTime){
      firstStart = System.currentTimeMillis();
    }

    try{

      //System.out.println("~~~~~~~~~~~~~~~~~~2");
      // Summary Hash Checking
      if(securityFilter.dbg){
        System.out.println("spi sh : " + spi.getSH());
        System.out.println("local sh : " + securityFilter.getSummaryHash(spi.getDVV()));
      }
      if( spi.isHasHash() && !spi.getSH().equals(securityFilter.getSummaryHash(spi.getDVV()))){
        //TODO : call controller      
        if(securityFilter.dbg){
          System.out.println("Unmatching summary hash -- SecurePreciseInv " + securityFilter.getSummaryHash(spi.getDVV()));
          System.out.println("Faked Assertion : " + spi);
          System.out.println(securityFilter.getAhsMap().toLongString());
          System.out.println(securityFilter.getAhsMap().toString());
          assert(false):spi;
        }
        return false;
        //return true;
      }
    }
    finally{
      if(SecurityFilter.measureTime){
        code.security.ahs.AHSMap.inclusionTime += (System.currentTimeMillis() - firstStart);
      }
    }
    //System.out.println("~~~~~~~~~~~~~~~~~~3");
    // DVV checking
    AHSMap ahsMap = securityFilter.getAhsMap();
    //System.out.println("~~~~~~~~~~~~~~~~~~4");
    TreeNode prev = ahsMap.getLastTreeNodePriorTo(spi.getNodeId(), spi.getStart());
    //System.out.println("~~~~~~~~~~~~~~~~~~5");
    if(prev != null && prev.getNext() != null){
      if( prev.getNext().getStartTS() != spi.getStart() ){
        if(securityFilter.dbg){
          System.out.println("Inconsistent DVV information -- SecurePreciseInv");
          System.out.println("Faked Assertion : " + spi);
          assert(false):spi;
        }        
        //TODO: call controller
        //return true;
        return false;
      }
    }

    // experiment related instrumentation
    securityFilter.numReceivedInv++;
    spi.increaseHops();
    SecurePreciseInv svvInv = securityFilter.hashMap.get(spi);
    if(svvInv != null){
      if(svvInv.getHops() > spi.getHops()){
        securityFilter.hashMap.put(spi, spi);
      }        
    }else{
      //System.out.println("Stats: msg Latency for " + spi + " : " + (System.currentTimeMillis() - spi.getReal()));
      securityFilter.hashMap.put(spi, spi);
    }

    //System.out.println("~~~~~~~~~~~~~~~~~~9");
    //System.out.println("$$verification passed!");

    if(this.securityFilter.measureTime){
      end = System.currentTimeMillis();
      LatencyWatcher.put("SecurityFilter.verifyPreciseInv(no signature verfication included)", 
          (end - start));
    }

    // instrumentation ends
    return true;
  }
}
