package code.security;

import java.io.File;
import java.util.Date;

import code.TimingStats;
import code.simulator.SyncRequest;

public class SangminConfig {
  public enum DebugLevel{Silent, Normal, Verbose}; 
  
  public static final int NONE = 0;
  public static final int SIGNEDVV = 2;
  public static final int SIGNATURE = 5;
  public static final int COMPLETE = 10;
//  public static int securityLevel = NONE;
  public static int securityLevel = COMPLETE;
  public static final boolean useAHS = true;
  public static final boolean executeTrace = true;
  public static final boolean analyzeTrace = true;

  public static boolean useRSA = true;
  public static String RSAscheme = "SHA256withRSA";
  public static String RSAProvider = "FlexiCore";
  public static TimingStats stat = new TimingStats(true);

  public static boolean disableSignatureVerfication = false;
  public static boolean attachBodyToCheckpoint = false;

  // how long in milliseconds for write throughput measurement
  public static boolean writeThroughPutMeasure = false;
  public static long writeThroughputExpDuration = 100000;

  public static boolean readThroughPutMeasure = false;
  public static long readThroughputExpRate = 100;

  public static final boolean printDebugHashes = false;
  public static final boolean securityFilterDebug = false;
  public static final boolean compressNodeId = false;
  public static final boolean sanityCheck = false;
  public static final boolean fast = true;
  public static boolean optimizeDVVMapHashes = true;
  public static boolean enableInconsistencyNotification = false;
  /**
   * useful to enable Sangmin's code in security code and the use of BranchID everywhere
   */
  public static final boolean forkjoin = true;

  /**
   * determines whether network communication is allowed to occur or not
   * if false, local communication, otherwise creates listener
   */
  public static final boolean useSimulator = false;

  /**
   * determines whether simulatorID is used or BranchID
   */
  public static boolean useSimulatorId = false;
  public static final boolean syncToDisk = true;
  public static final boolean separateBodies = true;

  public static final byte BodyConfig = //SyncRequest.CheckpointBodies|
  SyncRequest.UncommittedLastBodies;

  /**
   * determines which of the two sync code is used: only valid when simulating and 
   * sync function is called
   */
  public static final boolean useSync2 = true;

  /**
   * 
   */
  public static final boolean lastWriterWin = false;


  public static String configFile = "/tmp/iris_dbstorage";
  public static long BDBCacheSize = 1024L*1024L*100L;

  public static boolean usePersistentStore = true;

  public static boolean hackedHash = false;
  public static boolean hackedSignature = false;
  public static final boolean compressVV = false;
  public static final boolean tryOptimizedSync = true;
  public static final boolean enableSanityCheck = sanityCheck;
  public static final boolean useShortId = true;
  public static final boolean optimizeLength = true;
  public static final boolean enableOracle = false;
  public static final boolean useBufferedIO = true;
  public static final int IOBufferSize = 1024;
  public static final boolean useByteArraysForIO = false;
  
  public static boolean useHash = true;

  public static final String bodyAttachDir = "/iris/attachBody/";
  public static final String gcProposalDir = "/iris/gc/proposals/";
  public static boolean fineGrainedTracking = true;
  public static final int wanTimeout = 60000;
  public static final int lanTimeout = 10000;
  
  /**
   * should the value written be returned with the reply (for debugging)
   */
  public static final boolean echoWrittenObject = false;
  public static final DebugLevel debugLevel = DebugLevel.Normal;
  public static boolean hackedStore = false;
  public static long p2pModeTime = 30000;

}
