package code.security;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.security.PublicKey;
import java.util.Enumeration;

import code.AcceptStamp;
import code.BoundInval;
import code.Config;
import code.Core;
import code.ImmutableBytes;
import code.NodeId;
import code.ObjId;
import code.ObjInvalTarget;
import code.PreciseInv;
import code.SummaryHash;
import code.branchDetecting.BranchID;
import code.security.ahs.DependencyVV;

public class SecureBoundInval extends SecurePreciseInv{
  private final ImmutableBytes body;
  //private final double priority;
  //private final long maxBoundHops;
  
  public SecureBoundInval(){
    super();
    body = null;
  }
  
  public SecureBoundInval(SecurePreciseInv spi, ImmutableBytes buffer){
    super(spi.getObjInvalTarget(),spi.getAcceptStamp(),spi.getRTAcceptStamp(),
    		spi.isEmbargoed(), spi.dvv, spi.sh, spi.dh, spi.signature);
    this.body = buffer;
    //this.priority = Core.DEFAULT_PRIORITY;
  }
  
  public BoundInval getBoundInval(){
    return new BoundInval(this.getObjInvalTarget(),
        this.acceptStamp, body, Core.DEFAULT_PRIORITY);
  }
  
  public void writeExternal(ObjectOutput out) throws IOException{
    assert(this.verify((PublicKey)Config.publicKeys.get(new Long(this.getCreator().getIDint())))) : "writeExternal" + this;
    //out.write(this.obj2Bytes());
    out.writeObject(this.getObjId().getPath());
    out.writeLong(this.getOffset());
    out.writeLong(this.getLength());
    out.writeLong(this.getAcceptStamp().getLocalClock());
    if(SangminConfig.forkjoin){
      out.writeObject(this.getAcceptStamp().getNodeId()); 
    } else {
      out.writeLong(this.getAcceptStamp().getNodeId().getIDint());
    }

    // realtime AcceptStamp & embargoed flag for tact/embargoed write
    out.writeLong(this.getRTAcceptStamp().getLocalClock());
    out.writeBoolean(this.isEmbargoed());

    // security components
    if(SangminConfig.securityLevel >= SangminConfig.COMPLETE){
      out.writeInt(dvv.getSize());
      for( Enumeration<NodeId> enu = dvv.getEnumeratedNodes(); enu.hasMoreElements();){
        try{
          NodeId nodeId = (NodeId)enu.nextElement();
          if(SangminConfig.forkjoin){
            out.writeObject(nodeId);
          } else {
            out.writeLong(nodeId.getIDint());
          }
          out.writeLong(dvv.getStampByServer(nodeId));                               
        }catch(Exception e){
          e.printStackTrace();
          System.exit(-1);
        }
      }

      assert(sh.getValue().length == 20);
      out.write(sh.getValue());
    }
    assert(dh.getHashVal().length == 20);
    out.write(dh.getHashVal());
    out.writeInt(signature.length);
    out.write(signature);
    
    out.writeInt(hops);
    
    out.writeInt(body.getLength());
    out.write(body.dangerousGetReferenceToInternalByteArray(),
        0,body.getLength());

  }
  
  protected void readExternalHelper(ObjectInput in)
  throws IOException, ClassNotFoundException{
    String objIdString = (String)(in.readObject());
    long  offset = in.readLong();
    long  length = in.readLong();
    long  localClock = in.readLong();
    NodeId nId;
    if(SangminConfig.forkjoin){
      nId = (BranchID)in.readObject();
    } else {
      nId = new NodeId(in.readLong());
    }
    //long  nodeIdInt = in.readLong();

    long realTime = in.readLong();
    boolean  myembargoed = in.readBoolean();

    DependencyVV _dvv = null;
    SummaryHash _sh = null;

    if(SangminConfig.securityLevel >= SangminConfig.COMPLETE){
      int  numNodesInDVV = in.readInt();
      _dvv = new DependencyVV();
      for(int i=0; i < numNodesInDVV; i++){
        NodeId nodeId;
        if(SangminConfig.forkjoin){
          nodeId = (BranchID)in.readObject();
        } else {
          nodeId = new NodeId(in.readLong());
        }
        _dvv.put(nodeId, in.readLong());
      }

      
      byte[] shBuffer = new byte[20];
      in.read(shBuffer,0,20);
      _sh = new SummaryHash(shBuffer, false);
    }
    
    byte[] dhBuffer = new byte[20];
    in.read(dhBuffer,0,20);
    DataHash _dh = new DataHash(dhBuffer, false);

    int signatureLength = in.readInt();
    byte[] _signature = new byte[signatureLength];
    in.read(_signature,0,signatureLength);

    int _hops = in.readInt();
    
    int bodySize = in.readInt();
    byte[] _body = new byte[bodySize];
    in.read(_body, 0, bodySize);
    
    Field[] f = new Field[10];
    
    try{

      f[0] = PreciseInv.class.getDeclaredField("obj");
      f[1] = PreciseInv.class.getDeclaredField("acceptStamp");
      f[2] = PreciseInv.class.getDeclaredField("rtAcceptStamp");
      f[3] = PreciseInv.class.getDeclaredField("embargoed");
      f[4] = SecurePreciseInv.class.getDeclaredField("dvv");
      f[5] = SecurePreciseInv.class.getDeclaredField("sh");
      f[6] = SecurePreciseInv.class.getDeclaredField("dh");
      f[7] = SecurePreciseInv.class.getDeclaredField("signature");
      f[8] = SecurePreciseInv.class.getDeclaredField("hops");
      f[9] = SecureBoundInval.class.getDeclaredField("body");
    }catch(NoSuchFieldException ne){
      System.err.println(ne.toString());
      ne.printStackTrace();
      System.exit(-1);

    }
    try{
      AccessibleObject.setAccessible(f, true);
    } catch (SecurityException se){
      System.err.println(se.toString());
      se.printStackTrace();
      System.exit(-1);
    }
    try{
      f[0].set(this, new ObjInvalTarget(new ObjId(objIdString),
          offset,
          length));
      f[1].set(this, new AcceptStamp(localClock, nId));
      f[2].set(this, new AcceptStamp(realTime, nId));
      f[3].setBoolean(this, myembargoed);
      f[4].set(this, _dvv);
      f[5].set(this, _sh);
      f[6].set(this, _dh);
      f[7].set(this, _signature);
      f[8].setInt(this, _hops);
      f[9].set(this, ImmutableBytes.dangerousCreateImmutableBytes(_body));

    }catch(IllegalArgumentException ie){
      System.err.println(ie.toString());
      ie.printStackTrace();
      System.exit(-1);
    }catch(IllegalAccessException iae){
      System.err.println(iae.toString());
      iae.printStackTrace();
      System.exit(-1);
    }

    try{
      AccessibleObject.setAccessible(f, false);
    } catch (SecurityException se){
      System.err.println(se.toString());
      se.printStackTrace();
      System.exit(-1);
    }
    
    
  }
  
  public void readExternal(ObjectInput in) 
  throws IOException, ClassNotFoundException{

    readExternalHelper(in);
    assert(in.available() == 0);

    assert(this.verify((PublicKey)Config.publicKeys.get(new Long(this.getCreator().getIDint())))) : "readExternal" + this;

  }

}
