package code.security;

import java.io.IOException;
import java.util.concurrent.locks.ReentrantLock;
import java.io.*;
import java.util.Hashtable;
import java.util.Collection;

import code.*;
import code.security.holesync.filter.*;
import code.security.liveness.*;
import code.security.holesync.*;



public class SecureCore extends Core{

  public SecurityFilter securityFilter;

  public
  SecureCore(SecureRMIClient rmiClient_, 
      boolean filterOn, 
      boolean cleanDb, 
      NodeId myId,
      boolean noSyncLog, 
      LivenessFilter livenessFilter, 
      Collection<Filter> filters){
    try{

      UpdateBuffer updateBuffer = null;
      if(verbose){
        Env.dprintln(verbose, "Core constructor cleanDb=" + cleanDb);
      }

      this.myNodeId = myId;
      securityFilter = new SecurityFilter(this, rmiClient_, livenessFilter, filters);
      logPath = Config.getLocalStore(this.myNodeId) + this.myNodeId + ".log";
      storePath = Config.getLocalStore(this.myNodeId) + this.myNodeId + ".store";
      // logPath = ufsDir +Config.getConfigFile() + this.myNodeId + ".log";
      // storePath = ufsDir +Config.getConfigFile() + this.myNodeId + ".store";
      if(cleanDb) cleanEnv();
      this.rmiClient = rmiClient_;
      String name = Config.getConfigFile();
      if(verbose){
        Env.dprintln(verbose, "Core constructor logPath=" + logPath);
      }
      log = new SecureUpdateLog(logPath, myId, noSyncLog, securityFilter);
      recovering = false;
      recoverEndVV = new CounterVV(log.getCurrentVV());
      if(verbose){
        Env.dprintln(verbose, "Core constructor recoverEndVV=" + recoverEndVV.toString());
      }
      this.store = new DataStore(storePath, myId);
      updateBuffer = new UpdateBuffer(UpdateBuffer.INFINITE_BUFFER_BYTES,
          UpdateBuffer.FAIL_ON_FULL);
      this.invalBuffer = new InvalidateBuffer(this.store, updateBuffer);
      /*
      new InvalidateBufferWorkerThread(this.invalBuffer,
                                       this.store,
                                       updateBuffer);
       */
      this.store.setInvalBuffer(this.invalBuffer);
      this.localWriteStreamId = StreamId.makeNewStreamId();
      /*
        recoverStartVV = 
        new CounterVV(store.getCurrentVV(new DirectoryInterestSet("/*")));

        this doesn't work, because the interestset doesn't exist
       */
      recoverStartVV = new CounterVV(this.store.getMaxCurrentVV());
      if(verbose){
        Env.dprintln(verbose, "Core constructor recoverStartVV=" + recoverStartVV.toString());
      }
      Env.tbd("recoverStartVV should be initialized as store.getMinLPVV()"+
      "when the new isstatus is placed in");
      assert(recoverEndVV.includes(recoverStartVV));
      assert(recoverStartVV.includes(log.getDiskOmitVV()));
      if(!recoverStartVV.includes(recoverEndVV)){
        recovering = true;
      }
      //System.err.println("recoverStartVV: " + recoverStartVV);

      iiFilter = new InvalIteratorFilter(filterOn);
      log.startGCWorker(store);

    } catch (Exception e){
      e.printStackTrace();
      assert false;

      Env.printDebug("Failed to initiate the core.." + e);
      System.exit(-1);
    }
  }



  /** 
   *  Core construction with option to choose null RAS - for testing only 
   **/ 


  public
  SecureCore(SecureRMIClient rmiClient_, 
      boolean filterOn, 
      boolean cleanDb, 
      NodeId myId,
      boolean noSyncLog, 
      boolean nullRAS, 
      LivenessFilter livenessFilter, 
      Collection<Filter> filters){
    try{

      UpdateBuffer updateBuffer = null;
      if(verbose){
        Env.dprintln(verbose, "Core constructor cleanDb=" + cleanDb);
      }

      this.myNodeId = myId;
      securityFilter = new SecurityFilter(this, rmiClient_, livenessFilter, filters);

      logPath = Config.getLocalStore(this.myNodeId) + this.myNodeId + ".log";
      storePath = Config.getLocalStore(this.myNodeId) + this.myNodeId + ".store";
      // logPath = ufsDir +Config.getConfigFile() + this.myNodeId + ".log";
      // storePath = ufsDir +Config.getConfigFile() + this.myNodeId + ".store";
      if(cleanDb) cleanEnv();
      this.rmiClient = rmiClient_;
      String name = Config.getConfigFile();
      if(verbose){
        Env.dprintln(verbose, "Core constructor logPath=" + logPath);
      }
      log = new SecureUpdateLog(logPath, myId, noSyncLog, securityFilter);
      recovering = false;
      recoverEndVV = new CounterVV(log.getCurrentVV());
      if(verbose){
        Env.dprintln(verbose, "Core constructor recoverEndVV=" + recoverEndVV.toString());
      }
      this.store = new DataStore(storePath, myId, nullRAS);
      updateBuffer = new UpdateBuffer(UpdateBuffer.INFINITE_BUFFER_BYTES,
          UpdateBuffer.FAIL_ON_FULL);
      this.invalBuffer = new InvalidateBuffer(this.store, updateBuffer);
      /*
      new InvalidateBufferWorkerThread(this.invalBuffer,
                                       this.store,
                                       updateBuffer);
       */
      this.store.setInvalBuffer(this.invalBuffer);
      this.localWriteStreamId = StreamId.makeNewStreamId();
      /*
        recoverStartVV = 
        new CounterVV(store.getCurrentVV(new DirectoryInterestSet("/*")));

        this doesn't work, because the interestset doesn't exist
       */
      recoverStartVV = new CounterVV(this.store.getMaxCurrentVV());
      if(verbose){
        Env.dprintln(verbose, "Core constructor recoverStartVV=" + recoverStartVV.toString());
      }
      Env.tbd("recoverStartVV should be initialized as store.getMinLPVV()"+
      "when the new isstatus is placed in");
      assert(recoverEndVV.includes(recoverStartVV));
      assert(recoverStartVV.includes(log.getDiskOmitVV()));
      if(!recoverStartVV.includes(recoverEndVV)){
        recovering = true;
      }
      //System.err.println("recoverStartVV: " + recoverStartVV);

      iiFilter = new InvalIteratorFilter(filterOn);
      log.startGCWorker(store);



    } catch (Exception e){
      e.printStackTrace();
      assert false;

      Env.printDebug("Failed to initiate the core.." + e);
      System.exit(-1);
    }
  }

  public AcceptVV getCurrentVV(){
//  assert securityFilter.getCurrentVV().equalsIgnoreNegatives(log.getCurrentVV()): "logCVV " + log.getCurrentVV() + " securityCVV " + securityFilter.getCurrentVV();
    return securityFilter.getCurrentVV();
  }

  public void specialLock(){
    /*
    System.out.print("TID : " + Thread.currentThread().getName());
    if(log.lock.isHeldByCurrentThread()){
        System.out.print(" : held by currentThread");
    }else{
    }
    if(log.lock.hasQueuedThreads()){
        System.out.print("Some threads are waiting for this lock");
    }else{
        System.out.print("No threads is waiting for this lock");
    }
    new Throwable().printStackTrace();
     */
    log.lock.lock();
  }

  public boolean specialLockHeld(){
    return log.lock.isLocked();
  }

  public boolean specialLockHeldByMe(){
    return log.lock.isHeldByCurrentThread();
  }

  public void specialUnlock(){
    /*
    System.out.print("TID : " + Thread.currentThread().getName());
    new Throwable().printStackTrace();
     */
    log.lock.unlock();
  }

  public boolean verify(GeneralInv gi, NodeId sender){
    //first check access control
    //then check consistency
    return securityFilter.verifyAndApply(gi, sender);
  }


  public SecureCore(SecureRMIClient rmiClient_, boolean filterOn, boolean cleanDb,
      NodeId myId, ISStatus isStatus, boolean noSyncLog, LivenessFilter livenessFilter, Collection<Filter> filters){
    // TODO Auto-generated constructor stub

    try{
      UpdateBuffer updateBuffer = null;
      if(verbose){
        Env.dprintln(verbose, "Core constructor cleanDb=" + cleanDb);
      }

      this.myNodeId = myId;
      securityFilter = new SecurityFilter(this, rmiClient_, livenessFilter, filters);
      logPath = Config.getLocalStore(this.myNodeId) + this.myNodeId + ".log";
      storePath = Config.getLocalStore(this.myNodeId) + this.myNodeId + ".store";
      // logPath = ufsDir +Config.getConfigFile() + this.myNodeId + ".log";
      // storePath = ufsDir +Config.getConfigFile() + this.myNodeId + ".store";
      if(cleanDb) cleanEnv();
      this.rmiClient = rmiClient_;
      String name = Config.getConfigFile();
      int index = name.indexOf('.');
      String prefix = name.substring(0,index);
      if(verbose){
        Env.dprintln(verbose, "Core constructor logPath=" + logPath);
      }

      log = new SecureUpdateLog(logPath, myId, noSyncLog, securityFilter);
      recovering = false;
      recoverEndVV = new CounterVV(log.getCurrentVV());
      if(verbose){
        Env.dprintln(verbose, "Core constructor recoverEndVV=" + recoverEndVV.toString());
      }
      this.store = new DataStore(storePath, isStatus, myId);
      updateBuffer = new UpdateBuffer(UpdateBuffer.INFINITE_BUFFER_BYTES,
          UpdateBuffer.FAIL_ON_FULL);
      this.invalBuffer = new InvalidateBuffer(this.store, updateBuffer);
      new InvalidateBufferWorkerThread(this.invalBuffer,
          this.store,
          updateBuffer);
      this.store.setInvalBuffer(this.invalBuffer);
      this.localWriteStreamId = StreamId.makeNewStreamId();
      /*
        recoverStartVV = 
        new CounterVV(store.getCurrentVV(new DirectoryInterestSet("/*")));

        this doesn't work, because the interestset doesn't exist
       */
      recoverStartVV = new CounterVV(this.store.getMaxCurrentVV());
      if(verbose){
        Env.dprintln(verbose, "Core constructor recoverStartVV=" + recoverStartVV.toString());
      }
      Env.tbd("recoverStartVV should be initialized as store.getMinLPVV()"+
      "when the new isstatus is placed in");
      assert(recoverEndVV.includes(recoverStartVV));
      assert(recoverStartVV.includes(log.getDiskOmitVV()));
      if(!recoverStartVV.includes(recoverEndVV)){
        recovering = true;
      }
      //System.err.println("recoverStartVV: " + recoverStartVV);

      iiFilter = new InvalIteratorFilter(filterOn);
      log.startGCWorker(store);


    } catch (Exception e){
      e.printStackTrace();
      assert false;

      Env.printDebug("Failed to initiate the core.." + e);
      System.exit(-1);
    }
  }

  /** 
   *  call datastore.sendCheckpoint: send CPStartMsg, cvv, PTreeNode list,  
   *                                      RAS records, RAS_SHIP_DONE 
   *  difference from the previous sendCheckpoint: 
   *    doesn't need to wait until the cvv and streamCVV matches 
   *    just send the cp for streamSS from streamCVV to cvv if they doesn't match 
   **/ 
  public AcceptVV sendCheckpoint(TaggedOutputStream tos,
      SubscriptionSet ss,
      AcceptVV startVV,
      boolean withBody,
      SubscriptionSet streamSS,
      AcceptVV streamCVV, /*
        boolean includeAll, */
      LivenessFilter lf, 
      Filter f, 
      FilterKnowledge fk)
  throws IOException{

    // check if we need to send anything in the first place
    
    assert SangminConfig.securityLevel > SangminConfig.SIGNATURE;
    if(SangminConfig.securityLevel > SangminConfig.SIGNATURE){
      return sendSecureCheckpoint(tos, ss, startVV, withBody, streamSS, streamCVV/*, includeAll*/, lf, f, fk);
    }else{
      return super.sendCheckpoint(tos, ss, startVV, withBody, streamSS, streamCVV/*, includeAll*/);
    }
  }

  /** 
   *  call datastore.sendCheckpoint: send CPStartMsg, cvv, PTreeNode list,  
   *                                      RAS records, RAS_SHIP_DONE 
   *  difference from the previous sendCheckpoint: 
   *    doesn't need to wait until the cvv and streamCVV matches 
   *    just send the cp for streamSS from streamCVV to cvv if they doesn't match 
   **/ 
  @Override
  public AcceptVV sendCheckpoint(TaggedOutputStream tos,
      SubscriptionSet ss,
      AcceptVV startVV,
      boolean withBody,
      SubscriptionSet streamSS,
      AcceptVV streamCVV/*, 
      boolean includeAll*/)
  throws IOException{

    Filter f = new SubscriptionSetFilter(ss);
    FilterKnowledge fk = new FilterKnowledge(startVV, f);
    return sendCheckpoint(tos, ss, startVV, withBody, streamSS, streamCVV/*, includeAll*/, new BlockingLivenessFilter(), f, fk);
  }

  /** 
   *  call securityFilter.applyCheckpoint: receive SecureCheckpointMsg 
   **/ 

  synchronized public boolean applySecureCheckpoint(SecureConnectionState s, SecureCheckpoint msg, NodeId sender){

    //
    // now we are ready to update the checkpoint to the datastore
    // note: it's ok if gapInv apply succeed while the datastore update failed 
    //       as long as the datastore update is atomic
    //       If this is the case, we only leave the isstatus in a very
    //       imprecise state but still causal, i.e. safe.
    //
    return this.securityFilter.apply(msg, s, sender);
  }

  /** 
   *  call datastore.sendCheckpoint: send CPStartMsg, cvv, PTreeNode list,  
   *                                      RAS records, RAS_SHIP_DONE 
   *  difference from the previous sendCheckpoint: 
   *    doesn't need to wait until the cvv and streamCVV matches 
   *    just send the cp for streamSS from streamCVV to cvv if they doesn't match 
   **/ 
  public AcceptVV sendSecureCheckpoint(TaggedOutputStream tos,
      SubscriptionSet ss,
      AcceptVV startVV,
      boolean withBody,
      SubscriptionSet streamSS,
      AcceptVV streamCVV, 
      /*      boolean includeAll,*/
      LivenessFilter lf, 
      Filter f, 
      FilterKnowledge fk)
  throws IOException{
    SecureCheckpoint chkPt =null; 

//  if(!((AcceptVV)streamCVV).equalsIgnoreNegatives(this.getCurrentVV())
//  && (!streamSS.isEmpty())){
//  //gap between streamCVV and cvv
//  chkPt = securityFilter.getSecureCheckpoint(streamSS, streamCVV, withBody, this.getCurrentVV());
//  tos.writeObject(chkPt);
//  }
    //System.out.println("sendSecureCheckpoint called");
//  assert streamCVV.includes(startVV): "streamCVV " + streamCVV + " startVV " +startVV;
    System.out.println(" startVV " + startVV + " streamCVV " + streamCVV + " LivenessFilter " + lf);

    AcceptVV realDiff =  AcceptVV.decrementAll(streamCVV.getRealDiff(startVV.cloneMaxVV(AcceptVV.makeVVAllNegatives()))).dropNegatives();
    streamCVV = streamCVV.project(realDiff);
    startVV = startVV.project(realDiff);
    System.out.println("realdiff" + realDiff + " startVV " + startVV + " streamCVV " + streamCVV + " LivenessFilter " + lf);
    //streamCVV = streamCVV.getDiff(startVV);
    //startVV = startVV.project(streamCVV);
    //if(!startVV.includes(streamCVV)){
      chkPt = securityFilter.getSecureCheckpoint(AcceptVV.incrementAll(startVV), withBody, streamCVV/*, includeAll*/, lf, f, fk);
      
      if(SecurityFilter.dbg)System.out.println("writing checkpoint " + chkPt);
      if(SecurityFilter.measureTime){
        if(!chkPt.isEmpty()){
          System.out.println("NonEmpty Additional Knowledge size" + fk.size());
          System.out.println("NonEmpty Original Knowledge size" + (fk.getCVV().dropNegatives().size()*16+4));
        }else{
          System.out.println("Empty Additional Knowledge size" + fk.size());
          System.out.println("Empty Original Knowledge size" + (fk.getCVV().dropNegatives().size()*16+4));
        }
      }
      tos.writeObject(chkPt);
    //}
    //System.out.println("sendSecureCheckpoint called1");

//  SubscriptionSet totalSet = ss.getCompleteUnion(streamSS);
//  if(!streamCVV.includes(getCurrentVV())){
//  assert false: " current security code shouldn't ever reach here";
//  chkPt = securityFilter.getSecureCheckpoint(totalSet, AcceptVV.incrementAll(streamCVV), withBody, getCurrentVV(), includeAll);
//  tos.writeObject(chkPt);

//  }
    //System.out.println("sendSecureCheckpoint going to return");

    return getCurrentVV();
  }


  public SecurityFilter getSecurityFilter(){
    return securityFilter;
  }

  public SecureRMIClient getRMIClient(){
    return (SecureRMIClient) rmiClient;
  }
  
  public AcceptVV
  getLpVV(SubscriptionSet ss){
    //assert SangminConfig.forkjoin;
    // Correct code for getting LPVV has to be written
    return getCurrentVV();
  }
  /** 
   *  close() -- release all resources 
   **/ 
  public void close(){
    if(!closed){
      super.close();
      this.securityFilter.close();
    }
  }

  // Return number of "new" bytes that are made current by this store
  @Override
  public long applyBody(BodyMsg body)
  throws InterruptedException, IOException, InvalidBodyException{
    try{
      //Env.sprintln(" -- -- Core::applyBody:log:wait going to be called");
      log.waitUntilTentativeApplied(body.getAcceptStamp());
      //Env.sprintln(" -- -- Core::applyBody:log:wait returned");
      //Env.sprintln(" -- -- Core::applyBody:store:applyBody going to be called");
      //long bytes = this.invalBuffer.applyBody(body, true);

      if(SangminConfig.securityLevel >= SangminConfig.SIGNATURE){
        //verify received body using data hash stored in corresponding inv
        if (((SecureUpdateLog)log).verifyBody(body) == false){
          throw new InvalidBodyException();
        }
      }

      long bytes = store.applyBody(body);
      //Env.sprintln(" -- -- Core::applyBody:store.applyBody returned");
      return bytes;
    }
    catch(InterruptedException e){
      Env.warn("Core::interruptedException shouldn't happen"
          + " in current implementation, right?");
      e.printStackTrace();
      assert(false);
      throw e;
    }
    catch(IOException f){
      Env.warn("Core::applyBody got IOException " 
          + f.toString());
      f.printStackTrace();
      throw f;
    }
  }

  public LivenessCertificate certify(AcceptVV certifiedVV) throws IOException{
    assert(recoveryComplete.get()); // Require either recoverLocalState() or testSkipRecoverLocalState() after constructor

    AcceptStamp realStamp = new AcceptStamp(System.currentTimeMillis(), 
        this.myNodeId);
    //
    // Note: current implementation assume writes 
    // are bound by passing "true"
    //
    LivenessCertificate lc = ((SecureUpdateLog)log).certify(realStamp, certifiedVV);

    //deadlineMS = System.currentTimeMillis() + MAX_INVAL_DELAY_MS;
    /*
    this.invalBuffer.applyInval(bi,
                                this.localWriteStreamId,
                                deadlineMS);
     */

    try{
      store.applyWrite(lc);
    }catch(CausalOrderException e){
      System.exit(0);
      assert false;
    } 

    return lc;

  }

  public void printStats(Filter f){

    securityFilter.printStats();
    FilterKnowledge fk = new FilterKnowledge(f);
    AcceptVV cvv = this.getCurrentVV();
    AcceptVV startVV = AcceptVV.makeVVAllNegatives();
    AcceptVV realDiff =  AcceptVV.decrementAll(cvv.getRealDiff(startVV)).dropNegatives();
    AcceptVV endVV = cvv.project(realDiff);
    startVV = startVV.project(realDiff);

    System.out.println("startVV " + startVV + " endVV " + endVV);

    //    securityFilter.dbg = true;
    SecureCheckpoint sc = securityFilter.getSecureCheckpoint(startVV, false, endVV, securityFilter.getLivenessFilter(), f, fk);

    Hashtable<String, Integer> statsTable = sc.stats();
    System.out.println("Final Stats " );
    for(String str: statsTable.keySet()){
      System.out.println(str + " " + statsTable.get(str));
    }
    System.out.println("FilterKnowledge " + securityFilter.getKnowledge());
  }

  //-------------------------------------------------------------------------
  // Bound parameter is there for debugging/testing -- to allow
  // us to insert an unbound write into log. Always return a 
  // bound inval summarizing the write.
  //
  // WARNING -- if write is not bound, then body is not in redo 
  // log --> data may be lost if we crash before next sync()
  //-------------------------------------------------------------------------
  @Override
  public BoundInval
  write(ObjId objId,
      long offset,
      long length,
      ImmutableBytes buffer,
      boolean bound,
      long maxBoundHops) 
  throws IOException{
    assert(recoveryComplete.get()); // Require either recoverLocalState() or testSkipRecoverLocalState() after constructor
    return(this.write(objId, offset, length, DEFAULT_PRIORITY, buffer, bound, maxBoundHops));
  }

  //---------------------------------------------------------------
  // Bound parameter is there for debugging/testing -- to allow
  // us to insert an unbound write into log. Always return a 
  // bound inval summarizing the write.
  //
  // WARNING -- if write is not bound, then body is not in redo 
  // log --> data may be lost if we crash before next sync()
  //---------------------------------------------------------------
  @Override
  public BoundInval
  write(ObjId objId,
      long offset,
      long length,
      double priority,
      ImmutableBytes buffer,
      boolean bound,
      long maxBoundHops) 
  throws IOException{
    BoundInval bi = super.write(objId, offset, length, priority, buffer, bound, maxBoundHops);
    securityFilter.createNewCertificate();
    return bi;
  }

  /** 
   *  Write multiple objects simultaneously 
   **/ 
  public MultiObjPreciseInv //removed synchronized by zjd
  writeMulti(MultiWriteEntry[] mwe, boolean embargoed) 
  throws IOException{
    assert false;
    return null;
  }

  /** 
   *  add Order Error Bound for local write 
   *  all the same as above method except add "targetOE" to log.write(); 
   *  
   *  WARNING -- if write is not bound, then body is not in redo  
   *  log --> data may be lost if we crash before next sync() 
   **/ 
  @Override
  public BoundInval //removed synchronized by zjd
  write(ObjId objId,
      long offset,
      long length,
      double priority,
      ImmutableBytes buffer,
      boolean bound,
      long maxBoundHops,
      long targetOE, 
      boolean embargoed)
  throws IOException{

    BoundInval bi = super.write(objId, offset, length, priority, buffer, bound, maxBoundHops, targetOE, embargoed);
    securityFilter.createNewCertificate();
    return bi;
  }

  /** 
   *  Write multiple objects simultaneously 
   **/ 
  @Override
  public MultiObjPreciseInv//removed synchronized by zjd
  writeMulti(MultiWriteEntry[] mwe, long targetOE, boolean embargoed)
  throws Exception{
    assert false;
    return null;
  }

  /** 
   *  Currently, this interface just deletes the object. 
   *  Do we want to create an interface to atomically 
   *  update the directory file and delete the object? 
   **/ 
  @Override
  public DeleteInv delete(ObjId obj)
  throws IOException{
    DeleteInv di = super.delete(obj);
    securityFilter.createNewCertificate();
    return di;
  }

  public static boolean readBytes(ObjectInput in, int bytes, byte[] buffer, int o) throws IOException
  {
    int readB = 0;
    int offset = 0;
    while(offset < bytes && (readB = in.read(buffer, offset + o, (bytes-offset)))!=-1){
      offset += readB;
      //	    System.out.println("Problem avoided" + offset);
    }
    assert offset == bytes: offset + " " + new String(buffer);
    return true;
  }
}
