package code.security;

import java.io.ByteArrayOutputStream;
import java.io.IOException;

import java.io.ObjectOutputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.security.*;


import code.AcceptStamp;
import code.AcceptVV;
import code.Config;
import code.CounterVV;
import code.HierInvalTarget;
import code.ObjInvalTarget;

import code.ImpreciseInv;
import code.InvalTarget;
import code.NoSuchEntryException;
import code.NodeId;

import code.SubscriptionSet;
import code.branchDetecting.BranchID;
import code.security.ahs.AHS;
import code.security.ahs.DVVMap;
import code.security.ahs.DVVMapEntry;
import code.security.ahs.DependencyVV;
import code.security.ahs.IH;

import code.security.ahs.AHSEntry;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import java.util.Hashtable;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Collections;
import code.ObjId;

/**
 * A secure summarized update
 * @author princem
 *
 */
public class SecureImpreciseInv extends ImpreciseInv implements SecureInv{

  Hashtable<NodeId,Vector<IH>> ihTuples; // key: NodeId, value: Vector<IH>
  NodeId creator;
  private byte[]      signature = null;

  transient private AcceptVV externalDVV = null;

  protected SecureImpreciseInv(){
    ihTuples = null;
    creator = null;
  }

  public SecureImpreciseInv(InvalTarget invalTarget_,
      AcceptVV startTime_,
      AcceptVV endTime_,
      NodeId myNodeId)
  {
    super(invalTarget_, startTime_, endTime_);
    ihTuples = new Hashtable<NodeId,Vector<IH>>();
    creator = myNodeId;
    sign((PrivateKey)(Config.privateKeys.get(new Long(myNodeId.getIDint()))));    
  }

  public SecureImpreciseInv(InvalTarget invalTarget_,
      AcceptVV startTime_,
      AcceptVV endTime_,
      NodeId myNodeId,
      Hashtable<NodeId,Vector<IH>> ihTuples_)
  {
    super(invalTarget_, startTime_, endTime_);
    ihTuples = ihTuples_;
    creator = myNodeId;
    sign((PrivateKey)(Config.privateKeys.get(new Long(myNodeId.getIDint()))));    
  }

  public SecureImpreciseInv(InvalTarget invalTarget_,
      AcceptVV startTime_,
      AcceptVV endTime_,
      NodeId myNodeId,
      Hashtable<NodeId,Vector<IH>> ihTuples_,
      byte[] signature)
  {
    super(invalTarget_, startTime_, endTime_);
    ihTuples = ihTuples_;
    creator = myNodeId;
    this.signature = signature;
  }

  public static SecureImpreciseInv getSecureImpreciseInv(TestClass tc)
  {
    SecureImpreciseInv sii = new SecureImpreciseInv(tc.invalTarget, 
        tc.startTime, tc.endTime, tc.realTime, tc.creator);
    sii.ihTuples = tc.ihTuples;
    sii.signature = tc.signature;
    if(tc.isSplit){
      return new SplitSecureImpreciseInv(sii);
    }else{
      return sii;
    }
  }

  public TestClass getTestClass(){
    return new TestClass(ihTuples, // key: NodeId, value: Vector<IH>
        creator,
        signature,
        false,
        invalTarget,
        startTime,
        endTime,
        realTime);
  }

  public SecureImpreciseInv(InvalTarget invalTarget_,
      AcceptVV startTime_,
      AcceptVV endTime_,
      AcceptVV realTime_,
      NodeId myNodeId)
  {
    super(invalTarget_,startTime_,endTime_,realTime_);
    ihTuples = new Hashtable<NodeId,Vector<IH>>();
    creator = myNodeId;
    sign((PrivateKey)(Config.privateKeys.get(new Long(myNodeId.getIDint()))));    
  }

  public SecureImpreciseInv(ImpreciseInv ii, Hashtable<NodeId,Vector<IH>> ihTuples_, NodeId myNodeId, AcceptVV _externalDVV){
    super(ii.getInvalTarget(), ii.getStartVV(), ii.getEndVV(), ii.getRTVV());
    ihTuples = ihTuples_;
    creator = myNodeId;
    sign((PrivateKey)(Config.privateKeys.get(new Long(myNodeId.getIDint()))));
    this.externalDVV = _externalDVV;
  }

  public SecureImpreciseInv(ImpreciseInv ii, Hashtable<NodeId,Vector<IH>> ihTuples_, NodeId myNodeId){
    super(ii.getInvalTarget(), ii.getStartVV(), ii.getEndVV(), ii.getRTVV());
    ihTuples = ihTuples_;
    creator = myNodeId;
    sign((PrivateKey)(Config.privateKeys.get(new Long(myNodeId.getIDint()))));    
  }

  public int size(){
    int s = 0;
    s+=(SangminConfig.compressNodeId?1:4);
    for(NodeId n: ihTuples.keySet()){
      s+=(SangminConfig.compressNodeId?1:4);
      for(IH ih: ihTuples.get(n)){
        s += ih.getAHSEntry().getSize().get("PhysicalOnDiskSize");
      }
    }
    return s;
  }
  
  private void sign(PrivateKey privKey){
    try{
//      Signature sig = Signature.getInstance(privKey.getAlgorithm());
      Signature sig = Crypto.getSignature();
      sig.initSign(privKey);

      sig.update(this.obj2BytesExcludingSignature());

      this.signature = sig.sign();
      Crypto.returnSignature(sig);
    }catch(Exception e){
      System.out.println(e.toString());
      System.out.println(e.getStackTrace());
      System.exit(-1);
    }
  }

  public boolean isSplit(NodeId nodeId, long ts){
    if(!ihTuples.containsKey(nodeId)){
      return false;
    }else{
      Vector<IH> vec = ihTuples.get(nodeId);
      for(IH ih: vec){
        if(ih.getEndTS() == ts){
          return true;
        }
      }
    }

    return false;
  }

  public byte[] getSignature(){
    return signature;
  }

  public boolean verify(PublicKey pubkey){
    if(SangminConfig.disableSignatureVerfication){
      return true; 
     }
    try{
      //Signature sig = Signature.getInstance(pubkey.getAlgorithm());
      Signature sig = Crypto.getSignature();
      sig.initVerify(pubkey);

      sig.update(this.obj2BytesExcludingSignature());
      boolean ret = sig.verify(signature);
      Crypto.returnSignature(sig);
      return ret;
    }catch(Exception e){
      System.out.println(e.toString());
      System.out.println(e.getStackTrace());
      System.exit(-1);
    }    
    return false;
  }
  public byte[] obj2Bytes(){

    try{
      ByteArrayOutputStream bs = new ByteArrayOutputStream();
      ObjectOutputStream oos = new ObjectOutputStream(bs);

      HierInvalTarget hit;
      if( invalTarget instanceof HierInvalTarget){
        hit = (HierInvalTarget)this.invalTarget;
      }else{
        hit = HierInvalTarget.makeHierInvalTarget(((ObjInvalTarget)this.invalTarget).getObjId().getPath());
      }
      oos.writeObject(hit.getName());
      oos.writeLong(creator.getIDint());

      List<NodeId> l = super.startTime.getSortedNodeList();
      ListIterator<NodeId> iter;

      for(iter = l.listIterator(); iter.hasNext();){
        NodeId n = iter.next();
        oos.writeLong(super.startTime.getStampByServer(n));
        oos.writeLong(super.endTime.getStampByServer(n));
        oos.writeLong(super.realTime.getStampByServer(n));     
      }

      if(SangminConfig.securityLevel >= SangminConfig.COMPLETE){

        Enumeration<NodeId> e = ihTuples.keys();
        List<NodeId> l2 = Collections.list(e);
        Collections.sort(l2);

        ListIterator<NodeId> iter2;
        for(iter2=l2.listIterator(); iter2.hasNext();){
          Vector<IH> v = ihTuples.get(iter2.next());
          int n = v.size();
          for(int i=0; i<n; i++){
            IH ih = v.elementAt(i);
            AHSEntry ae = ih.getAHSEntry();
            oos.write(ae.obj2Bytes());
          }
        }
      }

      oos.writeInt(signature.length);
      oos.write(signature);

      oos.flush();
      byte [] obj = bs.toByteArray();
      oos.close();
      bs.close();
      return obj;
    }catch(Exception e){
      System.out.println(e.toString());
      e.printStackTrace();
      System.exit(1);
    }
    return null;

  }
  public byte[] obj2BytesExcludingSignature(){
    //System.out.println("!!!!!!!!!!!!!!!!!!!obj2bytesES:");
    try{
      ByteArrayOutputStream bs = new ByteArrayOutputStream();
      ObjectOutputStream oos = new ObjectOutputStream(bs);

      HierInvalTarget hit;
      if( invalTarget instanceof HierInvalTarget){
        hit = (HierInvalTarget)this.invalTarget;
      }else{
        hit = HierInvalTarget.makeHierInvalTarget(((ObjInvalTarget)this.invalTarget).getObjId().getPath());
      }

      //System.out.println("@@@@ inval targets:"+hit);

      oos.writeObject(hit.toString());      
      oos.writeLong(creator.getIDint());

      List<NodeId> l = super.startTime.getSortedNodeList();
      ListIterator<NodeId> iter;

      for(iter = l.listIterator(); iter.hasNext();){
        NodeId n = iter.next();
        oos.writeLong(super.startTime.getStampByServer(n));        
        oos.writeLong(super.endTime.getStampByServer(n));
        oos.writeLong(super.realTime.getStampByServer(n));        
      }

      if(SangminConfig.securityLevel >= SangminConfig.COMPLETE){

        Enumeration<NodeId> e = ihTuples.keys();
        List<NodeId> l2 = Collections.list(e);
        Collections.sort(l2);

        ListIterator<NodeId> iter2;
        for(iter2=l2.listIterator(); iter2.hasNext();){
          Vector<IH> v = ihTuples.get(iter2.next());
          int n = v.size();
          for(int i=0; i<n; i++){
            IH ih = v.elementAt(i);
            AHSEntry ae = ih.getAHSEntry();
            //System.out.println("### ahs:"+ae);

            oos.write(ae.obj2Bytes());
          }
        }
      }

      oos.flush();
      byte [] obj = bs.toByteArray();
      oos.close();
      bs.close();
      return obj;
    }catch(Exception e){
      System.out.println(e.toString());
      e.printStackTrace();
      System.exit(1);
    }
    return null;

  }

  private void writeObject(ObjectOutputStream out) throws IOException{

    if(SangminConfig.forkjoin){
      out.writeObject(this.getCreator());
    } else {
      out.writeLong(this.getCreator().getIDint());
    }

    if(SangminConfig.securityLevel >= SangminConfig.COMPLETE){

      out.writeInt(ihTuples.size());
      for(NodeId nodeId : ihTuples.keySet()){
        Vector<IH> v = ihTuples.get(nodeId);
        if(SangminConfig.forkjoin){
          out.writeObject(nodeId);
        } else {
          out.writeLong(nodeId.getIDint());
        }
        out.writeInt(v.size());
        for(IH ih :v){
          AHSEntry ahsEntry = ih.getAHSEntry();
          out.writeInt(ahsEntry.getLevel());

          assert ahsEntry.getHash().length == 20;
          out.write(ahsEntry.getHash());

          out.writeLong(ahsEntry.getStartTS());
          out.writeLong(ahsEntry.getEndTS());

          out.writeObject(ahsEntry.getInvalTarget());

          DVVMap maxDVVMap = ahsEntry.getMaxDVVMap();
          out.writeInt(maxDVVMap.size());
          for(NodeId nodeId2 : maxDVVMap.getNodeSet()){
            if(SangminConfig.forkjoin){
              out.writeObject(nodeId2);
            } else {
              out.writeLong(nodeId2.getIDint());
            }
            DVVMapEntry dvvMapEntry = maxDVVMap.getEntry(nodeId2);
            out.writeLong(dvvMapEntry.getTimeStamp());
            assert dvvMapEntry.getHashValue().length == 20;
            out.write(dvvMapEntry.getHashValue());
          }

          assert ahsEntry.getSuperHash().length == 20;
          out.write(ahsEntry.getSuperHash());

        }
      }

    }

    if(signature != null){
      out.writeInt(signature.length);
      out.write(signature);
    }else{
      out.writeInt(0);
    }
  }

  private void readObject(ObjectInputStream in) 
  throws IOException, ClassNotFoundException{

    NodeId      _creator;
    if(SangminConfig.forkjoin){
      _creator = (BranchID)in.readObject();
    } else {
      _creator = new NodeId(in.readLong());
    }

    Hashtable<NodeId,Vector<IH>> _ihTuples = new Hashtable<NodeId,Vector<IH>>();
    if(SangminConfig.securityLevel >= SangminConfig.COMPLETE){
      int numKeys = in.readInt();
      for(int i=0; i < numKeys; i++){
        NodeId nodeId;
        if(SangminConfig.forkjoin){
          nodeId = (BranchID)in.readObject();
        } else {
          nodeId = new NodeId(in.readLong());
        }
        int numIHes = in.readInt();
        Vector<IH> v = new Vector<IH>();
        for(int j=0; j < numIHes; j++){

          int _level = in.readInt();
          byte[] _hash = new byte[20];
	  //          in.read(_hash, 0, 20);
	  SecureCore.readBytes(in, 20, _hash, 0);

          long _startTS = in.readLong();
          long _endTS = in.readLong();
          InvalTarget _invalTarget = (InvalTarget) in.readObject();

          Hashtable<NodeId, DVVMapEntry> _maxDVVMapH = new Hashtable<NodeId, DVVMapEntry>();
          int maxDVVMapSize = in.readInt();
          for(int k=0; k < maxDVVMapSize; k++){
            NodeId nodeId2;
            if(SangminConfig.forkjoin){
              nodeId2 = (BranchID)in.readObject();
            } else {
              nodeId2 = new NodeId(in.readLong());
            }

            long _timeStamp = in.readLong();
            byte[] _hashVal = new byte[20];
            //in.read(_hashVal, 0, 20);
	    SecureCore.readBytes(in, 20, _hashVal, 0);
            _maxDVVMapH.put(nodeId2, new DVVMapEntry(_timeStamp,_hashVal));
          }

          DVVMap _maxDVVMap = new DVVMap(_maxDVVMapH);
          
          byte[] _superhash = new byte[20];
          //in.read(_superhash, 0, 20);
	  SecureCore.readBytes(in, 20, _superhash, 0);

          AHSEntry _ahsEntry = new AHSEntry(_level, _hash, _startTS,
              _endTS, _invalTarget, _maxDVVMap, _superhash);

          v.add(new IH(_ahsEntry));

        }
        _ihTuples.put(nodeId, v);
      }
    }

    int signatureLength = in.readInt();
    byte[] _signature;
    if(signatureLength != 0){
      _signature = new byte[signatureLength];
      //      in.read(_signature,0,signatureLength);
      SecureCore.readBytes(in, signatureLength, _signature, 0);
    }else{
      _signature = null;
    }

    Field[] f = new Field[3];
    try{
      f[0] = SecureImpreciseInv.class.getDeclaredField("creator");
      f[1] = SecureImpreciseInv.class.getDeclaredField("ihTuples");
      f[2] = SecureImpreciseInv.class.getDeclaredField("signature");      
    }catch(NoSuchFieldException ne){
      System.err.println(ne.toString());
      ne.printStackTrace();
      System.exit(-1);
    }

    try{
      AccessibleObject.setAccessible(f, true);
    } catch (SecurityException se){
      System.err.println(se.toString());
      se.printStackTrace();
      System.exit(-1);
    }

    try{
      f[0].set(this, _creator);
      f[1].set(this, _ihTuples);
      f[2].set(this, _signature);      
    }catch(IllegalArgumentException ie){
      System.err.println(ie.toString());
      ie.printStackTrace();
      System.exit(-1);
    }catch(IllegalAccessException iae){
      System.err.println(iae.toString());
      iae.printStackTrace();
      System.exit(-1);
    }

    try{
      AccessibleObject.setAccessible(f, false);
    } catch (SecurityException se){
      System.err.println(se.toString());
      se.printStackTrace();
      System.exit(-1);
    }

    if(SangminConfig.securityLevel >= SangminConfig.COMPLETE){
      Enumeration<NodeId> e = ihTuples.keys();
      CounterVV _externalDVV = new CounterVV();
      while(e.hasMoreElements()){
        NodeId nodeId = e.nextElement();
        Vector<IH> v = ihTuples.get(nodeId);
        DVVMap _maxDVVMap = SecurityFilter.getMaxDVVMap(v,nodeId);      
        _externalDVV.advanceTimestamps(_maxDVVMap.getDVV());           
      }

      e = ihTuples.keys();
      while(e.hasMoreElements()){
        NodeId nodeId = e.nextElement();      
        _externalDVV.setStampByServer(nodeId, AcceptVV.BEFORE_TIME_BEGAIN);                
      }

      this.externalDVV = _externalDVV.cloneAcceptVV();
    }

  }

  private void _writeObject(ObjectOutputStream out) throws IOException{

    out.writeLong(this.getCreator().getIDint());

    if(SangminConfig.securityLevel >= SangminConfig.COMPLETE){
      out.writeInt(ihTuples.size());
      for(NodeId nodeId : ihTuples.keySet()){
        Vector<IH> v = ihTuples.get(nodeId);
        out.writeLong(nodeId.getIDint());
        out.writeInt(v.size());
        for(IH ih :v){
          out.writeObject(ih.getAHSEntry());
        }
      }

    }

    if(signature != null){
      out.writeInt(signature.length);
      out.write(signature);
    }else{
      out.writeInt(0);
    }
  }

  private void _readObject(ObjectInputStream in) 
  throws IOException, ClassNotFoundException{

    NodeId      _creator = new NodeId(in.readLong());

    Hashtable<NodeId,Vector<IH>> _ihTuples = new Hashtable<NodeId,Vector<IH>>();
    if(SangminConfig.securityLevel >= SangminConfig.COMPLETE){
      int numKeys = in.readInt();
      for(int i=0; i < numKeys; i++){
        NodeId nodeId = new NodeId(in.readLong());
        int numIHes = in.readInt();
        Vector<IH> v = new Vector<IH>();
        for(int j=0; j < numIHes; j++){
          //v.add((IH)in.readObject());
          v.add(new IH((AHSEntry)in.readObject()));
        }
        _ihTuples.put(nodeId, v);
      }
    }

    int signatureLength = in.readInt();
    byte[] _signature;
    if(signatureLength != 0){
      _signature = new byte[signatureLength];
      //      in.read(_signature,0,signatureLength);
      SecureCore.readBytes(in, signatureLength, _signature, 0);
    }else{
      _signature = null;
    }
    //    in.read(_signature,0,signatureLength);

    Field[] f = new Field[3];
    try{
      f[0] = SecureImpreciseInv.class.getDeclaredField("creator");
      f[1] = SecureImpreciseInv.class.getDeclaredField("ihTuples");
      f[2] = SecureImpreciseInv.class.getDeclaredField("signature");      
    }catch(NoSuchFieldException ne){
      System.err.println(ne.toString());
      ne.printStackTrace();
      System.exit(-1);
    }

    try{
      AccessibleObject.setAccessible(f, true);
    } catch (SecurityException se){
      System.err.println(se.toString());
      se.printStackTrace();
      System.exit(-1);
    }

    try{
      f[0].set(this, _creator);
      f[1].set(this, _ihTuples);
      f[2].set(this, _signature);      
    }catch(IllegalArgumentException ie){
      System.err.println(ie.toString());
      ie.printStackTrace();
      System.exit(-1);
    }catch(IllegalAccessException iae){
      System.err.println(iae.toString());
      iae.printStackTrace();
      System.exit(-1);
    }

    try{
      AccessibleObject.setAccessible(f, false);
    } catch (SecurityException se){
      System.err.println(se.toString());
      se.printStackTrace();
      System.exit(-1);
    }
    if(SangminConfig.securityLevel >= SangminConfig.COMPLETE){

      initExternalDVV();
    }
  }

  private void initExternalDVV(){
    Enumeration<NodeId> e = ihTuples.keys();
    CounterVV _externalDVV = new CounterVV();
    CounterVV _minVV = new CounterVV();
    while(e.hasMoreElements()){
      NodeId nodeId = e.nextElement();
      Vector<IH> v = ihTuples.get(nodeId);
      DVVMap _maxDVVMap = SecurityFilter.getMaxDVVMap(v,nodeId);  
      DependencyVV _dvv = _maxDVVMap.getDVV();
      _externalDVV.advanceTimestamps(_dvv); 
      if(_dvv.containsNodeId(nodeId)){
        try {
          _minVV.addMinAS(new AcceptStamp(_dvv.getStampByServer(nodeId), nodeId));
        } catch (NoSuchEntryException e1) {
          // TODO Auto-generated catch block
          assert false: e1;
        }
      }else{
        _minVV.addMinAS(new AcceptStamp(AcceptStamp.BEFORE_TIME_BEGAN, nodeId));
      }
    }

    e = ihTuples.keys();
    while(e.hasMoreElements()){
      NodeId nodeId = e.nextElement();   
      if(_minVV.containsNodeId(nodeId)){
        try {
          _externalDVV.setStampByServer(nodeId, _minVV.getStampByServer(nodeId));
        } catch (NoSuchEntryException e1) {
          // TODO Auto-generated catch block
          assert false: e1;
        }     
      }else
      {
        _externalDVV.setStampByServer(nodeId, AcceptVV.BEFORE_TIME_BEGAIN);            
      }
//    _externalDVV.setStampByServer(nodeId, AcceptVV.BEFORE_TIME_BEGAIN);            
    }

    this.externalDVV = _externalDVV.cloneAcceptVV();

  }


  public Vector<IH> getIH(NodeId nodeId){
    Vector<IH> ihes = ihTuples.get(nodeId);
    return ihes;
  }

  public Hashtable<NodeId, Vector<IH>> getIHTuples(){
    return this.ihTuples;
  }

  public AHS getAHS(NodeId nodeId){
    AHS ret = new AHS();
    Vector<IH> ihes = ihTuples.get(nodeId);
    for(int i=0; i < ihes.size(); i++){
      ret.add((ihes.elementAt(i)).getAHSEntry());
    }

    return ret;
  }

  public String toString(){
    String ret = super.toString();

    for(NodeId n: ihTuples.keySet()){
	ret += "\n" +  n + "ihTuples:" + ihTuples.get(n);
    }

    ret += " Security info: signature = " + (signature!=null?signature.toString():"null");
    ret += " Creator = " + this.creator;
    ret += (externalDVV!=null)?externalDVV:"null";
    return ret;
  }

  public NodeId getCreator(){
    return creator;
  }

  public AcceptVV getExternalDVV(){
    assert(externalDVV != null);
    return externalDVV;
  }

  public boolean equals(Object o){
    boolean result = false;

    if(o instanceof SecureImpreciseInv){
      SecureImpreciseInv sii = (SecureImpreciseInv)o;
      result = (this.invalTarget.equals(sii.invalTarget) &&
          this.startTime.equalsIgnoreNegatives(sii.startTime) &&
          this.endTime.equalsIgnoreNegatives(sii.endTime) &&
          this.creator.equals(sii.creator)
      );
      if(!result){
        return result;
      }
      Enumeration<NodeId> e = ihTuples.keys();

      while(e.hasMoreElements()){
        NodeId n1 = e.nextElement();
        if(! sii.ihTuples.containsKey(n1)){
          return false;
        }
        Vector<IH> v1 = ihTuples.get(n1);
        Vector<IH> v2 = sii.ihTuples.get(n1);
        if(v1.size() != v2.size()){
          return false;
        }

        Iterator<IH> i1 = v1.iterator();
        Iterator<IH> i2 = v2.iterator();

        while(i1.hasNext()){
          IH ih1 = i1.next();
          IH ih2 = i2.next();
          if(!ih1.equals(ih2)){
            return false;
          }
        }

      }
      if(!Arrays.equals(this.signature, sii.signature)){
        return false;
      }
    }    

    return true;
  }

  public boolean validate(){
    SubscriptionSet ss = SubscriptionSet.makeSubscriptionSet("/*");
    InvalTarget invTarget = null;


    if(startTime.getSize() != ihTuples.size()
        || endTime.getSize() != ihTuples.size()){
      return false;
    }

    Enumeration<NodeId> e = ihTuples.keys();            

    while(e.hasMoreElements()){

      NodeId nodeId = e.nextElement();

      Vector<IH> v = ihTuples.get(nodeId);

      int n = v.size();

      long startTS = Long.MAX_VALUE;
      long endTS = Long.MIN_VALUE;

      for(int i=0; i < n; i++){
        //for each IH on this node
        IH ih = v.get(i);

        long IhStartTS = ih.getStartTS();
        long IhEndTS = ih.getEndTS();

        if( IhStartTS < startTS ){
          startTS = IhStartTS;
        }
        if( IhEndTS > endTS ){
          endTS = IhEndTS;
        }

        // accumulating InvalTargets of IHes
        if(invTarget == null){
          invTarget = ih.getInvalTarget();
        }else{
          invTarget = ih.getInvalTarget().getUnion(invTarget, ss);
        }        
      } // End of for

      try{
        // startTS of IHes should match startTime of this inv
        if(startTS != startTime.getStampByServer(nodeId)){
          return false;
        }
        // endTS of IHes should match endTime of this inv
        if(endTS != endTime.getStampByServer(nodeId)){
          return false;
        }
      }catch(NoSuchEntryException nsee){
        // if startVV or endVV of this inv doesn't contain this node
        return false;
      }      

    } // End of While

    // Checking InvarTarget
    if(!invTarget.equals(this.getInvalTarget())){
      return false;
    }    

    return true;
  }


}

