package code.security;
import java.util.Iterator;

import code.AcceptVV;
import code.CounterVV;
import code.GeneralInv;
import code.security.ahs.AHSMap;
import code.security.ahs.TreeNodePointers;
import code.security.ahs.TreeNode;

// TreeNode -> TreeNode
public class SecureInMemLogIterator implements Iterator<GeneralInv>{
  private static final boolean dbg = false;
    private TreeNodePointers sentPointers;

    private CounterVV cvv; //summarize all sent invals

    private AHSMap ahs = null;
    
    /**
     * 
     */
    public SecureInMemLogIterator(AcceptVV excludedStartVV, AHSMap ahs){
      //populate the next items for each writer
      assert ahs != null;
      this.ahs = ahs;
      sentPointers = ahs.getSentPointers(excludedStartVV);
      cvv = new CounterVV(excludedStartVV);
      
    }
    
    //tbd, are we sure that we can call nextPointers.size()
    //without any locking of the items?
    //
    // issues: next() return nextSentable item.
    //         there's a case that there's no nextSentable item (multiple-writer imprecise inv)
    //         even if there's new item not sent yet.
    // 
    // hasNext() is consistent with next()
    // therefore if it is false, it does not necessary mean there's new updates
    // it only means that iter can't find a sensable item to send yet.
    //
    public boolean hasNext(){
      
        return sentPointers.nextSentableItem(cvv.cloneAcceptVV())!= null;
    }

    /**
     * just get the next sentable item with the minimum start
     * advance cvv
     * 
     * tbd, make sure that it's ok
     */
    public GeneralInv next(){
      
      
      GeneralInv ret = null;
      TreeNode nextItem = sentPointers.nextSentableItem(cvv.cloneAcceptVV());
      
      if(nextItem != null){
        assert hasNext();
        ret = (GeneralInv)(nextItem.getInv());
        assert ret != null;
        assert cvv.includes(((SecureInv)ret).getExternalDVV());
        assert !cvv.includes(ret.getStartVV());
        
        //update the pointers
        this.cvv.advanceTimestamps(ret.getEndVV());
        //cvv will be used to advance the TreeNodes next time pointers.nextSentableItem() is called
        //to minimize the number of invalidations returns
        
      }else{
	assert !this.hasNext();
      }
    
      return ret;
    }       

    public void remove()
    throws UnsupportedOperationException{
      throw new UnsupportedOperationException("InMemLogIterator.remove() is not supported"); 
    }
}
