package code.security;

import java.net.Socket;
import java.security.PublicKey;
import java.util.LinkedList;

import code.AcceptVV;
import code.CatchupStreamEndMsg;
import code.CatchupStreamStartMsg;
import code.Config;
import code.Controller;
import code.Core;
import code.CounterVV;
import code.Env;
import code.GeneralInv;
import code.IllegalRemoveSubscriptionSetException;
import code.ImpreciseInv;
import code.IncommingConnection;
import code.LocalController;
import code.StreamId;
import code.SubscriptionSet;
import code.TaggedInputStream;
import code.VV;

public class SecureIncomingConnection extends IncommingConnection implements SecureConnectionState{

  /**
   * the starting point of current checkpoint that is being applied
   */
  AcceptVV prevCheckpointStartVV = null;

 /** 
 *  Constructor -- for test 
 **/ 
  public
  SecureIncomingConnection(StreamId sid, SubscriptionSet ss, AcceptVV prevVV){

    super(sid,ss,prevVV);

  }

 /** 
 *  Constructor 
 **/ 
  public
  SecureIncomingConnection(TaggedInputStream s,
      Core core,
      Controller controller,
      Socket underlyingSocket,
      StreamId newStreamId){

    super(s,core,controller, underlyingSocket, newStreamId);
  }

  public void applySecureCheckpoint(SecureCheckpoint sc){
    ((SecureCore)core).applySecureCheckpoint(this, sc, this.senderId);
  }
  
  /** 
   *  apply CheckpointStartMsg  -- 
   *        
   **/ 
    public void
    applySecureCheckpointUpdates(AcceptVV startVV, LinkedList<GeneralInv> giList, SecureCheckpoint chkPt){
  	  assert false;
    }

  /**
   * apply the GI to the log and AHS data structure after verifying its correctness
   */
  public void
  applyGI(GeneralInv gi){

//  if(gi instanceof ImpreciseInv || gi instanceof SecureImpreciseInv){
//  System.out.println("Received Imprecise Invalidation!!");
//  if(gi instanceof SecureImpreciseInv){
//  System.out.println("And it's SecureImpreciseInv");
//  }else{
//  System.out.println("But it's not SecureImpreciseInv");
//  }

//  }

    if(!((SecureCore)core).getSecurityFilter().verifyAndApply(gi, this.senderId)){
      System.out.println("security verification failed");
      assert(false);
      return;
    }      

    super.applyGI(gi);
  }

 /** 
 *  apply CatchupStreamStartMsg -- 
 *        put the pending set into pendingSet if startVV match current lpvv 
 *  startVV is the exclusion startVV 
 **/ 
  public void
  applyCatchupStreamStartMsg(CatchupStreamStartMsg psm){

    prevCheckpointStartVV = this.getPrevVV();
    super.applyCatchupStreamStartMsg(psm);
  }




 /** 
 *  apply CatchupStreamEndMsg 
 *      -- put pendingSet into subscriptionset if lpvv match prevVV 
 **/ 
  public void
  applyCatchupStreamEndMsg(CatchupStreamStartMsg start){
    if(dbgProgress){
      System.out.println("IncommingConnection.applyCatchupStreamEndMsg:(start=" + start
          + ") is called with pendingSet " + pendingSet); 
    }

    SubscriptionSet newSS = start.getSubscriptionSet();
    VV newStart = start.getStartVV();
    if(pendingSet!=null){

      // anyone survived during the catch up stream 
      // should be able to add
      if(!pendingSet.isEmpty()){

        if(this.prevCheckpointStartVV.includes(prevVV)){
          // do nothing: we didn't advance enough
          //TODO: princem can do something smarter by advancing the ss if no imprecise invalidates cover the ss after 
          // prevCheckpointStartVV

          if(dbgProgress){
            Env.dprint(dbgProgress, "IncomingConnection::applyCatchupStreamEndMsg failed in adding"
                + newSS + " with newStart " + newStart);
          }

        }else if(this.prevCheckpointStartVV.equals(prevVV)){
          this.addSubscriptionSet(pendingSet);
          if(dbgProgress){
            Env.dprint(dbgProgress, "IncomingConnection::applyCatchupStreamEndMsg succeeded in adding"
                + newSS + " with newStart " + newStart);
          }
          controller.informSubscribeInvalSucceeded(senderId,
              core.getMyNodeId(),
              newSS,
              newStart);
        }else{
          // we advanced too much so need to kick out earlier stuff
          this.replaceSubscriptionSet(pendingSet);
          if(dbgProgress){
            Env.dprint(dbgProgress, "IncomingConnection::applyCatchupStreamEndMsg succeeded in replacing"
                + newSS + " with newStart " + newStart);
          }
          controller.informSubscribeInvalSucceeded(senderId,
              core.getMyNodeId(),
              newSS,
              newStart);
        }

      }
      pendingSet = null;
      pendingStartVV = null;
      prevCheckpointStartVV = null;
    }
    assert pendingSet == null;
    assert pendingStartVV == null;
    assert prevCheckpointStartVV == null;
  }

}
