package code.security;

import java.net.Socket;
import java.util.LinkedList;

import code.*;

public class SecureIncomingInvalConnection extends IncommingInvalConnection implements SecureConnectionState{


  AcceptVV prevCheckpointStartVV = null;

 /** 
 *  Constructor -- for test 
 **/ 
  public
  SecureIncomingInvalConnection(StreamId sid, SubscriptionSet ss, AcceptVV prevVV){

    super(sid,ss,prevVV);

  }

 /** 
 *  Constructor 
 **/ 
  public
  SecureIncomingInvalConnection(TaggedInputStream s,
      Core core,
      Controller controller,
      Socket underlyingSocket,
      StreamId newStreamId){

    super(s,core,controller, underlyingSocket, newStreamId);
  }

  protected boolean checkAndApplyInitialCP(TaggedInputStream tis){
    try{
      Object next = tis.readTaggedObject();
      if(next instanceof SecureCheckpoint){
        this.applySecureCheckpoint((SecureCheckpoint) next);
        return true;
      }else{
	  //        assert false:""+next;
        return false;
      }
    }catch(Exception e){
      e.printStackTrace();
      return false;
    }
          
  }
  

  /** 
  *  apply CheckpointStartMsg  -- 
  *        
  **/ 
   public void
   applySecureCheckpointUpdates(AcceptVV startVV, LinkedList<GeneralInv> giList, SecureCheckpoint chkPt){
 	  assert false;
   }
  
  public boolean applySecureCheckpoint(SecureCheckpoint sc){
    boolean ret =
	  ((SecureCore)core).applySecureCheckpoint(this, sc, this.senderId);  
    return ret;
  }
 
  public void
  applyGI(GeneralInv gi){

//  if(gi instanceof ImpreciseInv || gi instanceof SecureImpreciseInv){
//  System.out.println("Received Imprecise Invalidation!!");
//  if(gi instanceof SecureImpreciseInv){
//  System.out.println("And it's SecureImpreciseInv");
//  }else{
//  System.out.println("But it's not SecureImpreciseInv");
//  }
    //
//  }
  
    if(!((SecureCore)core).verify(gi, this.senderId)){
      System.out.println("security verification failed");
      assert(false);
      return;
    }      

   super.applyGI(gi);

  }
  public void
  applyInsecureGI(GeneralInv gi){
    long start = System.currentTimeMillis();
    long end;
    if(dbgProgress){
      System.out.println(core.getMyNodeId() + 
          " IncommingInvalConnection.applyGI:( " + gi + ") is called"); 
    }

    //
    // advance outgoingConnection cvv to prevent redundant invalidates
    // from sending back to sender again.
    //
    this.filterRedundantInvForSender(gi);
    end = System.currentTimeMillis();
    if(dbgPerformance){
      System.out.println("11111 " + (end-start));
    }
    //
    //note: we must first update the cvv
    //      then update lpvv/prevVV for causal view across objects
    //
    core.applyInval(gi, streamId); 
    start = end;
    end = System.currentTimeMillis();
    if(dbgPerformance){
      System.out.println("22222 " + (end-start));
    }
    if (pendingSet == null){
    //if (gi.getEndVV().isAnyPartGreaterThan(this.prevVV)){
      start = end;
      end = System.currentTimeMillis();
      if(dbgPerformance){
        System.out.println("33333 " + (end-start));
      }
      // 
      // from the main stream ==> will advance prevVV
      // 

      assert pendingSet == null : "pendingSet : " + pendingSet + "\npendingStartVV : " + pendingStartVV;
      assert pendingStartVV == null;

      //kick off imprecise subset
      SubscriptionSet kickedSet = this.getKickedSet(gi, this.ss);
      start = end;
      end = System.currentTimeMillis();
      if(dbgPerformance){
        System.out.println("44444 " + (end-start));
      }
      if(kickedSet != null){
        AcceptVV newLpvv = prepareNewLpvv(this.prevVV.cloneAcceptVV(), gi.getStartVV());
        removeSubscriptionSet(kickedSet, newLpvv);
        controller.informSubscribeInvalFailed(senderId, core.getMyNodeId(), 
            kickedSet, newLpvv);
      }
      start = end;
      end = System.currentTimeMillis();
      if(dbgPerformance){
        System.out.println("55555 " + (end-start));
      }
      //advance prevVV
      this.prevVV.advanceTimestamps(gi.getEndVV());
      core.notifyDatastore(this.ss, this.prevVV.cloneAcceptVV());//notify imprecise read thread
      start = end;
      end = System.currentTimeMillis();
      if(dbgPerformance){
        System.out.println("66666 " + (end-start));
      }

    }else if (pendingSet != null){
      //
      // from catch up streams
      //
      applyCatchupGI(gi);
      this.prevVV.advanceTimestamps(gi.getEndVV());
    }
    start = end;
    end = System.currentTimeMillis();
    if(dbgPerformance){
      System.out.println("88888 " + (end-start));
    }
    controller.informReceiveInval(gi, senderId);
  }



 /** 
 *  apply CatchupStreamStartMsg -- 
 *        put the pending set into pendingSet if startVV match current lpvv 
 *  startVV is the exclusion startVV 
 **/ 
  public void
  applyCatchupStreamStartMsg(CatchupStreamStartMsg psm){

    super.applyCatchupStreamStartMsg(psm);
 //   assert pendingStartVV.equals(psm.getStartVV()):"pendingStartVV:" + pendingStartVV + " psm" + psm;
  }
  

  public void applyCheckpointCatchupStreamStartMsg(CatchupStreamStartMsg cssm, AcceptVV endVV){
    super.applyCatchupStreamStartMsg(cssm);
    if(!prevVV.includes(endVV) && dbgProgress){
      System.out.println("prevVV:" + prevVV + " received checkpoint till " + endVV);
    }
//    this.prevVV.advanceTimestamps(endVV);
    
  }


  public void applyCatchupGI(GeneralInv gi) {
    //
    // from catch up streams
    //

    //apply to pendingSet
    assert pendingStartVV != null;
    if(gi.isPrecise()){
      ObjInvalTarget oit = (ObjInvalTarget)gi.getInvalTarget();
      pendingSet = pendingSet.getCompleteUnion(new SubscriptionSet(HierInvalTarget.makeHierInvalTarget(oit.getObjId().getPath())));//so that lpvv can be advanced
    //advance pendingStartVV
      if(pendingStartVV != null){
        assert !pendingSet.isEmpty();
        pendingStartVV.advanceTimestamps(gi.getEndVV());
      }
    } else {
      super.applyCatchupGI(gi);
    }


  }

 /** 
 *  apply CatchupStreamEndMsg 
 *      -- put pendingSet into subscriptionset if lpvv match prevVV 
 **/ 
  public void
  applyCatchupStreamEndMsg(CatchupStreamStartMsg start){
    if(dbgProgress){
      System.out.println("SecureIncommingInvalConnection.applyCatchupStreamEndMsg:(start=" + start
          + ") is called with pendingSet " + pendingSet); 
    }

    SubscriptionSet newSS = start.getSubscriptionSet();
    VV newStart = start.getStartVV();
    if(pendingSet!=null){

      // anyone survived during the catch up stream 
      // should be able to add
      if(!pendingSet.isEmpty()){

        if(!pendingStartVV.includes(prevVV)){
          // do nothing: we didn't advance enough
          //TODO: princem can do something smarter by advancing the ss if no imprecise invalidates cover the ss after 
          // prevCheckpointStartVV

          if(dbgProgress){
            Env.dprint(dbgProgress, "IncomingConnection::applyCatchupStreamEndMsg failed in adding"
                + newSS + " with newStart " + newStart);
          }

        }else if(pendingStartVV.equals(prevVV)){
          this.addSubscriptionSet(pendingSet);
          if(dbgProgress){
            Env.dprint(dbgProgress, "IncomingConnection::applyCatchupStreamEndMsg succeeded in adding"
                + newSS + " with newStart " + newStart);
          }
          controller.informSubscribeInvalSucceeded(senderId,
              core.getMyNodeId(),
              newSS,
              newStart);
        }else{
          assert !prevVV.includes(pendingStartVV);
          // we advanced too much so need to kick out earlier stuff
          this.replaceSubscriptionSet(pendingSet);
          if(dbgProgress){
            Env.dprint(dbgProgress, "IncomingConnection::applyCatchupStreamEndMsg succeeded in replacing"
                + newSS + " with newStart " + newStart);
          }
          controller.informSubscribeInvalSucceeded(senderId,
              core.getMyNodeId(),
              newSS,
              newStart);
        }

      }
      pendingSet = null;
      pendingStartVV = null;
      prevCheckpointStartVV = null;
    }
    assert pendingSet == null;
    assert pendingStartVV == null;
    assert prevCheckpointStartVV == null;
  }

 /** 
 *  startWorker() -- kick off the worker thread. Must be called right 
 *     after initialization. 
 **/ 
  public void startWorker(){    
    assert worker==null;
    worker = new SecureIncomingInvalConnectionWorker(this.s, this.underlyingSocket, this);
    worker.start();
  }

  public Controller getController(){
      return controller;
  }
}

