package code.security;

import java.net.Socket;
import java.util.LinkedList;

import code.branchDetecting.BranchKnowledge;
import code.security.liveness.*;
import code.*;
import code.security.holesync.*;
import code.security.holesync.filter.*;


public class SecureNewIncomingInvalConnection extends IncommingInvalConnection implements SecureConnectionState {


  LivenessFilter livenessFilter;
  /** 
   *  Constructor -- for test 
   **/ 
  public
  SecureNewIncomingInvalConnection(StreamId sid, SubscriptionSet ss, AcceptVV prevVV, SecureCore core, Controller controller){

    super(sid,ss,prevVV);
    this.core = core;
    this.controller = controller;
    this.livenessFilter = ((SecureCore)core).securityFilter.getLivenessFilter();
    
  }

  /** 
   *  Constructor 
   **/ 
  public
  SecureNewIncomingInvalConnection(TaggedInputStream s,
      Core core,
      Controller controller,
      Socket underlyingSocket,
      StreamId newStreamId){

    super(s,core,controller, underlyingSocket, newStreamId);
    this.livenessFilter = ((SecureCore)core).securityFilter.getLivenessFilter();
    
  }

  private FilterKnowledge getFilterKnowledge(){
    FilterKnowledge fk = null;
    Knowledge k = ((SecureCore)core).securityFilter.getKnowledge();
    assert k.getFilters().size() == 1: k.getFilters() + " currently only one filter per node";
    for(Filter f: k.getFilters()){
      fk = k.getFilterKnowledge(f);
    }
    //    System.out.println("FilterKnowledge " + fk);
    return fk;
  }

  protected boolean checkAndApplyInitialCP(TaggedInputStream tis){
    assert false;
    return true;
  }

  /** 
   *  handle initial prevVV 
   *  
   *  only called by worker 
   **/ 
  protected boolean initConnection(TaggedInputStream tis, AcceptVV senderVV, SubscriptionSet ss){
    assert core.getCurrentVV().includes(senderVV): "SenderVV: " + senderVV + " CVV " + core.getCurrentVV();
    if(core.getLpVV(ss).includes(senderVV)){
      this.ss = ss;
      assert prevVV.equalsIgnoreNegatives(AcceptVV.makeVVAllNegatives());
      prevVV.advanceTimestamps(senderVV);
      this.addSubscriptionSet(ss);
//      core.addConnectionToISStatus(ss, this);

    }else{
      if(dbgProgress){
        System.out.println("SecureNewIncomingInvalConnection: This connection will be useless as ss is null" + senderVV + " lpvv" + core.getLpVV(ss) + " ss " + ss);
      }
	//princem:holesync modification      //princem: new code modification      assert false;
    }
    // super.initConnection(tis, senderVV);
    return true;
  }


  public boolean applySecureCheckpoint(SecureCheckpoint sc){
    boolean ret =
      ((SecureCore)core).applySecureCheckpoint(this, sc, this.senderId);
    if(!ret){
      System.out.println("CP application FAILED");
    }
    return ret;
  }

  public void
  applyGI(GeneralInv gi){
    assert false;
  }

  public void
  applyInsecureGI(GeneralInv gi){
    assert false;
  }

  /** 
   *  apply Secure Checkpoint  --
   *  apply updates and keep track of which all objects have not been succeeded by a precise update and (1) those should be removed from
   *  connection (if attached and if the checkpoint is not catchup), while (2) others should be added(if not already added)
   *  if the checkpoint is catchup, then only do (2)
   *        
   **/ 
  public void
  applySecureCheckpointUpdates(AcceptVV startVV, LinkedList<GeneralInv> giList, SecureCheckpoint chkPt){
    this.applySecureCheckpointUpdates(startVV, giList, chkPt, ((SecureCore)core).securityFilter.getHoleCostPredicate(this.ss));
  }

  public void
  applySecureCheckpointUpdates(AcceptVV startVV, LinkedList<GeneralInv> giList, SecureCheckpoint chkPt, CostPredicate cp){
    if(measureTime){
      System.out.println("CP Size : " + chkPt.size(cp));
      System.out.println("Number of CP components :" + chkPt.getEndVV().size());
    }       
    
      for(GeneralInv gi: giList){
	  core.applyInval(gi, this.streamId);
      }
    controller.informSubscribeInvalSucceeded(this.senderId, core.getMyNodeId(), ss, startVV);
  }
  /** 
   *  apply Secure Checkpoint  --
   *  apply updates and keep track of which all objects have not been succeeded by a precise update and (1) those should be removed from
   *  connection (if attached and if the checkpoint is not catchup), while (2) others should be added(if not already added)
   *  if the checkpoint is catchup, then only do (2)
   *        
   **/ 
  public void
  oldapplySecureCheckpointUpdates(AcceptVV startVV, LinkedList<GeneralInv> giList, SecureCheckpoint chkPt, CostPredicate cp){
    // new checkpoint
    assert(!prevVV.includes(chkPt.getEndVV()));
    AcceptVV cvv = core.getCurrentVV();
    AcceptVV oldlpvv = core.getLpVV(ss);

    //assert (oldlpvv.includes(cvv)): "oldlpvv " + oldlpvv + " cvv "+ cvv ;
    if(measureTime){
      System.out.println("CP Size : " + chkPt.size(cp));
      System.out.println("Number of CP components :" + chkPt.getEndVV().size());
    }       
    
    CounterVV endVV = new CounterVV();
    if(this.dbgProgress)
    {
      System.out.println("SecureNewIncomingConnection: Received secure checkpoint: update list" + giList + " current ss " + ss + " CVV:" + cvv);
    }
    
    if(!ss.isEmpty()){
      // assert that ss is current till startVV (start of checkpoint)
	
	assert core.getLpVV(ss).includes(chkPt.getExternalDVV()):" core.getLPVV" + core.getLpVV(ss) +  " externalDVV " + chkPt.getExternalDVV();
      if(dbgProgress){
        System.out.println("SecureNewIncomingConnection: Current lpvv: " +core.getLpVV(ss));
      }
    }
    
    // removed set tracks objects for which imprecise invals are received and these should be removed when the stream is not a catchup stream
    SubscriptionSet removedSet = SubscriptionSet.makeEmptySet();


    for(GeneralInv gi: giList){
      core.applyInval(gi, this.streamId);
      endVV.advanceTimestamps(gi.getEndVV());
      if (!gi.isPrecise()){

	
        assert gi.getInvalTarget() instanceof HierInvalTarget;

        //princem: added this
        SubscriptionSet moreRemoved = ss.getIntersection((HierInvalTarget)gi.getInvalTarget());
        if(!moreRemoved.isEmpty() && !core.getLpVV(moreRemoved).includes(gi.getEndVV())){
          removedSet = removedSet.getCompleteUnion(moreRemoved);
        }

{
    if(!removedSet.getIntersection(ss).isEmpty()){
      
      if(dbgProgress){
        System.out.println("removing " + removedSet + " from ss" + ss);
      }
      AcceptVV lpvv = core.getLpVV(removedSet);
      this.removeSubscriptionSet(removedSet, lpvv);
      //assert false: "nothing should ever be removed in this setting" + gi;
//      core.removeConnectionFromISStatus(removedSet, this, lpvv);
    }
    
    //missing code goes here    

    if(this.dbgProgress && !removedSet.isEmpty())
    {
      System.out.println("SecureNewIncomingConnection: removed set" + removedSet + " new ss" + ss + " newlpvv " + core.getLpVV(ss));
      System.out.println("MapManager: removed set" + removedSet + " new ss" + code.security.application.MapShare.MapManager.ss + " newlpvv " + core.getLpVV(code.security.application.MapShare.MapManager.ss));
      //assert code.security.application.MapShare.MapManager.ss.equals(ss): code.security.application.MapShare.MapManager.ss + " ss " + ss;
    }
    

}
//        System.out.println("removed set increased " + removedSet + " due to " + gi);
      }else{
	  /*        HierInvalTarget it = null;

        if(gi.getInvalTarget() instanceof HierInvalTarget){
          it = (HierInvalTarget)gi.getInvalTarget();
        }else if(gi.getInvalTarget() instanceof ObjInvalTarget){
          it = HierInvalTarget.makeHierInvalTarget(((ObjInvalTarget)gi.getInvalTarget()).getObjId().getPath());
        }else {
          assert false;
        }
        if(it.intersects(removedSet)){
          try {
            removedSet = removedSet.remove(new SubscriptionSet(it), true);
//            System.out.println("removed set decreased " + removedSet + " due to " + gi);
          } catch (IllegalRemoveSubscriptionSetException e) {
            // TODO Auto-generated catch block
            assert false: e;
          }
        }
	  */
      }

    }

    this.prevVV.advanceTimestamps(endVV);
    core.notifyDatastore(this.ss, this.prevVV.cloneAcceptVV());//notify imprecise read thread

    
    
    //princem: hack to see if the lpvv advances
    
    AcceptVV lpvv = core.getLpVV(ss);
    VVIterator vvi = lpvv.getIterator();
    long numInv = 0;
    while(vvi.hasMoreElements()){
      Object token = vvi.getNext();      
      long ts1 = 0;
      if(oldlpvv.containsNodeId((NodeId)token)){
       ts1 = oldlpvv.getStampByIteratorToken(token);
      }
      long ts2 = lpvv.getStampByIteratorToken(token);
      if(ts2 - ts1 > 0){
        numInv += ts2 - ts1;
      }
    }
    System.out.println("lpvv increase " + numInv + " newlpvv " + lpvv + " cvv"  + core.getCurrentVV());

    this.removeSubscriptionSet(ss, lpvv);
    controller.informSubscribeInvalSucceeded(this.senderId, core.getMyNodeId(), ss, startVV);
  }


  public void
  applyCatchupSecureCheckpointUpdates(AcceptVV startVV, SubscriptionSet ss, LinkedList<GeneralInv> giList, SecureCheckpoint chkPt){

//  // potentially, we can accept and make use of checkpoints that are not complete catchup (lead to prevVV) but 
//  // to simplify things, we only utilize checkpoints that lead to prevVV
//  if(prevVV.includes(chkPt.endVV) && !chkPt.endVV.includes(prevVV)){
//  //TODO:		  controller.informSubscribeInvalFailed(senderNodeId, core.getMyNodeId(), ss, vvStart);
//  return;
//  }else if(!prevVV.includes(chkPt.endVV)){
//  // new checkpoint
//  this.applySecureCheckpointUpdates(startVV, ss, giList, chkPt, false);
//  }else{
//  // catchup
//  applySecureCheckpointUpdates(startVV, ss, giList, chkPt, true);
//  }
    applySecureCheckpointUpdates(startVV, ss, giList, chkPt, true);

  }

  /** 
   *  apply Secure Checkpoint  --
   *  apply updates and keep track of which all objects have not been succeeded by a precise update and (1) those should be removed from
   *  connection (if attached and if the checkpoint is not catchup), while (2) others should be added(if not already added)
   *  if the checkpoint is catchup, then only do (2)
   *        
   **/ 
  private void applySecureCheckpointUpdates(AcceptVV startVV, SubscriptionSet ss, LinkedList<GeneralInv> giList, SecureCheckpoint chkPt, boolean catchup){
    SubscriptionSet addedSet = ss;
    // removed set tracks objects for which imprecise invals are received and these should be removed when the stream is not a catchup stream
    SubscriptionSet removedSet = SubscriptionSet.makeEmptySet();
    // assert that ss is current till startVV (start of checkpoint)
    //assert core.getLpVV(ss).includes(startVV);
    for(GeneralInv gi: giList){
      if (!gi.isPrecise() && gi.getInvalTarget().intersects(addedSet)){

        assert gi.getInvalTarget() instanceof HierInvalTarget;

        SubscriptionSet kickedSet = ss.getIntersection((HierInvalTarget)(gi.getInvalTarget()));

        removedSet = removedSet.getCompleteUnion(kickedSet);


      }
    }

  }


  /** 
   *  apply CatchupStreamStartMsg -- 
   *        put the pending set into pendingSet if startVV match current lpvv 
   *  startVV is the exclusion startVV 
   **/ 
  public void
  applyCatchupStreamStartMsg(CatchupStreamStartMsg psm){
    assert false;
  }


  public void applyCatchupGI(GeneralInv gi) {
    assert false;
  }

  /** 
   *  apply CatchupStreamEndMsg 
   *      -- put pendingSet into subscriptionset if lpvv match prevVV 
   **/ 
  public void
  applyCatchupStreamEndMsg(CatchupStreamStartMsg start){
    assert false;
  }

  /** 
   *  startWorker() -- kick off the worker thread. Must be called right 
   *     after initialization. 
   **/ 
  public void startWorker(){    
    assert worker==null;
    /*
    if(SangminConfig.forkjoin){
      SecureCore sc = (SecureCore)super.core;
      BranchKnowledge bK = sc.securityFilter.getBranchManager().getKnowledge();
      worker = new SecureNewIncomingInvalConnectionWorker(this.s, 
          this.underlyingSocket, this, livenessFilter, core.getCurrentVV(),
          getFilterKnowledge(), bK );
    } else  {
      worker = new SecureNewIncomingInvalConnectionWorker(this.s, this.underlyingSocket, this, livenessFilter, core.getCurrentVV(), getFilterKnowledge() );
    }*/
    worker = new SecureNewIncomingInvalConnectionWorker(this.s, this.underlyingSocket, this, livenessFilter, core.getCurrentVV(), getFilterKnowledge() );
    worker.start();
  }

  public Controller getController(){
    return controller;
  }
}

