package code.security;
import java.io.EOFException;
import java.io.IOException;
import java.io.InvalidClassException;
import java.net.Socket;
import java.io.ObjectOutputStream;

import code.AcceptVV;
import code.CPStartMsg;
import code.CatchupStreamEndMsg;
import code.CatchupStreamStartMsg;
import code.DebargoMsg;
import code.Env;
import code.GeneralInv;
import code.NodeId;
import code.VVIterator;
import code.branchDetecting.BranchKnowledge;
import code.security.SecureNewIncomingInvalConnection;
import code.IncommingInvalConnectionWorker;
import code.LatencyWatcher;
import code.PreciseInv;
import code.TaggedInputStream;
import code.TerminateMsg;
import code.UnbindMsg;
import code.security.liveness.LivenessFilter;
import code.security.holesync.*;

public class SecureNewIncomingInvalConnectionWorker extends
IncommingInvalConnectionWorker{

  LivenessFilter livenessFilter;
  AcceptVV curVV;
  FilterKnowledge filterKnowledge;
  
  //BranchKnowledge branchKnowledge;
  /** 
   * Constructor for worker thread 
   **/ 
  public SecureNewIncomingInvalConnectionWorker(TaggedInputStream tis,
      Socket underlyingSocket,
      SecureNewIncomingInvalConnection ic, 
      LivenessFilter lf,
      AcceptVV curVV, 
      FilterKnowledge filterK){
    super(tis, underlyingSocket, ic);
    livenessFilter = lf;
    this.curVV = curVV;
    this.filterKnowledge = filterK;
  }
  /*
  public SecureNewIncomingInvalConnectionWorker(TaggedInputStream tis,
      Socket underlyingSocket,
      SecureNewIncomingInvalConnection ic, 
      LivenessFilter lf,
      AcceptVV curVV, 
      FilterKnowledge filterK, BranchKnowledge branchK){
    super(tis, underlyingSocket, ic);
    livenessFilter = lf;
    this.curVV = curVV;
    this.filterKnowledge = filterK;
    
    assert SangminConfig.forkjoin;
    assert branchK !=null;    
    this.branchKnowledge = branchK;
    
  }*/

  /** 
   *  Process an incoming stream consisting of 
   *   
   *  [INVAL_SOCKET_MAGIC, senderId, intial prevVV,  
   *   {(CatchupStreamStartMsg - (GerneralInv)* - CatchupStreamEndMsg)| 
   *   (GeneralInv|UnbindMsg|DebargoMsg)*| 
   *   (CPStartMsg-cvv-LPVVRecord*- (PerObjStateForSend|PerRangeStateForSend|BodyMsg)*-RAS_SHIP_DONE)}* 
   *   TerminateMsg] 
   **/ 
  @Override
  public void
  run(){
    if(SecureNewIncomingInvalConnection.dbgProgress){
      System.out.println("IncommingInvalConnectionWorker starts");
    }

    //
    // handshake
    //
    if(!handshake()){
      Env.remoteAssert(false);
      this.closeStreamAndSocket("SecureNewIncomingInvalConnection cannot handshake with sender ");
      closeFile();
      return;
    }

    //tbd from InvalRecvWorker.java
    if(!tbdPrinted){
      Env.tbd("TBD: subclass Socket to be a heartbeat Socket \n"
          + "sender sends a msg every 5 seconds \n "
          + "and receiver expects to recv message every 20 seconds or\n"
          + "throws IO Exception OR USE KEEPALIVE OPTION?");
      tbdPrinted = true;
    }



    try{
      ObjectOutputStream oos = new ObjectOutputStream(underlyingSocket.getOutputStream());
      oos.writeObject(livenessFilter);
      
      oos.writeObject(filterKnowledge);
     /*
      if(SangminConfig.forkjoin){
        oos.writeObject(branchKnowledge);
      }*/
     // oos.writeObject(curVV);
      oos.flush();
      //oos.close();
    }catch(IOException e){
      // TODO Auto-generated catch block
      e.printStackTrace();
      assert false;
    }


    long handleInvalStart=0;
    long handleInvalEnd=0;


    //
    // Read the sequence of invalidations/CP from stream
    //
    try{

      Object next = s.readTaggedObject();
      assert next!=null: "next is null";
      while(! (next instanceof TerminateMsg)){

        if(measureTime){
          handleInvalStart = System.currentTimeMillis();
        }
        if(SecureNewIncomingInvalConnection.dbg){
          Env.dprintln(SecureNewIncomingInvalConnection.dbg, "Read next : " + next);
        }


        if(next instanceof UnbindMsg){
          assert false;
        }else if(next instanceof DebargoMsg){
          assert false;



        }else if(next instanceof CatchupStreamStartMsg){
          assert false;

        }else if(next instanceof CatchupStreamEndMsg){

          assert false;


        }else if(next instanceof CPStartMsg){
          assert false;
        }else if(next instanceof SecureCheckpoint){
        	SecureCheckpoint sc = ((SecureCheckpoint)next);
        	
          if(SecureNewIncomingInvalConnection.dbgProgress){
            System.out.println("Received checkpoint" + sc);
          }
          boolean succeeded =
          ((SecureNewIncomingInvalConnection)ic).applySecureCheckpoint(sc);
          if(SecureNewIncomingInvalConnection.dbgProgress){
            System.out.println("Finished processing checkpoint");
          }
          if(measureTime){
            handleInvalEnd = System.currentTimeMillis();
            writeToFile((handleInvalEnd - handleInvalStart));
            LatencyWatcher.put("SecureNewIncomingInvalConnection.applySecureCheckpoint", (handleInvalEnd - handleInvalStart));            
          }

          ((SecureNewIncomingInvalConnection)ic).getController().informCheckpointApplied(ic.getSenderId(), succeeded);


        }else {
          assert false : next;

        }



        if(SecureNewIncomingInvalConnection.dbgPerformance){
          long start = System.currentTimeMillis();
          Env.dprintln(SecureNewIncomingInvalConnection.dbgPerformance, "@ "+ start 
              + " SecureNewIncomingInvalConnection -- about to read next message");
        }


        next = s.readTaggedObject();
        assert next!=null: "next is null";


        if(SecureNewIncomingInvalConnection.dbgPerformance){
          long start = System.currentTimeMillis();
          Env.dprintln(SecureNewIncomingInvalConnection.dbgPerformance, "@ "+ start 
              + " SecureNewIncomingInvalConnection -- done reading next message");
        }
      }// while loop for next object

    }catch(EOFException i){

      this.closeStreamAndSocket("terminated because of EOFException " + i.toString());
      closeFile();

      return; // expected case thread exit
    }catch(IOException io){
      if(SecureNewIncomingInvalConnection.dbg){
        io.printStackTrace();
      }
      this.closeStreamAndSocket("terminated because of IOException " + io.toString());
      closeFile();
      return; // expected case thread exit
    }catch(Exception i3){
      i3.printStackTrace();
      assert false; // Unexpected cases
      this.closeStreamAndSocket("terminated unexcpectedly because of " + i3.toString());
      closeFile();
      return; // thread exit
    }

    this.closeStreamAndSocket("terminated normally");


  }
}
