package code.security;

import code.AcceptVV;
import code.Controller;
import code.Core;
import code.NetAddr;
import code.NodeId;
import code.OutgoingConnectionMailBox;
import code.OutgoingInvalConnection;
import code.OutgoingInvalConnectionPool;
import code.OutgoingInvalConnectionWorker;
import code.SubscriptionRequest;
import code.SubscriptionSet;
import code.branchDetecting.BranchDetector;
import code.branchDetecting.BranchKnowledge;
import code.branchDetecting.ForkJoinRMIClient;
import code.branchDetecting.RemoteBranchManager;

public class SecureNewOutgoingInvalConnectionPool extends
    OutgoingInvalConnectionPool{

  public SecureNewOutgoingInvalConnectionPool(Core core, Controller controller){
    super(core, controller);
    // TODO Auto-generated constructor stub
  }
  
//  /** 
//   *   add a subscriptionset to a connection 
//   *        
//   *      For simplicity: here we just use one connection per (sender, receiver); 
//   *      tbd: for multiple connections can take the simple policy such as: 
//   *          always the most advanced stream i.e. the one with largest prevVV. 
//   *          if the all prevVV is much less than cvv, then create a new stream? 
//   *    Note: multi-stream might not worthwhile, because of overhead and the bottleneck 
//   *    might be accessing the log, and there's redundant OUT imprecise invalidations. 
//   *  return the matching OutgoingInvalConnection in pool 
//   *  create one if not exists yet. 
//   *  
//   **/ 
//    synchronized public void addToConnection(NodeId receiverId,
//                                             String receiverDNS,
//                                             int portInval,
//                                             SubscriptionSet newSS,
//                                             AcceptVV newStartVV,
//                                             boolean sendBodiesWithCP,
//                                             boolean catchupWithCP){
//      this.addToConnection(receiverId, receiverDNS, portInval, newSS, newStartVV, sendBodiesWithCP, catchupWithCP, false);
//      
//    }

 /** 
 *   add a subscriptionset to a connection 
 *        
 *      For simplicity: here we just use one connection per (sender, receiver); 
 *      tbd: for multiple connections can take the simple policy such as: 
 *          always the most advanced stream i.e. the one with largest prevVV. 
 *          if the all prevVV is much less than cvv, then create a new stream? 
 *    Note: multi-stream might not worthwhile, because of overhead and the bottleneck 
 *    might be accessing the log, and there's redundant OUT imprecise invalidations. 
 *  return the matching OutgoingInvalConnection in pool 
 *  create one if not exists yet. 
 *  
 **/ 
  @Override
  synchronized public AcceptVV addToConnection(NodeId receiverId,
                                           String receiverDNS,
                                           int portInval,
                                           SubscriptionSet newSS,
                                           AcceptVV newStartVV,
                                           boolean sendBodiesWithCP,
                                           boolean catchupWithCP/*, 
                                           boolean includeAll*/){
    AcceptVV returnVV = null;
    if(shutdown){
      return returnVV;
    }


    System.out.println("addToConnection!");
    System.out.println("receiverId : " + receiverId);
    System.out.println("receiverDNS : " + receiverDNS);
    System.out.println("receiverId : " + portInval);

    SubscriptionRequest newRequest =
	              new SubscriptionRequest(catchupWithCP?SubscriptionRequest.CP:SubscriptionRequest.LOG,
				            newSS,
	                                    newStartVV,
	                                    sendBodiesWithCP/*, 
	                                    includeAll*/);
    
    NetAddr netAddr = new NetAddr(receiverDNS, portInval);
    OutgoingInvalConnection oc = (OutgoingInvalConnection)pool.get(netAddr);
    if(oc == null || oc.getWorker().getTimeToDie()){
      OutgoingConnectionMailBox box = core.makeOutgoingConnectionMailBox(core.getCurrentVV());
      SecureNewOutgoingInvalConnectionWorker worker = null;
      //box.addNewRequest(newRequest); -- handled in the initialization
      worker = new SecureNewOutgoingInvalConnectionWorker(core, controller, 
                                                 receiverId, receiverDNS, portInval,
                                                 newRequest,
                                                 box);
      returnVV = worker.getStreamCVV();
      oc = new SecureNewOutgoingInvalConnection(box, worker);
      pool.put(netAddr, oc);
      new Thread(worker).start();

    }else{
      assert(!oc.getWorker().getTimeToDie());
      oc.getMailBox().addNewRequest(newRequest);
    }
    return returnVV;
  }
    
  synchronized public AcceptVV addToConnection(NodeId receiverId,
                                           String receiverDNS,
                                           int portInval,
                                           SubscriptionSet newSS,
                                           AcceptVV newStartVV,
                                           boolean sendBodiesWithCP,
                                           boolean catchupWithCP,
                                           BranchKnowledge branchKnowledge/*, 
                                           boolean includeAll*/){
    AcceptVV returnVV = null;
    if(shutdown){
      return returnVV;
    }


    System.out.println("addToConnection!");
    System.out.println("receiverId : " + receiverId);
    System.out.println("receiverDNS : " + receiverDNS);
    System.out.println("receiverId : " + portInval);

    SubscriptionRequest newRequest =
                      new SubscriptionRequest(catchupWithCP?SubscriptionRequest.CP:SubscriptionRequest.LOG,
                                            newSS,
                                            newStartVV,
                                            sendBodiesWithCP/*, 
                                            includeAll*/);
    
    assert branchKnowledge != null;
      SecureCore seCore = (SecureCore)core;
      RemoteBranchManager rbm = 
        new RemoteBranchManager(branchKnowledge, 
            (ForkJoinRMIClient)seCore.getRMIClient(), receiverId);
      
      BranchDetector bd = new BranchDetector(seCore.securityFilter.getBranchManager());
      bd.registerReceiverSegementChecker(rbm);
      bd.detectBranches();
    
    
    
    NetAddr netAddr = new NetAddr(receiverDNS, portInval);
    OutgoingInvalConnection oc = (OutgoingInvalConnection)pool.get(netAddr);
    if(oc == null || oc.getWorker().getTimeToDie()){
      OutgoingConnectionMailBox box = core.makeOutgoingConnectionMailBox(core.getCurrentVV());
      SecureNewOutgoingInvalConnectionWorker worker = null;
      //box.addNewRequest(newRequest); -- handled in the initialization
      worker = new SecureNewOutgoingInvalConnectionWorker(core, controller, 
                                                 receiverId, receiverDNS, portInval,
                                                 newRequest,
                                                 box);
      returnVV = worker.getStreamCVV();
      oc = new SecureNewOutgoingInvalConnection(box, worker);
      pool.put(netAddr, oc);
      new Thread(worker).start();

    }else{
      assert(!oc.getWorker().getTimeToDie());
      oc.getMailBox().addNewRequest(newRequest);
    }
    return returnVV;
  }
}
