package code.security;

import java.io.IOException;
import code.AcceptVV;
import code.Controller;
import code.Core;
import code.CounterVV;
import code.Env;
import code.GeneralInv;
import code.ImpreciseInv;
import code.LatencyWatcher;
import code.NodeId;
import code.OutgoingConnectionMailBox;
import code.OutgoingInvalConnectionWorker;
import code.SingleWriterImpreciseInv;
import code.SubscriptionSet;
import code.TaggedOutputStream;
import code.SubscriptionRequest;
import code.branchDetecting.BranchDetector;
import code.branchDetecting.BranchKnowledge;
import code.branchDetecting.BranchManager;
import code.branchDetecting.ForkJoinRMIClient;
import code.branchDetecting.RemoteBranchManager;
import code.security.liveness.*;
import java.io.*;
import java.util.LinkedList;

import code.security.holesync.filter.*;
import code.security.holesync.*;

public class SecureNewOutgoingInvalConnectionWorker extends
    OutgoingInvalConnectionWorker{

  LivenessFilter receiverLivenessFilter = null;
  Filter filter = null;
  AcceptVV lpvv;
  FilterKnowledge filterKnowledge;
  
  //BranchManager bm;
  
  public SecureNewOutgoingInvalConnectionWorker(Core core, Controller controller,
      NodeId receiverId, String receiverDNS, int portInval,
      SubscriptionRequest newRequest,
      OutgoingConnectionMailBox box){
    super(core, controller, receiverId, receiverDNS, portInval, newRequest, box);

    lpvv = core.getLpVV(newRequest.getSubscriptionSet());
    if(SangminConfig.securityFilterDebug){
        System.out.println("Received new request: " + newRequest);
        System.out.println("lpvv " + lpvv + " startvv " + initialRequest.getStartVV());
    }
    if(initialRequest.getStartVV().includes(lpvv)){
      this.streamCVV = new CounterVV(initialRequest.getStartVV().cloneMinVV(core.getCurrentVV()));
    }else{
      AcceptVV dvv = lpvv.cloneMaxVV(((SecureCore)core).securityFilter.getMaxDVV(AcceptVV.makeVVAllNegatives(), lpvv));
      System.out.println("lpvv " + lpvv + " dvv " + dvv);
//      //princem: the following is a really ugly way of ensuring that all the dependencies of a checkpoint are satisfied
//      AcceptVV lastDVV = ((SecureCore)core).securityFilter.getMaxDVV(AcceptVV.makeVVAllNegatives(), dvv);
//      while(!dvv.includes(lastDVV)){
//        dvv = dvv.cloneMaxVV(lastDVV);
//        lastDVV = ((SecureCore)core).securityFilter.getMaxDVV(AcceptVV.makeVVAllNegatives(), dvv);
//      }
//      
//      //drop entries that are covered by the curVV
//      AcceptVV neededDVV = AcceptVV.decrementAll(dvv.getRealDiff(curVV)).dropNegatives();
//      System.out.println("dvv fixed point " + dvv.dropNegatives() + " neededDVV " + neededDVV.dropNegatives() + " curVV " + curVV.dropNegatives());
//      this.streamCVV = new CounterVV(lpvv.cloneMaxVV(dvv.project(neededDVV)));
//      System.out.println("streamCVV" + streamCVV);
      this.streamCVV = new CounterVV(dvv);
      // TODO Auto-generated constructor stub
    }
    /*
    if(SangminConfig.forkjoin){
      bm = ((SecureCore)core).securityFilter.getBranchManager();
    }*/
  }

  

  
  /**
   * process next Invalidate
   * if it intersects streamSS, send it immediately. Note flush the previously
   *     accumulated imprecise invalidation before send the new invalidate
   * else accumulate it in the accumulatedInv.
   */
  @Override
  protected void writeInvToStream(TaggedOutputStream tos, GeneralInv gi)
  throws IOException{
    if(gi instanceof ImpreciseInv){
      gi = ((SecureCore)core).securityFilter.createImpreciseInv((ImpreciseInv)gi);
    }else if(gi instanceof SingleWriterImpreciseInv){
      gi = ((SecureCore)core).securityFilter.createImpreciseInv(
          ((SingleWriterImpreciseInv)gi).cloneImpreciseInv());
    }
    
    assert(SangminConfig.securityLevel > SangminConfig.NONE);
    assert(gi instanceof SecureInv):"++++++++++++" + gi;
    
    super.writeInvToStream(tos, gi);
  }

  /** 
   *  remove a request from pendingQue 
   *  and process the request by sending catchupstream && add the subscriptionset 
   *                          or removing the subscriptionset 
   *  
   *  Side effect - update pendingCP with deferred checkpoints catchup requests. 
   **/ 
  @Override
    protected void serveNewRequest(TaggedOutputStream tos, SubscriptionRequest nextRequest)
    throws IOException{

      if(dbgProgress){
        Env.dprintln(dbgProgress, "OutgoingInvalConnectionWorker processing " + nextRequest 
            + " @ streamSS=" + streamSS + " streamCVV=" + streamCVV);
      }

      //
      // CASE 1: New request is for CP
      //
      if(nextRequest.getType() == SubscriptionRequest.CP){


        sendCP(tos, 
            nextRequest.getSubscriptionSet(), 
//            nextRequest.getStartVV(),
//            nextRequest.getStartVV().cloneMinVV(core.getCurrentVV()),
            filterKnowledge.getCVV(), 
            nextRequest.getCPBodies()/*, 
            nextRequest.isIncludeAll()*/);

        this.addToStreamSS(nextRequest.getSubscriptionSet());

        //
        // CASE 2: New request is for log
        //
      } else {
        super.serveNewRequest(tos, nextRequest);
      }
    }

  //--------------------------------------------------------------------------
  // Send the handshake to start the connection.
  //--------------------------------------------------------------------------
  @Override
  protected void handshake(TaggedOutputStream tos) throws IOException{

   
    handshakeHelper(tos);
    
    ObjectInputStream ois = new ObjectInputStream(sock.getInputStream());
    Object o = null;
    try{
      o = ois.readObject();
      assert o instanceof LivenessFilter;
      
      receiverLivenessFilter = (LivenessFilter)o; 
      
      o = ois.readObject();
      
      
      filterKnowledge = (FilterKnowledge)o;
      
      filter = filterKnowledge.getFilter();
      
      if(SecurityFilter.dbg)System.out.println("requestor's filter knowledge:" + filterKnowledge);
      /*
      if(SangminConfig.forkjoin){
        BranchKnowledge branchKnowledge = (BranchKnowledge)ois.readObject();
        assert branchKnowledge != null;
        SecureCore seCore = (SecureCore)core;
        RemoteBranchManager rbm = 
          new RemoteBranchManager(branchKnowledge, 
              (ForkJoinRMIClient)seCore.getRMIClient(), receiverId);
        
        BranchDetector bd = new BranchDetector(bm);
        bd.registerReceiverSegementChecker(rbm);
        bd.detectBranches();
      }*/
      // AcceptVV curVV = (AcceptVV)ois.readObject();
      
//      if(initialRequest.getStartVV().includes(lpvv)){
//        this.streamCVV = new CounterVV(core.getCurrentVV().cloneMinVV(initialRequest.getStartVV()));
//      }else{
//        AcceptVV dvv = lpvv.cloneMaxVV(((SecureCore)core).securityFilter.getMaxDVV(AcceptVV.makeVVAllNegatives(), lpvv));
//        System.out.println("lpvv " + lpvv + " dvv " + dvv);
//        //princem: the following is a really ugly way of ensuring that all the dependencies of a checkpoint are satisfied
//        AcceptVV lastDVV = ((SecureCore)core).securityFilter.getMaxDVV(AcceptVV.makeVVAllNegatives(), dvv);
//        while(!dvv.includes(lastDVV)){
//          dvv = dvv.cloneMaxVV(lastDVV);
//          lastDVV = ((SecureCore)core).securityFilter.getMaxDVV(AcceptVV.makeVVAllNegatives(), dvv);
//        }
//        
//        //drop entries that are covered by the curVV
//        AcceptVV neededDVV = AcceptVV.decrementAll(dvv.getRealDiff(curVV)).dropNegatives();
//        System.out.println("dvv fixed point " + dvv.dropNegatives() + " neededDVV " + neededDVV.dropNegatives() + " curVV " + curVV.dropNegatives());
//        this.streamCVV = new CounterVV(lpvv.cloneMaxVV(dvv.project(neededDVV)));
//        System.out.println("streamCVV" + streamCVV);
        
//      }
    }catch(ClassNotFoundException e){
      // TODO Auto-generated catch block
      e.printStackTrace();
      assert false;
    }
    
    
    //    System.out.println("receive's liveness filter" + receiverLivenessFilter + " filter " + filter);
    receiverLivenessFilter.union(((SecureCore)core).securityFilter.getLivenessFilter());
    //    System.out.println("union " + receiverLivenessFilter);
    this.serveNewRequest(tos, initialRequest);
    //tos.writeObject(streamCVV.cloneAcceptVV());//synchronize prevVV with receiver
    //if(dbgProgress || printStream){
    //  System.out.println("OutgoingInvalConnection-" + receiverId + ".writeObject(initial endVV): " 
    //      + streamCVV); 
    //}
    
    
    //
    // fall back with the original protocol:
    // initialize with sender.cvv and emptySubscriptionSet
    //
    // 
    //tos.writeObject(streamSS);//synchronize streamSS with receiver
    //if(dbgProgress || printStream){
    //  System.out.println("OutgoingInvalConnection-" + receiverId + ".writeObject(initial streamSS): " 
    //                     + streamSS); 
    //}

  }

  //-------------------------------------------------------------------------------------------
  // send the checkpoint + CP_END
  //-------------------------------------------------------------------------------------------
  @Override
  protected void sendCP(TaggedOutputStream tos, 
      SubscriptionSet subset, 
      AcceptVV startvv, 
      boolean withBody/*, 
      boolean includeAll*/)
  throws IOException{

    long start = 0, end = 0;
    if(measureTime){
      start = System.currentTimeMillis();
    }

    //note: 
    // the checkpoint apply needs to be careful,
    // the streamSS in the sender side might not match with the attachedSS
    // at the receiver side. 
    // we shouldn't kickoff the entire streamSS if at the end some of 
    // object under streamSS doesn't catchup. Instead we need to attach
    // these objects that are attachable, i.e. don't treat the cp ss
    // as one attach unit. Then the availability might be very bad.
    if(dbgProgress){
      System.out.println("OutgoingInvalConnection.sendCP:( " + subset + ", " + startvv 
          + " streamSS= " + subset //streamSS.getIntersection(subset) 
          + " streamCVV= " + streamCVV + " ) starts.");
          
    }
    
    AcceptVV cpEndVV = ((SecureCore)core).sendCheckpoint(tos, subset, startvv, withBody, 
        subset,
//        streamSS.getIntersection(subset), 
        streamCVV.cloneAcceptVV()/*, 
        includeAll*/, receiverLivenessFilter, filter, filterKnowledge);

    streamCVV.advanceTimestamps(cpEndVV); 
    if(dbgProgress){
      System.out.println("OutgoingInvalConnection.sendCP:( " + subset + ", " + startvv 
          + ") finished."); 
    }

    if(measureTime){
      end = System.currentTimeMillis();
      LatencyWatcher.put("Core.sendCP", (end-start));
    }

  }

}
