package code.security;

import java.io.IOException;

import code.AcceptVV;
import code.Controller;
import code.Core;
import code.GeneralInv;
import code.ImpreciseInv;
import code.LatencyWatcher;
import code.NodeId;
import code.OutgoingConnectionMailBox;
import code.OutgoingInvalConnectionWorker;
import code.SingleWriterImpreciseInv;
import code.SubscriptionSet;
import code.TaggedOutputStream;
import code.SubscriptionRequest;

public class SecureOutgoingInvalConnectionWorker extends
    OutgoingInvalConnectionWorker{

  public SecureOutgoingInvalConnectionWorker(Core core, Controller controller,
      NodeId receiverId, String receiverDNS, int portInval,
      SubscriptionRequest newRequest,
      OutgoingConnectionMailBox box){
    super(core, controller, receiverId, receiverDNS, portInval, newRequest, box);
    // TODO Auto-generated constructor stub
  }

  

  
  /**
   * process next Invalidate
   * if it intersects streamSS, send it immediately. Note flush the previously
   *     accumulated imprecise invalidation before send the new invalidate
   * else accumulate it in the accumulatedInv.
   */

  @Override
  protected void writeInvToStream(TaggedOutputStream tos, GeneralInv gi)
  throws IOException{
    if(gi instanceof ImpreciseInv){
      gi = ((SecureCore)core).securityFilter.createImpreciseInv((ImpreciseInv)gi);
    }else if(gi instanceof SingleWriterImpreciseInv){
      gi = ((SecureCore)core).securityFilter.createImpreciseInv(
          ((SingleWriterImpreciseInv)gi).cloneImpreciseInv());
    }
    
    assert(SangminConfig.securityLevel > SangminConfig.NONE);
    assert(gi instanceof SecureInv):"++++++++++++" + gi;
    
    super.writeInvToStream(tos, gi);
  }

//-------------------------------------------------------------------------------------------
  // send the checkpoint + CP_END
  //-------------------------------------------------------------------------------------------
  @Override
  protected void sendCP(TaggedOutputStream tos, 
      SubscriptionSet subset, 
      AcceptVV startvv, 
      boolean withBody)
  throws IOException{

    long start = 0, end = 0;
    if(measureTime){
      start = System.currentTimeMillis();
    }


    //note: 
    // the checkpoint apply needs to be careful,
    // the streamSS in the sender side might not match with the attachedSS
    // at the receiver side. 
    // we shouldn't kickoff the entire streamSS if at the end some of 
    // object under streamSS doesn't catchup. Instead we need to attach
    // these objects that are attachable, i.e. don't treat the cp ss
    // as one attach unit. Then the availability might be very bad.
    if(dbgProgress){
      System.out.println("OutgoingInvalConnection.sendCP:( " + subset + ", " + startvv 
          + " streamSS= " + subset //streamSS.getIntersection(subset) 
          + " streamCVV= " + streamCVV + " ) starts.");
          
    }
    AcceptVV cpEndVV = core.sendCheckpoint(tos, subset, startvv, withBody, 
        subset,
//        streamSS.getIntersection(subset), 
        streamCVV.cloneAcceptVV()/*, this.initialRequest.isIncludeAll()*/);

    streamCVV.advanceTimestamps(cpEndVV); 
    if(dbgProgress){
      System.out.println("OutgoingInvalConnection.sendCP:( " + subset + ", " + startvv 
          + ") finished."); 
    }

    if(measureTime){
      end = System.currentTimeMillis();
      LatencyWatcher.put("Core.sendCP", (end-start));
    }

  }


}
