package code.security;

import java.net.MalformedURLException;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.UnknownHostException;
import java.util.Hashtable;

import code.security.ahs.AHS;
import code.Config;
import code.Env;
import code.NodeId;
import code.RMIApplicationException;
import code.RMIClient;
import code.ImpreciseInv;
import code.RMINetworkException;
import code.SummaryHash;
import code.VV;

public class SecureRMIClient extends RMIClient{

  private boolean printWarning = true;

  public SecureRMIClient(){
    super();
  }


  public SecureImpreciseInv
  getSplitSecureImpreciseInv(long startTS,
      long splitTS,
      long endTS,
      NodeId supplierId,
      NodeId tsNodeId)
  throws RMINetworkException, RMIApplicationException{
    if(super.dbg){
      Env.dprintln(dbg, "SecureRMIClient::getComplement("
          + " start ="+ startTS + " split = "+ splitTS
          + " end =" + endTS 
          + " supplierId = " + supplierId
          + " requesterId= " + tsNodeId);
    }

    long end, totalTime, start;

    SecureRMIServer rmiServer = null;
    try{
      rmiServer = (SecureRMIServer)Naming.lookup(Config.getRMIUrl(supplierId));



      if(dbgPerformance){
        end = System.currentTimeMillis();
        Env.dprintln(dbgPerformance, " Naminglookup****** "
            + (end-start) + " ---rmiClient::getComplement(senderID="+ supplierId
            + " receiverId="+ tsNodeId + " startTS= "+ startTS
            + " splitTS=" + splitTS + " endTS=" + endTS);
      }
      if(printWarning){
        Env.performanceWarning(" Receiver gets complement of the IH nodes using RMI as a return value.");

        printWarning = false;
      }
      //      SecureImpreciseInv complement = rmiServer.getSplitSecureImpreciseInv(startTS, splitTS, 
      //          endTS, tsNodeId);
      TestClass tc = rmiServer.getSplitSecureImpreciseInv(startTS, splitTS, 
          endTS, tsNodeId);
      if(tc == null){
        return null;
      }
      SecureImpreciseInv complement = SecureImpreciseInv.getSecureImpreciseInv(tc);

      if(dbgPerformance){
        end = System.currentTimeMillis();
        totalTime = (end-start);
        Env.dprintln(dbgPerformance, "end@ " + end + "---- take @@@@@@@" + totalTime
            + "ms " + " ---rmiClient::getComplement(senderID="+ supplierId
            + " receiverId="+ tsNodeId + " startTS= "+ startTS
            + " splitTS=" + splitTS + " endTS=" + endTS);
      }

      if(dbg){
        Env.dprintln(dbg, complement.toString());
      }
      return complement;
    }catch(java.net.MalformedURLException e){
      e.printStackTrace();
      System.exit(-1);
    }catch(ConnectException a){

      Env.dprintln(true, " ---rmiClient::getComplement(senderID="+ supplierId
          + " receiverId="+ tsNodeId + " startTS= "+ startTS
          + " splitTS=" + splitTS + " endTS=" + endTS + " failed:");
      a.printStackTrace();
      assert false;
      throw new RMINetworkException(a);
    }catch(ConnectIOException b){
      b.printStackTrace();
      assert false;
      throw new RMINetworkException(b);
    }catch(NotBoundException c){
      c.printStackTrace();
      assert false;
      throw new RMINetworkException(c);
    }catch(UnknownHostException d){
      d.printStackTrace();
      assert false;
      throw new RMINetworkException(d);
    }catch(RemoteException e){
      e.printStackTrace();
      assert false;
      throw new RMIApplicationException(e);
    }
    assert false;

    return null;
  }
  
  public AHS
  getAHS(NodeId sender, 
      long startTS,
      long endTS,
      NodeId nodeId)
  throws RMINetworkException, RMIApplicationException{
    if(super.dbg){
      Env.dprintln(dbg, "SecureRMIClient::getComplement("
          + " start ="+ startTS 
          + " end =" + endTS 
          + " supplierId = " + sender
          + " requesterId= " + nodeId);
    }

    long end, totalTime, start;

    SecureRMIServer rmiServer = null;
    try{
      rmiServer = (SecureRMIServer)Naming.lookup(Config.getRMIUrl(sender));



      if(dbgPerformance){
        end = System.currentTimeMillis();
        Env.dprintln(dbgPerformance, " Naminglookup****** "
            + (end-start) + " ---rmiClient::getComplement(senderID="+ sender
            + " receiverId="+ nodeId + " startTS= "+ startTS
            + " endTS=" + endTS);
      }
      if(printWarning){
        Env.performanceWarning(" Receiver gets complement of the IH nodes using RMI as a return value.");

        printWarning = false;
      }
      //      SecureImpreciseInv complement = rmiServer.getSplitSecureImpreciseInv(startTS, splitTS, 
      //          endTS, tsNodeId);
      AHS ahs = rmiServer.getAHS(nodeId, startTS, endTS);

      if(dbgPerformance){
        end = System.currentTimeMillis();
        totalTime = (end-start);
        Env.dprintln(dbgPerformance, "end@ " + end + "---- take @@@@@@@" + totalTime
            + "ms " + " ---rmiClient::getComplement(senderID="+ sender
            + " receiverId="+ nodeId + " startTS= "+ startTS
             + " endTS=" + endTS);
      }

      if(dbg){
        Env.dprintln(dbg, ahs.toString());
      }
      return ahs;
    }catch(java.net.MalformedURLException e){
      e.printStackTrace();
      System.exit(-1);
    }catch(ConnectException a){

      Env.dprintln(true, " ---rmiClient::getComplement(senderID="+ sender
          + " receiverId="+ nodeId + " startTS= "+ startTS
          + " endTS=" + endTS + " failed:");
      a.printStackTrace();
      assert false;
      throw new RMINetworkException(a);
    }catch(ConnectIOException b){
      b.printStackTrace();
      assert false;
      throw new RMINetworkException(b);
    }catch(NotBoundException c){
      c.printStackTrace();
      assert false;
      throw new RMINetworkException(c);
    }catch(UnknownHostException d){
      d.printStackTrace();
      assert false;
      throw new RMINetworkException(d);
    }catch(RemoteException e){
      e.printStackTrace();
      assert false;
      throw new RMIApplicationException(e);
    }
    assert false;

    return null;
  }
  
  public boolean testState(NodeId serverId, NodeId myId, VV cvv, SummaryHash sh) throws RMINetworkException,
  RMIApplicationException, RemoteException, MalformedURLException, NotBoundException{
    SecureRMIServer rmiServer = null;
    rmiServer = (SecureRMIServer)Naming.lookup(Config.getRMIUrl(serverId));
    //rmiServer = (SecureRMIServer) getRMIServer(serverId);
    return rmiServer.testState(myId, cvv, sh);
  }

  public void clearState(NodeId nodeId) throws RMINetworkException,
  RMIApplicationException, RemoteException{
    SecureRMIServer rmiServer = null;
    rmiServer = (SecureRMIServer) getRMIServer(nodeId);
    rmiServer.recoverState();
  }

}
