package code.security;

import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.LinkedList;

import code.AcceptStamp;
import code.AcceptVV;
import code.Controller;
import code.Core;
import code.Env;
import code.HierInvalTarget;
import code.ImpreciseInv;
import code.NodeId;
import code.OutgoingBodyConnectionPool;
import code.OutgoingConnectionPool;
import code.OutgoingInvalConnectionPool;
import code.RMIApplicationException;
import code.RMINetworkException;
import code.RMIServerImpl;
import code.StreamPool;
import code.SummaryHash;
import code.SyncPool;
import code.VV;
import code.security.ahs.AHS;

public class SecureRMIServerImpl extends RMIServerImpl implements SecureRMIServer{

	public static final boolean useNewConnectionClasses = true;
  public SecureRMIServerImpl(Core core, Controller controller_) 
  throws java.rmi.RemoteException{
    if(core == null){
      System.err.println("null is passed in as the Core");
    }
    _core = core;
    assert(controller_ != null);
    this.controller = controller_;
    // Don't forget to call start() after calling the constructor
    // (start needs to reference "this" so can't be merged in).
    started = false;
    //prefetchStreams = new NiceStreamPool(core.getMyNodeId());
    demandStreams = new StreamPool(core.getMyNodeId());
    syncRequestBuffers = new SyncPool(_core);

    if(doStats){
      Env.warn("Performance warning: Stats turned on in RMIServerImpl. "
          + " Extra copy being made of all RMIs");
    }
    assert(useNewIterator);


    if(this.useNewConnectionClasses){
    	icp = new SecureNewOutgoingInvalConnectionPool(core, controller);
    }else{
    	icp = new SecureOutgoingInvalConnectionPool(core, controller);
    }
    
    bcp = new OutgoingBodyConnectionPool(core, controller, demandStreams);
    
    testStateRequestQ = new LinkedList<TestStateRequest>();
    //outstandingTest = new Hashtable<NodeId, TestStateRequest>();
    tsProcessor = new TestStateProcessor();
    tsProcessor.start();
    
  }
  
  
  TestStateProcessor tsProcessor;
  LinkedList<TestStateRequest> testStateRequestQ;
  //Hashtable<NodeId, TestStateRequest> outstandingTest;
  
  /**
   * 
   * This thread initiates a connection for state test
   *
   */
  private class TestStateProcessor extends Thread{
    boolean running;
    SecureRMIClient rmiClient;
    
    public TestStateProcessor(){
      running = true;
      rmiClient = ((SecureCore)_core).getRMIClient();
    }
    
    public void run(){
      while(running){

        synchronized(testStateRequestQ){
          while(running && testStateRequestQ.isEmpty()){
            try{
              testStateRequestQ.wait();
            }catch(InterruptedException e){
            }
          }
        }
        
        if(!running){
          return;
        }
        TestStateRequest req = testStateRequestQ.removeFirst();
        //outstandingTest.put(req.id, req);
        //XXX
        try{
          rmiClient.subscribeInval(req.id, _core.getMyNodeId().getIDint(), "/*", true, false);
          
        }catch(RMINetworkException e){                    
          e.printStackTrace();
        }catch(RMIApplicationException e){
          e.printStackTrace();
        }
        
      }

    }
    public void shutdown(){
      running = false;
      synchronized(testStateRequestQ){
        testStateRequestQ.notifyAll();
      }
    }

  }
  private class TestStateRequest{
    public TestStateRequest(NodeId id){
      this.id = id;      
    }
    NodeId id;
  }
  
  public TestClass getSplitSecureImpreciseInv(long start, long split, long end, NodeId splitId) throws java.rmi.RemoteException{
    if (_core.getCurrentVV().includes(new AcceptStamp(split, splitId))){
      SecureImpreciseInv sii = ((SecureCore)_core).securityFilter.getSplitSecureImpreciseInv(start, split, end, splitId);
      if(sii != null){
      return sii.getTestClass();
      }else{
        return null;
      }
    }else{
      assert false;
      return null;
    }
  }
  
  public AHS getAHS(NodeId nodeId, long start, long end) throws java.rmi.RemoteException{
    if (_core.getCurrentVV().includes(new AcceptStamp(end, nodeId))){
      return ((SecureCore)_core).securityFilter.getAhsMap().createAHS(nodeId, start, end);
    }else{
      assert false;
      return null;
    }
  }
  
  /**
   * We are asked to check "node"'s state is compatible with us
   * (Trusted Server).  We will sync from the "node" to check this  
   **/
  public boolean testState(NodeId node, VV cvv, SummaryHash sh) throws java.rmi.RemoteException{
    //If I am not a trustedServer,
    // Maybe we should just return
    //
    VV myCVV = _core.getCurrentVV();
    if(myCVV.includes(cvv)){
      SummaryHash mySH = ((SecureCore)_core).securityFilter.getSummaryHash(cvv);
      if(!mySH.equals(sh)){
        return false;
      }
    }
    synchronized(testStateRequestQ){
      testStateRequestQ.add(new TestStateRequest(node));
      testStateRequestQ.notifyAll();
    }
    return true;
  }
  
  public void close(){
    super.close();
    if(tsProcessor !=null)
      tsProcessor.shutdown();
  }
  
  public void recoverState() throws java.rmi.RemoteException{
    //
    // here I should not be a trusted server
    ((SecureController)controller).informRecoverState();
  }

 /*
  public ImpreciseInv getSplitSecureImpreciseInv(long start, long split, long end, NodeId splitId) throws java.rmi.RemoteException{
      System.out.println("getSplitSecureImpreciseInv called!");

      SecureImpreciseInv sii = ((SecureCore)_core).securityFilter.getSplitSecureImpreciseInv(start, split, end, splitId);
      
      return sii;

  }
*/
  
}
