package code.security;

import code.Config;
import code.Controller;
import code.Core;
import code.LocalController;
import code.LocalInterface;
import code.NodeId;
import code.RMIClient;
import code.branchDetecting.ForkJoinRMIClient;
import code.branchDetecting.ForkJoinRMIServerImpl;
import code.security.SecureRMIServerImpl;
import code.RandomReadDirectory;
import code.SDIMSController;
import code.SDIMSInterface;
import code.SDIMSReadDirectory;
import code.SDIMSSpanningDirectory;
import code.SocketServer;
import code.TrivialSpanningDirectory;
import code.URANode;
import code.security.liveness.*;
import code.security.holesync.filter.*;
import java.util.Collection;

public class SecureURANode extends URANode{

 /** 
 *  cleanDb is used for testing purpose. True -- clean all the involved db 
 **/ 
  public SecureURANode(String localConfigFile,
                 NodeId myId,
                 int controllerType,
                 boolean cleanDb, 
                 LivenessFilter livenessFilter, 
                 Collection<Filter> filters){
    this(localConfigFile, myId, controllerType, cleanDb, false, livenessFilter, filters);
  }

  
 /** 
 *  cleanDb is used for testing purpose. True -- clean all the involved db 
 **/ 
  public SecureURANode(String localConfigFile,
                 NodeId myId,
                 int controllerType,
                 boolean cleanDb,
                 boolean noSyncLog, 
                 LivenessFilter livenessFilter, 
                 Collection<Filter> filters){
    try{
      Config.readConfig(localConfigFile);
      SecureRMIClient secureRmiClient;
      if(SangminConfig.forkjoin){
        secureRmiClient = new ForkJoinRMIClient();
        rmiClient = secureRmiClient;
      } else {
        secureRmiClient = new SecureRMIClient();
        rmiClient = secureRmiClient;
      }
      //???????add filterOn to parameter later
      boolean filterOn = true;
      core = new SecureCore(secureRmiClient, filterOn, cleanDb, myId, noSyncLog, livenessFilter, filters);
      controller = makeController(controllerType, core, rmiClient);
      if(SangminConfig.forkjoin){
        rmiServer = new ForkJoinRMIServerImpl(core, controller);
      } else {
        rmiServer = new SecureRMIServerImpl(core, controller);
      }
      rmiServer.start();
      socketServer = new SocketServer(core, controller);
      localInterface = new LocalInterface(controller, core);
      assert(this.localInterface != null);
      core.recoverLocalState(rmiServer);
    }catch(Exception e){
      System.err.println("" + e);
      e.printStackTrace();
      assert(false);
    }
  }

 /** 
 *  cleanDb is used for testing purpose. True -- clean all the involved db 
 **/ 
  public SecureURANode(String localConfigFile,
                 NodeId myId,
                 Controller c,
                 boolean cleanDb,
                 boolean noSyncLog, 
                 LivenessFilter livenessFilter, 
                 Collection<Filter> filters){
    try{
      Config.readConfig(localConfigFile);
      SecureRMIClient secureRmiClient;
      if(SangminConfig.forkjoin){
        secureRmiClient = new ForkJoinRMIClient();
        rmiClient = secureRmiClient;
      } else {
        secureRmiClient = new SecureRMIClient();
        rmiClient = secureRmiClient;
      }
      boolean filterOn = true;
      core = new SecureCore(secureRmiClient, filterOn, cleanDb, myId, noSyncLog, livenessFilter, filters);
      controller = c;
      if(SangminConfig.forkjoin){
        rmiServer = new ForkJoinRMIServerImpl(core, controller);
      } else {
        rmiServer = new SecureRMIServerImpl(core, controller);
      }
      rmiServer.start();
      socketServer = new SocketServer(core, controller);
      localInterface = new LocalInterface(controller, core);
      assert(this.localInterface != null);
      core.recoverLocalState(rmiServer);
    }catch(Exception e){
      System.err.println("" + e);
      e.printStackTrace();
      assert(false);
    }
  }

 /** 
 *  nullRAS is used to pick a null random access state 
 **/ 
  public SecureURANode(String localConfigFile,
                 NodeId myId,
                 int controllerType,
                 boolean cleanDb,
                 boolean noSyncLog, 
                 boolean nullRAS, 
                 LivenessFilter livenessFilter, 
                 Collection<Filter> filters){
 
  try{
      Config.readConfig(localConfigFile);
      SecureRMIClient secureRmiClient;
      if(SangminConfig.forkjoin){
        secureRmiClient = new ForkJoinRMIClient();
        rmiClient = secureRmiClient;
      } else {
        secureRmiClient = new SecureRMIClient();
        rmiClient = secureRmiClient;
      }
      
      boolean filterOn = true;
      core = new SecureCore(secureRmiClient, filterOn, cleanDb, myId, noSyncLog, nullRAS, livenessFilter, filters);
      controller = makeController(controllerType, core, rmiClient);
      if(SangminConfig.forkjoin){
        rmiServer = new ForkJoinRMIServerImpl(core, controller);
      } else {
        rmiServer = new SecureRMIServerImpl(core, controller);
      }
      rmiServer.start();
      socketServer = new SocketServer(core, controller);
      localInterface = new LocalInterface(controller, core);
      assert(this.localInterface != null);
      core.recoverLocalState(rmiServer);
    }catch(Exception e){
      System.err.println("" + e);
      e.printStackTrace();
      assert(false);
    }
  }

 /** 
 *  cleanDb is used for testing purpose. True -- clean all the involved db 
 **/ 
  public SecureURANode(String localConfigFile,
                 NodeId myId,
                 int controllerType,
                 boolean cleanDb,
                 boolean noSyncLog,
                 boolean logLIOpToFile,
                 String logLIOpFileName, 
                 LivenessFilter livenessFilter, 
                 Collection<Filter> filters){
    try{
      Config.readConfig(localConfigFile);
      SecureRMIClient secureRmiClient;
      if(SangminConfig.forkjoin){
        secureRmiClient = new ForkJoinRMIClient();
        rmiClient = secureRmiClient;
      } else {
        secureRmiClient = new SecureRMIClient();
        rmiClient = secureRmiClient;
      }
      
      //???????add filterOn to parameter later
      boolean filterOn = true;
      
      core = new SecureCore(secureRmiClient, filterOn, cleanDb, myId, noSyncLog, livenessFilter, filters);
      controller = makeController(controllerType, core, rmiClient);
      if(SangminConfig.forkjoin){
        rmiServer = new ForkJoinRMIServerImpl(core, controller);
      } else {
        rmiServer = new SecureRMIServerImpl(core, controller);
      }
      rmiServer.start();
      socketServer = new SocketServer(core, controller);
      localInterface = new LocalInterface(controller, core, logLIOpToFile, logLIOpFileName);
      assert(this.localInterface != null);
      core.recoverLocalState(rmiServer);
    }catch(Exception e){
      System.err.println("" + e);
      e.printStackTrace();
      assert(false);
    }
  }

 /** 
 *  cleanDb is used for testing purpose. by default it's false. i.e. recover 
 *  from disk 
 **/ 
  public SecureURANode(String localConfigFile, NodeId myId, int controllerType, LivenessFilter livenessFilter, Collection<Filter> filters){

    try{
      Config.readConfig(localConfigFile);
      SecureRMIClient secureRmiClient;
      if(SangminConfig.forkjoin){
        secureRmiClient = new ForkJoinRMIClient();
        rmiClient = secureRmiClient;
      } else {
        secureRmiClient = new SecureRMIClient();
        rmiClient = secureRmiClient;
      }
      
      //???????add filterOn to parameter later
      boolean filterOn = true;
      boolean cleanDb = false; // by default, recover from disk
      core = new SecureCore(secureRmiClient, filterOn, cleanDb, myId, false, livenessFilter, filters);
      controller = makeController(controllerType, core, rmiClient);
      if(SangminConfig.forkjoin){
        rmiServer = new ForkJoinRMIServerImpl(core, controller);
      } else {
        rmiServer = new SecureRMIServerImpl(core, controller);
      }
      rmiServer.start();
      socketServer = new SocketServer(core, controller);
      localInterface = new LocalInterface(controller, core);
      assert(this.localInterface != null);
      core.recoverLocalState(rmiServer);
    }catch(Exception e){
      System.err.println("" + e);
      e.printStackTrace();
      assert(false);
    }
  }

  public void setFilter(Collection<Filter> filters){
    ((SecureCore)core).securityFilter.setFilter(filters);
  }
  

}
