package code.security;

import code.security.liveness.*;
import code.InvalTarget;

import java.io.IOException;

import code.AcceptStamp;
import code.BodyMsg;
import code.BoundInval;
import code.CantRecoverCheckpointException;
import code.CausalOrderException;
import code.Env;
import code.GeneralInv;
import code.ImmutableBytes;
import code.NoSuchEntryException;
import code.NodeId;
import code.ObjId;
import code.ObjInvalTarget;
import code.PreciseInv;
import code.UpdateLog;
import code.AcceptVV;

public class SecureUpdateLog extends UpdateLog{

  SecurityFilter securityFilter;

  public SecureUpdateLog(String logPath_, NodeId myNodeId_, boolean noSync,
      SecurityFilter sf) throws IOException, CantRecoverCheckpointException,
      SecurityException, NoSuchEntryException{
    super(logPath_, myNodeId_, noSync);
    this.securityFilter = sf;
    // TODO Auto-generated constructor stub
  }



  // Create and apply BoundInv for local write
  @Override
  public AcceptStamp
  writeInternal(ObjId objId,
      long offset,
      long len,
      double priority,
      AcceptStamp realStamp,
      ImmutableBytes buffer,
      boolean bound,
      long maxBoundHops,
      boolean embargoed){
    lock.lock();
    try{
      GeneralInv inv;
      long checkLamportClock = currentLamportClock;

      AcceptStamp acceptStamp = new AcceptStamp(currentLamportClock, myNodeId);

      if(bound){
        assert(SangminConfig.securityLevel == SangminConfig.NONE);
        inv = new BoundInval(objId,
            offset,
            len,
            acceptStamp, 
            buffer,
            priority,
            realStamp,
            maxBoundHops,
            embargoed);
      }else{
        PreciseInv pInv = new PreciseInv(new ObjInvalTarget(objId, offset, len),
            acceptStamp,
            realStamp,
            embargoed);
        inv = securityFilter.createPreciseInval(pInv, buffer);
      }

      try{
        applyInvalAtomic(inv);
      }catch(CausalOrderException e){
        e.printStackTrace();
        assert false;
        //Assert.affirm(false, "Causal order exception on local write " 
            //              + e.toString());
      }

      return acceptStamp;
    }finally{
      lock.unlock();
    }

  }

  /**
   * verifyBody()
   **/ 
  public boolean verifyBody(BodyMsg body){
    AcceptStamp as = body.getAcceptStamp();
    SecurePreciseInv spi = (SecurePreciseInv)securityFilter.getSecureInvbyTS(as.getNodeId(), as.getLocalClock());
//  SingleWriterLogUncommitted l =
//  (SingleWriterLogUncommitted)perWriterLogs.get(as.getNodeId());
//  SecurePreciseInv spi =
//  (SecurePreciseInv)l.findSecurePreciseInv(as.getLocalClock()).getInv();
    //if (spi.getDH().equals(DataHash.createHash(body.getBody().getCopyBytes()))){
    if (spi.getDH().equals(new DataHash(body.getBody().getCopyBytes(), true))){
      return true;
    }
    return false;
  }

  public LivenessCertificate certify(AcceptStamp realStamp, AcceptVV certifiedVV){
    LivenessCertificate ret = this.certifyInternal(realStamp, certifiedVV);
    notifyMailBoxOfNewUpdates();//notify OutgoingConnection of new updates
    return ret;
  }

  public LivenessCertificate certifyInternal(AcceptStamp realStamp, AcceptVV certifiedVV){
    lock.lock();
    try{
      LivenessCertificate inv;
      
      AcceptStamp acceptStamp = new AcceptStamp(currentLamportClock, myNodeId);

      inv = securityFilter.createCertificate(acceptStamp, realStamp, certifiedVV);
      
      try{
        applyInvalAtomic(inv);
      }catch(CausalOrderException e){
        e.printStackTrace();
        assert false;
        //Assert.affirm(false, "Causal order exception on local write " 
            //              + e.toString());
      }

      return inv;
    }finally{
      lock.unlock();
    }

  }

}
