package code.security;

import java.io.ByteArrayOutputStream;
import java.util.*;
import java.security.*;


import code.branchDetecting.BranchID;
import code.branchDetecting.BranchKnowledge;
import code.branchDetecting.BranchManager;
import code.branchDetecting.ForkJoinRMIClient;
import code.branchDetecting.ForkableAHSMap;
import code.security.holesync.Range; 
import code.*;
import code.security.ahs.*;
import code.signedVV.SVVInv;
import code.NoSuchEntryException;
import code.security.liveness.*;
import code.security.holesync.filter.*;
import code.security.holesync.*;

public class SecurityFilter{

  private AHSMap        ahsMap;
  private BranchKnowledge branchKnowledge;

  final static ObjInvalTarget DummyTarget = null;

  public static final boolean debugSerialization = false;
  HashSet<NodeId>     setInteracted;
  
  TreeSet<Filter> myFilters; 

  private AcceptVV lastDVV;

  final public SecureCore core;
  SecureRMIClient secureRMIClient;
  Controller controller;

  public static boolean dbg = SangminConfig.securityFilterDebug;
  public static boolean fast = SangminConfig.fast;
    public static boolean sanityCheck = SangminConfig.sanityCheck;
  final public static boolean measureTime = false;
  private boolean closed = false;

  HashMap<SecurePreciseInv, SecurePreciseInv> hashMap;

  int numReceivedInv;

  NewCheckpointFilter newCheckpointFilter;

  PreciseInvFilter preciseInvFilter;

  ImpreciseInvFilter impreciseInvFilter;

  public static String certificateDir = "/certificate/";
  public ObjId certificateObj;

  public SplitManager splitManager;

  /**
   * Decides whether IDVV optimization is used or not
   */
  final public static boolean useDVV = true;

  /**
   * Decides whether the marking scheme will be used or not
   */
  final public static boolean useMarks = true;

  private LivenessFilter livenessFilter; 

  Filter myTotalFilter;
  
  CertificateAuthority certificateAuthority;

  boolean useTrustedServerLivenessFilter = false;
  
//public SecurityFilter(SecureCore core, SecureRMIClient rmiClient, LivenessFilter livenessFilter){
//if(SangminConfig.securityLevel > SangminConfig.SIGNATURE){
//ahsMap = new AHSMap();      
//setInteracted = new HashSet<NodeId>();
//lastDVV = AcceptVV.makeVVAllNegatives().dropNegatives();
//}
//this.core = core;
//secureRMIClient =rmiClient;
//numReceivedInv = 0;
//hashMap = new HashMap<SecurePreciseInv, SecurePreciseInv>();

//NewCheckpointFilter = new NewCheckpointFilter(this);
//preciseInvFilter = new PreciseInvFilter(this);
//impreciseInvFilter = new ImpreciseInvFilter(this);
//splitManager = new TraceSplitManager(this);
//this.livenessFilter = livenessFilter;
//this.certificateAuthority =  
//}

  public SecurityFilter(SecureCore core, SecureRMIClient rmiClient, LivenessFilter livenessFilter, Collection<Filter> myFilters){
    //System.out.println("new securityFilter created " + this);
    this.myFilters = new TreeSet<Filter>();
    this.myFilters.addAll(myFilters);
    myTotalFilter = new OrFilter(myFilters);
    if(SangminConfig.securityLevel > SangminConfig.SIGNATURE){
      if(SangminConfig.forkjoin){
        ahsMap = new ForkableAHSMap(this);
        branchKnowledge = new BranchKnowledge();
        ((ForkJoinRMIClient)rmiClient).setBranchKnowledge(branchKnowledge); 
      } else {
        ahsMap = new AHSMap();
      }
      for(Filter f: myFilters){
        ahsMap.addFilter(f);
      }
      setInteracted = new HashSet<NodeId>();
      lastDVV = AcceptVV.makeVVAllNegatives().dropNegatives();
    }else{
      ahsMap = null;
    }
    this.core = core;
    secureRMIClient =rmiClient;
    numReceivedInv = 0;
    hashMap = new HashMap<SecurePreciseInv, SecurePreciseInv>();
    
    newCheckpointFilter = new NewCheckpointFilter(this);
    preciseInvFilter = new PreciseInvFilter(this);
    impreciseInvFilter = new ImpreciseInvFilter(this);
    splitManager = new TraceSplitManager(this);
    certificateObj = new ObjId(certificateDir +  core.getMyNodeId());
    this.livenessFilter = livenessFilter;
    livenessFilter.initialize(this);
    
  }
  
  /**
   * Create and return a BranchManager 
   * 
   */
  public BranchManager getBranchManager(){
    assert SangminConfig.forkjoin;
    return new BranchManager(branchKnowledge, (ForkableAHSMap)ahsMap);
  }
  
  public AcceptVV getCurrentVV(){
    return ahsMap.getKnowledge().getCurrentVV();
  }
  
  public Knowledge getKnowledge(){
    return ahsMap.getKnowledge();
  }
  
  public void addFilter(Filter f){
    myFilters.add(f);
    myTotalFilter = new OrFilter(myFilters);
    assert false: "more work needed here";
  }
  
  public void removeFilter(Filter f){
    myFilters.remove(f);
    myTotalFilter = new OrFilter(myFilters);
  }
  
  public Filter getFilter(){
    return this.myTotalFilter;
  }
  
  public void setFilter(Collection<Filter> filters){
    core.specialLock();
    System.out.println(" prior filters " + myFilters + " replaced by " + filters);
    try{
    myFilters.clear();
    myFilters.addAll(filters);
    myTotalFilter = new OrFilter(myFilters);
    ahsMap.setFilter(filters);
    }
    finally{
      core.specialUnlock();
    }
  }
  
//  public SecurityFilter(SecureCore core, SecureRMIClient rmiClient){
//    if(SangminConfig.securityLevel > SangminConfig.SIGNATURE){
//      ahsMap = new AHSMap();      
//      setInteracted = new HashSet<NodeId>();
//      lastDVV = AcceptVV.makeVVAllNegatives().dropNegatives();
//    }
//    this.core = core;
//    secureRMIClient =rmiClient;
//    numReceivedInv = 0;
//    hashMap = new HashMap<SecurePreciseInv, SecurePreciseInv>();
//
//    NewCheckpointFilter = new NewCheckpointFilter(this);
//    preciseInvFilter = new PreciseInvFilter(this);
//    impreciseInvFilter = new ImpreciseInvFilter(this);
//    splitManager = new TraceSplitManager(this);
//    certificateObj = new ObjId(certificateDir +  core.getMyNodeId());
//    this.livenessFilter = new TrustedServerTraceLivenessFilter(null, this);
//  }
  
  public void close(){
    if(SangminConfig.securityLevel > SangminConfig.SIGNATURE){
      System.out.println("close called");
      core.specialLock(); assert !closed;
      closed = true;
      ahsMap.close();
      setInteracted.clear();
      core.specialUnlock();
    }
  }

  /**
   *  added by zjd
   * 
   *  create a SecureInMemLogIterator to iterate all items in log
   */
  public SecureInMemLogIterator makeSecureInMemLogIterator(AcceptVV excludedStartVV){
    SecureInMemLogIterator ret;
    core.specialLock(); assert !closed;
    ret = new SecureInMemLogIterator(excludedStartVV, ahsMap);
    core.specialUnlock();
    return ret;
  }


  /**
   *  added by princem
   * 
   *  create a SecureInMemLogIterator to iterate all items in log starting at endVV (endVV should not be included)
   *
   */
  public SecureReverseTreeNodeIterator makeSecureReverseTreeNodeIterator(AcceptVV endVV){
    SecureReverseTreeNodeIterator ret;
    core.specialLock(); assert !closed;
    ret = new SecureReverseTreeNodeIterator(endVV, ahsMap);
    core.specialUnlock();
    return ret;
  }

  /**
   *  added by princem
   * 
   *  create a SecureInMemLogIterator to iterate all items in log starting at endVV (endVV should not be included)
   */
  public SecureTreeNodeIterator makeSecureTreeNodeIterator(AcceptVV endVV){
    SecureTreeNodeIterator ret;
    core.specialLock(); assert !closed;
    ret = new SecureTreeNodeIterator(endVV, ahsMap);
    core.specialUnlock();
    return ret;
  }

  /**
   * returns whether the ihVector is ordered by ensuring that the first entry's start time matches the start value and last entry's 
   * end time matches end time
   * @param ihVector
   * @param start
   * @param end
   * @return
   */
  public boolean isValidIHVector(Vector<IH> ihVector, long start, long end){
    return (ihVector.size() > 0 && 
        ihVector.firstElement().getStartTS() == start && 
        ihVector.lastElement().getEndTS() == end);
  }

  /***
   * 
   * @return hash of the status of log with respect to vv
   */
  public SummaryHash getSummaryHash(VV vv){
    core.specialLock();
    try{          
      return this.getSummaryHash(new DependencyVV(vv));      
    }finally{
      core.specialUnlock();
    }
  }
  
  
  public AHSEntry getAHSEntryWithSH(AHSEntry ahsEntry){
    if(!SangminConfig.optimizeDVVMapHashes){
      return ahsEntry;
    }
    // add the SHs to the AHSEntry whereever missing
    DVVMap dvvMap = ahsEntry.getMaxDVVMap();
    Hashtable<NodeId, DVVMapEntry> newDVVMap = new Hashtable<NodeId, DVVMapEntry>();
    boolean modified = false;
    for(NodeId nodeId: dvvMap.getNodeSet()){
      DVVMapEntry dme = dvvMap.getEntry(nodeId);
      if(!dme.hasHash()){
        AHS ahs = ahsMap.asAHS(nodeId, dme.getTimeStamp());
        if(SangminConfig.sanityCheck){
          List<AHSEntry> ahsEntries = ahs.getSortedListOfEntries();
          assert ahsEntries.size()>0:" ahsEntry " + ahsEntry + " node " + nodeId;
          assert ahsEntries.get(ahsEntries.size()-1).getEndTS() == dme.getTimeStamp(): ahsEntries + " ahsEntry " + ahsEntry + " node " + nodeId;
        }
        dme = new DVVMapEntry(dme.getTimeStamp(), ahs.getHash());
        modified = true;
      }
      newDVVMap.put(nodeId, dme);
    }
    if(!modified){
      return ahsEntry;
    }else{
      return new AHSEntry(ahsEntry.getLevel(), ahsEntry.getHash(), ahsEntry.getStartTS(), ahsEntry.getEndTS(), ahsEntry.getInvalTarget(), new DVVMap(newDVVMap), null);
    }
  }
  
  public SecurePreciseInv getSecurePreciseInvWithSH(SecurePreciseInv spi){
    if(!SangminConfig.optimizeDVVMapHashes){
      return spi;
    }
    if(spi.isHasHash()){
      return spi;
    }else{
      return spi.setHasHash(this.getSummaryHash(spi.getDVV()));
    }
  }
  
  public SecurePreciseInv getSecurePreciseInvWithoutSHAndSignature(SecurePreciseInv spi){
    if(!SangminConfig.optimizeDVVMapHashes){
      return spi;
    }
    if(!spi.isHasHash()){
      return spi;
    }else{
      return spi.resetHasHashAndSignature();
    }
  }
  

  
  /***
   * create DVV for a new precise update based on the current status of log
   * 
   * @return
   */
  DependencyVV generateDVV(){
    core.specialLock(); assert !closed;
    try{

//    DependencyVV dvv = new DependencyVV();

//    if(!useDVV ){
//    dvv = new DependencyVV(core.getCurrentVV());

//    }else{

//    for( Iterator<NodeId> i = setInteracted.iterator(); i.hasNext();){
//    NodeId nodeId = i.next();
//    try{
//    long ts = core.getCurrentVV().getStampByServer(nodeId);
//    //assert(ts >= 0);
//    if(ts >=0){
//    dvv.put(nodeId, ts);
//    }
//    } catch (Exception e){
//    // Can't reach here
//    System.err.println(e.toString());
//    e.printStackTrace();
//    System.err.println("!!!!!!!! nodeid :" + core.getMyNodeId().getIDint());
//    System.err.println("!!!!!!!! my nodeid :" +  core.getMyNodeId().getIDint());
//    System.exit(-1);
//    }
//    }
//    }

      AcceptVV cvv = core.getCurrentVV().dropNegatives();
      AcceptVV usefulVV = cvv.getDiff(lastDVV);
//    assert usefulVV.equalsIgnoreNegatives(dvv): "lastDVV " +lastDVV + " cvv " + cvv + " usefulVV " + usefulVV + " dvv " +dvv;
      lastDVV = cvv;

      return new DependencyVV(usefulVV);
//    return dvv;
    }
    finally{
      core.specialUnlock();
    }
  }

  /**
   * returns the most precise secure invalidate that covers the ts
   * @param nodeId
   * @param ts
   * @return
   */
  public SecureInv getSecureInvbyTS(NodeId nodeId, long ts){
    core.specialLock(); assert !closed;
    TreeNode t = ahsMap.getTreeNodeTS(nodeId, ts);
     
    if(t!=null){
      core.specialUnlock();
      return (SecureInv)t.getInv();
    }else{
      core.specialUnlock();
      return null;
    }
  }

  /**
   * compute the maxDVV for updates in the range of startTS to endTS
   * @param writer
   * @param startTS
   * @param endTS
   * @return
   */
  public AcceptVV getMaxDVV(NodeId writer, long startTS, long endTS){
    core.specialLock(); assert !closed;
//  System.out.println("!!! getNaxDVV node : " + writer + " , startTS:"+startTS+",endTS:"+endTS);
    Vector<IH> vecIH = ahsMap.generateIHs(writer, startTS, endTS);
    if(vecIH.size() > 0 && startTS >= 0){
      //princem: I think this assertion should be there without the if clause
      assert vecIH.get(0).getStartTS() == startTS && vecIH.get(vecIH.size() - 1).getEndTS() == endTS: vecIH + " start " + startTS + " endTS: " + endTS;
    }
    CounterVV maxDVV = new CounterVV();
    for(IH ih: vecIH){
      //System.out.println("ih : " + ih.getAHSEntry());
      DependencyVV dvv = ih.getAHSEntry().getMaxDVVMap().getDVV();
      //System.out.println("dvv : " + dvv);
      maxDVV.addMaxVV(dvv);
    }
    //System.out.println("returning : " + maxDVV);
    core.specialUnlock();
    return maxDVV.cloneAcceptVV();
  }

  /**
   * compute the maxDVV for updates in the range of startTS to endTS
   * @param writer
   * @param startTS
   * @param endTS
   * @return
   */
  public AcceptVV getMaxDVV(VV startVV, VV endVV){
    core.specialLock(); assert !closed;
    VVIterator vvIter = null;
    NodeId token;
    long timeStamp;
    CounterVV cvv = new CounterVV();
    
    for(vvIter = endVV.getIterator(); vvIter.hasMoreElements();){
      token = vvIter.getNext();
      timeStamp = endVV.getStampByIteratorToken(token);
      if(timeStamp >=0 ){
        if(startVV.containsNodeId(token)){
          try{
            cvv.advanceTimestamps(getMaxDVV(token, startVV.getStampByServer(token), timeStamp));
          }catch(NoSuchEntryException e){
            assert false;
            // TODO Auto-generated catch block
            e.printStackTrace();
          }
        }else{
        cvv.advanceTimestamps(getMaxDVV(token, -1, timeStamp));
        }
      }
    }
    core.specialUnlock();
    return cvv.cloneAcceptVV();
  }




  
  /** 
   *  getSecureCheckpoint() 
   *  startVV: inclusion startVV 
   *  endVV: inclusion endVV 
   **/ 
  public SecureCheckpoint getSecureCheckpoint(
      AcceptVV startVV, 
      boolean withBody,
      AcceptVV endVV, 
     /* boolean includeAll,*/ 
      LivenessFilter lf, 
      Filter f, 
      FilterKnowledge fk){

    core.specialLock(); assert !closed;

    //System.out.println("GetCheckpoint: " + ahsMap);
    SecureCheckpoint chkPt = newCheckpointFilter.getSecureCheckpoint(startVV, withBody, endVV/*, includeAll*/, lf, f, fk);
    //    if(dbg)System.out.println("GetCheckpoint return: " + ahsMap.toLongString() + "\n ahsMap " + ahsMap);

    //    if(dbg)assert verifyCheckpoint(chkPt, new LinkedList<GeneralInv>(), core.getMyNodeId(), getCurrentVV());
    
    core.specialUnlock();
    return chkPt;
  }


  //all the state modification should take place here
  void apply(GeneralInv gi, AcceptVV initialVV){
    core.specialLock(); assert !closed;
//  System.out.println("## Now applying it: " +gi);

    long start=0,end=0;
    assert(SangminConfig.securityLevel > SangminConfig.SIGNATURE);
    assert(gi instanceof SecureInv);
    if(measureTime){
      start = System.currentTimeMillis();
    }
    if( gi instanceof SecurePreciseInv){
      SecurePreciseInv spi = (SecurePreciseInv)gi;
      if(!spi.getCreator().equals(core.getMyNodeId())){
        setInteracted.add(spi.getNodeId());
      }
      try{
        ahsMap.applySecurePreciseInv((SecurePreciseInv)gi);
        if(SangminConfig.forkjoin){
          // This seems very inefficient when many Invs are applied
         // branchKnowledge.applyInval(spi, ahsMap.getHash(spi.getNodeId()));
          assert false;
        }
      }catch(UnmatchingTreeNodeException e){
        assert false;
      }
      if(measureTime){
        end = System.currentTimeMillis();
        LatencyWatcher.put("SecurityFilter.SecurePreciseInvApplication", 
            (end - start));
      }
    }else {
      assert(gi instanceof SecureImpreciseInv);
      SecureImpreciseInv sii = (SecureImpreciseInv)gi;
      //first get the diff from counterVV

    }

    // local write
    if(initialVV != null){
      AcceptVV advancedVV = AcceptVV.decrementAll(gi.getEndVV().getRealDiff(initialVV)).dropNegatives();
      setInteracted.addAll(advancedVV.getSortedNodeList());
    }

    core.specialUnlock();
  }

  /**
   * print the first differing treeNode between the sender and receiver for a given Node n and timestamp ts
   * @param sender
   * @param n
   * @param ts
   * @return true if there is any difference, false otherwise
   */
  public boolean findDifference(NodeId sender, NodeId n, long ts){
    long diffStart = 0, diffEnd = ts; // the region of potential difference 
    boolean difference = false;
    while(!difference && diffStart <= diffEnd){
      try{
        AHS otherAHS = secureRMIClient.getAHS(sender, diffStart, diffEnd, n);
      }catch(RMINetworkException e){
        // TODO Auto-generated catch block
        e.printStackTrace();
      }catch(RMIApplicationException e){
        // TODO Auto-generated catch block
        e.printStackTrace();
      }
      AHS myAHS = ahsMap.createAHS(n, diffStart, diffEnd);
    }
    return difference;
  }
  
  public SecureImpreciseInv getSplitSecureImpreciseInv(long start, long split, long end, NodeId nId){
    //if start - split - end time is present return that start-split, split-end
    /// else need to an imprecise inval containing start-split s.t. covers start and split and is split at split point
    // this can be done by finding the start ts of the treenode containing start and the end time of the inval covering split
    assert(end != split);
    SecureImpreciseInv sii;
    core.specialLock(); assert !closed;
    sii = splitManager.getSplitSecureImpreciseInv(start, split, end, nId);
    core.specialUnlock();
    return sii;
  }


  public PreciseInv createPreciseInval(PreciseInv inv, ImmutableBytes buffer){
    PreciseInv ret = null;
    core.specialLock(); assert !closed;

    ret = preciseInvFilter.createPreciseInval(inv, buffer);
    
    core.specialUnlock();

    if(SangminConfig.securityLevel == SangminConfig.COMPLETE){
      livenessFilter.getCA().notifyUpdateProcessed((SecurePreciseInv)ret);
    }
    return ret;

  }

  public void createNewCertificate(){
    livenessFilter.getCA().createNewCertificate();
  }
  
  public AcceptVV getLastCertificate(){
    return livenessFilter.getCA().lastCertifiedVV();
  }
  
  public ImpreciseInv createImpreciseInv(ImpreciseInv iInv){
    ImpreciseInv inv = null;
    core.specialLock(); assert !closed;
    inv = impreciseInvFilter.createImpreciseInv(iInv);
    core.specialUnlock();
    return inv;
  }

  public boolean verifyCheckpoint(SecureCheckpoint chkPt, LinkedList<GeneralInv> giList,  NodeId sender, AcceptVV initialVV){
    boolean res = false;
    //System.out.println("reached SecurityFilter.verifyCheckpoint");
    core.specialLock(); assert !closed;
    assert (!sanityCheck || ahsMap.isLinear());

    //System.out.println("grabbed lock at SecurityFilter.verifyCheckpoint");
    res = newCheckpointFilter.verifyCheckpoint(chkPt, giList, sender, initialVV);
    assert ahsMap.isLinear();

    core.specialUnlock();
    //System.out.println("exitted SecurityFilter.verifyCheckpoint");
    assert res: "this function has modified the AHS";
    return res;
  }

  /***
   * applies the split secure imprecise inv: if a valid tree node that needs to be split can be found then 
   * it is split using the given split secure imprecise inv and true is returned otherwise false is returned
   * @param ssii
   * @return
   */
  public boolean applySplitSecureImpreciseInv(SplitSecureImpreciseInv ssii, AcceptStamp as, NodeId sender){

    core.specialLock(); assert !closed;
    boolean ret = splitManager.applySplitSecureImpreciseInv(ssii, as, sender);
    core.specialUnlock();
    return ret;
  }

  public boolean apply(SecureCheckpoint chkPt, SecureConnectionState sic, NodeId sender){
    boolean ret = false;
    long start;
    LinkedList<GeneralInv> giList = null;
    
    if(measureTime){
      start = System.currentTimeMillis();
    }
    try{
      core.specialLock(); assert !closed;

      if(!chkPt.isEmpty()){
      if(!livenessFilter.shouldAccept(chkPt)){
        if(measureTime){
          LatencyWatcher.put("SecurityFilter.Liveness", 
              (System.currentTimeMillis() - start));    
        }
        assert false;
        return false;
      }
      if(measureTime){
        LatencyWatcher.put("SecurityFilter.Liveness", 
            (System.currentTimeMillis() - start));    
        start = System.currentTimeMillis();
      }

      giList = new LinkedList<GeneralInv>();
      if(dbg){
	  //	  System.out.println("AHSMap: " + ahsMap);
	  System.out.println("applying chkPt : " + chkPt);
      }
      assert (!sanityCheck || ahsMap.isLinear());
      AHSMap clonedAHSMap = (fast?ahsMap:ahsMap.clone());
      ret = newCheckpointFilter.apply(chkPt, sender, giList);
      if(!ret){
        assert false;
        ahsMap = clonedAHSMap;
      }
      if(measureTime){
        long time = System.currentTimeMillis()  - start;
        time -= (SplitManager.rmiTime + AHSMap.linkCheck  + SecurePreciseInv.encryptionTime + AHSMap.inclusionTime);
        LatencyWatcher.put("SecurityFilter.RMI", 
            SplitManager.rmiTime);
        LatencyWatcher.put("SecurityFilter.LinkCheck", 
            AHSMap.linkCheck);
        LatencyWatcher.put("SecurityFilter.Encryption", 
            SecurePreciseInv.encryptionTime);
        LatencyWatcher.put("SecurityFilter.Inclusion", 
            AHSMap.inclusionTime);
        LatencyWatcher.put("SecurityFilter.OtherCheckpoint", time);
        SplitManager.rmiTime = 0;
        SecurePreciseInv.encryptionTime = 0;
        AHSMap.linkCheck = 0;
        AHSMap.inclusionTime = 0;


      }
      assert ahsMap.isLinear();
      }else{
        System.out.println("Empty checkpoint received");
        ret = true;
        giList = new LinkedList<GeneralInv>();

      }
    }
    finally{
      core.specialUnlock();
      if(ret){
        if(measureTime){
          start = System.currentTimeMillis();
        }
        newCheckpointFilter.updateState(chkPt.getStartVV(),  giList, chkPt, sic);
        if(measureTime){
          long time = System.currentTimeMillis()  - start;
          LatencyWatcher.put("SecurityFilter.InsecureApply", 
              time);

        }
        for(GeneralInv gi: giList){
          if(gi instanceof SecurePreciseInv){
            livenessFilter.getCA().notifyUpdateProcessed((SecurePreciseInv)gi);
          }
        }
        livenessFilter.getCA().createNewCertificate();
      }
    }

//    System.out.println("AHSMap return: " + ahsMap);

    return ret;
  }

  public LinkedList<PreciseInv> getLastUpdateList(AcceptVV startVV,  
      SubscriptionSet ss, AcceptVV endVV){
    core.specialLock(); assert !closed;
    LinkedList<PreciseInv> lastUpdateList =  newCheckpointFilter.getLastUpdateList(startVV, ss, endVV);
    core.specialUnlock();
    return lastUpdateList;
  }

  public boolean verifyAndApply(GeneralInv gi, NodeId sender){

    assert gi instanceof SecureInv;

    core.specialLock(); assert !closed;
    if(!livenessFilter.shouldAccept((SecureInv)gi)){
      assert false;
      return false;
    }
    AHSMap clonedAHSMap = null;
    if(SangminConfig.securityLevel == SangminConfig.COMPLETE){
      clonedAHSMap = (fast?ahsMap:ahsMap.clone());
//      assert ahsMap.isLinear();
    }
    boolean ret = false;
    try{
      long start=0,end=0;

      if(dbg){
        //System.out.println("verifying " + gi);
        //new Throwable().printStackTrace();
      }

      assert(gi instanceof SecureInv) : "-----"+gi;
      SecureInv si = (SecureInv)gi;
      if(!verifySignature(si)){
        assert false;
        return false;
      }
      
      DependencyVV dvv = getSplitEndVVBetweenStartAndCVV(gi.getStartVV(), 
          gi.getEndVV(), core.getCurrentVV());
      if(!livenessFilter.ensureCompatibility(dvv, ahsMap, sender)){
        assert false;
        return false;
      }

      if(SangminConfig.securityLevel == SangminConfig.COMPLETE){
        assert(gi instanceof SecureInv);
        if(measureTime){
          start = System.currentTimeMillis();
        }

        if(gi instanceof SecurePreciseInv){
          assert(gi instanceof SecurePreciseInv);
          // can the precise inval be verified?
          if(!preciseInvFilter.getMaxDVV((SecurePreciseInv)gi, sender)){
            assert false;
            return false;
          }
          if(!preciseInvFilter.verifyPreciseInv((SecurePreciseInv)gi, this.getCurrentVV(), sender)){
            if(dbg){
              System.out.println("## Precise Invalidation security part failed!!");
              assert(false):gi;
            }
            assert false;
            return false;
          }
          AcceptVV initialVV = core.getCurrentVV();

          this.apply(gi, initialVV);
          
          System.out.println("+++");
        }
        else{
          assert(gi instanceof SecureImpreciseInv);
          SecureImpreciseInv sii = (SecureImpreciseInv)gi;
          
          AcceptVV cvv = this.getCurrentVV();

          if(!impreciseInvFilter.applyImprecise(sii, sender)){
            if(dbg){
              System.out.println("## Imprecise  Invalidation security part failed!!");
              assert(false):gi;
            }
            assert false;
            return false;
          }

          dvv = this.getSplitCVVBetweenStartAndEnd(sii.getStartVV(), 
              sii.getEndVV(), cvv);
          if(!livenessFilter.ensureCompatibility(dvv, ahsMap, sender)){
            assert false;
            return false;
          }

        }
      }

      if(measureTime){
        end = System.currentTimeMillis();
        LatencyWatcher.put("SecurityFilter.PreciseInvVerification", 
            (end - start));
      }
      System.out.println("+++ 2");
      ret = true;
      return true;

    }
    catch(Exception e){
      e.printStackTrace();
      assert false;
      return false;
    }
    finally{
      if(SangminConfig.securityLevel == SangminConfig.COMPLETE){
//        assert ahsMap.isLinear();
        if(!ret){
          assert false;
//          ahsMap = clonedAHSMap;
        }
      }
      core.specialUnlock();
      if(ret){
        if(gi instanceof SecurePreciseInv){
          livenessFilter.getCA().notifyUpdateProcessed((SecurePreciseInv)gi);
        }
        livenessFilter.getCA().createNewCertificate();
      }
    }


  }


  /**
   * find components of endVV that lie between startVV and CVV
   * @param startVV
   * @param endVV
   * @param currentVV
   * @return
   */
  DependencyVV getSplitEndVVBetweenStartAndCVV(AcceptVV startVV, AcceptVV endVV, AcceptVV currentVV){
    assert endVV.includes(startVV);
    DependencyVV dvv = new DependencyVV(endVV);
    VVIterator vvIter = null;
    Object token = null;
    NodeId nid = null;
    long timeStamp = 0;

    for(vvIter = endVV.getIterator(); vvIter.hasMoreElements();){
      token = vvIter.getNext();
      nid = endVV.getServerByIteratorToken(token);
      timeStamp = endVV.getStampByIteratorToken(token);
      try{
        if(!currentVV.containsNodeId(nid) || currentVV.getStampByServer(nid) < timeStamp){
          dvv.dropNode(nid);
        }
      }catch(NoSuchEntryException e){
        // TODO Auto-generated catch block

      }
    }
    return dvv;

  }

  /**
   * find components of currentVV that lie between startVV and endVV
   * @param startVV
   * @param endVV
   * @param currentVV
   * @return
   */
  DependencyVV getSplitCVVBetweenStartAndEnd(AcceptVV startVV, AcceptVV endVV, AcceptVV currentVV){
    assert endVV.includes(startVV);

    DependencyVV dvv = new DependencyVV(currentVV);
    VVIterator vvIter = null;
    Object token = null;
    NodeId nid = null;
    long endTS = 0;
    long startTS = 0;
    long cvv = 0;

    for(vvIter = currentVV.getIterator(); vvIter.hasMoreElements();){
      token = vvIter.getNext();
      nid = currentVV.getServerByIteratorToken(token);
      try{
        if(!endVV.containsNodeId(nid)){
          dvv.dropNode(nid);
	  if(dbg)System.out.println("Dropping nodeId " + nid + " remaining DVV" + dvv);
        }else{
          if(startVV.containsNodeId(nid)){
            startTS = startVV.getStampByServer(nid);
          }else{
            startTS = -1;
          }
          endTS = endVV.getStampByIteratorToken(token);
          cvv = currentVV.getStampByIteratorToken(token);
          if(cvv < startTS || cvv >= endTS){
            dvv.dropNode(nid);
	    if(dbg)System.out.println("Dropping nodeId " + nid + " remaining DVV" + dvv + " cvv " + cvv + " startTS " + startTS + " endTS " + endTS);
          }
        }
      }catch(NoSuchEntryException e){
        // TODO Auto-generated catch block
        assert false;
      }
    }
    return dvv;
  }

  public final AHSMap getAhsMap(){
    return ahsMap;
  }

  public void printStats(){
      //    for(SecurePreciseInv svvInv : hashMap.keySet()){
      // System.out.println("hops: " + svvInv.getHops());
      // }
    System.out.println("total received inval: " + numReceivedInv);

    Hashtable h = Stats.getStats();
    Enumeration e = h.keys();
    long tot = 0;
    while(e.hasMoreElements()){
      String key = (String)e.nextElement();
      Long value = (Long)h.get(key);

      System.out.println("Stats: " + key + " " + value);

      tot += value.longValue();
    }

    System.out.println("Total Bandwidth: " + tot);

    Vector<Integer> stats = ahsMap.stats();
    System.out.println("Total Storage size: " + stats.get(0));

    System.out.println("Total logical updates: " + stats.get(1));

  }

  /** 
   *  getSummaryHash() 
   **/ 
  SummaryHash getSummaryHash(DependencyVV dvv){

    core.specialLock(); assert !closed;
    try{
      ByteArrayOutputStream buffer = new ByteArrayOutputStream(dvv.getSize()*20);

      if(dvv.getSize() == 0 || dvv.getMaxTimeStamp() < 0){      
        return new SummaryHash("EmptyDVV".getBytes(), true);
      }

      Enumeration<NodeId> enu = dvv.getEnumeratedNodes();
      List<NodeId> l = Collections.list(enu);
      Collections.sort(l);
      ListIterator<NodeId> iter;

      int count = 0;
      for(iter = l.listIterator(); iter.hasNext();){
        try{
          NodeId nodeId = iter.next();
          if(SangminConfig.forkjoin){
            assert nodeId instanceof BranchID;
          }
          if(SangminConfig.useAHS){
            //ByteArrayOutputStream tempBuffer = new ByteArrayOutputStream();
            long ts = dvv.getStampByServer(nodeId); 
            if(ts<0){
              continue;
            }
            AHS ahs = ahsMap.asAHS(nodeId, ts);
            if(ahs.size() == 0){
              System.out.println("AHSMap" + ahsMap);
              System.out.println("Problem" + " ts: " + ts + " nodeId " + nodeId + " cvv " + core.getCurrentVV() + " dvv"+ dvv.toString());
            }else{
		count += 1;
	    }
            //princem: add hook to call controller here
            assert(!sanityCheck || ahs.elementAt(ahs.size()-1) == ahs.getSortedListOfEntries().get(ahs.size()-1));
            if( ahs.elementAt(ahs.size()-1).getEndTS() != ts){
              //TODO:Call controller?
              TreeNode containingTreeNode = ahsMap.getTreeNodeTS(nodeId, ts);

              if(SecurityFilter.dbg){
                System.out.println("need info about inval that has NodeId:" + nodeId + "EndTS " + ts);
              }
              assert(false);
            }else{
              
              buffer.write(ahs.getHash());
            }
          }else{
            //  InvalListItem invalListItem =
            //    l.findSecurePreciseInv(dvv.getLocalClock(nodeId));
            //  buffer.write(invalListItem.getChainHash().getHashVal());
          }

        } catch (Exception e){
          e.printStackTrace();
          System.exit(-1);
        }
      }
      //return new SummaryHash("TEST".getBytes());

      if(count == 1){
	  // if only one element, then returns its superhash; no need to hash again
	  return new SummaryHash(buffer.toByteArray(), false);
      }else{
	  return new SummaryHash(buffer.toByteArray(), true);
      }
    }
    finally
    {
      core.specialUnlock();
    }
  }

  public boolean verifySignature(SecureInv si){
    long start=0,end=0;

    if(SecurityFilter.measureTime){
      start = System.currentTimeMillis();
    }
    if(SangminConfig.securityLevel >= SangminConfig.SIGNATURE){
      // Verify the sender's signature on this invalidation
      if(!si.verify((PublicKey)(Config.publicKeys.get(new Long(si.getCreator().getIDint()))))){
        if(SecurityFilter.measureTime){
          end = System.currentTimeMillis();
          LatencyWatcher.put("SecurityFilter.SignatureVerification", 
              (end - start));
        }
        if(SecurityFilter.dbg){
          System.out.println("## Verifying signature failed!!");
          System.out.println("Faked Assertion... : " + si);
          //assert(false):si;
        }
        return true;
      }
      if(SecurityFilter.measureTime){
        end = System.currentTimeMillis();
        LatencyWatcher.put("SecurityFilter.SignatureVerification", 
            (end - start));
      }
    }

    return true;

  }


  static DVVMap getMaxDVVMap(Vector<IH> v, NodeId writer){
    assert(v.size()>0);
    DVVMap maxDVVMap = new DVVMap();    
    Enumeration<IH> e = v.elements();
/*
 * princem: commented this code because supporting changes need to be made in the new "immutable" DVVMap
    //System.out.println("getMaxDVVMap");
    //Enumeration<NodeId> enu = dvv.getEnumeratedNodes();
    List<IH> l = Collections.list(e);
    Collections.sort(l);
    ListIterator<IH> iter;

    for(iter=l.listIterator(); iter.hasNext();){
      IH ih = iter.next();
      //System.out.println("+++ " + ih.getAHSEntry());
      maxDVVMap.extend(ih.getAHSEntry().getMaxDVVMap());
    }

    // we take minimum for the component of writer
    DVVMapEntry min = l.get(0).getAHSEntry().getMaxDVVMap().getEntry(writer);
    if(min!=null){
      maxDVVMap.put(writer,min);
    }else{
      maxDVVMap.remove(writer);
    }
*/
    return maxDVVMap;
  }
  
  /**
   * returns the DVVMap that must be verified for a given ts (all the previous unverified DVV entries are included)
   * @param writer
   * @param ts
   * @return
   */
  DVVMap getNewMaxDVVMap(NodeId writer, long ts){
    return ahsMap.getUnverifiedIDVV(writer, ts);
  }

  public final LivenessFilter getLivenessFilter(){
    return livenessFilter;
  }
  
  public LivenessCertificate createCertificate(AcceptStamp as, AcceptStamp rs, AcceptVV certifiedVV){
    assert (livenessFilter.getCA().lastCertifiedVV().equals(certifiedVV));
    LivenessCertificate lc = null;
    core.specialLock(); assert !closed;
    try{
      DependencyVV dvv = this.generateDVV();
      SummaryHash sh = getSummaryHash(dvv);
      lc = new LivenessCertificate(new ObjInvalTarget(certificateObj, 0, 1), as, rs, dvv, sh, certifiedVV, 
          (PrivateKey)(Config.privateKeys.get(new Long(core.getMyNodeId().getIDint()))));
      this.apply(lc, null);
      //getKnowledge().apply(lc);
    }
    finally{
      core.specialUnlock();
      livenessFilter.getCA().notifyUpdateProcessed(lc);
    }
    return lc;
  }

  
  public CostPredicate getHoleCostPredicate(SubscriptionSet ss){
    core.specialLock();
    AcceptVV lpvv = null;
    AcceptVV cvv = null;
    Hashtable<NodeId, List<Range>> holes = null;
   
    try{
      cvv = getCurrentVV().dropNegatives();
      holes = new Hashtable<NodeId, List<Range>>();
      
      if(ss.isEmpty()){
        return new CostPredicate(AcceptVV.makeVVAllNegatives(), cvv, holes);
      }
      lpvv = core.getLpVV(ss).dropNegatives();
      AcceptVV realDiff =  AcceptVV.decrementAll(cvv.getRealDiff(lpvv)).dropNegatives();
      AcceptVV endVV = cvv.project(realDiff);
      AcceptVV startVV = lpvv.project(realDiff);

      //streamCVV = streamCVV.getDiff(startVV);
      //startVV = startVV.project(streamCVV);
      if(!startVV.includes(endVV)){

        for(AcceptStamp as: endVV.getAllStamps()){
          
          List<Range> list = new LinkedList<Range>();
          TreeNode tn = ahsMap.getLeafNodeTS(as.getNodeId(), as.getLocalClock());
          long limit = -1;
          try{
            limit = (startVV.containsNodeId(as.getNodeId())?startVV.getStampByServer(as.getNodeId()):-1);
          }catch(NoSuchEntryException e){
            // TODO Auto-generated catch block
            e.printStackTrace();
          }
          long end = -1;
          long start = -1;
          while(tn!=null && !(tn.getEndTS() <= limit)){
	      //	      System.out.println("tree node " + tn);
            if(tn.getInvalTarget().intersects(ss) && !(tn.getInv() instanceof PreciseInv)){
              if(end == -1){
                end = tn.getEndTS();
              }
              start = tn.getStartTS();
            }{
              if(end != -1){
                list.add(new Range(start, end));
              }
            }
            tn = tn.getPrev();
          }
          holes.put(as.getNodeId(), list);
        }

      }
      return new CostPredicate(lpvv, cvv, holes);
      
    }
    finally{
      core.specialUnlock();
    }

  }
}
