package code.security;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;

import code.AcceptStamp;
import code.AcceptVV;
import code.GeneralInv;
import code.ImpreciseInv;
import code.LatencyWatcher;
import code.NoSuchEntryException;
import code.NodeId;
import code.RMIApplicationException;
import code.RMINetworkException;
import code.VV;
import code.VVIterator;
import code.security.ahs.IH;
import code.security.ahs.NodeAHSTuple;
import code.security.ahs.AHSMap;
import code.security.ahs.TreeNode;
import code.security.*;

public class SplitManager {

  SecurityFilter securityFilter;

  int splitCount = 0;
  
  public static long rmiTime = 0;
  static boolean advance = true;
  
  public SplitManager(SecurityFilter securityFilter)
  {
    this.securityFilter = securityFilter;
  }

//  SecureImpreciseInv oldgetSplitSecureImpreciseInv(long start, long split, long end, NodeId nId){
//    //if start - split - end time is present return that start-split, split-end
//    /// else need to an imprecise inval containing start-split s.t. covers start and split and is split at split point
//    // this can be done by finding the start ts of the treenode containing start and the end time of the inval covering split
//    assert(end != split);
//
//    RootList rootList = securityFilter.getAhsMap().getRootList(nId);
//    // first check if a tree node containing start-end
//    Vector<IH> ahsVector = securityFilter.getAhsMap().generateIHs(nId, start, end);
//    // assuming ahsVector is sorted
//    if(ahsVector.size() > 0 && 
//        securityFilter.isValidIHVector(ahsVector, start, end)){
//      // check if we can construct a split secure imprecise inval
//      Vector<IH> range1 = securityFilter.getAhsMap().generateIHs(nId, start, split);
//      TreeNode t = rootList.getTreeNodeTS(split);
//
//      if(t.getNext() != null && securityFilter.isValidIHVector(range1, start, split)){
//        long splitNextStart = t.getNext().getStartTS();
//        Vector<IH> range2 = securityFilter.getAhsMap().generateIHs(nId, splitNextStart, end);
//        if(securityFilter.isValidIHVector(range2, splitNextStart, end)){
//          range1.addAll(range2);
//          assert ahsVector.size() == 1;
//          Hashtable<NodeId, Vector<IH>> ihTuples = new Hashtable<NodeId, Vector<IH>>();
//          ihTuples.put(nId, range1);
//          assert range1.size() > 1:range1;
//          AcceptStamp startAS = new AcceptStamp(start, nId);
//          AcceptStamp endAS = new AcceptStamp(end, nId);
//          SecureImpreciseInv ret =
//            new SplitSecureImpreciseInv(ahsVector.firstElement().getInvalTarget(), 
//                new AcceptVV(startAS), 
//                new AcceptVV(endAS), 
//                securityFilter.core.getMyNodeId(), 
//                ihTuples);
//          return ret;
//        }
//      }
//
//
//    }
//
//    try{
//      // else we can't produce a splitImpreciseInv or send an invalidate from startTreeNode.startTS-splitTreeNode's update->endTS
//      long iistartTime = rootList.getTreeNodeTS(start).getStartTS();
//      SecureInv si =rootList.getTreeNodeTS(split).getInv();
//      long iiendTime;
//      if(si instanceof SecureCheckpoint){
//        iiendTime = ((SecureCheckpoint)si).getEndVV().getStampByServer(nId);
//      }else{
//        iiendTime = ((GeneralInv)si).getEndVV().getStampByServer(nId);
//      }
//      Hashtable<NodeId, Vector<IH>> ihTuples = new Hashtable<NodeId, Vector<IH>>();
//      Vector<IH> range1 = securityFilter.getAhsMap().generateIHs(nId, iistartTime, iiendTime);
//
//      ihTuples.put(nId, range1);
//      SecureImpreciseInv ret =
//        (SecureImpreciseInv)this.securityFilter.createImpreciseInv(this.securityFilter.impreciseInvFilter.getInsecureImpreciseInv(ihTuples));
//      return ret;
//
//
//    }catch(NoSuchEntryException e){
//      // TODO Auto-generated catch block
//      e.printStackTrace();
//      assert false;
//    }
//    assert false; 
//    return null;
//  }

  public SecureImpreciseInv getSplitSecureImpreciseInv(long start, long split, long end, NodeId nId){
    //if start - split - end time is present return that start-split, split-end
    /// else need to an imprecise inval containing start-split s.t. covers start and split and is split at split point
    // this can be done by finding the start ts of the treenode containing start and the end time of the inval covering split
    assert(end != split);

    AHSMap ahsMap = securityFilter.getAhsMap();
    // first check if a tree node containing start-end
    Vector<IH> ahsVector = securityFilter.getAhsMap().generateIHs(nId, start, end);
    // assuming ahsVector is sorted
    if(ahsVector.size() > 0 && 
        securityFilter.isValidIHVector(ahsVector, start, end)){
      // check if we can construct a split secure imprecise inval
      Vector<IH> range1 = securityFilter.getAhsMap().generateIHs(nId, start, split);
      TreeNode t = ahsMap.getTreeNodeTS(nId, split);

      if(t.getNext() != null && securityFilter.isValidIHVector(range1, start, split)){
        long splitNextStart = t.getNext().getStartTS();
        Vector<IH> range2 = securityFilter.getAhsMap().generateIHs(nId, splitNextStart, end);
        if(securityFilter.isValidIHVector(range2, splitNextStart, end)){
          range1.addAll(range2);
          assert ahsVector.size() == 1;
          Hashtable<NodeId, Vector<IH>> ihTuples = new Hashtable<NodeId, Vector<IH>>();
          ihTuples.put(nId, range1);
          assert range1.size() > 1:range1;
          AcceptStamp startAS = new AcceptStamp(start, nId);
          AcceptStamp endAS = new AcceptStamp(end, nId);
          SecureImpreciseInv ret =
            new SplitSecureImpreciseInv(ahsVector.firstElement().getInvalTarget(), 
                new AcceptVV(startAS), 
                new AcceptVV(endAS), 
                securityFilter.core.getMyNodeId(), 
                ihTuples);
          return ret;
        }
      }


    }

    //assert false; 
    return null;
  }

  /***
   * applies the split secure imprecise inv: if a valid tree node that needs to be split can be found then 
   * it is split using the given split secure imprecise inv and true is returned otherwise false is returned
   * @param ssii
   * @return
   */
  boolean applySplitSecureImpreciseInv(SplitSecureImpreciseInv ssii, AcceptStamp as, NodeId sender){

    assert securityFilter.core.specialLockHeldByMe();

    if(SecurityFilter.measureTime){
      int bwCost = 32 + ssii.size(); // startTS, endTS, splitTS, nodeId
      System.out.println("remoteRMI bw cost " + bwCost);
    }
    if(SecurityFilter.dbg)System.out.println("Received " + ssii);

    // find the tree node containing this range: if no such tree node exists return false;
    NodeId nodeId = null;
    if(ssii.ihTuples.size() != 1){
      assert false;
      return false;
    }else{
      nodeId = ssii.getEndVV().getIterator().getNext();
    }
    Vector<NodeAHSTuple> ahsVector = securityFilter.getAhsMap().generateAHS(ssii.getStartVV(), ssii.getEndVV());
    if(ahsVector.size() != 1){
      assert false;
      return false;
    }else{
      NodeAHSTuple nodeAHSTuple = ahsVector.firstElement();
      if(!nodeAHSTuple.getNodeId().equals(nodeId)){
        assert false;
        return false;
      }else if(nodeAHSTuple.getAHS().size() != 1 ){
        assert false;
        return false;
      }else{
        try{
          if(nodeAHSTuple.getAHS().elementAt(0).getStartTS() != ssii.getStartVV().getStampByServer(nodeId) || 
              nodeAHSTuple.getAHS().elementAt(0).getEndTS() != ssii.getEndVV().getStampByServer(nodeId)){
            assert false;
            return false;
          }
        }catch(NoSuchEntryException e){
          // TODO Auto-generated catch block
          assert false: e;
        return false;
        }
        if(!securityFilter.impreciseInvFilter.tryAndApply(ssii, sender)){
          assert false;
          return false;
        }
      }
    }
    return true;
  }
  
  public boolean tryAndSplit(VV maxDVV, NodeId sender){
    return this.tryAndSplit(maxDVV, sender, true);
  }

  /**
   * ensure that the maxDVV can be satisfied based on local state and potentially by fetching more information from 
   * other nodes based on liveness policy
   * @param maxDVV
   * @param sender
   * @return
   */
  public boolean tryAndSplit(VV maxDVV, NodeId sender, boolean contactRemoteNode){
    VVIterator vvi = maxDVV.getIterator();
    NodeId nodeId;
    while(vvi.hasMoreElements()){
      nodeId = vvi.getNext();
      if(!tryAndSplit(nodeId, maxDVV.getStampByIteratorToken(nodeId), sender, contactRemoteNode)){
        return false;
      }
    }
    //System.out.println("tryAndSplit split" + maxDVV + " returning true");
    return true;
  }
  
  
  boolean tryAndSplit(NodeId nodeId, long ts, NodeId sender, boolean contactRemoteNode){
    long start;
    TreeNode splitTreeNode = securityFilter.getAhsMap().getLeafNodeTS(nodeId, ts);
    assert splitTreeNode != null && splitTreeNode.getEndTS() >= ts: "nodeId " + nodeId + " ts" + ts + " splitTreeNode " + (splitTreeNode!=null?splitTreeNode:"NULL") + " ahsMap " + securityFilter.getAhsMap().getRootList(nodeId);
    if(splitTreeNode.getEndTS() > ts && contactRemoteNode){
      // make the call
      // apply the returned val
      if(SecurityFilter.measureTime){
        start = System.currentTimeMillis();
      }
      System.out.println( ts + " " + nodeId + " "  +sender + " splitTreeNode " + splitTreeNode);
      try{
        
        
	//princem: performance modification
	ImpreciseInv ii = securityFilter.secureRMIClient.getSplitSecureImpreciseInv(splitTreeNode.getStartTS(), ts, splitTreeNode.getEndTS(), sender, nodeId);
	if(ii == null){
	  if(!nodeId.equals(sender) && advance){
	    System.out.println("tryAndSplit contacting remote node" + (this.splitCount++));
	    advance = false;
	  }
          ii = securityFilter.secureRMIClient.getSplitSecureImpreciseInv(splitTreeNode.getStartTS(), ts, splitTreeNode.getEndTS(), nodeId, nodeId);
	}
        if(!(ii instanceof SecureImpreciseInv)){
          assert false:ii;
        return false;
        }
        SecureImpreciseInv si = (SecureImpreciseInv)ii;
        if(si instanceof SplitSecureImpreciseInv){
          SplitSecureImpreciseInv ssii = (SplitSecureImpreciseInv)si;
          if(ssii != null){
            // check if the ssii is split at the desired split point
            if(ssii.isSplit(nodeId, ts) && applySplitSecureImpreciseInv(ssii, new AcceptStamp(ts, nodeId), sender)){
              // do nothing
            }else{
              assert false;
              return false;
            }
          }else{
            assert false;
            return false;
          }
        }else{
          assert false: "Expecting split secure imprecise inval, got an imprecise inval instead" + ii + " ts " +ts + " nodeId " + nodeId;
//      try{
//      if(!si.getEndVV().containsNodeId(nodeId) || 
//      si.getEndVV().getStampByServer(nodeId) < ts || 
//      !si.isSplit(nodeId, ts)){
//      assert false;
//      return false;
//      }else if(!this.securityFilter.verifyAndApply(si, sender)){
//      assert false;
//      return false;
//      }
//      }catch(NoSuchEntryException e){
//      // TODO Auto-generated catch block
//      e.printStackTrace();
//      assert false;
//      return false;
//      }

        }
      }catch(RMINetworkException e){
        // TODO Auto-generated catch block
        e.printStackTrace();
        assert false;

      }catch(RMIApplicationException e){
        // TODO Auto-generated catch block
        e.printStackTrace();
        assert false;
        return false;
      }
      finally{
        if(SecurityFilter.measureTime){
          SplitManager.rmiTime += System.currentTimeMillis() - start;
        }
      }
    }
    
    return true;
  }


  /**
   * ensure that the maxDVV can be satisfied based on local state and potentially by fetching more information from 
   * other nodes based on liveness policy
   * @param maxDVV
   * @param sender
   * @return
   */
  boolean oldtryAndSplit(VV maxDVV, NodeId sender){
    VVIterator vvi = maxDVV.getIterator();
    NodeId nodeId;
    while(vvi.hasMoreElements()){
      nodeId = vvi.getNext();
      long ts = maxDVV.getStampByIteratorToken(nodeId);
      TreeNode splitTreeNode = securityFilter.getAhsMap().getTreeNodeTS(nodeId, ts);
      assert splitTreeNode.getEndTS() >= ts;
      if(splitTreeNode.getEndTS() > ts){
        // make the call
        // apply the returned val
//      System.out.println( maxDVV + " " + nodeId + " "  +sender + " splitTreeNode " + splitTreeNode);
        try{
          //System.out.println("tryAndSplit contacting remote node" + maxDVV);
          ImpreciseInv ii = securityFilter.secureRMIClient.getSplitSecureImpreciseInv(splitTreeNode.getStartTS(), ts, splitTreeNode.getEndTS(), sender, nodeId);
          if(!(ii instanceof SecureImpreciseInv)){
            assert false:ii;
          return false;
          }
          SecureImpreciseInv si = (SecureImpreciseInv)ii;
          if(si instanceof SplitSecureImpreciseInv){
            SplitSecureImpreciseInv ssii = (SplitSecureImpreciseInv)si;
            if(ssii != null){
              // check if the ssii is split at the desired split point
              if(ssii.isSplit(nodeId, ts) && applySplitSecureImpreciseInv(ssii, new AcceptStamp(ts, nodeId), sender)){
                // do nothing
              }else{
                assert false;
                return false;
              }
            }else{
              return false;
            }
          }else{
            try{
              if(!si.getEndVV().containsNodeId(nodeId) || 
                  si.getEndVV().getStampByServer(nodeId) < ts || 
                  !si.isSplit(nodeId, ts)){
                assert false;
                return false;
              }else if(!this.securityFilter.verifyAndApply(si, sender)){
                assert false;
                return false;
              }
            }catch(NoSuchEntryException e){
              // TODO Auto-generated catch block
              e.printStackTrace();
              assert false;
              return false;
            }

          }
        }catch(RMINetworkException e){
          // TODO Auto-generated catch block
          e.printStackTrace();
          assert false;

        }catch(RMIApplicationException e){
          // TODO Auto-generated catch block
          e.printStackTrace();
          assert false;
          return false;
        }
      }
    }
    //System.out.println("tryAndSplit split" + maxDVV + " returning true");
    return true;
  }


}
