package code.security;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PrivateKey;
import java.util.Hashtable;
import java.util.Vector;

import code.AcceptVV;
import code.Config;
import code.InvalTarget;
import code.NodeId;
import code.security.ahs.IH;

/**
 *  Requested by a receiver when it can not verify an invalidation because its dvv is hit 
 *  some imprecise ih.
 *   
 *  This invalidation has the complement precise information (the right stop of the hash values)
 *  that the receiver needed to verify something.
 */
public class SplitSecureImpreciseInv extends SecureImpreciseInv{
  
  private SplitSecureImpreciseInv(){
    super();
  }
  
  public SplitSecureImpreciseInv(SecureImpreciseInv source){
    super(source.getInvalTarget(), 
          source.getStartVV(), 
          source.getEndVV(),
          source.getCreator(), 
          source.getIHTuples(), 
          source.getSignature());
  }
  
  public SplitSecureImpreciseInv(InvalTarget invalTarget_,
      AcceptVV startTime_,
      AcceptVV endTime_,
      NodeId myNodeId,
      Hashtable<NodeId,Vector<IH>> ihTuples_)
  {
    super(invalTarget_, startTime_, endTime_, myNodeId, ihTuples_, null);
  }
  
  public TestClass getTestClass(){
    TestClass tc = super.getTestClass();
    tc.isSplit = true;
    return tc;
  }
  
  public String toString(){
    return "SplitSecureImpreciseInv:: " + super.toString();
  }
  private void writeObject(ObjectOutputStream out) throws IOException{
    
  }
  
  public int size(){
    int s = 0;
    for(NodeId n: ihTuples.keySet()){
      for(IH ih: ihTuples.get(n)){
        s += ih.getAHSEntry().getSize().get("PhysicalOnDiskSize");
      }
    }
    return s;
  }
  
  private void readObject(ObjectInputStream in) 
  throws IOException, ClassNotFoundException{
  
  }
  
}
