package code.security;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;

import code.AcceptStamp;
import code.AcceptVV;
import code.GeneralInv;
import code.ImpreciseInv;
import code.NoSuchEntryException;
import code.NodeId;
import code.RMIApplicationException;
import code.RMINetworkException;
import code.VV;
import code.VVIterator;
import code.security.ahs.IH;
import code.security.ahs.NodeAHSTuple;
import code.security.ahs.RootList;
import code.security.ahs.TreeNode;

public class TraceSplitManager extends SplitManager {
  
  public static NodeId trustedNode = null; 
  TraceSplitManager(SecurityFilter securityFilter)
  {
    super(securityFilter);
  }

  /**
   * ensure that the maxDVV can be satisfied based on local state and potentially by fetching more information from 
   * other nodes based on liveness policy
   * @param maxDVV
   * @param sender
   * @return
   */
  public boolean tryAndSplit(VV maxDVV, NodeId sender){
    if(trustedNode == null){
      return super.tryAndSplit(maxDVV, sender);
    }else{
      return super.tryAndSplit(maxDVV, trustedNode);
    }
  }
  
  /**
   * ensure that the maxDVV can be satisfied based on local state and potentially by fetching more information from 
   * other nodes based on liveness policy
   * @param maxDVV
   * @param sender
   * @return
   */
  public boolean tryAndSplit(VV maxDVV, NodeId sender, boolean contactRemoteNode){
    if(trustedNode == null){
      return super.tryAndSplit(maxDVV, sender, contactRemoteNode);
    }else{
      return super.tryAndSplit(maxDVV, trustedNode, contactRemoteNode);
    }
  }
  
  boolean tryAndSplit(NodeId nodeId, long ts, NodeId sender, boolean contactRemoteNode){
    if(trustedNode == null){
      return super.tryAndSplit(nodeId, ts, sender, contactRemoteNode);
    }else{
      return super.tryAndSplit(nodeId, ts, trustedNode, contactRemoteNode);
    }
  }
  
  
}
 