package code.security.ahs;

import java.io.ByteArrayOutputStream;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;


import code.NodeId;
import code.security.DataHash;
import code.security.SangminConfig;

import java.io.Serializable;

public class AHS implements Serializable{

  private Vector<AHSEntry> ahsEntries;
  
  public AHS(){
    ahsEntries = new Vector<AHSEntry>();    
  }

  public AHS(AHSEntry ahsEntry){
    ahsEntries = new Vector<AHSEntry>();
    ahsEntries.add(ahsEntry);
  }
  
  public void add(TreeNode treeNode){
    ahsEntries.add(new AHSEntry(treeNode));
  }
  
  public void add(AHSEntry ahsentry){
    ahsEntries.add(ahsentry);
  }

  public AHSEntry removeFirst(){
    return (AHSEntry)ahsEntries.remove(0);
  }
  
  public AHSEntry elementAt(int index){
    return (AHSEntry)ahsEntries.elementAt(index);
  }
  
  public int size(){
    return ahsEntries.size();
  }
  
  public List<AHSEntry> getSortedListOfEntries(){    
    List<AHSEntry> ret = Collections.list(ahsEntries.elements());
    Collections.sort(ret);
    return ret;
  }
  
  public byte[] getHash(){
    if(SangminConfig.forkjoin){
      return ahsEntries.get(ahsEntries.size()-1).getSuperHash();
    }
    if(ahsEntries.size() == 1){
      return ahsEntries.get(0).getSuperHash();
    }
    ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    for(int i=0; i<ahsEntries.size(); i++){
      try{
        buffer.write(((AHSEntry)ahsEntries.elementAt(i)).getSuperHash());
      }catch (Exception e){
        e.printStackTrace();
        System.err.println(e.toString());
        System.exit(-1);
      }
    }
    return DataHash.getMD(buffer.toByteArray());
  }

  public final Vector<IH> getIHs(){
    assert Collections.list(ahsEntries.elements()).equals(getSortedListOfEntries()): "entries not sorted" + ahsEntries;
    Vector<IH> v = new Vector<IH>();
    for(AHSEntry ahsEntry: ahsEntries){
       v.add(new IH(ahsEntry));
    }
    return v;
  }
  
  public String toString(){
      String str = "AHSArray";
      for(AHSEntry ahsEntry: ahsEntries){
	  str += "\n\t"+ahsEntry;
      }
      return str;
  }
  
  public boolean equals(Object o){
	  if(o instanceof AHS){
		  AHS ahs = (AHS)o;
		  return ahsEntries.equals(ahs.ahsEntries);
	  }else{
		  return false;
	  }
	}
}
